(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7760,        282]
NotebookOptionsPosition[      4897,        188]
NotebookOutlinePosition[      6576,        239]
CellTagsIndexPosition[      6457,        233]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SeriesData::sdatn", "ObjectName",
 CellID->8052],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"sdatn\"\>"}], ":", 
  " ", "\<\"Order specification `1` in `2` is not a machine-size \
integer.\"\>"}]], "Message", "MSG",
 CellID->214883383],

Cell[TextData[{
 "Generated when either the fourth argument or the fifth  argument in a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " expression is not an integer or is an integer that cannot be represented  \
as a machine integer on your computer."
}], "Notes",
 CellID->10794]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246607444],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->41146775],

Cell[TextData[{
 "An error occurs in this example because a list is not a valid value for the \
 fifth argument in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->19879067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", "5", ",", 
   RowBox[{"{", "}"}], ",", "1"}], "]"}]], "Input",
 CellTags->"SeriesData::sdatn",
 CellLabel->"In[1]:=",
 CellID->21761],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"sdatn\"\>"}], ":", 
  " ", "\<\"Order specification \\!\\({}\\) in \\!\\(SeriesData[\\(\\(x, 1, \
\\(\\({5, 6, 7}\\)\\), 5, \\(\\({}\\)\\), 1\\)\\)]\\) is not a machine-size \
integer.\"\>"}]], "Message", "MSG",
 CellTags->"SeriesData::sdatn",
 CellID->785929],

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", "5", ",", 
   RowBox[{"{", "}"}], ",", "1"}], "]"}]], "Output",
 CellTags->"SeriesData::sdatn",
 CellLabel->"Out[1]=",
 CellID->290907236]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->307655781],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SeriesData", "[", 
  RowBox[{"x", ",", "1", ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "7"}], "}"}], ",", "5", ",", "8", ",", "1"}], 
  "]"}]], "Input",
 CellTags->"SeriesData::sdatn",
 CellLabel->"In[2]:=",
 CellID->27678173],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "5"]}], "+", 
   RowBox[{"6", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "6"]}], "+", 
   RowBox[{"7", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "7"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "1"}], "]"}], "8"],
    SeriesData[$CellContext`x, 1, {}, 5, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 1, {5, 6, 7}, 5, 8, 1],
  Editable->False]], "Output",
 CellTags->"SeriesData::sdatn",
 CellLabel->"Out[2]=",
 CellID->443360353]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData::sdatn - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 35.5247036}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SeriesData::sdatn", "synonyms" -> {}, "title" -> 
    "SeriesData::sdatn", "type" -> "Message", "uri" -> "ref/message/sdatn"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1862, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->246607444]},
 "SeriesData::sdatn"->{
  Cell[2705, 104, 275, 8, 70, "Input",
   CellTags->"SeriesData::sdatn",
   CellID->21761],
  Cell[2983, 114, 319, 7, 70, "Message",
   CellTags->"SeriesData::sdatn",
   CellID->785929],
  Cell[3305, 123, 280, 8, 70, "Output",
   CellTags->"SeriesData::sdatn",
   CellID->290907236],
  Cell[3842, 146, 262, 8, 70, "Input",
   CellTags->"SeriesData::sdatn",
   CellID->27678173],
  Cell[4107, 156, 724, 25, 70, "Output",
   CellTags->"SeriesData::sdatn",
   CellID->443360353]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5813, 210},
 {"SeriesData::sdatn", 5956, 214}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->8052],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 201, 5, 70, "Message",
 CellID->214883383],
Cell[1464, 56, 361, 9, 70, "Notes",
 CellID->10794]
}, Closed]],
Cell[CellGroupData[{
Cell[1862, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->246607444],
Cell[CellGroupData[{
Cell[2247, 84, 147, 5, 70, "ExampleSection",
 CellID->41146775],
Cell[2397, 91, 283, 9, 70, "ExampleText",
 CellID->19879067],
Cell[CellGroupData[{
Cell[2705, 104, 275, 8, 70, "Input",
 CellTags->"SeriesData::sdatn",
 CellID->21761],
Cell[2983, 114, 319, 7, 70, "Message",
 CellTags->"SeriesData::sdatn",
 CellID->785929],
Cell[3305, 123, 280, 8, 70, "Output",
 CellTags->"SeriesData::sdatn",
 CellID->290907236]
}, Open  ]],
Cell[3600, 134, 217, 8, 70, "ExampleText",
 CellID->307655781],
Cell[CellGroupData[{
Cell[3842, 146, 262, 8, 70, "Input",
 CellTags->"SeriesData::sdatn",
 CellID->27678173],
Cell[4107, 156, 724, 25, 70, "Output",
 CellTags->"SeriesData::sdatn",
 CellID->443360353]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4870, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

