(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7657,        284]
NotebookOptionsPosition[      4750,        188]
NotebookOutlinePosition[      6419,        239]
CellTagsIndexPosition[      6301,        233]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SeriesData::slnc", "ObjectName",
 CellID->17620],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"slnc\"\>"}], ":", 
  " ", "\<\"Argument `1` in Log is a series with no coefficients.\"\>"}]], \
"Message", "MSG",
 CellID->548635601],

Cell[TextData[{
 "Generated when the argument in ",
 Cell[BoxData[
  ButtonBox["Log",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Log"]], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " expression with no coefficients."
}], "Notes",
 CellID->13601],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " expressions are designed for representing power series expansions and can  \
represent logarithmic singularities only in special cases."
}], "Notes",
 CellID->10456]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252177787],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->153328156],

Cell["\<\
An error occurs in this example because the the series has an indeterminate \
singularity.\
\>", "ExampleText",
 CellID->322928835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "0"}], "}"}]}], "]"}], "]"}]], "Input",
 CellTags->"SeriesData::slnc",
 CellLabel->"In[1]:=",
 CellID->18791],

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesData", "::", "\<\"slnc\"\>"}], ":", 
  " ", "\<\"Argument \\!\\(\\*InterpretationBox[\\(\\(O[x]\\)\\^1\\), \
SeriesData[x, 0, List[], 1, 1, 1], Rule[Editable, False]]\\) in Log is a \
series with no coefficients.\"\>"}]], "Message", "MSG",
 CellTags->"SeriesData::slnc",
 CellID->100943617],

Cell[BoxData[
 RowBox[{"Log", "[", 
  InterpretationBox[
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "1"],
   SeriesData[$CellContext`x, 0, {}, 1, 1, 1],
   Editable->False], "]"}]], "Output",
 CellTags->"SeriesData::slnc",
 CellLabel->"Out[1]=",
 CellID->398167791]
}, Open  ]],

Cell["\<\
The logarithm of a series can be computed if the leading term in the series \
is known.\
\>", "ExampleText",
 CellID->532020100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Log", "[", 
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellTags->"SeriesData::slnc",
 CellLabel->"In[2]:=",
 CellID->23546],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["x", "2"], "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 2, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Rational[-1, 2]}, 2, 4, 1],
  Editable->False]], "Output",
 CellTags->"SeriesData::slnc",
 CellLabel->"Out[2]=",
 CellID->102427699]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SeriesData::slnc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 42.3530034}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SeriesData::slnc", "synonyms" -> {}, "title" -> 
    "SeriesData::slnc", "type" -> "Message", "uri" -> "ref/message/slnc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2162, 84, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->252177787]},
 "SeriesData::slnc"->{
  Cell[2864, 113, 302, 10, 70, "Input",
   CellTags->"SeriesData::slnc",
   CellID->18791],
  Cell[3169, 125, 331, 7, 70, "Message",
   CellTags->"SeriesData::slnc",
   CellID->100943617],
  Cell[3503, 134, 275, 9, 70, "Output",
   CellTags->"SeriesData::slnc",
   CellID->398167791],
  Cell[3956, 154, 276, 9, 70, "Input",
   CellTags->"SeriesData::slnc",
   CellID->23546],
  Cell[4235, 165, 449, 16, 70, "Output",
   CellTags->"SeriesData::slnc",
   CellID->102427699]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5662, 210},
 {"SeriesData::slnc", 5804, 214}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 54, 1, 70, "ObjectName",
 CellID->17620],
Cell[CellGroupData[{
Cell[782, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1260, 49, 192, 5, 70, "Message",
 CellID->548635601],
Cell[1455, 56, 360, 13, 70, "Notes",
 CellID->13601],
Cell[1818, 71, 307, 8, 70, "Notes",
 CellID->10456]
}, Closed]],
Cell[CellGroupData[{
Cell[2162, 84, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->252177787],
Cell[CellGroupData[{
Cell[2547, 98, 148, 5, 70, "ExampleSection",
 CellID->153328156],
Cell[2698, 105, 141, 4, 70, "ExampleText",
 CellID->322928835],
Cell[CellGroupData[{
Cell[2864, 113, 302, 10, 70, "Input",
 CellTags->"SeriesData::slnc",
 CellID->18791],
Cell[3169, 125, 331, 7, 70, "Message",
 CellTags->"SeriesData::slnc",
 CellID->100943617],
Cell[3503, 134, 275, 9, 70, "Output",
 CellTags->"SeriesData::slnc",
 CellID->398167791]
}, Open  ]],
Cell[3793, 146, 138, 4, 70, "ExampleText",
 CellID->532020100],
Cell[CellGroupData[{
Cell[3956, 154, 276, 9, 70, "Input",
 CellTags->"SeriesData::slnc",
 CellID->23546],
Cell[4235, 165, 449, 16, 70, "Output",
 CellTags->"SeriesData::slnc",
 CellID->102427699]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4723, 186, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

