(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8246,        289]
NotebookOptionsPosition[      5293,        194]
NotebookOutlinePosition[      7034,        246]
CellTagsIndexPosition[      6909,        240]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["SetStreamPosition::sbuf", "ObjectName",
 CellID->32713],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetStreamPosition", "::", "\<\"sbuf\"\>"}], ":", 
  " ", "\<\"Requested position `1` in stream `2` is outside the file buffer; \
cannot reach outside the file buffer for non-disk files.\"\>"}]], "Message", \
"MSG",
 CellID->49553007],

Cell[TextData[{
 "Generated when the second argument in ",
 Cell[BoxData[
  ButtonBox["SetStreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFormula"],
 " refers to a position that is not available in the indicated input stream."
}], "Notes",
 CellID->21378]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->51479489],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->7174978],

Cell[TextData[{
 "An error occurs in this example because the second argument in ",
 Cell[BoxData[
  ButtonBox["SetStreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFormula"],
 " is greater than the number of characters that are available in this input  \
stream."
}], "ExampleText",
 CellID->705733505],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<112233445566778899\>\"", "]"}]}], 
     ",", "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"SetStreamPosition", "[", 
     RowBox[{"s", ",", "50"}], "]"}], ";", "\n", "\t", 
    RowBox[{"result", "=", 
     RowBox[{"Read", "[", 
      RowBox[{"s", ",", 
       RowBox[{"{", 
        RowBox[{"Character", ",", "Character", ",", "Character"}], "}"}]}], 
      "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", "result"}]}], "\n", 
  "]"}]], "Input",
 CellTags->"SetStreamPosition::sbuf",
 CellLabel->"In[1]:=",
 CellID->30808],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetStreamPosition", "::", "\<\"sbuf\"\>"}], ":", 
  " ", "\<\"Requested position \\!\\(50\\) in stream \
\\!\\(InputStream[\\(\\(String, 376\\)\\)]\\) is outside the file buffer; \
cannot reach outside the file buffer for non-disk files.\"\>"}]], "Message", \
"MSG",
 CellTags->"SetStreamPosition::sbuf",
 CellID->157416802],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"1\"\>", ",", "\<\"1\"\>", ",", "\<\"2\"\>"}], "}"}]], "Output",\

 CellTags->"SetStreamPosition::sbuf",
 CellLabel->"Out[1]=",
 CellID->5460128]
}, Open  ]],

Cell[TextData[{
 "This shows a valid use of ",
 Cell[BoxData[
  ButtonBox["SetStreamPosition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetStreamPosition"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->864787309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"s", "=", 
      RowBox[{"StringToStream", "[", "\"\<112233445566778899\>\"", "]"}]}], 
     ",", "result"}], "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"SetStreamPosition", "[", 
     RowBox[{"s", ",", "5"}], "]"}], ";", "\n", "\t", 
    RowBox[{"result", "=", 
     RowBox[{"Read", "[", 
      RowBox[{"s", ",", 
       RowBox[{"{", 
        RowBox[{"Character", ",", "Character", ",", "Character"}], "}"}]}], 
      "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "s", "]"}], ";", "\n", "\t", "result"}]}], "\n", 
  "]"}]], "Input",
 CellTags->"SetStreamPosition::sbuf",
 CellLabel->"In[2]:=",
 CellID->19709],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3\"\>", ",", "\<\"4\"\>", ",", "\<\"4\"\>"}], "}"}]], "Output",\

 CellTags->"SetStreamPosition::sbuf",
 CellLabel->"Out[2]=",
 CellID->122234317]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SetStreamPosition::sbuf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 18, 59.1659338}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "SetStreamPosition::sbuf", "synonyms" -> {}, "title" -> 
    "SetStreamPosition::sbuf", "type" -> "Message", "uri" -> 
    "ref/message/sbuf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1877, 70, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->51479489]},
 "SetStreamPosition::sbuf"->{
  Cell[2783, 104, 716, 21, 70, "Input",
   CellTags->"SetStreamPosition::sbuf",
   CellID->30808],
  Cell[3502, 127, 359, 8, 70, "Message",
   CellTags->"SetStreamPosition::sbuf",
   CellID->157416802],
  Cell[3864, 137, 188, 6, 70, "Output",
   CellTags->"SetStreamPosition::sbuf",
   CellID->5460128],
  Cell[4319, 158, 715, 21, 70, "Input",
   CellTags->"SetStreamPosition::sbuf",
   CellID->19709],
  Cell[5037, 181, 190, 6, 70, "Output",
   CellTags->"SetStreamPosition::sbuf",
   CellID->122234317]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6231, 217},
 {"SetStreamPosition::sbuf", 6379, 221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 61, 1, 70, "ObjectName",
 CellID->32713],
Cell[CellGroupData[{
Cell[789, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1267, 49, 268, 6, 70, "Message",
 CellID->49553007],
Cell[1538, 57, 302, 8, 70, "Notes",
 CellID->21378]
}, Closed]],
Cell[CellGroupData[{
Cell[1877, 70, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->51479489],
Cell[CellGroupData[{
Cell[2261, 84, 146, 5, 70, "ExampleSection",
 CellID->7174978],
Cell[2410, 91, 348, 9, 70, "ExampleText",
 CellID->705733505],
Cell[CellGroupData[{
Cell[2783, 104, 716, 21, 70, "Input",
 CellTags->"SetStreamPosition::sbuf",
 CellID->30808],
Cell[3502, 127, 359, 8, 70, "Message",
 CellTags->"SetStreamPosition::sbuf",
 CellID->157416802],
Cell[3864, 137, 188, 6, 70, "Output",
 CellTags->"SetStreamPosition::sbuf",
 CellID->5460128]
}, Open  ]],
Cell[4067, 146, 227, 8, 70, "ExampleText",
 CellID->864787309],
Cell[CellGroupData[{
Cell[4319, 158, 715, 21, 70, "Input",
 CellTags->"SetStreamPosition::sbuf",
 CellID->19709],
Cell[5037, 181, 190, 6, 70, "Output",
 CellTags->"SetStreamPosition::sbuf",
 CellID->122234317]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[5266, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

