(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29173,        761]
NotebookOptionsPosition[      6029,        213]
NotebookOutlinePosition[     26648,        691]
CellTagsIndexPosition[     26204,        676]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Solve::dinv
Eliminate::dinv
Roots::dinv
Reduce::dinv
System`Private`OldReduce::dinv
SolveAlways::dinv
GroebnerBasis::dinv
PolynomialReduce::dinv
MainSolve::dinv
AlgebraicRules::dinv\
\>", "ObjectName",
 CellID->31067],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"dinv\"\>"}], ":", 
  " ", "\<\"The expression `1` involves unknowns in more than one argument, \
so inverse functions cannot be used.\"\>"}]], "Message", "MSG",
 CellID->296500254],

Cell["\<\
Generated when the inverse of a function is needed to represent a solution \
and the solution variable occurs in more than one argument of that function.\
\>", "Notes",
 CellID->8322]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->339400795],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->59896795],

Cell["\<\
A warning message is generated in this example because the solution to this \
equation cannot be represented using an inverse with respect to one of the \
function arguments.\
\>", "ExampleText",
 CellID->116255750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"testf", "[", 
     RowBox[{"x", ",", "x"}], "]"}], "==", "1"}], ",", "x"}], "]"}]], "Input",\

 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellLabel->"In[1]:=",
 CellID->2799],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"dinv\"\>"}], ":", 
  " ", "\<\"The expression \\!\\(testf[\\(\\(x, x\\)\\)]\\) involves unknowns \
in more than one argument, so inverse functions cannot be used.\"\>"}]], \
"Message", "MSG",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->744543771],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"testf", "[", 
     RowBox[{"x", ",", "x"}], "]"}], "\[Equal]", "1"}], ",", "x"}], 
  "]"}]], "Output",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellLabel->"Out[1]=",
 CellID->67217]
}, Open  ]],

Cell[TextData[{
 "If the variable occurs in only one argument of the test function, the  \
solution can be represented as an ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " expression."
}], "ExampleText",
 CellID->36741938],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"testf", "[", 
     RowBox[{"x", ",", "0"}], "]"}], "==", "1"}], ",", "x"}], "]"}]], "Input",\

 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellLabel->"In[2]:=",
 CellID->25068],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->790322361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{
     RowBox[{"InverseFunction", "[", 
      RowBox[{"testf", ",", "1", ",", "2"}], "]"}], "[", 
     RowBox[{"1", ",", "0"}], "]"}]}], "}"}], "}"}]], "Output",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellLabel->"Out[2]=",
 CellID->70125150]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solve::dinv - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 19, 14.7913338}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Solve::dinv Eliminate::dinv Roots::dinv Reduce::dinv \
System`Private`OldReduce::dinv SolveAlways::dinv GroebnerBasis::dinv \
PolynomialReduce::dinv MainSolve::dinv AlgebraicRules::dinv", 
    "synonyms" -> {}, "title" -> "Solve::dinv", "type" -> "Message", "uri" -> 
    "ref/message/dinv"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1923, 77, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->339400795]},
 "Solve::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "Eliminate::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "Roots::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "Reduce::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "System`Private`OldReduce::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "SolveAlways::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "GroebnerBasis::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "PolynomialReduce::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "MainSolve::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]},
 "AlgebraicRules::dinv"->{
  Cell[2708, 107, 446, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->2799],
  Cell[3157, 122, 505, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->744543771],
  Cell[3665, 135, 455, 13, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->67217],
  Cell[4474, 164, 447, 13, 70, "Input",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->25068],
  Cell[4924, 179, 509, 11, 70, "Message",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->790322361],
  Cell[5436, 192, 527, 14, 70, "Output",
   CellTags->{
    "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
     "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
     "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
     "AlgebraicRules::dinv"},
   CellID->70125150]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7110, 239},
 {"Solve::dinv", 7247, 243},
 {"Eliminate::dinv", 9140, 286},
 {"Roots::dinv", 11029, 329},
 {"Reduce::dinv", 12919, 372},
 {"System`Private`OldReduce::dinv", 14827, 415},
 {"SolveAlways::dinv", 16722, 458},
 {"GroebnerBasis::dinv", 18619, 501},
 {"PolynomialReduce::dinv", 20519, 544},
 {"MainSolve::dinv", 22412, 587},
 {"AlgebraicRules::dinv", 24310, 630}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 227, 12, 70, "ObjectName",
 CellID->31067],
Cell[CellGroupData[{
Cell[955, 43, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1433, 60, 257, 6, 70, "Message",
 CellID->296500254],
Cell[1693, 68, 193, 4, 70, "Notes",
 CellID->8322]
}, Closed]],
Cell[CellGroupData[{
Cell[1923, 77, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->339400795],
Cell[CellGroupData[{
Cell[2308, 91, 147, 5, 70, "ExampleSection",
 CellID->59896795],
Cell[2458, 98, 225, 5, 70, "ExampleText",
 CellID->116255750],
Cell[CellGroupData[{
Cell[2708, 107, 446, 13, 70, "Input",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->2799],
Cell[3157, 122, 505, 11, 70, "Message",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->744543771],
Cell[3665, 135, 455, 13, 70, "Output",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->67217]
}, Open  ]],
Cell[4135, 151, 314, 9, 70, "ExampleText",
 CellID->36741938],
Cell[CellGroupData[{
Cell[4474, 164, 447, 13, 70, "Input",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->25068],
Cell[4924, 179, 509, 11, 70, "Message",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->790322361],
Cell[5436, 192, 527, 14, 70, "Output",
 CellTags->{
  "Solve::dinv", "Eliminate::dinv", "Roots::dinv", "Reduce::dinv", 
   "System`Private`OldReduce::dinv", "SolveAlways::dinv", 
   "GroebnerBasis::dinv", "PolynomialReduce::dinv", "MainSolve::dinv", 
   "AlgebraicRules::dinv"},
 CellID->70125150]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6002, 211, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

