(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9704,        320]
NotebookOptionsPosition[      4987,        189]
NotebookOutlinePosition[      8284,        275]
CellTagsIndexPosition[      8103,        267]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["\<\
Solve::ifun
Eliminate::ifun
SolveAlways::ifun\
\>", "ObjectName",
 CellID->7607],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{
   StyleBox["function", "TI"], "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by `1`, so some solutions may \
not be found; use Reduce for complete solution information.\"\>"}]], "Message",\
 "MSG",
 CellID->139234874],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and related functions use inverse functions to represent a solution. "
}], "Notes",
 CellID->24200],

Cell["\<\
Inverse functions normally give one branch of a general  inverse, so \
equations that are solved in terms of inverse functions may omit  solutions \
associated with other branches.\
\>", "Notes",
 CellID->16630]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117522436],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->447839972],

Cell["\<\
A warning message is generated in this example because the inverse function \
that is used to represent the solution gives only one of the solutions to \
this equation.  This equation has an infinite number of solutions.\
\>", "ExampleText",
 CellID->125470340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "==", "b"}], ",", "x"}], "]"}]], "Input",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellLabel->"In[1]:=",
 CellID->18498],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellID->145937945],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"ArcSin", "[", "b", "]"}]}], "}"}], "}"}]], "Output",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellLabel->"Out[1]=",
 CellID->292418454]
}, Open  ]],

Cell[TextData[{
 "Other solutions to this equation can be constructed by adding multiples of  \
",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->704934082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "==", "b"}], ")"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", "->", 
      RowBox[{"ArcSin", "[", "b", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "->", 
      RowBox[{
       RowBox[{"ArcSin", "[", "b", "]"}], "+", 
       RowBox[{"2", "Pi"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", "->", 
      RowBox[{
       RowBox[{"ArcSin", "[", "b", "]"}], "-", 
       RowBox[{"8", "Pi"}]}]}], "}"}]}], "}"}]}]], "Input",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellLabel->"In[2]:=",
 CellID->26063],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellLabel->"Out[2]=",
 CellID->543244922]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solve::ifun - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 19, 22.4946560}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Solve::ifun Eliminate::ifun SolveAlways::ifun", 
    "synonyms" -> {}, "title" -> "Solve::ifun", "type" -> "Message", "uri" -> 
    "ref/message/ifun"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2092, 82, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->117522436]},
 "Solve::ifun"->{
  Cell[2924, 112, 245, 7, 70, "Input",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->18498],
  Cell[3172, 121, 337, 7, 70, "Message",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->145937945],
  Cell[3512, 130, 249, 7, 70, "Output",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->292418454],
  Cell[4050, 153, 665, 22, 70, "Input",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->26063],
  Cell[4718, 177, 203, 5, 70, "Output",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->543244922]},
 "Eliminate::ifun"->{
  Cell[2924, 112, 245, 7, 70, "Input",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->18498],
  Cell[3172, 121, 337, 7, 70, "Message",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->145937945],
  Cell[3512, 130, 249, 7, 70, "Output",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->292418454],
  Cell[4050, 153, 665, 22, 70, "Input",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->26063],
  Cell[4718, 177, 203, 5, 70, "Output",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->543244922]},
 "SolveAlways::ifun"->{
  Cell[2924, 112, 245, 7, 70, "Input",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->18498],
  Cell[3172, 121, 337, 7, 70, "Message",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->145937945],
  Cell[3512, 130, 249, 7, 70, "Output",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->292418454],
  Cell[4050, 153, 665, 22, 70, "Input",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->26063],
  Cell[4718, 177, 203, 5, 70, "Output",
   CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
   CellID->543244922]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5923, 212},
 {"Solve::ifun", 6060, 216},
 {"Eliminate::ifun", 6740, 232},
 {"SolveAlways::ifun", 7422, 248}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 90, 5, 70, "ObjectName",
 CellID->7607],
Cell[CellGroupData[{
Cell[818, 36, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1296, 53, 281, 7, 70, "Message",
 CellID->139234874],
Cell[1580, 62, 251, 8, 70, "Notes",
 CellID->24200],
Cell[1834, 72, 221, 5, 70, "Notes",
 CellID->16630]
}, Closed]],
Cell[CellGroupData[{
Cell[2092, 82, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->117522436],
Cell[CellGroupData[{
Cell[2477, 96, 148, 5, 70, "ExampleSection",
 CellID->447839972],
Cell[2628, 103, 271, 5, 70, "ExampleText",
 CellID->125470340],
Cell[CellGroupData[{
Cell[2924, 112, 245, 7, 70, "Input",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellID->18498],
Cell[3172, 121, 337, 7, 70, "Message",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellID->145937945],
Cell[3512, 130, 249, 7, 70, "Output",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellID->292418454]
}, Open  ]],
Cell[3776, 140, 249, 9, 70, "ExampleText",
 CellID->704934082],
Cell[CellGroupData[{
Cell[4050, 153, 665, 22, 70, "Input",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellID->26063],
Cell[4718, 177, 203, 5, 70, "Output",
 CellTags->{"Solve::ifun", "Eliminate::ifun", "SolveAlways::ifun"},
 CellID->543244922]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4960, 187, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

