(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6680,        242]
NotebookOptionsPosition[      3964,        152]
NotebookOutlinePosition[      5608,        203]
CellTagsIndexPosition[      5493,        197]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Solve::incnst", "ObjectName",
 CellID->8112],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"incnst\"\>"}], ":", 
  " ", "\<\"Inconsistent or redundant transcendental equation. After \
reduction, the bad equation is `1` == 0.\"\>"}]], "Message", "MSG",
 CellID->350489942],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " is used with degenerate transcendental equations or with transcendental  \
equations that have no solution."
}], "Notes",
 CellID->7610]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148281629],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->212122497],

Cell["\<\
An error is generated in this example because these transcendental equations \
do not have a solution.\
\>", "ExampleText",
 CellID->129903905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"x", "+", "y"}], "]"}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "+", "y"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellTags->"Solve::incnst",
 CellLabel->"In[1]:=",
 CellID->6915],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"incnst\"\>"}], ":", 
  " ", "\<\"Inconsistent or redundant transcendental equation. After \
reduction, the bad equation is \\!\\(1 - \\(\\(ArcSin[\\(\\(Sin[\\(\\(x + \
y\\)\\)]\\)\\)]\\)\\)\\) == 0.\"\>"}]], "Message", "MSG",
 CellTags->"Solve::incnst",
 CellID->233048534],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution \
information.\"\>"}]], "Message", "MSG",
 CellTags->"Solve::incnst",
 CellID->291817217],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables.\
\"\>"}]], "Message", "MSG",
 CellTags->"Solve::incnst",
 CellID->85680030],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 CellTags->"Solve::incnst",
 CellLabel->"Out[1]=",
 CellID->457455613]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solve::incnst - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 19, 22.6821608}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Solve::incnst", "synonyms" -> {}, "title" -> 
    "Solve::incnst", "type" -> "Message", "uri" -> "ref/message/incnst"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1817, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->148281629]},
 "Solve::incnst"->{
  Cell[2531, 99, 388, 14, 70, "Input",
   CellTags->"Solve::incnst",
   CellID->6915],
  Cell[2922, 115, 327, 7, 70, "Message",
   CellTags->"Solve::incnst",
   CellID->233048534],
  Cell[3252, 124, 297, 7, 70, "Message",
   CellTags->"Solve::incnst",
   CellID->291817217],
  Cell[3552, 133, 227, 6, 70, "Message",
   CellTags->"Solve::incnst",
   CellID->85680030],
  Cell[3782, 141, 116, 4, 70, "Output",
   CellTags->"Solve::incnst",
   CellID->457455613]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4869, 174},
 {"Solve::incnst", 5008, 178}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->8112],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 233, 5, 70, "Message",
 CellID->350489942],
Cell[1492, 56, 288, 9, 70, "Notes",
 CellID->7610]
}, Closed]],
Cell[CellGroupData[{
Cell[1817, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->148281629],
Cell[CellGroupData[{
Cell[2202, 84, 148, 5, 70, "ExampleSection",
 CellID->212122497],
Cell[2353, 91, 153, 4, 70, "ExampleText",
 CellID->129903905],
Cell[CellGroupData[{
Cell[2531, 99, 388, 14, 70, "Input",
 CellTags->"Solve::incnst",
 CellID->6915],
Cell[2922, 115, 327, 7, 70, "Message",
 CellTags->"Solve::incnst",
 CellID->233048534],
Cell[3252, 124, 297, 7, 70, "Message",
 CellTags->"Solve::incnst",
 CellID->291817217],
Cell[3552, 133, 227, 6, 70, "Message",
 CellTags->"Solve::incnst",
 CellID->85680030],
Cell[3782, 141, 116, 4, 70, "Output",
 CellTags->"Solve::incnst",
 CellID->457455613]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3937, 150, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

