(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6458,        247]
NotebookOptionsPosition[      3688,        153]
NotebookOutlinePosition[      5306,        204]
CellTagsIndexPosition[      5193,        198]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Solve::smod", "ObjectName",
 CellID->14444],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"smod\"\>"}], ":", 
  " ", "\<\"Unable to solve equations for modulus.\"\>"}]], "Message", "MSG",
 CellID->288619584],

Cell["\<\
Generated when a modulus implied by the equations could not be determined.\
\>", "Notes",
 CellID->9523]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->82994429],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->38647645],

Cell["\<\
A warning occurs in this example because the equations are degenerate.\
\>", "ExampleText",
 CellID->34733395],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", "1"}], ",", 
     RowBox[{
      RowBox[{"2", "x"}], "==", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"Mode", "->", "Modular"}]}], "]"}]], "Input",
 CellTags->"Solve::smod",
 CellLabel->"In[1]:=",
 CellID->6211],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"smod\"\>"}], ":", 
  " ", "\<\"Unable to solve equations for modulus.\"\>"}]], "Message", "MSG",
 CellTags->"Solve::smod",
 CellID->195218473],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", "1"}], "}"}], "}"}]], "Output",
 CellTags->"Solve::smod",
 CellLabel->"Out[1]=",
 CellID->1051658]
}, Open  ]],

Cell["The modulus is computed in this example.", "ExampleText",
 CellID->86446946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", "1"}], ",", 
     RowBox[{
      RowBox[{"7", "x"}], "==", "1"}]}], "}"}], ",", "x", ",", 
   RowBox[{"Mode", "->", "Modular"}]}], "]"}]], "Input",
 CellTags->"Solve::smod",
 CellLabel->"In[2]:=",
 CellID->175649518],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Modulus", "\[Rule]", "6"}], ",", 
    RowBox[{"x", "\[Rule]", "1"}]}], "}"}], "}"}]], "Output",
 CellTags->"Solve::smod",
 CellLabel->"Out[2]=",
 CellID->848779811]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solve::smod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 19, 23.2290498}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Solve::smod", "synonyms" -> {}, "title" -> "Solve::smod", 
    "type" -> "Message", "uri" -> "ref/message/smod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1579, 63, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->82994429]},
 "Solve::smod"->{
  Cell[2258, 91, 314, 11, 70, "Input",
   CellTags->"Solve::smod",
   CellID->6211],
  Cell[2575, 104, 196, 5, 70, "Message",
   CellTags->"Solve::smod",
   CellID->195218473],
  Cell[2774, 111, 170, 6, 70, "Output",
   CellTags->"Solve::smod",
   CellID->1051658],
  Cell[3066, 125, 319, 11, 70, "Input",
   CellTags->"Solve::smod",
   CellID->175649518],
  Cell[3388, 138, 234, 8, 70, "Output",
   CellTags->"Solve::smod",
   CellID->848779811]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 4585, 175},
 {"Solve::smod", 4721, 179}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 49, 1, 70, "ObjectName",
 CellID->14444],
Cell[CellGroupData[{
Cell[777, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1255, 49, 170, 4, 70, "Message",
 CellID->288619584],
Cell[1428, 55, 114, 3, 70, "Notes",
 CellID->9523]
}, Closed]],
Cell[CellGroupData[{
Cell[1579, 63, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->82994429],
Cell[CellGroupData[{
Cell[1963, 77, 147, 5, 70, "ExampleSection",
 CellID->38647645],
Cell[2113, 84, 120, 3, 70, "ExampleText",
 CellID->34733395],
Cell[CellGroupData[{
Cell[2258, 91, 314, 11, 70, "Input",
 CellTags->"Solve::smod",
 CellID->6211],
Cell[2575, 104, 196, 5, 70, "Message",
 CellTags->"Solve::smod",
 CellID->195218473],
Cell[2774, 111, 170, 6, 70, "Output",
 CellTags->"Solve::smod",
 CellID->1051658]
}, Open  ]],
Cell[2959, 120, 82, 1, 70, "ExampleText",
 CellID->86446946],
Cell[CellGroupData[{
Cell[3066, 125, 319, 11, 70, "Input",
 CellTags->"Solve::smod",
 CellID->175649518],
Cell[3388, 138, 234, 8, 70, "Output",
 CellTags->"Solve::smod",
 CellID->848779811]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[3661, 151, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

