(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7320,        276]
NotebookOptionsPosition[      4533,        182]
NotebookOutlinePosition[      6163,        233]
CellTagsIndexPosition[      6049,        227]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Solve::svars", "ObjectName",
 CellID->12702],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables.\
\"\>"}]], "Message", "MSG",
 CellID->298252421],

Cell[TextData[{
 "Generated when the number of variables listed in the  second argument of ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " is greater than the number of variables that could be determined from the  \
equations."
}], "Notes",
 CellID->3447]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->327945902],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->8547149],

Cell["\<\
An error occurs in this example because the number of variables is greater \
than the number of equations.\
\>", "ExampleText",
 CellID->5999027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", 
      RowBox[{"y", "+", "1"}]}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "==", "z"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"Solve::svars",
 CellLabel->"In[1]:=",
 CellID->21068],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"svars\"\>"}], ":", 
  " ", "\<\"Equations may not give solutions for all \\\"solve\\\" variables.\
\"\>"}]], "Message", "MSG",
 CellTags->"Solve::svars",
 CellID->444765120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", 
     RowBox[{"1", "+", "y"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     SuperscriptBox["y", "2"]}]}], "}"}], "}"}]], "Output",
 CellTags->"Solve::svars",
 CellLabel->"Out[1]=",
 CellID->361121712]
}, Open  ]],

Cell["\<\
Solutions are obtained for all of the variables in this example.\
\>", "ExampleText",
 CellID->68289410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "==", 
      RowBox[{"y", "+", "1"}]}], ",", 
     RowBox[{
      RowBox[{"y", "^", "2"}], "==", "z"}], ",", 
     RowBox[{"z", "==", "9"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellTags->"Solve::svars",
 CellLabel->"In[2]:=",
 CellID->18499],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", "2"}]}], ",", 
     RowBox[{"z", "\[Rule]", "9"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", "3"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "4"}], ",", 
     RowBox[{"z", "\[Rule]", "9"}], ",", 
     RowBox[{"y", "\[Rule]", "3"}]}], "}"}]}], "}"}]], "Output",
 CellTags->"Solve::svars",
 CellLabel->"Out[2]=",
 CellID->26801910]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Solve::svars - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 19, 23.5259324}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Solve::svars", "synonyms" -> {}, "title" -> "Solve::svars", 
    "type" -> "Message", "uri" -> "ref/message/svars"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1822, 70, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->327945902]},
 "Solve::svars"->{
  Cell[2536, 99, 363, 13, 70, "Input",
   CellTags->"Solve::svars",
   CellID->21068],
  Cell[2902, 114, 227, 6, 70, "Message",
   CellTags->"Solve::svars",
   CellID->444765120],
  Cell[3132, 122, 282, 10, 70, "Output",
   CellTags->"Solve::svars",
   CellID->361121712],
  Cell[3568, 142, 400, 14, 70, "Input",
   CellTags->"Solve::svars",
   CellID->18499],
  Cell[3971, 158, 496, 17, 70, "Output",
   CellTags->"Solve::svars",
   CellID->26801910]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 5434, 204},
 {"Solve::svars", 5572, 208}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 50, 1, 70, "ObjectName",
 CellID->12702],
Cell[CellGroupData[{
Cell[778, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1256, 49, 200, 5, 70, "Message",
 CellID->298252421],
Cell[1459, 56, 326, 9, 70, "Notes",
 CellID->3447]
}, Closed]],
Cell[CellGroupData[{
Cell[1822, 70, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->327945902],
Cell[CellGroupData[{
Cell[2207, 84, 146, 5, 70, "ExampleSection",
 CellID->8547149],
Cell[2356, 91, 155, 4, 70, "ExampleText",
 CellID->5999027],
Cell[CellGroupData[{
Cell[2536, 99, 363, 13, 70, "Input",
 CellTags->"Solve::svars",
 CellID->21068],
Cell[2902, 114, 227, 6, 70, "Message",
 CellTags->"Solve::svars",
 CellID->444765120],
Cell[3132, 122, 282, 10, 70, "Output",
 CellTags->"Solve::svars",
 CellID->361121712]
}, Open  ]],
Cell[3429, 135, 114, 3, 70, "ExampleText",
 CellID->68289410],
Cell[CellGroupData[{
Cell[3568, 142, 400, 14, 70, "Input",
 CellTags->"Solve::svars",
 CellID->18499],
Cell[3971, 158, 496, 17, 70, "Output",
 CellTags->"Solve::svars",
 CellID->26801910]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[4506, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

