(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8623,        309]
NotebookOptionsPosition[      5517,        205]
NotebookOutlinePosition[      7255,        259]
CellTagsIndexPosition[      7139,        253]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA MESSAGE", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell["Splice::splicf", "ObjectName",
 CellID->15297],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[BoxData[
 RowBox[{
  RowBox[{"Splice", "::", "\<\"splicf\"\>"}], ":", 
  " ", "\<\"Cannot deduce output file name from `1`.\"\>"}]], "Message", \
"MSG",
 CellID->36933603],

Cell[TextData[{
 "Generated when ",
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " is used without specifying the name of the output file and the name of   \
the input file is not of the form ",
 StyleBox["file", "MR",
  FontSlant->"Italic"],
 StyleBox[".m", "MR"],
 StyleBox["x", "MR",
  FontSlant->"Italic"],
 "."
}], "Notes",
 CellID->4411],

Cell[TextData[{
 "The first argument in ",
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 " gives the name of the input file, and the optional second argument gives   \
the name of the output file."
}], "Notes",
 CellID->20545]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->82061500],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->419346252],

Cell["\<\
An error occurs in this example because the name of the input file does not \
have the expected form.\
\>", "ExampleText",
 CellID->166735354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "result", "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"Write", "[", 
     RowBox[{"\"\<TEST.f\>\"", ",", 
      RowBox[{
      "OutputForm", "[", "\"\<       y = <*Expand[(1+x)^3]*>\>\"", "]"}]}], 
     "]"}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "\"\<TEST.f\>\"", "]"}], ";", "\n", "\t", 
    RowBox[{"Splice", "[", "\"\<TEST.f\>\"", "]"}], ";", "\n", "\t", 
    RowBox[{"result", "=", 
     RowBox[{"Read", "[", 
      RowBox[{"\"\<TEST.f\>\"", ",", "String"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "\"\<TEST.f\>\"", "]"}], ";", "\n", "\t", 
    "result"}]}], "\n", "\t", "]"}]], "Input",
 CellTags->"Splice::splicf",
 CellLabel->"In[1]:=",
 CellID->5923],

Cell[BoxData[
 RowBox[{
  RowBox[{"Splice", "::", "\<\"splicf\"\>"}], ":", 
  " ", "\<\"Cannot deduce output file name from \
\\!\\(\\\"TEST.f\\\"\\).\"\>"}]], "Message", "MSG",
 CellTags->"Splice::splicf",
 CellID->352756485],

Cell[BoxData["\<\"       y = <*Expand[(1+x)^3]*>\"\>"], "Output",
 CellTags->"Splice::splicf",
 CellLabel->"Out[1]=",
 CellID->485279941]
}, Open  ]],

Cell[TextData[{
 "This shows valid arguments in ",
 Cell[BoxData[
  ButtonBox["Splice",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Splice"]], "InlineFormula"],
 "."
}], "ExampleText",
 CellID->49022798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "result", "}"}], ",", "\n", "\t", 
   RowBox[{
    RowBox[{"Write", "[", 
     RowBox[{"\"\<TEST.mf\>\"", ",", 
      RowBox[{
      "OutputForm", "[", "\"\<       y = <*Expand[(1+x)^3]*>\>\"", "]"}]}], 
     "]"}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "\"\<TEST.mf\>\"", "]"}], ";", "\n", "\t", 
    RowBox[{"Splice", "[", "\"\<TEST.mf\>\"", "]"}], ";", "\n", "\t", 
    RowBox[{"result", "=", 
     RowBox[{"Read", "[", 
      RowBox[{"\"\<TEST.f\>\"", ",", "String"}], "]"}]}], ";", "\n", "\t", 
    RowBox[{"Close", "[", "\"\<TEST.f\>\"", "]"}], ";", "\n", "\t", 
    "result"}]}], "\n", "\t", "]"}]], "Input",
 CellTags->"Splice::splicf",
 CellLabel->"In[2]:=",
 CellID->15655],

Cell[BoxData["\<\"       y = 1 + 3*x + 3*x**2 + x**3\"\>"], "Output",
 CellTags->"Splice::splicf",
 CellLabel->"Out[2]=",
 CellID->842867970]
}, Open  ]],

Cell["Remove the test files.", "ExampleText",
 CellID->1060073],

Cell[BoxData[
 RowBox[{
  RowBox[{"DeleteFile", "[", "\"\<TEST.mf\>\"", "]"}], ";", 
  RowBox[{"DeleteFile", "[", "\"\<TEST.f\>\"", "]"}]}]], "Input",
 CellTags->"Splice::splicf",
 CellLabel->"In[3]:=",
 CellID->22224]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Splice::splicf - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 19, 46.5108958}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Mathematica Message", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> "Splice::splicf", "synonyms" -> {}, "title" -> 
    "Splice::splicf", "type" -> "Message", "uri" -> "ref/message/splicf"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2187, 87, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->82061500]},
 "Splice::splicf"->{
  Cell[2899, 116, 750, 19, 70, "Input",
   CellTags->"Splice::splicf",
   CellID->5923],
  Cell[3652, 137, 226, 6, 70, "Message",
   CellTags->"Splice::splicf",
   CellID->352756485],
  Cell[3881, 145, 137, 3, 70, "Output",
   CellTags->"Splice::splicf",
   CellID->485279941],
  Cell[4266, 163, 754, 19, 70, "Input",
   CellTags->"Splice::splicf",
   CellID->15655],
  Cell[5023, 184, 141, 3, 70, "Output",
   CellTags->"Splice::splicf",
   CellID->842867970],
  Cell[5245, 193, 218, 6, 70, "Input",
   CellTags->"Splice::splicf",
   CellID->22224]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 6425, 227},
 {"Splice::splicf", 6564, 231}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 102, 2, 70, "AnchorBarGrid"],
Cell[703, 27, 52, 1, 70, "ObjectName",
 CellID->15297],
Cell[CellGroupData[{
Cell[780, 32, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[1258, 49, 176, 5, 70, "Message",
 CellID->36933603],
Cell[1437, 56, 414, 15, 70, "Notes",
 CellID->4411],
Cell[1854, 73, 296, 9, 70, "Notes",
 CellID->20545]
}, Closed]],
Cell[CellGroupData[{
Cell[2187, 87, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->82061500],
Cell[CellGroupData[{
Cell[2571, 101, 148, 5, 70, "ExampleSection",
 CellID->419346252],
Cell[2722, 108, 152, 4, 70, "ExampleText",
 CellID->166735354],
Cell[CellGroupData[{
Cell[2899, 116, 750, 19, 70, "Input",
 CellTags->"Splice::splicf",
 CellID->5923],
Cell[3652, 137, 226, 6, 70, "Message",
 CellTags->"Splice::splicf",
 CellID->352756485],
Cell[3881, 145, 137, 3, 70, "Output",
 CellTags->"Splice::splicf",
 CellID->485279941]
}, Open  ]],
Cell[4033, 151, 208, 8, 70, "ExampleText",
 CellID->49022798],
Cell[CellGroupData[{
Cell[4266, 163, 754, 19, 70, "Input",
 CellTags->"Splice::splicf",
 CellID->15655],
Cell[5023, 184, 141, 3, 70, "Output",
 CellTags->"Splice::splicf",
 CellID->842867970]
}, Open  ]],
Cell[5179, 190, 63, 1, 70, "ExampleText",
 CellID->1060073],
Cell[5245, 193, 218, 6, 70, "Input",
 CellTags->"Splice::splicf",
 CellID->22224]
}, Open  ]]
}, Open  ]],
Cell[5490, 203, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

