(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15869,        504]
NotebookOptionsPosition[     13309,        425]
NotebookOutlinePosition[     14539,        458]
CellTagsIndexPosition[     14496,        455]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica File Organization\"\>", 
       2->"\<\"Mathematica Sessions\"\>", 
       3->"\<\"System Administration for Network Licenses\"\>", 
       4->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"mathematica" :> 
          Documentation`HelpLookup["paclet:ref/program/mathematica-unix"], 
          RowBox[{"init", ".", "m"}] :> Documentation`HelpLookup[
            If[
             StringMatchQ[
              StringJoin["paclet:ref/", 
               RowBox[{"init", ".", "m"}]], "paclet*"], 
             Part[
              Part[{{"mathematica", "paclet:ref/program/mathematica-unix"}, {
                 RowBox[{"init", ".", "m"}], 
                 StringJoin["paclet:ref/", 
                  RowBox[{"init", ".", "m"}]]}, {
                "mathlm", "paclet:ref/program/mathlm"}, {
                "MathKernel", "paclet:ref/program/MathKernel"}}, 
               DocumentationTools`Utilities`Private`i], 2], 
             StringJoin["paclet:", 
              Part[
               
               Part[{{"mathematica", "paclet:ref/program/mathematica-unix"}, {
                 
                  RowBox[{"init", ".", "m"}], 
                  StringJoin["paclet:ref/", 
                   RowBox[{"init", ".", "m"}]]}, {
                 "mathlm", "paclet:ref/program/mathlm"}, {
                 "MathKernel", "paclet:ref/program/MathKernel"}}, 
                DocumentationTools`Utilities`Private`i], 2]]]], "mathlm" :> 
          Documentation`HelpLookup["paclet:ref/program/mathlm"], "MathKernel" :> 
          Documentation`HelpLookup["paclet:ref/program/MathKernel"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"mathematica\"\>", 2->
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"init\"\>", ",", "\<\".\"\>", ",", "\<\"m\"\>"}], "}"}], 
        "]"}], 3->"\<\"mathlm\"\>", 
       4->"\<\"MathKernel\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stand-Alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Stand-Alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["math", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"math", " ", 
       StyleBox["options", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]starts the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel on Unix and Linux."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["math"], "InlineFormula"],
 " runs the stand-alone ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. To access the full ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system including the notebook interface, use ",
 Cell[BoxData[
  ButtonBox["mathematica",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/mathematica-unix"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1170061928],

Cell[TextData[{
 "A stand-alone kernel session normally reads input from ",
 Cell[BoxData["stdin"], "InlineFormula"],
 " (typically a keyboard), evaluates the expression, and prints the results \
to ",
 Cell[BoxData["stdout"], "InlineFormula"],
 " (typically a display device). Input and output can be redirected using ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " commands or standard shell mechanisms."
}], "Notes",
 CellID->307501305],

Cell["The following command-line options can be given:", "Notes",
 CellID->443060207],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "mathlink"}], Cell[TextData[{
     "communicate only via ",
     StyleBox["MathLink",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "initfile"}], " ", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}], Cell[TextData[{
     "execute the commands in the initialization file ",
     StyleBox["file ", "TI"],
     "during startup"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "lmverbose"}], Cell[TextData[{
     "print information about interactions with ",
     StyleBox["MathLM",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "noinit"}], Cell[
    "do not read any initialization files", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "password"}], " ", "\"\<\!\(\*
StyleBox[\"pw\", \"TI\"]\)\>\""}], Cell[TextData[{
     "use the password ",
     StyleBox["pw", "TI"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "pwfile"}], " ", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\""}], Cell[TextData[{
     "read passwords from ",
     StyleBox["file", "TI"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "run"}], " ", 
     StyleBox["cmd", "TI"]}], Cell[TextData[{
     "run ",
     StyleBox["cmd", "TI"],
     " on startup"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "noprompt"}], Cell[TextData[{
     "do not print banner or ",
     Cell[BoxData[
      ButtonBox["In",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/In"]], "InlineFormula"],
     "/",
     Cell[BoxData[
      ButtonBox["Out",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Out"]], "InlineFormula"],
     " prompts (useful for batch input)"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->1187094900],

Cell[TextData[{
 "If no command-line options are given, the kernel will read the value of the \
environment variable ",
 Cell[BoxData["MATHKERNELINIT"], "InlineFormula"],
 " and will use that value as though it had been entered on the command \
line."
}], "Notes",
 CellID->1328778453],

Cell[TextData[{
 "Unless the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " variable ",
 Cell[BoxData[
  ButtonBox["$IgnoreEOF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$IgnoreEOF"]], "InlineFormula"],
 " is set to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", the kernel will exit when it receives an end-of-file character sequence. \
The kernel will always exit when given the command ",
 Cell[BoxData[
  ButtonBox["Quit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Quit"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1097014418]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["mathematica",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/mathematica-unix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    RowBox[{"init", ".", "m"}],
    BaseStyle->"Link",
    ButtonData:>"paclet:ref/file/init.m"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["mathlm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/mathlm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MathKernel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/MathKernel"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->784600906]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->502212112],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->1550580332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Stand-Alone ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
  FontSlant->"Italic"],
 ButtonBox[" Kernels",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"math - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 14.3443412}", "context" -> "", 
    "keywords" -> {
     "mathlink", "initfile", "lmverbose", "noinit", "password", "pwfile", 
      "run", "noprompt", "command line", "kernel options", 
      "environment variables", "command line switch", "command line options", 
      "kernel options"}, "index" -> True, "label" -> 
    "Mathematica System Program", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "math options starts the Mathematica kernel on Unix and Linux.", 
    "synonyms" -> {}, "title" -> "math", "type" -> "System Program", "uri" -> 
    "ref/program/math"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3970, 90, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4593, 117, 50, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[4646, 120, 458, 15, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5141, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5619, 157, 442, 15, 70, "Notes",
 CellID->1170061928],
Cell[6064, 174, 446, 11, 70, "Notes",
 CellID->307501305],
Cell[6513, 187, 85, 1, 70, "Notes",
 CellID->443060207],
Cell[6601, 190, 2262, 68, 70, "2ColumnTableMod",
 CellID->1187094900],
Cell[8866, 260, 285, 7, 70, "Notes",
 CellID->1328778453],
Cell[9154, 269, 628, 22, 70, "Notes",
 CellID->1097014418]
}, Closed]],
Cell[CellGroupData[{
Cell[9819, 296, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10138, 307, 1004, 36, 70, "SeeAlso",
 CellID->784600906]
}, Open  ]],
Cell[CellGroupData[{
Cell[11179, 348, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11500, 359, 309, 9, 70, "Tutorials",
 CellID->502212112],
Cell[11812, 370, 284, 9, 70, "Tutorials",
 CellID->522604605],
Cell[12099, 381, 208, 5, 70, "Tutorials",
 CellID->341631938],
Cell[12310, 388, 216, 5, 70, "Tutorials",
 CellID->1550580332]
}, Open  ]],
Cell[CellGroupData[{
Cell[12563, 398, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[12884, 409, 383, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[13282, 423, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

