(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15025,        463]
NotebookOptionsPosition[     12365,        386]
NotebookOutlinePosition[     13823,        421]
CellTagsIndexPosition[     13780,        418]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"System Administration for Network Licenses\"\>", 
       2->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"math" :> Documentation`HelpLookup["paclet:ref/program/math"], 
          StyleBox["Mathematica", FontSlant -> "Plain"] :> 
          Documentation`HelpLookup["paclet:ref/program/Mathematica"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"math\"\>", 2->
       RowBox[{"StyleBox", "[", 
        RowBox[{"\<\"Mathematica\"\>", ",", 
         RowBox[{"FontSlant", "\[Rule]", "\<\"Plain\"\>"}]}], 
        "]"}]}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stand-Alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Stand-Alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["mathematica", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["mathematica"], "InlineFormula"],
     " \[LineSeparator]starts the full ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " system including notebook interface on Unix and Linux."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " notebook interface provides dynamic interactivity and enhanced graphics \
functionality, and calls the kernel via ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " to perform calculations."
}], "Notes",
 CellID->1639282791],

Cell["\<\
The first calculation in a notebook may take slightly longer, as it typically \
launches the kernel.\
\>", "Notes",
 CellID->1358160974],

Cell["\<\
The following command-line options are accepted on Unix and Linux:\
\>", "Notes",
 CellID->517723741],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "appHelper"}], Cell[TextData[{
     "combine the options -",
     StyleBox["querySingleLaunch", "InlineCode"],
     " and -",
     StyleBox["forceSaveAs", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "clean"}], Cell["\<\
ignore stored caches and rebuild the front end preferences file \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "backgroundTaskDelay"}], " ", 
     StyleBox["n", "TI"]}], Cell["\<\
specify the time (in milliseconds) that the front end delays background tasks \
while waiting for input\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "copyright"}], Cell[
    "display copyright information on the command line", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "dontUpdatePrefs"}], Cell[
    "prevent changes to the user's preference settings", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "font"}], " ", 
     StyleBox["f", "TI"]}], Cell[
    "specify the font used in menus, buttons, etc.", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "forceSaveAs"}], Cell["\<\
force the front end to display the Save dialog box when closing a file passed \
on the command line\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "help"}], Cell[
    "display a list of all command-line options", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "lmverbose"}], Cell[TextData[{
     "print diagnostic information to ",
     StyleBox["stderr", "InlineCode"],
     " when connecting to ",
     StyleBox["MathLM",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "mathlink"}], Cell[TextData[{
     "make the front end run as a child process that is capable of accepting \
",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " packets"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "noSplashScreen"}], Cell[
    "prevent the splash screen from being displayed on startup", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "nostderrWindow"}], Cell[TextData[{
     "do not display ",
     StyleBox["stderr", "InlineCode"],
     " messages in a pop-up window"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "preferencesDirectory"}], " ", 
     StyleBox["dir", "TI"]}], Cell[
    "specify the location where preference settings are stored", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "printCommand"}], " ", 
     StyleBox["cmd", "TI"]}], Cell[
    "specify a command for sending a file to the printer", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "pwfile"}], " ", 
     StyleBox["file", "TI"]}], Cell[TextData[{
     "specify a file in which to look for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " passwords"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "querySingleLaunch"}], Cell["\<\
ask if a file given on the command line should open in the current front end\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "singleLaunch"}], Cell[
    "allow only one copy of the front end per display", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "style"}], " ", 
     StyleBox["s", "TI"]}], Cell[
    "specify the widget style used by the front end", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "topDirectory"}], " ", 
     StyleBox["dir", "TI"]}], Cell[TextData[{
     "specify the location of the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " installation directory "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "version"}], Cell["\<\
print the current version of the front end on the command line\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "wwwBrowser"}], " ", 
     StyleBox["command", "TI"]}], Cell[
    "specify the command to use when opening URLs", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True}}}},
 CellID->1013910898],

Cell[TextData[{
 "When using ",
 StyleBox["-font", "InlineCode"],
 ", a list of possible font names can be found by using ",
 Cell[BoxData["xfontsel"], "InlineFormula"],
 ". The name can be expressed either as an X Logical Font Description or as a \
valid font alias."
}], "Notes",
 CellID->1012239651],

Cell[TextData[{
 "When using the ",
 StyleBox["-wwwBrowser", "InlineCode"],
 " option, the command can contain a ",
 Cell[BoxData[
  RowBox[{"%", "s"}]], "InlineFormula"],
 " format argument that is replaced with the URL."
}], "Notes",
 CellID->346362823]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["math",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/math"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox[
    StyleBox["Mathematica",
     FontSlant->"Plain"],
    BaseStyle->"Link",
    ButtonData->"paclet:ref/program/Mathematica"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1611395045]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->1550580332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[{
 ButtonBox["Stand-Alone ",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"],
  FontSlant->"Italic"],
 ButtonBox[" Kernels",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/StandaloneMathematicaKernels"]
}], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"mathematica - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 6.7035206}", "context" -> "", 
    "keywords" -> {
     "appHelper", "clean", "backgroundTaskDelay", "copyright", 
      "dontUpdatePrefs", "font", "forceSaveAs", "help", "lmverbose", 
      "mathlink", "noSplashScreen", "nostderrWindow", "preferencesDirectory", 
      "printCommand", "pwfile", "querySingleLaunch", "singleLaunch", "style", 
      "topDirectory", "version", "wwwBrowser", "command line switch", 
      "command line options", "kernel options"}, "index" -> True, "label" -> 
    "Mathematica System Program", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "mathematica starts the full Mathematica system including notebook \
interface on Unix and Linux.", "synonyms" -> {}, "title" -> "mathematica", 
    "type" -> "System Program", "uri" -> "ref/program/mathematica-unix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2374, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2997, 84, 57, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3057, 87, 442, 13, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3536, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4014, 122, 302, 10, 70, "Notes",
 CellID->1639282791],
Cell[4319, 134, 146, 4, 70, "Notes",
 CellID->1358160974],
Cell[4468, 140, 111, 3, 70, "Notes",
 CellID->517723741],
Cell[4582, 145, 4786, 126, 70, "2ColumnTableMod",
 CellID->1013910898],
Cell[9371, 273, 302, 8, 70, "Notes",
 CellID->1012239651],
Cell[9676, 283, 255, 8, 70, "Notes",
 CellID->346362823]
}, Closed]],
Cell[CellGroupData[{
Cell[9968, 296, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[10287, 307, 510, 19, 70, "SeeAlso",
 CellID->1611395045]
}, Open  ]],
Cell[CellGroupData[{
Cell[10834, 331, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[11155, 342, 208, 5, 70, "Tutorials",
 CellID->341631938],
Cell[11366, 349, 216, 5, 70, "Tutorials",
 CellID->1550580332]
}, Open  ]],
Cell[CellGroupData[{
Cell[11619, 359, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[11940, 370, 383, 11, 70, "MoreAbout"]
}, Open  ]],
Cell[12338, 384, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

