(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16858,        549]
NotebookOptionsPosition[     13902,        457]
NotebookOutlinePosition[     15098,        489]
CellTagsIndexPosition[     15055,        486]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYSTEM PROGRAM", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Mathematica File Organization\"\>", 
       2->"\<\"Mathematica Sessions\"\>", 
       3->"\<\"System Administration for Network Licenses\"\>", 
       4->"\<\"System Administration for Single-User Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"monitorlm" :> 
          Documentation`HelpLookup["paclet:ref/program/monitorlm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"monitorlm\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System & License Management" :> 
          Documentation`HelpLookup[
           "paclet:guide/SystemAndLicenseManagement"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"System & License Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["mathlm", "ObjectNameAlt",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"mathlm", "  ", 
       StyleBox["options", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]starts ",
     StyleBox["MathLM",
      FontSlant->"Italic"],
     ", the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " license manager."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " runs on a networked license server, to which client computers connect via \
TCP/IP and check out a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " license for use."
}], "Notes",
 CellID->1213859875],

Cell["The following command-line options can be given:", "Notes",
 CellID->248272625],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "foreground"}], Cell[TextData[{
     "keep ",
     StyleBox["MathLM",
      FontSlant->"Italic"],
     " in the foreground and print server messages to ",
     StyleBox["stdout", "InlineCode"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "help"}], Cell[
    "print the list of all command-line options and the MathID", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "language"}], " ", 
     StyleBox["lang", "TI"]}], Cell[
    "specify the language in which to display server messages", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "localtime"}], Cell[
    "use local time instead of GMT in server messages", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "logfile"}], " ", 
     StyleBox["file", "TI"]}], Cell[
    "write server messages to a specified log file", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "logformat"}], " ", 
     StyleBox["string", "TI"]}], Cell[
    "specify the format for displaying server messages", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "loglevel"}], " ", 
     StyleBox["n", "TI"]}], Cell[
    "specify the level of verbosity of server messages", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "mathid"}], Cell[TextData[{
     "print the MathID of the machine running ",
     StyleBox["MathLM",
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "noremotemonitor"}], Cell[TextData[{
     "specify that ",
     StyleBox["MathLM",
      FontSlant->"Italic"],
     " cannot be remotely monitored via ",
     StyleBox[ButtonBox["MonitorLM",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/program/monitorlm"],
      FontSlant->"Italic"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "pwfile"}], " ", 
     StyleBox["file", "TI"]}], Cell[TextData[{
     "specify a file in which to look for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " passwords"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "restrict"}], " ", 
     StyleBox["file", "TI"]}], Cell[TextData[{
     "specify a policy file which describes how to allocate ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " licenses"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "timeout"}], " ", 
     StyleBox["n", "TI"]}], Cell[
    "return suspended licenses after a specified number of hours", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"-", "trfile"}], " ", 
     StyleBox["file", "TI"]}], Cell["\<\
specify a file that defines substitutions for the text of error messages\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, {
     None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True}}}},
 CellID->157282254],

Cell["\<\
The following additional command-line options are accepted on Windows:\
\>", "Notes",
 CellID->1094411804],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "install"}], Cell[TextData[{
     "install ",
     StyleBox["MathLM",
      FontSlant->"Italic"],
     " as a service program and automatically start the service"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", "uninstall"}], Cell[TextData[{
     "stop any currently running ",
     StyleBox["MathLM",
      FontSlant->"Italic"],
     " processes and remove ",
     StyleBox["MathLM",
      FontSlant->"Italic"],
     " from the list of services"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->581753273],

Cell[TextData[{
 "With ",
 StyleBox["-install", "InlineCode"],
 ", any arguments given are stored as a part of the service and used when \
starting ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " automatically."
}], "Notes",
 CellID->1782671328],

Cell[TextData[{
 "Possible values for ",
 Cell[BoxData[
  StyleBox["lang", "TI"]], "InlineFormula"],
 " in ",
 StyleBox["-language", "InlineCode"],
 " are English, French, German and Japanese."
}], "Notes",
 CellID->2037957168],

Cell[TextData[{
 "The four levels of verbosity in ",
 StyleBox["-loglevel", "InlineCode"],
 " are as follows:"
}], "Notes",
 CellID->1729436573],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "1", Cell["\<\
report server startup/shutdown errors and print a successful startup message\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "2", Cell["\<\
report everything from level 1 and all runtime error messages\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "3", Cell["\<\
report everything from level 2, all license activity, and startup messages \
pertaining to the process ID and socket number\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "4", Cell["\<\
report everything from level 3, debugging information, and a license table \
for every license transaction\
\>", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->449320266],

Cell[TextData[{
 "If ",
 StyleBox["-foreground", "InlineCode"],
 " is specified, the default verbosity level is set to 4."
}], "Notes",
 CellID->1173207810],

Cell[TextData[{
 "If ",
 StyleBox["-logfile", "InlineCode"],
 " is used without ",
 StyleBox["-loglevel", "InlineCode"],
 ", the default logging verbosity is set to 3."
}], "Notes",
 CellID->2056299563],

Cell[TextData[{
 "If ",
 StyleBox["-loglevel", "InlineCode"],
 " is used without specifying a level, the verbosity defaults to 4."
}], "Notes",
 CellID->772424170],

Cell[TextData[{
 "The default format for log messages is the W3C common logfile format. ",
 StyleBox["MathLM",
  FontSlant->"Italic"],
 " log files can be imported using the ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " format \"",
 Cell[BoxData[
  ButtonBox["ApacheLog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/ApacheLog"]], "InlineFormula"],
 "\"."
}], "Notes",
 CellID->594379075]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["monitorlm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/program/monitorlm"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->1138899866]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->502212112],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->341631938],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->1550580332]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->38303248],

Cell[TextData[ButtonBox["System & License Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemAndLicenseManagement"]], "MoreAbout"]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"mathlm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 7.3441620}", "context" -> "", 
    "keywords" -> {
     "foreground", "help", "language", "localtime", "logfile", "logformat", 
      "loglevel", "mathid", "noremotemonitor", "pwfile", "restrict", 
      "timeout", "trfile", "install", "uninstall"}, "index" -> True, "label" -> 
    "Mathematica System Program", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "mathlm options starts MathLM, the Mathematica license manager.", 
    "synonyms" -> {}, "title" -> "mathlm", "type" -> "System Program", "uri" -> 
    "ref/program/mathlm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2456, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3079, 87, 52, 1, 70, "ObjectNameAlt",
 CellID->1224892054],
Cell[3134, 90, 514, 18, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3685, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4163, 130, 268, 9, 70, "Notes",
 CellID->1213859875],
Cell[4434, 141, 85, 1, 70, "Notes",
 CellID->248272625],
Cell[4522, 144, 3366, 95, 70, "2ColumnTableMod",
 CellID->157282254],
Cell[7891, 241, 116, 3, 70, "Notes",
 CellID->1094411804],
Cell[8010, 246, 815, 24, 70, "2ColumnTableMod",
 CellID->581753273],
Cell[8828, 272, 247, 9, 70, "Notes",
 CellID->1782671328],
Cell[9078, 283, 227, 8, 70, "Notes",
 CellID->2037957168],
Cell[9308, 293, 144, 5, 70, "Notes",
 CellID->1729436573],
Cell[9455, 300, 944, 21, 70, "2ColumnTableMod",
 CellID->449320266],
Cell[10402, 323, 156, 5, 70, "Notes",
 CellID->1173207810],
Cell[10561, 330, 202, 7, 70, "Notes",
 CellID->2056299563],
Cell[10766, 339, 163, 5, 70, "Notes",
 CellID->772424170],
Cell[10932, 346, 474, 16, 70, "Notes",
 CellID->594379075]
}, Closed]],
Cell[CellGroupData[{
Cell[11443, 367, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[11762, 378, 211, 6, 70, "SeeAlso",
 CellID->1138899866]
}, Open  ]],
Cell[CellGroupData[{
Cell[12010, 389, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[12331, 400, 309, 9, 70, "Tutorials",
 CellID->502212112],
Cell[12643, 411, 284, 9, 70, "Tutorials",
 CellID->522604605],
Cell[12930, 422, 208, 5, 70, "Tutorials",
 CellID->341631938],
Cell[13141, 429, 216, 5, 70, "Tutorials",
 CellID->1550580332]
}, Open  ]],
Cell[CellGroupData[{
Cell[13394, 439, 318, 9, 70, "MoreAboutSection",
 CellID->38303248],
Cell[13715, 450, 145, 2, 70, "MoreAbout"]
}, Open  ]],
Cell[13875, 455, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

