(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19265,        631]
NotebookOptionsPosition[     15218,        502]
NotebookOutlinePosition[     16837,        544]
CellTagsIndexPosition[     16752,        539]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup["paclet:tutorial/NamingAndFindingFiles"], 
          "Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"], 
          "System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"Naming and Finding Files\"\>", 
       2->"\<\"Mathematica File Organization\"\>", 
       3->"\<\"System Administration for Single-User Licenses\"\>", 
       4->"\<\"System Administration for Network Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$UserBaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserBaseDirectory"], 
          "$InstallationDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InstallationDirectory"], 
          "$InitialDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InitialDirectory"], 
          "$HomeDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$HomeDirectory"], 
          "$RootDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$RootDirectory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$UserBaseDirectory\"\>", 
       2->"\<\"$InstallationDirectory\"\>", 3->"\<\"$InitialDirectory\"\>", 
       4->"\<\"$HomeDirectory\"\>", 
       5->"\<\"$RootDirectory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"Mathematica System Setup\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$BaseDirectory", "ObjectName",
 CellID->14316],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$BaseDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
     "\[LineSeparator]gives the base directory in which systemwide files to \
be loaded by ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " are conventionally placed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3917]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " returns the full name of the directory as a string. "
}], "Notes",
 CellID->21023],

Cell["Typical values are: ", "Notes",
 CellID->16440],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"C", ":", 
     RowBox[{
      RowBox[{"\[Backslash]", "Documents"}], "\[SpaceIndicator]", "and", 
      "\[SpaceIndicator]", 
      RowBox[{"Settings", "\[Backslash]", "All"}], "\[SpaceIndicator]", 
      RowBox[{"Users", "\[Backslash]", "Application"}], "\[SpaceIndicator]", 
      RowBox[{"Data", "\[Backslash]", 
       StyleBox["Mathematica",
        FontSlant->"Plain"]}]}]}], "\[SpanFromLeft]"},
   {Cell["      ", "TableRowIcon"], " ", Cell["Windows ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{"/", "Library"}], "/", 
     StyleBox["Mathematica",
      FontSlant->"Plain"]}], Cell["Macintosh ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     RowBox[{
      RowBox[{"/", "usr"}], "/", "share"}], "/", 
     StyleBox["Mathematica",
      FontSlant->"Plain"]}], Cell["Unix ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, False, True, True, True}}}},
 CellID->24048],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " can be specified by setting the ",
 Cell[BoxData["MATHEMATICA_BASE"], "InlineFormula"],
 " operating system environment variable when the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel is launched. It cannot be reset from inside the kernel. "
}], "Notes",
 CellID->27056],

Cell[TextData[{
 "Typical subdirectories of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->230],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "Applications", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " application packages "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "Autoload", Cell[
    "packages to be autoloaded on startup ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "FrontEnd", Cell[
    "front end initialization files ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Kernel", Cell[
    "kernel initialization files ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "Licensing", Cell[
    "license management files ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "SystemFiles", Cell[
    "general system files ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->4177],

Cell[TextData[{
 "These subdirectories are, if possible, created automatically the first time \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is run. "
}], "Notes",
 CellID->5531],

Cell[TextData[{
 "Appropriate subdirectories are automatically included on ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4881],

Cell[TextData[{
 "The subdirectories of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 " are given in ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " after the corresponding subdirectories of ",
 Cell[BoxData[
  ButtonBox["$UserBaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$UserBaseDirectory"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15072]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81557342],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->455409169],

Cell["The base directory in which systemwide files are placed:", "ExampleText",
 CellID->904142163],

Cell[CellGroupData[{

Cell[BoxData["$BaseDirectory"], "Input",
 CellLabel->"In[1]:=",
 CellID->323047369],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\All Users\\\\Application \
Data\\\\Mathematica\"\>"], "Output",
 ImageSize->{452, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276310046]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1453145935],

Cell[TextData[{
 "Subdirectories and files of ",
 Cell[BoxData[
  ButtonBox["$BaseDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BaseDirectory"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->1484427362],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "$UserBaseDirectory", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->879122256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->824052289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Applications\"\>", ",", "\<\"Autoload\"\>", 
   ",", "\<\"DatabaseResources\"\>", ",", "\<\"FrontEnd\"\>", 
   ",", "\<\"Kernel\"\>", ",", "\<\"Licensing\"\>", ",", "\<\"Paclets\"\>", 
   ",", "\<\"SystemFiles\"\>"}], "}"}]], "Output",
 ImageSize->{350, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149426901]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1839695861]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29851],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserBaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserBaseDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstallationDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InstallationDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InitialDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InitialDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HomeDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HomeDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$RootDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$RootDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22757]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19019],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->4406],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->126070248],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->34241995],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->157642292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->361211092],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->233219038],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->69666675]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$BaseDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 17.2598252}", "context" -> "System`", 
    "keywords" -> {
     "bin directory", "library directory", "packages", 
      "preferences directory", "share directory", "applications directory", 
      "preferences directorry", "addons directory", "package directory", 
      "paletter directory", "stylesheet directory", "init file directory", 
      "application directory", "settings directory"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$BaseDirectory gives the base directory in which systemwide files to be \
loaded by Mathematica are conventionally placed. ", 
    "synonyms" -> {"base directory"}, "title" -> "$BaseDirectory", "type" -> 
    "Symbol", "uri" -> "ref/$BaseDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9379, 282, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->81557342]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16610, 532}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3218, 73, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3841, 100, 52, 1, 70, "ObjectName",
 CellID->14316],
Cell[3896, 103, 557, 17, 70, "Usage",
 CellID->3917]
}, Open  ]],
Cell[CellGroupData[{
Cell[4490, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4968, 142, 232, 7, 70, "Notes",
 CellID->21023],
Cell[5203, 151, 53, 1, 70, "Notes",
 CellID->16440],
Cell[5259, 154, 1317, 32, 70, "2ColumnTableMod",
 CellID->24048],
Cell[6579, 188, 454, 13, 70, "Notes",
 CellID->27056],
Cell[7036, 203, 214, 8, 70, "Notes",
 CellID->230],
Cell[7253, 213, 1141, 25, 70, "2ColumnTableMod",
 CellID->4177],
Cell[8397, 240, 188, 7, 70, "Notes",
 CellID->5531],
Cell[8588, 249, 224, 8, 70, "Notes",
 CellID->4881],
Cell[8815, 259, 527, 18, 70, "Notes",
 CellID->15072]
}, Closed]],
Cell[CellGroupData[{
Cell[9379, 282, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81557342],
Cell[CellGroupData[{
Cell[9763, 296, 148, 5, 70, "ExampleSection",
 CellID->455409169],
Cell[9914, 303, 99, 1, 70, "ExampleText",
 CellID->904142163],
Cell[CellGroupData[{
Cell[10038, 308, 83, 2, 28, "Input",
 CellID->323047369],
Cell[10124, 312, 244, 6, 36, "Output",
 CellID->276310046]
}, Open  ]],
Cell[10383, 321, 126, 3, 70, "ExampleDelimiter",
 CellID->1453145935],
Cell[10512, 326, 225, 8, 70, "ExampleText",
 CellID->1484427362],
Cell[10740, 336, 143, 4, 70, "Input",
 CellID->879122256],
Cell[CellGroupData[{
Cell[10908, 344, 100, 3, 70, "Input",
 CellID->824052289],
Cell[11011, 349, 410, 10, 54, "Output",
 CellID->149426901]
}, Open  ]],
Cell[11436, 362, 124, 4, 70, "Input",
 CellID->1839695861]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11609, 372, 311, 9, 70, "SeeAlsoSection",
 CellID->29851],
Cell[11923, 383, 1276, 44, 70, "SeeAlso",
 CellID->22757]
}, Open  ]],
Cell[CellGroupData[{
Cell[13236, 432, 314, 9, 70, "TutorialsSection",
 CellID->19019],
Cell[13553, 443, 155, 3, 70, "Tutorials",
 CellID->4406],
Cell[13711, 448, 309, 9, 70, "Tutorials",
 CellID->126070248],
Cell[14023, 459, 214, 5, 70, "Tutorials",
 CellID->34241995],
Cell[14240, 466, 208, 5, 70, "Tutorials",
 CellID->157642292]
}, Open  ]],
Cell[CellGroupData[{
Cell[14485, 476, 319, 9, 70, "MoreAboutSection",
 CellID->361211092],
Cell[14807, 487, 179, 3, 70, "MoreAbout",
 CellID->233219038],
Cell[14989, 492, 157, 3, 70, "MoreAbout",
 CellID->69666675]
}, Open  ]],
Cell[15161, 498, 27, 0, 70, "History"],
Cell[15191, 500, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

