(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16878,        612]
NotebookOptionsPosition[     13018,        481]
NotebookOutlinePosition[     14352,        519]
CellTagsIndexPosition[     14267,        514]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$IgnoreEOF" :> 
          Documentation`HelpLookup["paclet:ref/$IgnoreEOF"], "$BatchOutput" :> 
          Documentation`HelpLookup["paclet:ref/$BatchOutput"], "$Linked" :> 
          Documentation`HelpLookup["paclet:ref/$Linked"], "$Notebooks" :> 
          Documentation`HelpLookup["paclet:ref/$Notebooks"], "$CommandLine" :> 
          Documentation`HelpLookup["paclet:ref/$CommandLine"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$IgnoreEOF\"\>", 2->"\<\"$BatchOutput\"\>", 
       3->"\<\"$Linked\"\>", 4->"\<\"$Notebooks\"\>", 
       5->"\<\"$CommandLine\"\>", 6->"\<\"$Input\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stand-Alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Stand-Alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$BatchInput", "ObjectName",
 CellID->30577],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$BatchInput",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$BatchInput"]], "InlineFormula"],
     "\[LineSeparator]is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if input in the current session is being fed directly to the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel in batch mode. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BatchInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchInput"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " if input is being taken from a file. "
}], "Notes",
 CellID->29565],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$BatchInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchInput"]], "InlineFormula"],
 " can be reset during a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->14476],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["$BatchInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchInput"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " terminates if it ever receives an interrupt, does not discard input when \
blank lines are given, and terminates when it receives \
end\[Hyphen]of\[Hyphen]file. "
}], "Notes",
 CellID->30138]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158990571],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->941705264],

Cell[TextData[{
 "In an interactive session, ",
 Cell[BoxData[
  ButtonBox["$BatchInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchInput"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " by default:"
}], "ExampleText",
 CellID->253271602],

Cell[CellGroupData[{

Cell[BoxData["$BatchInput"], "Input",
 CellLabel->"In[1]:=",
 CellID->68892269],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->411646108]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130609018],

Cell[TextData[{
 "Run a standalone ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel with an input file:"
}], "ExampleText",
 CellID->55730382],

Cell[BoxData[{
 RowBox[{
  RowBox[{"inputfile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<batchinput\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"outputfile", "=", 
   RowBox[{"ToFileName", "[", 
    RowBox[{"$TemporaryPrefix", ",", "\"\<batchoutput\>\""}], "]"}]}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->281168608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"math", "=", 
     RowBox[{"StringReplace", "[", 
      RowBox[{
       RowBox[{"First", "[", "$CommandLine", "]"}], ",", 
       RowBox[{"\"\<MathKernel\>\"", "\[Rule]", "\"\<math\>\""}]}], "]"}]}], 
    "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"commandstring", "=", 
    RowBox[{
    "math", "<>", "\"\< -noprompt < \\\"\>\"", "<>", "inputfile", "<>", 
     "\"\<\\\"\>\""}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214960096],

Cell[BoxData["\<\"math -noprompt < \\\"C:\\\\Documents and \
Settings\\\\roger\\\\Local Settings\\\\Temp\\\\batchinput\\\"\"\>"], "Output",\

 ImageSize->{571, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->410142524]
}, Open  ]],

Cell[TextData[{
 "Put commands in a file, in this case to evaluate ",
 Cell[BoxData[
  ButtonBox["$BatchInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchInput"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->560036410],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Put", "[", 
   RowBox[{
    RowBox[{"Unevaluated", "[", 
     RowBox[{"Put", "[", 
      RowBox[{"$BatchInput", ",", " ", 
       RowBox[{"ToFileName", "[", 
        RowBox[{"$TemporaryPrefix", ",", 
         RowBox[{"ToString", "[", "batchoutput", "]"}]}], "]"}]}], "]"}], 
     "]"}], ",", "inputfile"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FilePrint", "[", "inputfile", "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->157420480],

Cell["\<\
Put[$BatchInput, ToFileName[$TemporaryPrefix, ToString[batchoutput]]]\
\>", "Print",
 CellLabel->"During evaluation of In[28]:=",
 CellID->243012834]
}, Open  ]],

Cell["\<\
Run the command.  The session terminates at the end of the file:\
\>", "ExampleText",
 CellID->305607109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Run", "[", "commandstring", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->41580705],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->97637908]
}, Open  ]],

Cell[TextData[{
 "The output file contains the value of ",
 Cell[BoxData[
  ButtonBox["$BatchInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$BatchInput"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->129621163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "outputfile", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->411168041],

Cell["True", "Print",
 CellLabel->"During evaluation of In[31]:=",
 CellID->21622875]
}, Open  ]],

Cell["Delete the temporary files:", "ExampleText",
 CellID->125425680],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", 
  RowBox[{"{", 
   RowBox[{"inputfile", ",", "outputfile"}], "}"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->474535698]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29966],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$IgnoreEOF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$IgnoreEOF"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BatchOutput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$BatchOutput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Linked",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Linked"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Notebooks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Notebooks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CommandLine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CommandLine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31707]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7636],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->14473]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->483367960],

Cell[TextData[ButtonBox["Stand-Alone Mathematica Kernels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandaloneMathematicaKernels"]], "MoreAbout",
 CellID->225734504]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$BatchInput - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 17.7598380}", "context" -> "System`", 
    "keywords" -> {
     "batch files", "blank lines", "command files", "script files"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$BatchInput is True if input in the current session is being fed \
directly to the Mathematica kernel in batch mode. ", 
    "synonyms" -> {"batch input"}, "title" -> "$BatchInput", "type" -> 
    "Symbol", "uri" -> "ref/$BatchInput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5346, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->158990571]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14124, 507}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2323, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2946, 81, 49, 1, 70, "ObjectName",
 CellID->30577],
Cell[2998, 84, 678, 21, 70, "Usage",
 CellID->8547]
}, Open  ]],
Cell[CellGroupData[{
Cell[3713, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4191, 127, 331, 12, 70, "Notes",
 CellID->29565],
Cell[4525, 141, 260, 10, 70, "Notes",
 CellID->14476],
Cell[4788, 153, 521, 18, 70, "Notes",
 CellID->30138]
}, Closed]],
Cell[CellGroupData[{
Cell[5346, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->158990571],
Cell[CellGroupData[{
Cell[5731, 190, 148, 5, 70, "ExampleSection",
 CellID->941705264],
Cell[5882, 197, 349, 13, 70, "ExampleText",
 CellID->253271602],
Cell[CellGroupData[{
Cell[6256, 214, 79, 2, 28, "Input",
 CellID->68892269],
Cell[6338, 218, 162, 5, 36, "Output",
 CellID->411646108]
}, Open  ]],
Cell[6515, 226, 125, 3, 70, "ExampleDelimiter",
 CellID->130609018],
Cell[6643, 231, 155, 6, 70, "ExampleText",
 CellID->55730382],
Cell[6801, 239, 394, 12, 70, "Input",
 CellID->281168608],
Cell[CellGroupData[{
Cell[7220, 255, 524, 15, 70, "Input",
 CellID->214960096],
Cell[7747, 272, 272, 7, 36, "Output",
 CellID->410142524]
}, Open  ]],
Cell[8034, 282, 238, 8, 70, "ExampleText",
 CellID->560036410],
Cell[CellGroupData[{
Cell[8297, 294, 481, 13, 70, "Input",
 CellID->157420480],
Cell[8781, 309, 159, 4, 70, "Print",
 CellID->243012834]
}, Open  ]],
Cell[8955, 316, 115, 3, 70, "ExampleText",
 CellID->305607109],
Cell[CellGroupData[{
Cell[9095, 323, 110, 3, 70, "Input",
 CellID->41580705],
Cell[9208, 328, 157, 5, 36, "Output",
 CellID->97637908]
}, Open  ]],
Cell[9380, 336, 227, 8, 70, "ExampleText",
 CellID->129621163],
Cell[CellGroupData[{
Cell[9632, 348, 114, 3, 70, "Input",
 CellID->411168041],
Cell[9749, 353, 85, 2, 70, "Print",
 CellID->21622875]
}, Open  ]],
Cell[9849, 358, 70, 1, 70, "ExampleText",
 CellID->125425680],
Cell[9922, 361, 170, 5, 70, "Input",
 CellID->474535698]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10141, 372, 311, 9, 70, "SeeAlsoSection",
 CellID->29966],
Cell[10455, 383, 1449, 53, 70, "SeeAlso",
 CellID->31707]
}, Open  ]],
Cell[CellGroupData[{
Cell[11941, 441, 313, 9, 70, "TutorialsSection",
 CellID->7636],
Cell[12257, 452, 159, 3, 70, "Tutorials",
 CellID->14473]
}, Open  ]],
Cell[CellGroupData[{
Cell[12453, 460, 319, 9, 70, "MoreAboutSection",
 CellID->483367960],
Cell[12775, 471, 171, 3, 70, "MoreAbout",
 CellID->225734504]
}, Open  ]],
Cell[12961, 477, 27, 0, 70, "History"],
Cell[12991, 479, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

