(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14080,        508]
NotebookOptionsPosition[     10636,        393]
NotebookOutlinePosition[     12001,        431]
CellTagsIndexPosition[     11916,        426]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$ProcessorType" :> 
          Documentation`HelpLookup["paclet:ref/$ProcessorType"], "$System" :> 
          Documentation`HelpLookup["paclet:ref/$System"], 
          "$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], 
          "ByteOrdering" :> 
          Documentation`HelpLookup["paclet:ref/ByteOrdering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$ProcessorType\"\>", 
       2->"\<\"$System\"\>", 3->"\<\"$CharacterEncoding\"\>", 
       4->"\<\"ByteOrdering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Binary Data\"\>", 
       2->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$ByteOrdering", "ObjectName",
 CellID->26133],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$ByteOrdering",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ByteOrdering"]], "InlineFormula"],
     "\[LineSeparator]gives the native ordering of bytes in binary data on \
your computer system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible values of ",
 Cell[BoxData[
  ButtonBox["$ByteOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ByteOrdering"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->802],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " corresponds to big endian (appropriate for 680x0 and many other \
processors); ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " corresponds to little endian (appropriate for x86 processors). "
}], "Notes",
 CellID->31654],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " corresponds to having the most significant byte first; ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " to having the least significant byte first. "
}], "Notes",
 CellID->28317],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " is the order obtained from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IntegerDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IntegerDigits"], "[", 
   RowBox[{
    StyleBox["n", "TI"], ",", "256"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25505],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ByteOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ByteOrdering"]], "InlineFormula"],
 " gives the default setting for the ",
 Cell[BoxData[
  ButtonBox["ByteOrdering",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ByteOrdering"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Import",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Import"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Export",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Export"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12424]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->772863672],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->84985977],

Cell["Byte ordering on this machine:", "ExampleText",
 CellID->58841761],

Cell[CellGroupData[{

Cell[BoxData["$ByteOrdering"], "Input",
 CellLabel->"In[1]:=",
 CellID->697286007],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137333607]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->411698960],

Cell["Read in a byte stream with reversed byte ordering:", "ExampleText",
 CellID->11777507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ImportString", "[", 
   RowBox[{
    RowBox[{"ExportString", "[", 
     RowBox[{"12345", ",", "\"\<Integer32\>\""}], "]"}], ",", 
    "\"\<Integer32\>\"", ",", 
    RowBox[{"ByteOrdering", "\[Rule]", 
     RowBox[{"-", "$ByteOrdering"}]}]}], "]"}], "//", "First"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->281586624],

Cell[BoxData["959447040"], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->813624529]
}, Open  ]],

Cell["Correct the byte ordering:", "ExampleText",
 CellID->486732280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromDigits", "[", 
  RowBox[{
   RowBox[{"Reverse", "[", 
    RowBox[{"IntegerDigits", "[", 
     RowBox[{"%", ",", 
      RowBox[{"2", "^", "8"}], ",", "4"}], "]"}], "]"}], ",", 
   RowBox[{"2", "^", "8"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->329929585],

Cell[BoxData["12345"], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1425935]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3892],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ProcessorType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ProcessorType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$System",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$System"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ByteOrdering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ByteOrdering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25660]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17643],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->22958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->180720460],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->584570727],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->36636960]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$ByteOrdering - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 18.6661112}", "context" -> "System`", 
    "keywords" -> {
     "big-endian", "byte order", "endianness", "least significant byte", 
      "little-endian", "most significant byte"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$ByteOrdering gives the native ordering of bytes in binary data on your \
computer system. ", "synonyms" -> {"byte ordering"}, "title" -> 
    "$ByteOrdering", "type" -> "Symbol", "uri" -> "ref/$ByteOrdering"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5818, 200, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->772863672]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11773, 419}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2251, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2874, 82, 51, 1, 70, "ObjectName",
 CellID->26133],
Cell[2928, 85, 470, 14, 70, "Usage",
 CellID->17695]
}, Open  ]],
Cell[CellGroupData[{
Cell[3435, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3913, 121, 333, 14, 70, "Notes",
 CellID->802],
Cell[4249, 137, 309, 9, 70, "Notes",
 CellID->31654],
Cell[4561, 148, 266, 8, 70, "Notes",
 CellID->28317],
Cell[4830, 158, 346, 13, 70, "Notes",
 CellID->25505],
Cell[5179, 173, 602, 22, 70, "Notes",
 CellID->12424]
}, Closed]],
Cell[CellGroupData[{
Cell[5818, 200, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->772863672],
Cell[CellGroupData[{
Cell[6203, 214, 147, 5, 70, "ExampleSection",
 CellID->84985977],
Cell[6353, 221, 72, 1, 70, "ExampleText",
 CellID->58841761],
Cell[CellGroupData[{
Cell[6450, 226, 82, 2, 28, "Input",
 CellID->697286007],
Cell[6535, 230, 175, 6, 36, "Output",
 CellID->137333607]
}, Open  ]],
Cell[6725, 239, 125, 3, 70, "ExampleDelimiter",
 CellID->411698960],
Cell[6853, 244, 92, 1, 70, "ExampleText",
 CellID->11777507],
Cell[CellGroupData[{
Cell[6970, 249, 353, 10, 70, "Input",
 CellID->281586624],
Cell[7326, 261, 166, 5, 36, "Output",
 CellID->813624529]
}, Open  ]],
Cell[7507, 269, 69, 1, 70, "ExampleText",
 CellID->486732280],
Cell[CellGroupData[{
Cell[7601, 274, 293, 9, 70, "Input",
 CellID->329929585],
Cell[7897, 285, 160, 5, 36, "Output",
 CellID->1425935]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8118, 297, 310, 9, 70, "SeeAlsoSection",
 CellID->3892],
Cell[8431, 308, 979, 35, 70, "SeeAlso",
 CellID->25660]
}, Open  ]],
Cell[CellGroupData[{
Cell[9447, 348, 314, 9, 70, "TutorialsSection",
 CellID->17643],
Cell[9764, 359, 159, 3, 70, "Tutorials",
 CellID->22958]
}, Open  ]],
Cell[CellGroupData[{
Cell[9960, 367, 319, 9, 70, "MoreAboutSection",
 CellID->180720460],
Cell[10282, 378, 133, 3, 70, "MoreAbout",
 CellID->584570727],
Cell[10418, 383, 146, 3, 70, "MoreAbout",
 CellID->36636960]
}, Open  ]],
Cell[10579, 389, 27, 0, 70, "History"],
Cell[10609, 391, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

