(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19231,        612]
NotebookOptionsPosition[     15601,        493]
NotebookOutlinePosition[     17049,        533]
CellTagsIndexPosition[     16964,        528]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Raw Character Encodings" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RawCharacterEncodings"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Raw Character Encodings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/CharacterEncoding"], 
          "$CharacterEncodings" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncodings"], 
          "FromCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/FromCharacterCode"], 
          "ToCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/ToCharacterCode"], 
          "$SystemCharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$SystemCharacterEncoding"], 
          "$ByteOrdering" :> 
          Documentation`HelpLookup["paclet:ref/$ByteOrdering"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CharacterEncoding\"\>", 
       2->"\<\"$CharacterEncodings\"\>", 3->"\<\"FromCharacterCode\"\>", 
       4->"\<\"ToCharacterCode\"\>", 5->"\<\"$SystemCharacterEncoding\"\>", 
       6->"\<\"$ByteOrdering\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "International Character Sets" :> 
          Documentation`HelpLookup["paclet:guide/InternationalCharacterSets"],
           "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"International Character Sets\"\>", 
       3->"\<\"Locale & Internationalization\"\>", 
       4->"\<\"Mathematica Sessions\"\>", 
       5->"\<\"Mathematica System Setup\"\>", 
       6->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$CharacterEncoding", "ObjectName",
 CellID->23507],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$CharacterEncoding",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
     "\[LineSeparator]specifies the default raw character encoding to use for \
input and output functions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["$SystemCharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemCharacterEncoding"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29215],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"$CharacterEncoding", "=", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " takes all special characters to be represented externally by printable \
ASCII sequences such as \[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   StyleBox["Name", "TI"], "]"}]], "InlineFormula"],
 " and \[Backslash]",
 Cell[BoxData[
  RowBox[{":", 
   StyleBox["nnnn", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29051],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CharacterEncodings",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncodings"]], "InlineFormula"],
 " gives a list of all installed character encodings."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->42326806],

Cell["Typical examples include: ", "Notes",
 CellID->23866],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<AdobeStandard\>\"", Cell[
    "Adobe standard PostScript font encoding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ASCII\>\"", Cell[
    "full ASCII, with control characters ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<EUC\>\"", Cell[
    "extended Unix code for Japanese ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin1\>\"", Cell[
    "ISO 8859\[Hyphen]1 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin2\>\"", Cell[
    "ISO 8859\[Hyphen]2 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin3\>\"", Cell[
    "ISO 8859\[Hyphen]3 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatin4\>\"", Cell[
    "ISO 8859\[Hyphen]4 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ISOLatinCyrillic\>\"", Cell[
    "ISO 8859\[Hyphen]5 standard ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MacintoshRoman\>\"", Cell[
    "Macintosh roman font encoding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<PrintableASCII\>\"", Cell[
    "printable ASCII ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ShiftJIS\>\"", Cell["\<\
shift\[Hyphen]JIS encoding of JIS X 0208\[Hyphen]1990 and extensions \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Symbol\>\"", Cell[
    "symbol font encoding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Unicode\>\"", Cell["\<\
raw 16\[Hyphen]bit Unicode (with +1 byte ordering) \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<UTF8\>\"", Cell[
    "Unicode transformation format ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<WindowsANSI\>\"", Cell[
    "Windows standard font encoding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ZapfDingbats\>\"", Cell[
    "Zapf dingbats font encoding ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True}}}},
 CellID->24057],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"$CharacterEncoding", "=", "\"\<\!\(\*
StyleBox[\"encoding\", \"TI\"]\)\>\""}]], "InlineFormula"],
 " characters that are included in the encoding can be input in their raw 8\
\[Hyphen] or 16\[Hyphen]bit form, and will be output in this form. "
}], "Notes",
 CellID->19321],

Cell[TextData[{
 "Unencoded characters can be input and will be output in standard \
\[Backslash]",
 Cell[BoxData[
  RowBox[{"[", 
   StyleBox["Name", "TI"], "]"}]], "InlineFormula"],
 " or",
 " ",
 "\[Backslash]",
 Cell[BoxData[
  RowBox[{":", 
   StyleBox["nnnn", "TI"]}]], "InlineFormula"],
 " form. "
}], "Notes",
 CellID->16558],

Cell[TextData[{
 "When using a text\[Hyphen]based interface, resetting the value of ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 " has an immediate effect on standard input and output in a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session. "
}], "Notes",
 CellID->16674],

Cell[TextData[{
 "When using the notebook front end, raw character encodings are normally \
handled automatically based on the fonts you use. Only raw 16\[Hyphen]bit \
Unicode is ever sent through the ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " connection to the kernel. "
}], "Notes",
 CellID->5119],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 " affects the input and output of all characters, including those in symbol \
names and comments. "
}], "Notes",
 CellID->365],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 " also affects characters that appear in ",
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " primitives within graphics. "
}], "Notes",
 CellID->7938]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38218849],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->125774213],

Cell["The default raw character encoding:", "ExampleText",
 CellID->25707935],

Cell[CellGroupData[{

Cell[BoxData["$CharacterEncoding"], "Input",
 CellLabel->"In[1]:=",
 CellID->578239284],

Cell[BoxData["\<\"UTF-8\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->933829264]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9216],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncodings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncodings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SystemCharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SystemCharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ByteOrdering",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ByteOrdering"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3283],

Cell[TextData[ButtonBox["Raw Character Encodings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RawCharacterEncodings"]], "Tutorials",
 CellID->18211]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41360715],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->807241018],

Cell[TextData[ButtonBox["International Character Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InternationalCharacterSets"]], "MoreAbout",
 CellID->155489394],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->89143535],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->448216223],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->5261475],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->83150763]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$CharacterEncoding - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 20.4474068}", "context" -> "System`", 
    "keywords" -> {
     "character sets", "file encoding", "file language", 
      "native character sets", "raw character input", "unicode", 
      "unicode files", "unicode strings"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$CharacterEncoding specifies the default raw character encoding to use \
for input and output functions. ", "synonyms" -> {"character encoding"}, 
    "title" -> "$CharacterEncoding", "type" -> "Symbol", "uri" -> 
    "ref/$CharacterEncoding"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10889, 317, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->38218849]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16821, 521}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3316, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3939, 101, 56, 1, 70, "ObjectName",
 CellID->23507],
Cell[3998, 104, 486, 14, 70, "Usage",
 CellID->23]
}, Open  ]],
Cell[CellGroupData[{
Cell[4521, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4999, 140, 378, 13, 70, "Notes",
 CellID->29215],
Cell[5380, 155, 521, 18, 70, "Notes",
 CellID->29051],
Cell[5904, 175, 373, 10, 70, "Notes",
 CellID->42326806],
Cell[6280, 187, 59, 1, 70, "Notes",
 CellID->23866],
Cell[6342, 190, 2493, 49, 70, "2ColumnTableMod",
 CellID->24057],
Cell[8838, 241, 324, 8, 70, "Notes",
 CellID->19321],
Cell[9165, 251, 333, 14, 70, "Notes",
 CellID->16558],
Cell[9501, 267, 381, 11, 70, "Notes",
 CellID->16674],
Cell[9885, 280, 308, 8, 70, "Notes",
 CellID->5119],
Cell[10196, 290, 282, 8, 70, "Notes",
 CellID->365],
Cell[10481, 300, 371, 12, 70, "Notes",
 CellID->7938]
}, Closed]],
Cell[CellGroupData[{
Cell[10889, 317, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->38218849],
Cell[CellGroupData[{
Cell[11273, 331, 148, 5, 70, "ExampleSection",
 CellID->125774213],
Cell[11424, 338, 77, 1, 70, "ExampleText",
 CellID->25707935],
Cell[CellGroupData[{
Cell[11526, 343, 87, 2, 28, "Input",
 CellID->578239284],
Cell[11616, 347, 170, 5, 36, "Output",
 CellID->933829264]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11847, 359, 310, 9, 70, "SeeAlsoSection",
 CellID->9216],
Cell[12160, 370, 1543, 53, 70, "SeeAlso",
 CellID->540]
}, Open  ]],
Cell[CellGroupData[{
Cell[13740, 428, 313, 9, 70, "TutorialsSection",
 CellID->3283],
Cell[14056, 439, 155, 3, 70, "Tutorials",
 CellID->18211]
}, Open  ]],
Cell[CellGroupData[{
Cell[14248, 447, 318, 9, 70, "MoreAboutSection",
 CellID->41360715],
Cell[14569, 458, 151, 3, 70, "MoreAbout",
 CellID->807241018],
Cell[14723, 463, 166, 3, 70, "MoreAbout",
 CellID->155489394],
Cell[14892, 468, 169, 3, 70, "MoreAbout",
 CellID->89143535],
Cell[15064, 473, 151, 3, 70, "MoreAbout",
 CellID->448216223],
Cell[15218, 478, 156, 3, 70, "MoreAbout",
 CellID->5261475],
Cell[15377, 483, 152, 3, 70, "MoreAbout",
 CellID->83150763]
}, Open  ]],
Cell[15544, 489, 27, 0, 70, "History"],
Cell[15574, 491, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

