(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19502,        688]
NotebookOptionsPosition[     15187,        542]
NotebookOutlinePosition[     16592,        581]
CellTagsIndexPosition[     16507,        576]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Contexts" :> 
          Documentation`HelpLookup["paclet:tutorial/Contexts"], 
          "Contexts and Packages" :> 
          Documentation`HelpLookup["paclet:tutorial/ContextsAndPackages"], 
          "Setting Up Mathematica Packages" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SettingUpMathematicaPackages"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Contexts\"\>", 
       2->"\<\"Contexts and Packages\"\>", 
       3->"\<\"Setting Up Mathematica Packages\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Context" :> Documentation`HelpLookup["paclet:ref/$Context"], 
          "Contexts" :> Documentation`HelpLookup["paclet:ref/Contexts"], 
          "Begin" :> Documentation`HelpLookup["paclet:ref/Begin"], 
          "$Packages" :> Documentation`HelpLookup["paclet:ref/$Packages"], 
          "CellContext" :> 
          Documentation`HelpLookup["paclet:ref/CellContext"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$Context\"\>", 
       2->"\<\"Contexts\"\>", 3->"\<\"Begin\"\>", 4->"\<\"$Packages\"\>", 
       5->"\<\"CellContext\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica Session Information\"\>", 
       2->"\<\"Namespace Management\"\>", 
       3->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$ContextPath", "ObjectName",
 CellID->89],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$ContextPath",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
     "\[LineSeparator]is a global variable that gives a list of contexts, \
after ",
     Cell[BoxData[
      ButtonBox["$Context",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
     ", to search in trying to find a symbol that has been entered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25620]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Each context is specified by a string of the form ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\(\*
StyleBox[\"name\", \"TI\"]`\)]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3090],

Cell[TextData[{
 "The elements of ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " are tested in order to try to find a context containing a particular \
symbol. "
}], "Notes",
 CellID->25149],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " is modified by ",
 Cell[BoxData[
  ButtonBox["BeginPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BeginPackage"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EndPackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EndPackage"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24122],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " is a rough analog for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " symbols of the \[OpenCurlyDoubleQuote]search path\[CloseCurlyDoubleQuote] \
for files in many operating systems. "
}], "Notes",
 CellID->29685]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33269274],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->40948066],

Cell["The default contexts for looking up symbols:", "ExampleText",
 CellContext->"Global`",
 CellID->436426379],

Cell[CellGroupData[{

Cell[BoxData["$ContextPath"], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->91293924],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PacletManager`\"\>", ",", "\<\"System`\"\>", 
   ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{237, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->709096121]
}, Open  ]],

Cell["\<\
If a symbol with a given name cannot be found in one of these contexts a new \
one is created:\
\>", "ExampleText",
 CellContext->"Global`",
 CellID->10585112],

Cell[BoxData[
 RowBox[{"On", "[", 
  RowBox[{"General", "::", "newsym"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->30006833],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->58372248],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"newsym\"\>"}], ":", 
  " ", "\<\"Symbol \\!\\(x\\) is new. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\
\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/newsym\\\", ButtonNote -> \
\\\"General::newsym\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->948832559],

Cell[BoxData["x"], "Output",
 CellContext->"Global`",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->338247302]
}, Open  ]],

Cell[TextData[{
 "It is created in the context given by ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellContext->"Global`",
 CellID->26450323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Context", "[", "x", "]"}], "===", "$Context"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->18236164],

Cell[BoxData["True"], "Output",
 CellContext->"Global`",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->869815012]
}, Open  ]],

Cell["Turn off the message for new symbol creation:", "ExampleText",
 CellContext->"Global`",
 CellID->226094144],

Cell[BoxData[
 RowBox[{"Off", "[", 
  RowBox[{"General", "::", "newsym"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->4702810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1798],

Cell[TextData[{
 "Add  ",
 Cell[BoxData["Developer`"], "InlineFormula"],
 " context to the context path:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->583245741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$ContextPath", " ", "=", " ", 
  RowBox[{"Prepend", "[", 
   RowBox[{"$ContextPath", ",", "\"\<Developer`\>\""}], "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->15309725],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Developer`\"\>", ",", "\<\"PacletManager`\"\>", 
   ",", "\<\"System`\"\>", ",", "\<\"Global`\"\>"}], "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{318, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156576018]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData["PackedArrayForm"], "InlineFormula"],
 " is a command in the  ",
 Cell[BoxData["Developer`"], "InlineFormula"],
 " context that can now be used directly:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->1999756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PackedArrayForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Range", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->89012951],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\<\"PackedArray\"\>", "[", 
    RowBox[{"Integer", ",", 
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}]}], "]"}], ",", 
   RowBox[{"\<\"PackedArray\"\>", "[", 
    RowBox[{"Integer", ",", 
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "2", 
      "\[InvisibleSpace]", "\<\">\"\>"}]}], "]"}], ",", 
   RowBox[{"\<\"PackedArray\"\>", "[", 
    RowBox[{"Integer", ",", 
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}]}], "]"}], ",", 
   RowBox[{"\<\"PackedArray\"\>", "[", 
    RowBox[{"Integer", ",", 
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}]}], "]"}], ",", 
   RowBox[{"\<\"PackedArray\"\>", "[", 
    RowBox[{"Integer", ",", 
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "5", 
      "\[InvisibleSpace]", "\<\">\"\>"}]}], "]"}]}], "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{557, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->798782527]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28805],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Context",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Context"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Contexts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Contexts"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Begin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Begin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Packages",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Packages"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellContext",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellContext"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5699]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17951],

Cell[TextData[ButtonBox["Contexts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Contexts"]], "Tutorials",
 CellID->17470],

Cell[TextData[ButtonBox["Contexts and Packages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ContextsAndPackages"]], "Tutorials",
 CellID->38234755],

Cell[TextData[{
 ButtonBox["Setting Up ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"],
  FontSlant->"Italic"],
 ButtonBox[" Packages",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SettingUpMathematicaPackages"]
}], "Tutorials",
 CellID->132285413]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->926305182],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->884634647],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->439585531],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->296955049]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$ContextPath - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 24.0568742}", "context" -> "System`", 
    "keywords" -> {
     "search path", "symbol search path", "symbol lookup path", 
      "symbol lookup contexts", "namespace"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$ContextPath is a global variable that gives a list of contexts, after \
$Context, to search in trying to find a symbol that has been entered. ", 
    "synonyms" -> {"context path"}, "title" -> "$ContextPath", "type" -> 
    "Symbol", "uri" -> "ref/$ContextPath"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5988, 190, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->33269274]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16365, 569}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2795, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3418, 91, 47, 1, 70, "ObjectName",
 CellID->89],
Cell[3468, 94, 657, 19, 70, "Usage",
 CellID->25620]
}, Open  ]],
Cell[CellGroupData[{
Cell[4162, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4640, 135, 202, 7, 70, "Notes",
 CellID->3090],
Cell[4845, 144, 276, 9, 70, "Notes",
 CellID->25149],
Cell[5124, 155, 458, 17, 70, "Notes",
 CellID->24122],
Cell[5585, 174, 366, 11, 70, "Notes",
 CellID->29685]
}, Closed]],
Cell[CellGroupData[{
Cell[5988, 190, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->33269274],
Cell[CellGroupData[{
Cell[6372, 204, 147, 5, 70, "ExampleSection",
 CellID->40948066],
Cell[6522, 211, 112, 2, 70, "ExampleText",
 CellID->436426379],
Cell[CellGroupData[{
Cell[6659, 217, 105, 3, 28, "Input",
 CellID->91293924],
Cell[6767, 222, 292, 9, 36, "Output",
 CellID->709096121]
}, Open  ]],
Cell[7074, 234, 169, 5, 70, "ExampleText",
 CellID->10585112],
Cell[7246, 241, 157, 5, 70, "Input",
 CellID->30006833],
Cell[CellGroupData[{
Cell[7428, 250, 94, 3, 70, "Input",
 CellID->58372248],
Cell[7525, 255, 355, 7, 70, "Message",
 CellID->948832559],
Cell[7883, 264, 183, 6, 36, "Output",
 CellID->338247302]
}, Open  ]],
Cell[8081, 273, 245, 9, 70, "ExampleText",
 CellID->26450323],
Cell[CellGroupData[{
Cell[8351, 286, 159, 5, 70, "Input",
 CellID->18236164],
Cell[8513, 293, 186, 6, 36, "Output",
 CellID->869815012]
}, Open  ]],
Cell[8714, 302, 113, 2, 70, "ExampleText",
 CellID->226094144],
Cell[8830, 306, 157, 5, 70, "Input",
 CellID->4702810]
}, Open  ]],
Cell[CellGroupData[{
Cell[9024, 316, 222, 7, 70, "ExampleSection",
 CellID->1798],
Cell[9249, 325, 169, 6, 70, "ExampleText",
 CellID->583245741],
Cell[CellGroupData[{
Cell[9443, 335, 223, 6, 70, "Input",
 CellID->15309725],
Cell[9669, 343, 319, 9, 36, "Output",
 CellID->156576018]
}, Open  ]],
Cell[10003, 355, 252, 8, 70, "ExampleText",
 CellID->1999756],
Cell[CellGroupData[{
Cell[10280, 367, 276, 9, 70, "Input",
 CellID->89012951],
Cell[10559, 378, 1104, 28, 54, "Output",
 CellID->798782527]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11724, 413, 311, 9, 70, "SeeAlsoSection",
 CellID->28805],
Cell[12038, 424, 1187, 44, 70, "SeeAlso",
 CellID->5699]
}, Open  ]],
Cell[CellGroupData[{
Cell[13262, 473, 314, 9, 70, "TutorialsSection",
 CellID->17951],
Cell[13579, 484, 127, 3, 70, "Tutorials",
 CellID->17470],
Cell[13709, 489, 154, 3, 70, "Tutorials",
 CellID->38234755],
Cell[13866, 494, 412, 12, 70, "Tutorials",
 CellID->132285413]
}, Open  ]],
Cell[CellGroupData[{
Cell[14315, 511, 319, 9, 70, "MoreAboutSection",
 CellID->926305182],
Cell[14637, 522, 172, 3, 70, "MoreAbout",
 CellID->884634647],
Cell[14812, 527, 151, 3, 70, "MoreAbout",
 CellID->439585531],
Cell[14966, 532, 149, 3, 70, "MoreAbout",
 CellID->296955049]
}, Open  ]],
Cell[15130, 538, 27, 0, 70, "History"],
Cell[15160, 540, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

