(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16273,        612]
NotebookOptionsPosition[     11981,        467]
NotebookOutlinePosition[     13517,        510]
CellTagsIndexPosition[     13391,        504]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Two\[Hyphen]Way Communication with External Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Two\[Hyphen]Way Communication with External Programs\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$ParentLink" :> 
          Documentation`HelpLookup["paclet:ref/$ParentLink"], "Links" :> 
          Documentation`HelpLookup["paclet:ref/Links"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$ParentLink\"\>", 2->"\<\"Links\"\>", 
       3->"\<\"$Input\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$CurrentLink", "ObjectName",
 CellID->4003],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$CurrentLink",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
     "\[LineSeparator]is the ",
     Cell[BoxData[
      ButtonBox["LinkObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/LinkObject"]], "InlineFormula"],
     " representing the ",
     StyleBox["MathLink",
      FontSlant->"Italic"],
     " connection for an external program currently being installed or being \
called. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22760]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CurrentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
 " is temporarily set by ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " and by ",
 Cell[BoxData["ExternalCall"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17501],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["$CurrentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
 " to distinguish between several instances of an external program running at \
the same time. "
}], "Notes",
 CellID->30815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CurrentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
 " can be included in ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{
    ButtonBox["Pattern",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Pattern"], ":"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{":", 
   RowBox[{"Arguments", ":"}]}]], "InlineFormula"],
 " ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " template specifications, and will be evaluated at the time when ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 " is called. "
}], "Notes",
 CellID->21671]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->336962385],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->88790262],

Cell["Set the directory: ", "ExampleText",
 CellContext->"Global`",
 CellID->672120963],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{
   "$InstallationDirectory", "<>", " ", 
    "\"\</SystemFiles/Links/MathLink/DeveloperKit/\>\"", "<>", "$SystemID"}], 
   "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->187884416],

Cell[TextData[{
 "Install two instances of external ",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 "-compatible programs:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->559961695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link1", "=", 
  RowBox[{
  "Install", "[", "\"\<PrebuiltExamples/counter\>\"", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->278797890],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"PrebuiltExamples/counter\"\>", ",", "225", ",", "11"}], 
  "]"}]], "Output",
 CellContext->"Global`",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->752772015]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"link2", "=", 
  RowBox[{
  "Install", "[", "\"\<PrebuiltExamples/counter\>\"", "]"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->411234269],

Cell[BoxData[
 RowBox[{"LinkObject", "[", 
  RowBox[{"\<\"PrebuiltExamples/counter\"\>", ",", "226", ",", "12"}], 
  "]"}]], "Output",
 CellContext->"Global`",
 ImageSize->{314, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->156710212]
}, Open  ]],

Cell["Get usage information about linked-in symbols: ", "ExampleText",
 CellContext->"Global`",
 CellID->228134327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "AddToCounter"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[4]:=",
 CellID->242314195],

Cell[BoxData[
 StyleBox["\<\"AddToCounter[ ck, n] adds n to the counter   ck and returns \
the accumulated value.\"\>", "MSG"]], "Print", "PrintUsage",
 CellTags->"Info3384536531-1557917",
 CellID->113511510]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$CurrentLink",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CurrentLink"]], "InlineFormula"],
 " is used keep track of different persistent variables: "
}], "ExampleText",
 CellContext->"Global`",
 CellID->179474072],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Import", "[", 
  RowBox[{"\"\<MathLinkExamples/counter/counter.tm\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"\"\<Lines\>\"", ",", "21"}], "}"}]}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[5]:=",
 CellID->388539414],

Cell[BoxData["\<\":Pattern:       AddToCounter[$CurrentLink, \
n_Integer]\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{375, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->172616242]
}, Open  ]],

Cell[TextData[{
 "Update the value of the ",
 Cell[BoxData[
  StyleBox["link1", "TI"]], "InlineFormula"],
 " counter:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->952845457],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AddToCounter", "[", 
  RowBox[{"link1", ",", "1"}], "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[6]:=",
 CellID->593416509],

Cell[BoxData["1"], "Output",
 CellContext->"Global`",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->109218856]
}, Open  ]],

Cell["Check the value of the two counters: ", "ExampleText",
 CellContext->"Global`",
 CellID->643379137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AddToCounter", "[", 
    RowBox[{"link1", ",", "0"}], "]"}], ",", 
   RowBox[{"AddToCounter", "[", 
    RowBox[{"link2", ",", "0"}], "]"}]}], "}"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[7]:=",
 CellID->702625090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0"}], "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->10831063]
}, Open  ]],

Cell["Terminate the external programs:", "ExampleText",
 CellContext->"Global`",
 CellID->1721532427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Uninstall", "/@", " ", 
  RowBox[{"{", 
   RowBox[{"link1", ",", "link2"}], "}"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[8]:=",
 CellID->17513569],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"PrebuiltExamples/counter\"\>", 
   ",", "\<\"PrebuiltExamples/counter\"\>"}], "}"}]], "Output",
 CellContext->"Global`",
 ImageSize->{366, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->39714103]
}, Open  ]],

Cell["Reset to the original directory: ", "ExampleText",
 CellContext->"Global`",
 CellID->565310621],

Cell[BoxData[
 RowBox[{
  RowBox[{"ResetDirectory", "[", "]"}], ";"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[9]:=",
 CellID->312836734]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14269],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ParentLink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ParentLink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Links",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Links"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1169],

Cell[TextData[ButtonBox["Two\[Hyphen]Way Communication with External \
Programs",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TwoWayCommunicationWithExternalPrograms"]], "Tutorials",
 CellID->23938]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$CurrentLink - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 25.2287792}", "context" -> "System`", 
    "keywords" -> {
     "current MathLink program", "current link", "external program link"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$CurrentLink is the LinkObject representing the MathLink connection for \
an external program currently being installed or being called. ", 
    "synonyms" -> {"current link"}, "title" -> "$CurrentLink", "type" -> 
    "Symbol", "uri" -> "ref/$CurrentLink"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4761, 167, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->336962385]},
 "Info3384536531-1557917"->{
  Cell[7167, 268, 208, 4, 70, "Print",
   CellTags->"Info3384536531-1557917",
   CellID->113511510]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13117, 493},
 {"Info3384536531-1557917", 13266, 497}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1447, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2070, 62, 49, 1, 70, "ObjectName",
 CellID->4003],
Cell[2122, 65, 708, 22, 70, "Usage",
 CellID->22760]
}, Open  ]],
Cell[CellGroupData[{
Cell[2867, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3345, 109, 384, 14, 70, "Notes",
 CellID->17501],
Cell[3732, 125, 285, 9, 70, "Notes",
 CellID->30815],
Cell[4020, 136, 704, 26, 70, "Notes",
 CellID->21671]
}, Closed]],
Cell[CellGroupData[{
Cell[4761, 167, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->336962385],
Cell[CellGroupData[{
Cell[5146, 181, 147, 5, 70, "ExampleSection",
 CellID->88790262],
Cell[5296, 188, 87, 2, 70, "ExampleText",
 CellID->672120963],
Cell[5386, 192, 282, 9, 70, "Input",
 CellID->187884416],
Cell[5671, 203, 189, 7, 70, "ExampleText",
 CellID->559961695],
Cell[CellGroupData[{
Cell[5885, 214, 189, 6, 28, "Input",
 CellID->278797890],
Cell[6077, 222, 290, 9, 36, "Output",
 CellID->752772015]
}, Open  ]],
Cell[CellGroupData[{
Cell[6404, 236, 189, 6, 70, "Input",
 CellID->411234269],
Cell[6596, 244, 290, 9, 36, "Output",
 CellID->156710212]
}, Open  ]],
Cell[6901, 256, 115, 2, 70, "ExampleText",
 CellID->228134327],
Cell[CellGroupData[{
Cell[7041, 262, 123, 4, 70, "Input",
 CellID->242314195],
Cell[7167, 268, 208, 4, 70, "Print",
 CellTags->"Info3384536531-1557917",
 CellID->113511510]
}, Open  ]],
Cell[7390, 275, 265, 8, 70, "ExampleText",
 CellID->179474072],
Cell[CellGroupData[{
Cell[7680, 287, 254, 7, 70, "Input",
 CellID->388539414],
Cell[7937, 296, 246, 7, 36, "Output",
 CellID->172616242]
}, Open  ]],
Cell[8198, 306, 182, 7, 70, "ExampleText",
 CellID->952845457],
Cell[CellGroupData[{
Cell[8405, 317, 160, 5, 70, "Input",
 CellID->593416509],
Cell[8568, 324, 183, 6, 36, "Output",
 CellID->109218856]
}, Open  ]],
Cell[8766, 333, 105, 2, 70, "ExampleText",
 CellID->643379137],
Cell[CellGroupData[{
Cell[8896, 339, 278, 9, 70, "Input",
 CellID->702625090],
Cell[9177, 350, 227, 8, 36, "Output",
 CellID->10831063]
}, Open  ]],
Cell[9419, 361, 101, 2, 70, "ExampleText",
 CellID->1721532427],
Cell[CellGroupData[{
Cell[9545, 367, 185, 6, 70, "Input",
 CellID->17513569],
Cell[9733, 375, 294, 9, 36, "Output",
 CellID->39714103]
}, Open  ]],
Cell[10042, 387, 101, 2, 70, "ExampleText",
 CellID->565310621],
Cell[10146, 391, 148, 5, 70, "Input",
 CellID->312836734]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10343, 402, 311, 9, 70, "SeeAlsoSection",
 CellID->14269],
Cell[10657, 413, 692, 26, 70, "SeeAlso",
 CellID->10859]
}, Open  ]],
Cell[CellGroupData[{
Cell[11386, 444, 313, 9, 70, "TutorialsSection",
 CellID->1169],
Cell[11702, 455, 207, 5, 70, "Tutorials",
 CellID->23938]
}, Open  ]],
Cell[11924, 463, 27, 0, 70, "History"],
Cell[11954, 465, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

