(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13523,        435]
NotebookOptionsPosition[     10757,        346]
NotebookOutlinePosition[     12065,        383]
CellTagsIndexPosition[     11980,        378]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$ControlActiveSetting" :> 
          Documentation`HelpLookup["paclet:ref/$ControlActiveSetting"], 
          "ControlActive" :> 
          Documentation`HelpLookup["paclet:ref/ControlActive"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$ControlActiveSetting\"\>", 
       2->"\<\"ControlActive\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Dynamic Interactivity Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$DynamicEvaluation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$DynamicEvaluation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$DynamicEvaluation"]], "InlineFormula"],
     "\[LineSeparator]is a symbol whose value is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if it is evaluated as part of the evaluation of a ",
     Cell[BoxData[
      ButtonBox["Dynamic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->779755198],

Cell[TextData[{
 "Detect whether an evaluation is occurring inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->220435292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$DynamicEvaluation", ",", 
   RowBox[{"Dynamic", "[", "$DynamicEvaluation", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1411892988],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", 
   DynamicBox[ToBoxes[$DynamicEvaluation, StandardForm],
    ImageSizeCache->{28., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1581333852]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133887545],

Cell[TextData[{
 "The evaluations are inside a ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->92997034],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"$DynamicEvaluation", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "None"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->426616188],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0}}, Typeset`size$$ = {28., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $DynamicEvaluation, 
      "Specifications" :> {{$CellContext`x$$, 0, ControlType -> None}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{74., {32., 37.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{78, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132335155]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ControlActiveSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ControlActiveSetting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->415575510]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$DynamicEvaluation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 32.2914600}", "context" -> "System`", 
    "keywords" -> {"detect dynamic evaluation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$DynamicEvaluation is a symbol whose value is True if it is evaluated as \
part of the evaluation of a Dynamic.", "synonyms" -> {"dynamic evaluation"}, 
    "title" -> "$DynamicEvaluation", "type" -> "Symbol", "uri" -> 
    "ref/$DynamicEvaluation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5144, 146, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11845, 371}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2134, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2757, 79, 1583, 37, 70, "ObjectNameGrid"],
Cell[4343, 118, 764, 23, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5144, 146, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[5521, 160, 148, 5, 70, "ExampleSection",
 CellID->779755198],
Cell[5672, 167, 230, 8, 70, "ExampleText",
 CellID->220435292],
Cell[CellGroupData[{
Cell[5927, 179, 185, 5, 28, "Input",
 CellID->1411892988],
Cell[6115, 186, 299, 9, 36, "Output",
 CellID->1581333852]
}, Open  ]],
Cell[6429, 198, 125, 3, 70, "ExampleDelimiter",
 CellID->133887545],
Cell[6557, 203, 343, 13, 70, "ExampleText",
 CellID->92997034],
Cell[CellGroupData[{
Cell[6925, 220, 198, 6, 28, "Input",
 CellID->426616188],
Cell[7126, 228, 1486, 34, 92, "Output",
 CellID->132335155]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8673, 269, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[8992, 280, 491, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[9520, 302, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[9841, 313, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[10003, 318, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[10213, 326, 299, 8, 70, "MoreAboutSection"],
Cell[10515, 336, 170, 3, 70, "MoreAbout",
 CellID->415575510]
}, Open  ]],
Cell[10700, 342, 27, 0, 70, "History"],
Cell[10730, 344, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

