(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12131,        462]
NotebookOptionsPosition[      8593,        339]
NotebookOutlinePosition[      9806,        375]
CellTagsIndexPosition[      9722,        370]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Main Loop\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Urgent" :> Documentation`HelpLookup["paclet:ref/$Urgent"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"$Urgent\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stand-Alone Mathematica Kernels" :> 
          Documentation`HelpLookup[
           "paclet:guide/StandaloneMathematicaKernels"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Stand-Alone Mathematica Kernels\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$Echo", "ObjectName",
 CellID->17798],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Echo",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Echo"]], "InlineFormula"],
     "\[LineSeparator]gives a list of files and pipes to which all input is \
echoed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31405]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["$Echo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Echo"]], "InlineFormula"],
 " to keep a file of all your input commands. "
}], "Notes",
 CellID->18996]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26620494],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->5270611],

Cell["Echo input to a temporary file:", "ExampleText",
 CellID->102273240],

Cell[BoxData[
 RowBox[{
  RowBox[{"stream", " ", "=", " ", 
   RowBox[{"OpenWrite", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68946096],

Cell["Get the file name:", "ExampleText",
 CellID->94736634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"filename", " ", "=", " ", 
  RowBox[{"First", "[", "stream", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267114265],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\rknapp\\\\Local \
Settings\\\\Temp\\\\000002a01740\"\>"], "Output",
 ImageSize->{459, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252592290]
}, Open  ]],

Cell["\<\
Append the stream to the list of streams that input is being echoed to:\
\>", "ExampleText",
 CellID->35886120],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Echo", ",", " ", "stream"}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->355455517],

Cell[TextData[{
 "Enter commands in cells with ",
 Cell[BoxData["\"\<RawInputForm\>\""], "InlineFormula"],
 " style:"
}], "ExampleText",
 CellID->689705018],

Cell[CellGroupData[{

Cell["2 + 2", "Input",
 CellLabel->"In[4]:=",
 CellID->242736603],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->194696791]
}, Open  ]],

Cell[CellGroupData[{

Cell["f[g[x]]", "Input",
 CellLabel->"In[5]:=",
 CellID->325257950],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", "x", "]"}], "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->47355570]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$Echo",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Echo"]], "InlineFormula"],
 " to its default and close the stream and :"
}], "ExampleText",
 CellID->82892638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"$Echo", " ", "=", " ", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Close", "[", "stream", "]"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->481696119],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\rknapp\\\\Local \
Settings\\\\Temp\\\\000002a01740\"\>"], "Output",
 ImageSize->{459, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->246007112]
}, Open  ]],

Cell["Show the contents of the file:", "ExampleText",
 CellID->235370083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", "filename", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->535186641],

Cell["\<\
2 + 2
f[g[x]]
\
\>", "Print",
 CellLabel->"During evaluation of In[7]:=",
 CellID->536852030]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3080],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["$Urgent",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Urgent"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17693],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->13461]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->25744747],

Cell[TextData[ButtonBox["Stand-Alone Mathematica Kernels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandaloneMathematicaKernels"]], "MoreAbout",
 CellID->5171938]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Echo - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 32.6352188}", "context" -> "System`", 
    "keywords" -> {"record input", "echo input"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$Echo gives a list of files and pipes to which all input is echoed. ", 
    "synonyms" -> {}, "title" -> "$Echo", "type" -> "Symbol", "uri" -> 
    "ref/$Echo"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3626, 125, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26620494]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9580, 363}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1742, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2365, 73, 43, 1, 70, "ObjectName",
 CellID->17798],
Cell[2411, 76, 441, 14, 70, "Usage",
 CellID->31405]
}, Open  ]],
Cell[CellGroupData[{
Cell[2889, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3367, 112, 222, 8, 70, "Notes",
 CellID->18996]
}, Closed]],
Cell[CellGroupData[{
Cell[3626, 125, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26620494],
Cell[CellGroupData[{
Cell[4010, 139, 146, 5, 70, "ExampleSection",
 CellID->5270611],
Cell[4159, 146, 74, 1, 70, "ExampleText",
 CellID->102273240],
Cell[4236, 149, 156, 5, 70, "Input",
 CellID->68946096],
Cell[4395, 156, 60, 1, 70, "ExampleText",
 CellID->94736634],
Cell[CellGroupData[{
Cell[4480, 161, 146, 4, 28, "Input",
 CellID->267114265],
Cell[4629, 167, 248, 6, 36, "Output",
 CellID->252592290]
}, Open  ]],
Cell[4892, 176, 121, 3, 70, "ExampleText",
 CellID->35886120],
Cell[5016, 181, 160, 5, 70, "Input",
 CellID->355455517],
Cell[5179, 188, 156, 5, 70, "ExampleText",
 CellID->689705018],
Cell[CellGroupData[{
Cell[5360, 197, 65, 2, 70, "Input",
 CellID->242736603],
Cell[5428, 201, 158, 5, 36, "Output",
 CellID->194696791]
}, Open  ]],
Cell[CellGroupData[{
Cell[5623, 211, 67, 2, 70, "Input",
 CellID->325257950],
Cell[5693, 215, 212, 7, 36, "Output",
 CellID->47355570]
}, Open  ]],
Cell[5920, 225, 225, 8, 70, "ExampleText",
 CellID->82892638],
Cell[CellGroupData[{
Cell[6170, 237, 185, 6, 70, "Input",
 CellID->481696119],
Cell[6358, 245, 248, 6, 36, "Output",
 CellID->246007112]
}, Open  ]],
Cell[6621, 254, 73, 1, 70, "ExampleText",
 CellID->235370083],
Cell[CellGroupData[{
Cell[6719, 259, 112, 3, 70, "Input",
 CellID->535186641],
Cell[6834, 264, 103, 6, 70, "Print",
 CellID->536852030]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6998, 277, 310, 9, 70, "SeeAlsoSection",
 CellID->3080],
Cell[7311, 288, 194, 6, 70, "SeeAlso",
 CellID->28476]
}, Open  ]],
Cell[CellGroupData[{
Cell[7542, 299, 314, 9, 70, "TutorialsSection",
 CellID->17693],
Cell[7859, 310, 135, 3, 70, "Tutorials",
 CellID->13461]
}, Open  ]],
Cell[CellGroupData[{
Cell[8031, 318, 318, 9, 70, "MoreAboutSection",
 CellID->25744747],
Cell[8352, 329, 169, 3, 70, "MoreAbout",
 CellID->5171938]
}, Open  ]],
Cell[8536, 335, 27, 0, 70, "History"],
Cell[8566, 337, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

