(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12793,        430]
NotebookOptionsPosition[     10105,        340]
NotebookOutlinePosition[     11378,        377]
CellTagsIndexPosition[     11293,        372]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directory" :> Documentation`HelpLookup["paclet:ref/Directory"],
           "ParentDirectory" :> 
          Documentation`HelpLookup["paclet:ref/ParentDirectory"], 
          "$UserDocumentsDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserDocumentsDirectory"], 
          "$UserName" :> Documentation`HelpLookup["paclet:ref/$UserName"], 
          "$UserBaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserBaseDirectory"], 
          "$InstallationDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InstallationDirectory"], 
          "$BaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$BaseDirectory"], 
          "$InitialDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InitialDirectory"], 
          "$RootDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$RootDirectory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Directory\"\>", 
       2->"\<\"ParentDirectory\"\>", 3->"\<\"$UserDocumentsDirectory\"\>", 
       4->"\<\"$UserName\"\>", 5->"\<\"$UserBaseDirectory\"\>", 
       6->"\<\"$InstallationDirectory\"\>", 7->"\<\"$BaseDirectory\"\>", 
       8->"\<\"$InitialDirectory\"\>", 
       9->"\<\"$RootDirectory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$HomeDirectory", "ObjectName",
 CellID->612],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$HomeDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$HomeDirectory"]], "InlineFormula"],
     "\[LineSeparator]gives your \[OpenCurlyDoubleQuote]home\
\[CloseCurlyDoubleQuote] directory. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13475]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$HomeDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$HomeDirectory"]], "InlineFormula"],
 " returns the full name of the directory as a string. "
}], "Notes",
 CellID->49],

Cell[TextData[{
 "On multi\[Hyphen]user operating systems, ",
 Cell[BoxData[
  ButtonBox["$HomeDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$HomeDirectory"]], "InlineFormula"],
 " gives the main directory for the current user. "
}], "Notes",
 CellID->5847]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->188603472],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->259520832],

Cell["Your home directory on the current system:", "ExampleText",
 CellID->525304844],

Cell[CellGroupData[{

Cell[BoxData["$HomeDirectory"], "Input",
 CellLabel->"In[1]:=",
 CellID->23768301],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\"\>"], "Output",
 ImageSize->{221, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12343495]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5347],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ParentDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ParentDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserDocumentsDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserDocumentsDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserBaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserBaseDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstallationDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InstallationDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$BaseDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InitialDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InitialDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$RootDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$RootDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14447]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18019],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->32504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->359358569],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->47530626],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->37024752]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$HomeDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 40.8385538}", "context" -> "System`", 
    "keywords" -> {"user's directory"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$HomeDirectory gives your \
\\[OpenCurlyDoubleQuote]home\\[CloseCurlyDoubleQuote] directory. ", 
    "synonyms" -> {"home directory"}, "title" -> "$HomeDirectory", "type" -> 
    "Symbol", "uri" -> "ref/$HomeDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5232, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->188603472]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11150, 365}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3029, 69, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3652, 96, 50, 1, 70, "ObjectName",
 CellID->612],
Cell[3705, 99, 471, 14, 70, "Usage",
 CellID->13475]
}, Open  ]],
Cell[CellGroupData[{
Cell[4213, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4691, 135, 229, 7, 70, "Notes",
 CellID->49],
Cell[4923, 144, 272, 8, 70, "Notes",
 CellID->5847]
}, Closed]],
Cell[CellGroupData[{
Cell[5232, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->188603472],
Cell[CellGroupData[{
Cell[5617, 171, 148, 5, 70, "ExampleSection",
 CellID->259520832],
Cell[5768, 178, 85, 1, 70, "ExampleText",
 CellID->525304844],
Cell[CellGroupData[{
Cell[5878, 183, 82, 2, 28, "Input",
 CellID->23768301],
Cell[5963, 187, 202, 5, 36, "Output",
 CellID->12343495]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6226, 199, 310, 9, 70, "SeeAlsoSection",
 CellID->5347],
Cell[6539, 210, 2304, 80, 70, "SeeAlso",
 CellID->14447]
}, Open  ]],
Cell[CellGroupData[{
Cell[8880, 295, 314, 9, 70, "TutorialsSection",
 CellID->18019],
Cell[9197, 306, 156, 3, 70, "Tutorials",
 CellID->32504]
}, Open  ]],
Cell[CellGroupData[{
Cell[9390, 314, 319, 9, 70, "MoreAboutSection",
 CellID->359358569],
Cell[9712, 325, 178, 3, 70, "MoreAbout",
 CellID->47530626],
Cell[9893, 330, 140, 3, 70, "MoreAbout",
 CellID->37024752]
}, Open  ]],
Cell[10048, 336, 27, 0, 70, "History"],
Cell[10078, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

