(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12401,        426]
NotebookOptionsPosition[      9698,        336]
NotebookOutlinePosition[     10988,        373]
CellTagsIndexPosition[     10903,        368]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directory" :> Documentation`HelpLookup["paclet:ref/Directory"],
           "$CommandLine" :> 
          Documentation`HelpLookup["paclet:ref/$CommandLine"], 
          "$HomeDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$HomeDirectory"], 
          "$BaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$BaseDirectory"], 
          "$InstallationDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$InstallationDirectory"], 
          "$UserBaseDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$UserBaseDirectory"], 
          "$RootDirectory" :> 
          Documentation`HelpLookup["paclet:ref/$RootDirectory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Directory\"\>", 
       2->"\<\"$CommandLine\"\>", 3->"\<\"$HomeDirectory\"\>", 
       4->"\<\"$BaseDirectory\"\>", 5->"\<\"$InstallationDirectory\"\>", 
       6->"\<\"$UserBaseDirectory\"\>", 
       7->"\<\"$RootDirectory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$InitialDirectory", "ObjectName",
 CellID->28977],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$InitialDirectory",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$InitialDirectory"]], "InlineFormula"],
     "\[LineSeparator]gives the initial directory when the current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session was started. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$InitialDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InitialDirectory"]], "InlineFormula"],
 " returns the full name of the directory as a string. "
}], "Notes",
 CellID->32519],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is started from a shell or command line, ",
 Cell[BoxData[
  ButtonBox["$InitialDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InitialDirectory"]], "InlineFormula"],
 " gives the current operating system directory. "
}], "Notes",
 CellID->21128],

Cell[TextData[{
 "If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is started from a menu or icon, ",
 Cell[BoxData[
  ButtonBox["$InitialDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$InitialDirectory"]], "InlineFormula"],
 " typically gives the user\[CloseCurlyQuote]s home directory ",
 Cell[BoxData[
  ButtonBox["$HomeDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$HomeDirectory"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11642]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43257147],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->578044254],

Cell["Typical value of $InitialDirectory on Windows:", "ExampleText",
 CellID->4843967],

Cell[CellGroupData[{

Cell[BoxData["$InitialDirectory"], "Input",
 CellLabel->"In[1]:=",
 CellID->71982005],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\My \
Documents\"\>"], "Output",
 ImageSize->{312, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27105907]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17328],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CommandLine",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CommandLine"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HomeDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HomeDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$BaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$BaseDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$InstallationDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$InstallationDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$UserBaseDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$UserBaseDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$RootDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$RootDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28276]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13041],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->23442]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->166148575],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->239874077]
}, Open  ]],

Cell["New in 3  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$InitialDirectory - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 47.5105996}", "context" -> "System`", 
    "keywords" -> {"startup directory"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$InitialDirectory gives the initial directory when the current \
Mathematica session was started. ", "synonyms" -> {"initial directory"}, 
    "title" -> "$InitialDirectory", "type" -> "Symbol", "uri" -> 
    "ref/$InitialDirectory"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5455, 175, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43257147]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10761, 361}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2630, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3253, 91, 55, 1, 70, "ObjectName",
 CellID->28977],
Cell[3311, 94, 534, 16, 70, "Usage",
 CellID->29547]
}, Open  ]],
Cell[CellGroupData[{
Cell[3882, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4360, 132, 238, 7, 70, "Notes",
 CellID->32519],
Cell[4601, 141, 336, 11, 70, "Notes",
 CellID->21128],
Cell[4940, 154, 478, 16, 70, "Notes",
 CellID->11642]
}, Closed]],
Cell[CellGroupData[{
Cell[5455, 175, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43257147],
Cell[CellGroupData[{
Cell[5839, 189, 148, 5, 70, "ExampleSection",
 CellID->578044254],
Cell[5990, 196, 87, 1, 70, "ExampleText",
 CellID->4843967],
Cell[CellGroupData[{
Cell[6102, 201, 85, 2, 28, "Input",
 CellID->71982005],
Cell[6190, 205, 220, 6, 36, "Output",
 CellID->27105907]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6471, 218, 311, 9, 70, "SeeAlsoSection",
 CellID->17328],
Cell[6785, 229, 1770, 62, 70, "SeeAlso",
 CellID->28276]
}, Open  ]],
Cell[CellGroupData[{
Cell[8592, 296, 314, 9, 70, "TutorialsSection",
 CellID->13041],
Cell[8909, 307, 156, 3, 70, "Tutorials",
 CellID->23442]
}, Open  ]],
Cell[CellGroupData[{
Cell[9102, 315, 319, 9, 70, "MoreAboutSection",
 CellID->166148575],
Cell[9424, 326, 179, 3, 70, "MoreAbout",
 CellID->239874077]
}, Open  ]],
Cell[9618, 332, 50, 0, 70, "History"],
Cell[9671, 334, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

