(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9572,        324]
NotebookOptionsPosition[      7080,        242]
NotebookOutlinePosition[      8340,        278]
CellTagsIndexPosition[      8256,        273]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System Administration for Single-User Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/\
SystemAdministrationForSingleUserLicensesOverview"], 
          "System Administration for Network Licenses" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]},\
 #, 2]& , Evaluator -> Automatic], {
       1->"\<\"System Administration for Single-User Licenses\"\>", 
       2->"\<\"System Administration for Network Licenses\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MachineID" :> 
          Documentation`HelpLookup["paclet:ref/$MachineID"], "$LicenseServer" :> 
          Documentation`HelpLookup["paclet:ref/$LicenseServer"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MachineID\"\>", 
       2->"\<\"$LicenseServer\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "System & License Management" :> 
          Documentation`HelpLookup["paclet:guide/SystemAndLicenseManagement"],
           "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica System Setup\"\>", 
       2->"\<\"System & License Management\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$LicenseID", "ObjectName",
 CellID->25254],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$LicenseID",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$LicenseID"]], "InlineFormula"],
     " \[LineSeparator]is a string which gives the license ID under which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is being run."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->299851309],

Cell[CellGroupData[{

Cell[BoxData["$LicenseID"], "Input",
 CellLabel->"In[1]:=",
 CellID->410851554],

Cell[BoxData["\<\"L1111-1111\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82486510]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24418],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineID"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$LicenseServer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$LicenseServer"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30552]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25567],

Cell[TextData[ButtonBox["System Administration for Single-User Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForSingleUserLicensesOverview"]], \
"Tutorials",
 CellID->34241995],

Cell[TextData[ButtonBox["System Administration for Network Licenses",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SystemAdministrationForNetworkLicensesOverview"]], \
"Tutorials",
 CellID->157642292]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->109185349],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->243503779],

Cell[TextData[ButtonBox["System & License Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemAndLicenseManagement"]], "MoreAbout",
 CellID->35975088],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->422712314]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$LicenseID - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 30, 55.4795536}", "context" -> "System`", 
    "keywords" -> {"copy of Mathematica", "license number"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$LicenseID is a string which gives the license ID under which \
Mathematica is being run.", "synonyms" -> {"license ID"}, "title" -> 
    "$LicenseID", "type" -> "Symbol", "uri" -> "ref/$LicenseID"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3747, 111, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8121, 266}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2518, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3141, 87, 48, 1, 70, "ObjectName",
 CellID->25254],
Cell[3192, 90, 518, 16, 70, "Usage",
 CellID->4695]
}, Open  ]],
Cell[CellGroupData[{
Cell[3747, 111, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4124, 125, 148, 5, 70, "ExampleSection",
 CellID->299851309],
Cell[CellGroupData[{
Cell[4297, 134, 79, 2, 28, "Input",
 CellID->410851554],
Cell[4379, 138, 174, 5, 36, "Output",
 CellID->82486510]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4614, 150, 311, 9, 70, "SeeAlsoSection",
 CellID->24418],
Cell[4928, 161, 467, 17, 70, "SeeAlso",
 CellID->30552]
}, Open  ]],
Cell[CellGroupData[{
Cell[5432, 183, 314, 9, 70, "TutorialsSection",
 CellID->25567],
Cell[5749, 194, 214, 5, 70, "Tutorials",
 CellID->34241995],
Cell[5966, 201, 208, 5, 70, "Tutorials",
 CellID->157642292]
}, Open  ]],
Cell[CellGroupData[{
Cell[6211, 211, 319, 9, 70, "MoreAboutSection",
 CellID->109185349],
Cell[6533, 222, 158, 3, 70, "MoreAbout",
 CellID->243503779],
Cell[6694, 227, 164, 3, 70, "MoreAbout",
 CellID->35975088],
Cell[6861, 232, 147, 3, 70, "MoreAbout",
 CellID->422712314]
}, Open  ]],
Cell[7023, 238, 27, 0, 70, "History"],
Cell[7053, 240, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

