(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22779,        848]
NotebookOptionsPosition[     17343,        659]
NotebookOutlinePosition[     18699,        697]
CellTagsIndexPosition[     18614,        692]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arbitrary\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Arbitrary\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MaxPrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MaxPrecision"], "Quiet" :> 
          Documentation`HelpLookup["paclet:ref/Quiet"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$MaxPrecision\"\>", 
       2->"\<\"Quiet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>", 
       2->"\<\"Precision & Accuracy Control\"\>", 
       3->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MaxExtraPrecision", "ObjectName",
 CellID->18573],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MaxExtraPrecision",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
     "\[LineSeparator]gives the maximum number of extra digits of precision \
to be used in functions such as ",
     Cell[BoxData[
      ButtonBox["N",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/N"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1472]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " is 50. "
}], "Notes",
 CellID->27925],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Block",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Block"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"$MaxExtraPrecision", "=", 
      StyleBox["n", "TI"]}], "}"}], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " to reset the value of ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " temporarily during the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20089],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " is used implicitly in various exact numerical computations, including \
equality tests, comparisons and functions such as ",
 Cell[BoxData[
  ButtonBox["Round",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Round"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Sign",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sign"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18328]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116448362],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->76749663],

Cell["\<\
Allow up to 1000 digits of extra precision to complete a numerical \
approximation:\
\>", "ExampleText",
 CellID->76970723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "1000"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Cos", "[", "1", "]"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"Sin", "[", "1", "]"}], "^", "2"}], "-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"1", "-", 
        RowBox[{"Exp", "[", 
         RowBox[{"-", "1000"}], "]"}]}], "]"}]}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66702888],

Cell[BoxData["2.5379794487747283826459047397871684596`20.*^-435"], "Output",
 ImageSize->{197, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->79974306]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->637570969],

Cell["Allow as much extra precision as possible:", "ExampleText",
 CellID->513894508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "\[Infinity]"}], "}"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"2", "^", "1000000"}], "]"}], ",", "32"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162237992],

Cell[BoxData["0.650909333380289441796249738291306538920051899214`32."], \
"Output",
 ImageSize->{242, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385859573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->920432874],

Cell["The default of 50 is not sufficient for some calculations:", \
"ExampleText",
 CellID->596044705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"10", "^", "60"}], "]"}], ",", "47"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345495559],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Cos[1000000000000000000000000000000000000000000000000000000000000]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->24065774],

Cell[BoxData[
 RowBox[{"-", 
  "0.557182948248566708972916420591398992689132896067`36.82671582928246"}]], \
"Output",
 ImageSize->{285, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54791265]
}, Open  ]],

Cell["The result does not have the requested precision:", "ExampleText",
 CellID->68510520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"47", "-", 
  RowBox[{"Precision", "[", "%", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->313024071],

Cell[BoxData["10.173284170717537`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->849018382]
}, Open  ]],

Cell[TextData[{
 "Often raising ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " by just over the precision deficit will be sufficient:"
}], "ExampleText",
 CellID->564121097],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", 
     RowBox[{"50", "+", 
      RowBox[{"(", 
       RowBox[{"%", "+", "1"}], ")"}]}]}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"10", "^", "60"}], "]"}], ",", "47"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->252208935],

Cell[BoxData[
 RowBox[{"-", 
  "0.5571829482485667089729164205913989926891328960671940028337`47."}]], \
"Output",
 ImageSize->{355, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->246784209]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->179757551],

Cell[TextData[{
 "For hidden zeros, rasing ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " will not help:"
}], "ExampleText",
 CellID->78349844],

Cell[BoxData[
 RowBox[{
  RowBox[{"z", "=", 
   RowBox[{
    SqrtBox["2"], "+", 
    SqrtBox["3"], "-", 
    SqrtBox[
     RowBox[{"5", "+", 
      RowBox[{"2", " ", 
       SqrtBox["6"]}]}]]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->261870965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"z", ",", "30"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105634149],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\@2 + \\@3 - \\@\\(5 + \\(\\(2\\\\ \\@6\\)\\)\
\\)\\).\"\>"}]], "Message", "MSG",
 CellID->68410431],

Cell[BoxData["0``79.025083533165"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46759596]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "1000"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{"z", ",", "30"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->458351319],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(1000.`\\) \
reached while evaluating \\!\\(\\@2 + \\@3 - \\@\\(5 + \\(\\(2\\\\ \\@6\\)\\)\
\\)\\).\"\>"}]], "Message", "MSG",
 CellID->427505368],

Cell[BoxData["0``1029.025083533165"], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->26127418]
}, Open  ]],

Cell["\<\
Allowing unlimited extra precision can lead to running out of memory:\
\>", "ExampleText",
 CellID->563156161],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MemoryConstrained", "[", 
  RowBox[{
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"$MaxExtraPrecision", "=", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{"z", ",", "30"}], "]"}]}], "]"}], ",", "10000000"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->14226972],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->74925798]
}, Open  ]],

Cell[TextData[{
 "Relative error measured by ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " is not defined at zero, so use ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " as a goal:"
}], "ExampleText",
 CellID->112456393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "+", 
    RowBox[{"Sqrt", "[", "3", "]"}], "-", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"5", "+", 
      RowBox[{"2", "*", 
       RowBox[{"Sqrt", "[", "6", "]"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Infinity]", ",", "100"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->767281855],

Cell[BoxData["0``100."], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->387005954]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "%", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->525707487],

Cell[BoxData["100.`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->40674423]
}, Open  ]],

Cell["\<\
Symbolic simplification may resolve the dilemma conclusively:\
\>", "ExampleText",
 CellID->226524281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "z", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->409498226],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->268828643]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27222],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Quiet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quiet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11536]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6669],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "Tutorials",
 CellID->26659]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->46662702],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->560853554],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->206747277],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->97707173]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxExtraPrecision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 5.1985524}", "context" -> "System`", 
    "keywords" -> {
     "adaptive extra precision", "maximum adaptive extra precision"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$MaxExtraPrecision gives the maximum number of extra digits of precision \
to be used in functions such as N. ", "synonyms" -> {"max extra precision"}, 
    "title" -> "$MaxExtraPrecision", "type" -> "Symbol", "uri" -> 
    "ref/$MaxExtraPrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5564, 185, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->116448362]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18471, 685}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2310, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2933, 84, 56, 1, 70, "ObjectName",
 CellID->18573],
Cell[2992, 87, 622, 19, 70, "Usage",
 CellID->1472]
}, Open  ]],
Cell[CellGroupData[{
Cell[3651, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4129, 128, 221, 8, 70, "Notes",
 CellID->27925],
Cell[4353, 138, 620, 22, 70, "Notes",
 CellID->20089],
Cell[4976, 162, 551, 18, 70, "Notes",
 CellID->18328]
}, Closed]],
Cell[CellGroupData[{
Cell[5564, 185, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->116448362],
Cell[CellGroupData[{
Cell[5949, 199, 147, 5, 70, "ExampleSection",
 CellID->76749663],
Cell[6099, 206, 133, 4, 70, "ExampleText",
 CellID->76970723],
Cell[CellGroupData[{
Cell[6257, 214, 537, 18, 28, "Input",
 CellID->66702888],
Cell[6797, 234, 206, 5, 36, "Output",
 CellID->79974306]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7052, 245, 220, 7, 70, "ExampleSection",
 CellID->637570969],
Cell[7275, 254, 85, 1, 70, "ExampleText",
 CellID->513894508],
Cell[CellGroupData[{
Cell[7385, 259, 351, 12, 70, "Input",
 CellID->162237992],
Cell[7739, 273, 214, 6, 36, "Output",
 CellID->385859573]
}, Open  ]],
Cell[7968, 282, 125, 3, 70, "ExampleDelimiter",
 CellID->920432874],
Cell[8096, 287, 103, 2, 70, "ExampleText",
 CellID->596044705],
Cell[CellGroupData[{
Cell[8224, 293, 179, 6, 70, "Input",
 CellID->345495559],
Cell[8406, 301, 482, 9, 70, "Message",
 CellID->24065774],
Cell[8891, 312, 247, 8, 36, "Output",
 CellID->54791265]
}, Open  ]],
Cell[9153, 323, 91, 1, 70, "ExampleText",
 CellID->68510520],
Cell[CellGroupData[{
Cell[9269, 328, 129, 4, 70, "Input",
 CellID->313024071],
Cell[9401, 334, 176, 5, 36, "Output",
 CellID->849018382]
}, Open  ]],
Cell[9592, 342, 271, 8, 70, "ExampleText",
 CellID->564121097],
Cell[CellGroupData[{
Cell[9888, 354, 391, 14, 70, "Input",
 CellID->252208935],
Cell[10282, 370, 244, 8, 36, "Output",
 CellID->246784209]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10575, 384, 230, 7, 70, "ExampleSection",
 CellID->179757551],
Cell[10808, 393, 241, 8, 70, "ExampleText",
 CellID->78349844],
Cell[11052, 403, 256, 11, 70, "Input",
 CellID->261870965],
Cell[CellGroupData[{
Cell[11333, 418, 121, 4, 70, "Input",
 CellID->105634149],
Cell[11457, 424, 277, 6, 70, "Message",
 CellID->68410431],
Cell[11737, 432, 174, 5, 36, "Output",
 CellID->46759596]
}, Open  ]],
Cell[CellGroupData[{
Cell[11948, 442, 248, 8, 70, "Input",
 CellID->458351319],
Cell[12199, 452, 280, 6, 70, "Message",
 CellID->427505368],
Cell[12482, 460, 176, 5, 36, "Output",
 CellID->26127418]
}, Open  ]],
Cell[12673, 468, 120, 3, 70, "ExampleText",
 CellID->563156161],
Cell[CellGroupData[{
Cell[12818, 475, 342, 11, 70, "Input",
 CellID->14226972],
Cell[13163, 488, 164, 5, 36, "Output",
 CellID->74925798]
}, Open  ]],
Cell[13342, 496, 378, 13, 70, "ExampleText",
 CellID->112456393],
Cell[CellGroupData[{
Cell[13745, 513, 403, 13, 70, "Input",
 CellID->767281855],
Cell[14151, 528, 164, 5, 36, "Output",
 CellID->387005954]
}, Open  ]],
Cell[CellGroupData[{
Cell[14352, 538, 104, 3, 70, "Input",
 CellID->525707487],
Cell[14459, 543, 161, 5, 36, "Output",
 CellID->40674423]
}, Open  ]],
Cell[14635, 551, 112, 3, 70, "ExampleText",
 CellID->226524281],
Cell[CellGroupData[{
Cell[14772, 558, 108, 3, 70, "Input",
 CellID->409498226],
Cell[14883, 563, 158, 5, 36, "Output",
 CellID->268828643]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15102, 575, 311, 9, 70, "SeeAlsoSection",
 CellID->27222],
Cell[15416, 586, 455, 17, 70, "SeeAlso",
 CellID->11536]
}, Open  ]],
Cell[CellGroupData[{
Cell[15908, 608, 313, 9, 70, "TutorialsSection",
 CellID->6669],
Cell[16224, 619, 171, 3, 70, "Tutorials",
 CellID->26659]
}, Open  ]],
Cell[CellGroupData[{
Cell[16432, 627, 318, 9, 70, "MoreAboutSection",
 CellID->46662702],
Cell[16753, 638, 193, 4, 70, "MoreAbout",
 CellID->560853554],
Cell[16949, 644, 167, 3, 70, "MoreAbout",
 CellID->206747277],
Cell[17119, 649, 152, 3, 70, "MoreAbout",
 CellID->97707173]
}, Open  ]],
Cell[17286, 655, 27, 0, 70, "History"],
Cell[17316, 657, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

