(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21483,        719]
NotebookOptionsPosition[     17155,        571]
NotebookOutlinePosition[     18469,        608]
CellTagsIndexPosition[     18384,        603]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arbitrary\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ArbitraryPrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Arbitrary\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MinPrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MinPrecision"], 
          "$MaxExtraPrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MaxExtraPrecision"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"$MinPrecision\"\>", 
       2->"\<\"$MaxExtraPrecision\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Memory Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/MemoryMeasurementAndOptimization"], 
          "Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup[
           "paclet:guide/RepresentationOfNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Global Computation Settings & Parameters\"\>", 
       2->"\<\"Memory Measurement & Optimization\"\>", 
       3->"\<\"Precision & Accuracy Control\"\>", 
       4->"\<\"Representation of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MaxPrecision", "ObjectName",
 CellID->4332],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MaxPrecision",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
     "\[LineSeparator]gives the maximum number of digits of precision to be \
allowed in arbitrary\[Hyphen]precision numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5912],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$MaxPrecision", "=", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " uses the maximum value possible on a particular computer system, given \
roughly by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Log",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Log"], "[", 
   RowBox[{"10", ",", 
    ButtonBox["$MaxNumber",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/$MaxNumber"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6772],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " is measured in decimal digits, and need not be an integer. "
}], "Notes",
 CellID->5528]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->185670047],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->604059301],

Cell["Limit a calculation to use at most 100 digits of precision:", \
"ExampleText",
 CellID->51599210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxPrecision", "=", "100"}], "}"}], ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"N", "[", 
     RowBox[{
      RowBox[{"10", "^", 
       RowBox[{"-", "101"}]}], ",", "50"}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275551876],

Cell[BoxData["1.\
000000000000000000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000009999999999999979896384299500835050004281161240993219612\
87523245`100."], "Output",
 ImageSize->{585, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126809211]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->198561686],

Cell["Do a computation with fixed 24 digit precision:", "ExampleText",
 CellID->733659669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"$MaxPrecision", "=", "24"}], ",", 
     RowBox[{"$MinPrecision", "=", "24"}]}], "}"}], ",", 
   RowBox[{"Sin", "[", "1000000`24", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361363810],

Cell[BoxData[
 RowBox[{"-", "0.34999350217129295211765248677640762413`24."}]], "Output",
 ImageSize->{194, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->868702795]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4399484],

Cell["Iterate a map using fixed precision:", "ExampleText",
 CellID->22578315],

Cell[BoxData[
 RowBox[{
  RowBox[{"lm", "=", 
   RowBox[{"Block", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"$MinPrecision", "=", "50"}], ",", 
       RowBox[{"$MaxPrecision", "=", "50"}]}], "}"}], ",", 
     RowBox[{"NestList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"4", " ", "#", 
         RowBox[{"(", 
          RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
       RowBox[{"N", "[", 
        RowBox[{
         RowBox[{"1", "/", "Pi"}], ",", "50"}], "]"}], ",", "100"}], "]"}]}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->141047696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", "lm", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->656164478],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1lAlQU1cUhqFCYVQQIS1UQChSoWyDhr0CPyAhIRFCIAFrFURQQRllUWak
Iw8oI3abAsVC0WIVh7GtUhVpqaiRnVYwYtiRLihLBRVGcIEJpeO5mclkvvfl
v/e8d86778YfkCW+oaWllbj0/f/39eepf15be4prrNqfLuCQc66DqOURsT6M
tx8P1o++T2wElzyDvoTWJ8Q8CDNd53PNTxKb4aLKh6etuEZsgfk7m2ZvJvcR
W8PPY/fwPP8xsQ3m6vkXZmz+ILbFZEfSLYf4h8TrITqlni2JmyS2x56UOf24
K/3EDnCS7yn4vIGt5wQ3yd4Hu4wbiV2gWMcvfeTzF7ErMrRbV4ZpWP0bEKEu
bGy0FBNvRGvaKhdds33EfLTOiIp52p8Ru2EkMVA4de4HYneEWxom3Q9sJ/YA
X7BBUy54QOyJxe9X3n5WO0XshSZNRZHZKxWxN4QW384cmhkn9sHEbseaWA27
/w9wmGdteTCX9WMTDiy3HXr59zCxL073+KYtm2P344fLuvFdf86kE/vjdv6q
Uq2BYmLgDN/h/azMK6+ZA+ySZZbHFu6SD8D8tFv/7NAE+QCUS83HF3tGyAfC
rPXJnLM9PW8uENsEzhL576x/QUgZLT1Sd4vq54JgElCmlT/I6t+MGdsLISX9
Q+Q3Y6DtxPCpn1n9weB+UU9Jqs6SDwbPO/0Lx9EG8gKIz5sm3TWnfnICqPRW
B1cssnwIclO/rkxzsScfgg+l3wWHOQvJC+G44ON13X4veSF8vY6PZ79dQF6E
sU86z7/oqCIvwrBnxuHKyy3kQ5GZk10e+NM/5EOxGPg8e6c521+Mb5oehp5r
pfnnxBDY1Pw22cjmX4KK6Nh2wXb2/CTw5Pdds+luI78FZcea7nQto/nhtsAq
Y/9HjgtsfsKwMaC3vMy9k3wYeLND9rt4Y+TDsf7xSN7aeta/cLRMFNen27F5
lOKdt9Jr2ntpPUhRsN9YNWZK88hJUacvfNZtSvOolMIvqN/YQMXWj4CveE1m
yw7yiID59GmBkR95LgL5RzV6uam0vzICesvjJqUDbH8ZDKbXKJIM2f4yqNys
E6ziuykvg9okrUZ4hN53pQyZAw4pl0zY+x6Jom3eOYUcPT9EYu3RUZ2GXuoP
F4myq8JKxybqjzISHlVZXVYrWH+iEG6dWdJ+6Trlo+Dxq0/qmxigfBScO6ul
uc9pfWUURHb1aWmam5SXQ+fG2XvdmkHKy2FQYph8NZvW55Z8n/Z7RkXVlJcj
Szsiv7aig/IKjN07WPBV0yjlFTjzVDdbJPiX8gok61fUDXew+hX48kSYeocO
qz8aPRI9XdXHNygfjZLqH5Nkg6z+aLxoaq6NdaL/K6Pxstn9U9PmOsrHYF/C
K762cy/lY3Dx5MDO1YXUDy4GFiapvTnsPFDGIHJuwmeanQdaW1EqixWv6KXz
AFuRLJHrr1s6D/4DAMPffA==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 101.}, {0., 0.9999538754420829}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56062250]
}, Open  ]],

Cell["\<\
If the precision is not fixed, it eventually drops to zero in the 100 \
iterations:\
\>", "ExampleText",
 CellID->249777091],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"lma", "=", 
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"4", " ", "#", 
       RowBox[{"(", 
        RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
     RowBox[{"N", "[", 
      RowBox[{
       RowBox[{"1", "/", "Pi"}], ",", "50"}], "]"}], ",", "100"}], "]"}]}], 
  ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"Map", "[", 
   RowBox[{"Precision", ",", "lma"}], "]"}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->155823818],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1H9M1HUcx/GvjYEoDnEYHSE/bnpAgPw4BYIDXgd3HIfCcT8IZP3yx1Es
M9oZ/gDZd0ZYxkHiQBJdNMgLEFQS2OHYLiz54U2BJm6l/BjSCi1aNiY/ymq8
P9f6frfvvnt8n9/X989PwJ53dMZnOI4z/nP/+1y5fktaeapBL3C+6ORix2wa
eTVOpS0PS44yr0fMWLmzey6zJ9qHjk0dT1GRn0NRV559Xs7sA/f3KgcvxTP7
Y6Zm3G3Rn1kM403x2AyfSt4MhbVMbDExSyDqfjCgjWYOwrqbTqaYXiX5Bbxq
WV9xsYE5FMZ884mFhwryVnjkVRWvmmaOgOzCaXHrNeZILITYz3g9SCZH4dH7
/bfXOizFocLOlnvTzNugGY+84efwdrRxW/wCJ5mjUZawsebX75hjoOw0lW86
xxwLr4HzQ/muzC/iypEPQhRP5OQ4eOzPvRrVxBwPZ0vjcvVeZhnco6PMb86D
nADlJ3H2gRHmRGz6+brhjDWRnASfjInX3BwGFg8lhU90kXlA/mF4qGc763K0
lfyVZPyIdTmkLte/GBpJoJ6M08cmumLyyXwyRjK+3j8ZJKOegnPD5tnmdWQ+
BQPDLaVOVfHUFaju8Z7tbo2jroDBtPuhVwGZU2KwTGepM8ZSVyKoYO+nibvJ
XCpaeyvOFmtYT4Xl0Q85zatYV8E13eNWQ6uUugqH371qrmfm0lDj2vdxuaOn
4UaVc0mUo6thqjvbO9XMuhqvR9d+VdvEejq+FHmvna5kPR1DbTVxfBjrO5Cy
rf35+s8iqe/A0nFD/51qMrcTkosl1gMvs74TQYFhB0Y8IqhnYDCgvqPtcTj1
DOx6IyQ+U0TmMlEs8/Y92BFKPRMuW2UBdUVkTgN19+0mc14IdQ3eSnjs8/tc
MPUs+Gyf6VvYQEYWXIMPx6quSej7LHx+qjF/8ijZloWGUme7k2IL7bW4P8fN
/+S5mfZa5L7yTa3vmJj2Wvw5V9i41BlAey3EEfaCkmx/2utQ+IvK7ekdX9rr
EFb8/d3xy96016EnuD9y9bKI9jq4BN7TdEmepb0e+0J79JXqjbTXwyodvTs1
5057PU6+bb2/Rk626TH645PljnA32huwr0KkSV16unLuwQDphZzSP/zIvAGF
fYv10weXVmwzYEOd74nOW3Y6J7Nhaxk9MrznW9pn03/p4gW2Ccy99H9DYF5g
m8BcjmAvMC+wTWAuV7AXmBfYJjC3S7D/z38Dyvd1MQ==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 101.}, {0., 50.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 121},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37765179]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20451103],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  ButtonBox["$MaxPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxPrecision"]], "InlineFormula"],
 " is set, some computations may not get correct results:"
}], "ExampleText",
 CellID->107469575],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"pin", "=", 
   RowBox[{"N", "[", 
    RowBox[{"Pi", ",", "50"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxPrecision", "=", "$MachinePrecision"}], "}"}], ",", 
   RowBox[{"pin", "-", 
    FractionBox["265099323460521503743", "84383735478118508040"]}]}], 
  "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->14973679],

Cell[BoxData["0``15.45743989749687"], "Output",
 ImageSize->{59, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19723058]
}, Open  ]],

Cell["The actual value is much smaller:", "ExampleText",
 CellID->311492808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pin", "-", 
  FractionBox["265099323460521503743", "84383735478118508040"]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->47974396],

Cell[BoxData["4.06672232057263451353274719`9.11209464670821*^-41"], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->814622275]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31508],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxExtraPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxExtraPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6826]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27185],

Cell[TextData[ButtonBox["Arbitrary\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ArbitraryPrecisionNumbers"]], "Tutorials",
 CellID->22861]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->219885139],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->48996089],

Cell[TextData[ButtonBox["Memory Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MemoryMeasurementAndOptimization"]], "MoreAbout",
 CellID->416731413],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->288702250],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->953087622]
}, Open  ]],

Cell["New in 3  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MaxPrecision - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 11.7455950}", "context" -> "System`", 
    "keywords" -> {"fixed precision", "maximum allowed precision"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$MaxPrecision gives the maximum number of digits of precision to be \
allowed in arbitrary-precision numbers. ", "synonyms" -> {"max precision"}, 
    "title" -> "$MaxPrecision", "type" -> "Symbol", "uri" -> 
    "ref/$MaxPrecision"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5429, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->185670047]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18241, 596}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2578, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3201, 89, 50, 1, 70, "ObjectName",
 CellID->4332],
Cell[3254, 92, 497, 14, 70, "Usage",
 CellID->16262]
}, Open  ]],
Cell[CellGroupData[{
Cell[3788, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4266, 128, 332, 13, 70, "Notes",
 CellID->5912],
Cell[4601, 143, 552, 19, 70, "Notes",
 CellID->6772],
Cell[5156, 164, 236, 7, 70, "Notes",
 CellID->5528]
}, Closed]],
Cell[CellGroupData[{
Cell[5429, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->185670047],
Cell[CellGroupData[{
Cell[5814, 190, 148, 5, 70, "ExampleSection",
 CellID->604059301],
Cell[5965, 197, 103, 2, 70, "ExampleText",
 CellID->51599210],
Cell[CellGroupData[{
Cell[6093, 203, 328, 11, 28, "Input",
 CellID->275551876],
Cell[6424, 216, 335, 8, 54, "Output",
 CellID->126809211]
}, Open  ]],
Cell[6774, 227, 125, 3, 70, "ExampleDelimiter",
 CellID->198561686],
Cell[6902, 232, 90, 1, 70, "ExampleText",
 CellID->733659669],
Cell[CellGroupData[{
Cell[7017, 237, 291, 9, 70, "Input",
 CellID->361363810],
Cell[7311, 248, 219, 6, 36, "Output",
 CellID->868702795]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7579, 260, 225, 7, 70, "ExampleSection",
 CellID->4399484],
Cell[7807, 269, 78, 1, 70, "ExampleText",
 CellID->22578315],
Cell[7888, 272, 598, 20, 70, "Input",
 CellID->141047696],
Cell[CellGroupData[{
Cell[8511, 296, 109, 3, 70, "Input",
 CellID->656164478],
Cell[8623, 301, 1969, 41, 140, "Output",
 CellID->56062250]
}, Open  ]],
Cell[10607, 345, 134, 4, 70, "ExampleText",
 CellID->249777091],
Cell[CellGroupData[{
Cell[10766, 353, 497, 17, 70, "Input",
 CellID->155823818],
Cell[11266, 372, 1731, 37, 142, "Output",
 CellID->37765179]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13046, 415, 229, 7, 70, "ExampleSection",
 CellID->20451103],
Cell[13278, 424, 252, 8, 70, "ExampleText",
 CellID->107469575],
Cell[CellGroupData[{
Cell[13555, 436, 402, 13, 70, "Input",
 CellID->14973679],
Cell[13960, 451, 176, 5, 36, "Output",
 CellID->19723058]
}, Open  ]],
Cell[14151, 459, 76, 1, 70, "ExampleText",
 CellID->311492808],
Cell[CellGroupData[{
Cell[14252, 464, 153, 4, 70, "Input",
 CellID->47974396],
Cell[14408, 470, 208, 5, 36, "Output",
 CellID->814622275]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14677, 482, 311, 9, 70, "SeeAlsoSection",
 CellID->31508],
Cell[14991, 493, 480, 17, 70, "SeeAlso",
 CellID->6826]
}, Open  ]],
Cell[CellGroupData[{
Cell[15508, 515, 314, 9, 70, "TutorialsSection",
 CellID->27185],
Cell[15825, 526, 171, 3, 70, "Tutorials",
 CellID->22861]
}, Open  ]],
Cell[CellGroupData[{
Cell[16033, 534, 319, 9, 70, "MoreAboutSection",
 CellID->219885139],
Cell[16355, 545, 192, 4, 70, "MoreAbout",
 CellID->48996089],
Cell[16550, 551, 177, 3, 70, "MoreAbout",
 CellID->416731413],
Cell[16730, 556, 167, 3, 70, "MoreAbout",
 CellID->288702250],
Cell[16900, 561, 160, 3, 70, "MoreAbout",
 CellID->953087622]
}, Open  ]],
Cell[17075, 567, 50, 0, 70, "History"],
Cell[17128, 569, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

