(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22206,        764]
NotebookOptionsPosition[     17787,        617]
NotebookOutlinePosition[     19262,        657]
CellTagsIndexPosition[     19177,        652]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> 
          Documentation`HelpLookup["paclet:tutorial/Messages"], 
          "The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"The Main Loop\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$PrePrint" :> Documentation`HelpLookup["paclet:ref/$PrePrint"],
           "Message" :> Documentation`HelpLookup["paclet:ref/Message"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"$PrePrint\"\>", 
       2->"\<\"Message\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> Documentation`HelpLookup["paclet:guide/Messages"],
           "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MessagePrePrint", "ObjectName",
 CellID->7339],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MessagePrePrint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
     "\[LineSeparator]is a global variable whose value, if set, is applied to \
expressions before they are included in the text of messages. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21374]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default value of ",
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26206],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " is applied after each expression is wrapped with ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14504]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->380921247],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->222022821],

Cell[TextData[{
 "Have expressions in messages print out in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->26287278],

Cell[BoxData[
 RowBox[{
  RowBox[{"$MessagePrePrint", " ", "=", " ", "TraditionalForm"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->787245339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"x", "[", 
        RowBox[{"t", ",", "s"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146668899],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"dvlen\"\>"}], ":", 
  " ", "\<\"The function \\!\\(\\*TagBox[\\(TraditionalForm\\`\\(x(\\(\\(t, s\
\\)\\))\\)\\), TraditionalForm, Rule[Editable, True]]\\) does not have the \
same number of arguments as independent variables \
(\\!\\(\\*TagBox[\\(TraditionalForm\\`1\\), TraditionalForm, Rule[Editable, \
True]]\\)). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NDSolve/dvlen\\\", ButtonNote -> \
\\\"NDSolve::dvlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->137115725],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", 
        RowBox[{"t", ",", "s"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}],
    ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 ImageSize->{397, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218234473]
}, Open  ]],

Cell[TextData[{
 "Restore the default. Now the expressions are shown in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11606619],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$MessagePrePrint", " ", "=", " ", "Automatic"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "''"}], "[", "t", "]"}], "+", 
       RowBox[{"x", "[", 
        RowBox[{"t", ",", "s"}], "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "'"}], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
   "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->71210092],

Cell[BoxData[
 RowBox[{
  RowBox[{"NDSolve", "::", "\<\"dvlen\"\>"}], ":", 
  " ", "\<\"The function \\!\\(x[\\(\\(t, s\\)\\)]\\) does not have the same \
number of arguments as independent variables (\\!\\(1\\)). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NDSolve/dvlen\\\", \
ButtonNote -> \\\"NDSolve::dvlen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->299706316],

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", 
        RowBox[{"t", ",", "s"}], "]"}], "+", 
       RowBox[{
        SuperscriptBox["x", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", "0"}], ",", 
     
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", 
      RowBox[{
       SuperscriptBox["x", "\[Prime]",
        MultilineFunction->None], "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}],
    ",", "x", ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Output",
 ImageSize->{397, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->618004232]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23315],

Cell[TextData[{
 "Locally define ",
 Cell[BoxData[
  ButtonBox["$MessagePrePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessagePrePrint"]], "InlineFormula"],
 " so that expressions sent to messages are shown in a circle:"
}], "ExampleText",
 CellID->77587593],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MessagePrePrint", " ", "=", " ", 
     RowBox[{
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"ToString", "[", "#", "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"Red", ",", 
            RowBox[{"Circle", "[", "]"}]}], "}"}]}], "}"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}], "&"}]}], "}"}], ",", 
   
   RowBox[{"Sin", "[", 
    RowBox[{"1", ",", "2"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32506995],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(\\*GraphicsBox[List[InsetBox[FormBox[\\\"\\\\\\\"Sin\\\\\\\"\
\\\", TraditionalForm], List[0, 0]], List[RGBColor[1, 0, 0], \
CircleBox[List[0, 0]]]], Rule[ImageSize, 30]]\\) called with \
\\!\\(\\*GraphicsBox[List[InsetBox[FormBox[\\\"\\\\\\\"2\\\\\\\"\\\", \
TraditionalForm], List[0, 0]], List[RGBColor[1, 0, 0], CircleBox[List[0, \
0]]]], Rule[ImageSize, 30]]\\) arguments; 1 argument is expected. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/argx\\\", \
ButtonNote -> \\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->133055162],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->687204800]
}, Open  ]],

Cell[TextData[{
 "The local definition does not affect messages outside the ",
 Cell[BoxData[
  ButtonBox["Block",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Block"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->812531234],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121825094],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->174958643],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"1", ",", "2"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->591861681]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->195373193],

Cell["\<\
Make a list of all expressions sent to messages during a computation:\
\>", "ExampleText",
 CellID->36248109],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MessagePrePrint", "=", "Sow"}], "}"}], ",", 
   RowBox[{"Reap", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"1", ",", "2"}], "]"}], ";", 
     RowBox[{"LinearSolve", "[", 
      RowBox[{"N", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "+", "$MachineEpsilon"}], ",", " ", "2"}], "}"}]}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}]}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325169996],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "::", "\<\"argx\"\>"}], ":", 
  " ", "\<\"\\!\\(Sin\\) called with \\!\\(2\\) arguments; 1 argument is \
expected. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/argx\\\", ButtonNote -> \
\\\"Sin::argx\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->881655885],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(LinearSolve\\) of badly conditioned matrix \
\\!\\({\\(\\({1.`3.9999999999999996, 2.`4.30102999566398}\\)\\), \
\\(\\({1.0000000000000002`, 2.`4.30102999566398}\\)\\)}\\) may contain \
significant numerical errors. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/luc\\\", ButtonNote -> \
\\\"LinearSolve::luc\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->271677841],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"LinearSolveFunction", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
    False,
    Editable->False], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
      TagBox["Sin",
       HoldForm], ",", 
      TagBox["2",
       HoldForm], ",", 
      TagBox["LinearSolve",
       HoldForm], ",", 
      TagBox[
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1.`3.9999999999999996", ",", "2.`4.30102999566398"}], 
          "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1.0000000000000002`", ",", "2.`4.30102999566398"}], 
          "}"}]}], "}"}],
       HoldForm]}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{380, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->97964353]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4019],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PrePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Message",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Message"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31959]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20028],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Messages"]], "Tutorials",
 CellID->8342],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->1783]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->24062896],

Cell[TextData[ButtonBox["Messages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Messages"]], "MoreAbout",
 CellID->577359285],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->196175654]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MessagePrePrint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 12.7612460}", "context" -> "System`", 
    "keywords" -> {
     "full form of messages", "preprocessing of messages", "message data", 
      "message processing", "message handling", "warnings", "errors", 
      "diagnostics"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$MessagePrePrint is a global variable whose value, if set, is applied to \
expressions before they are included in the text of messages. ", 
    "synonyms" -> {"message pre print"}, "title" -> "$MessagePrePrint", 
    "type" -> "Symbol", "uri" -> "ref/$MessagePrePrint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4468, 147, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->380921247]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19034, 645}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2015, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2638, 76, 53, 1, 70, "ObjectName",
 CellID->7339],
Cell[2694, 79, 519, 14, 70, "Usage",
 CellID->21374]
}, Open  ]],
Cell[CellGroupData[{
Cell[3250, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3728, 115, 341, 13, 70, "Notes",
 CellID->26206],
Cell[4072, 130, 359, 12, 70, "Notes",
 CellID->14504]
}, Closed]],
Cell[CellGroupData[{
Cell[4468, 147, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->380921247],
Cell[CellGroupData[{
Cell[4853, 161, 148, 5, 70, "ExampleSection",
 CellID->222022821],
Cell[5004, 168, 238, 8, 70, "ExampleText",
 CellID->26287278],
Cell[5245, 178, 152, 5, 70, "Input",
 CellID->787245339],
Cell[CellGroupData[{
Cell[5422, 187, 565, 19, 70, "Input",
 CellID->146668899],
Cell[5990, 208, 612, 11, 34, "Message",
 CellID->137115725],
Cell[6605, 221, 760, 25, 36, "Output",
 CellID->218234473]
}, Open  ]],
Cell[7380, 249, 244, 8, 70, "ExampleText",
 CellID->11606619],
Cell[CellGroupData[{
Cell[7649, 261, 670, 22, 70, "Input",
 CellID->71210092],
Cell[8322, 285, 452, 8, 70, "Message",
 CellID->299706316],
Cell[8777, 295, 760, 25, 36, "Output",
 CellID->618004232]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9586, 326, 216, 7, 70, "ExampleSection",
 CellID->23315],
Cell[9805, 335, 272, 8, 70, "ExampleText",
 CellID->77587593],
Cell[CellGroupData[{
Cell[10102, 347, 734, 23, 70, "Input",
 CellID->32506995],
Cell[10839, 372, 722, 12, 70, "Message",
 CellID->133055162],
Cell[11564, 386, 210, 7, 36, "Output",
 CellID->687204800]
}, Open  ]],
Cell[11789, 396, 235, 8, 70, "ExampleText",
 CellID->812531234],
Cell[CellGroupData[{
Cell[12049, 408, 122, 4, 70, "Input",
 CellID->121825094],
Cell[12174, 414, 388, 8, 70, "Message",
 CellID->174958643],
Cell[12565, 424, 210, 7, 36, "Output",
 CellID->591861681]
}, Open  ]],
Cell[12790, 434, 125, 3, 70, "ExampleDelimiter",
 CellID->195373193],
Cell[12918, 439, 119, 3, 70, "ExampleText",
 CellID->36248109],
Cell[CellGroupData[{
Cell[13062, 446, 717, 24, 70, "Input",
 CellID->325169996],
Cell[13782, 472, 388, 8, 70, "Message",
 CellID->881655885],
Cell[14173, 482, 560, 10, 70, "Message",
 CellID->271677841],
Cell[14736, 494, 895, 33, 54, "Output",
 CellID->97964353]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15692, 534, 310, 9, 70, "SeeAlsoSection",
 CellID->4019],
Cell[16005, 545, 451, 17, 70, "SeeAlso",
 CellID->31959]
}, Open  ]],
Cell[CellGroupData[{
Cell[16493, 567, 314, 9, 70, "TutorialsSection",
 CellID->20028],
Cell[16810, 578, 126, 3, 70, "Tutorials",
 CellID->8342],
Cell[16939, 583, 134, 3, 70, "Tutorials",
 CellID->1783]
}, Open  ]],
Cell[CellGroupData[{
Cell[17110, 591, 318, 9, 70, "MoreAboutSection",
 CellID->24062896],
Cell[17431, 602, 128, 3, 70, "MoreAbout",
 CellID->577359285],
Cell[17562, 607, 153, 3, 70, "MoreAbout",
 CellID->196175654]
}, Open  ]],
Cell[17730, 613, 27, 0, 70, "History"],
Cell[17760, 615, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

