(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12653,        471]
NotebookOptionsPosition[      8990,        346]
NotebookOutlinePosition[     10337,        384]
CellTagsIndexPosition[     10252,        379]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Streams and Low\[Hyphen]Level Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StreamsAndLowLevelInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"The Main Loop\"\>", 
       2->"\<\"Streams and Low\[Hyphen]Level Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MessageList" :> 
          Documentation`HelpLookup["paclet:ref/$MessageList"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"$MessageList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$Messages", "ObjectName",
 CellID->25855],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Messages",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Messages"]], "InlineFormula"],
     "\[LineSeparator]gives the list of files and pipes to which message \
output is sent. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1158]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Output from ",
 Cell[BoxData[
  ButtonBox["Message",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Message"]], "InlineFormula"],
 " is always given on the ",
 Cell[BoxData[
  ButtonBox["$Messages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Messages"]], "InlineFormula"],
 " channel. "
}], "Notes",
 CellID->31098]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592925583],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->728787626],

Cell["The default channel for messages is standard output:", "ExampleText",
 CellID->92397087],

Cell[CellGroupData[{

Cell[BoxData["$Messages"], "Input",
 CellLabel->"In[1]:=",
 CellID->224121111],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"OutputStream", "[", 
   RowBox[{"\<\"stdout\"\>", ",", "1"}], "]"}], "}"}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->446269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45154003],

Cell["\<\
Have messages go to a temporary file and the default channel:\
\>", "ExampleText",
 CellID->725092029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"stream", " ", "=", " ", 
  RowBox[{"OpenWrite", "[", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175108982],

Cell[BoxData[
 RowBox[{"OutputStream", "[", 
  RowBox[{"\<\"C:\\\\Documents and Settings\\\\rknapp\\\\Local \
Settings\\\\Temp\\\\000002a03924\"\>", ",", "30"}], "]"}]], "Output",
 ImageSize->{583, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615178320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$Messages", " ", "=", " ", 
  RowBox[{"Append", "[", 
   RowBox[{"$Messages", ",", " ", "stream"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245917292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OutputStream", "[", 
    RowBox[{"\<\"stdout\"\>", ",", "1"}], "]"}], ",", 
   RowBox[{"OutputStream", "[", 
    RowBox[{"\<\"C:\\\\Documents and Settings\\\\rknapp\\\\Local \
Settings\\\\Temp\\\\000002a03924\"\>", ",", "30"}], "]"}]}], "}"}]], "Output",\

 ImageSize->{513, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121789357]
}, Open  ]],

Cell["Generate a message:", "ExampleText",
 CellID->79136178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", "0"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->304340353],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0\\) encountered.\"\>"}]], "Message",\
 "MSG",
 CellID->5940890],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->366898132]
}, Open  ]],

Cell["Show the contents of the temporary file:", "ExampleText",
 CellID->77121135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FilePrint", "[", 
  RowBox[{"stream", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->108291043],

Cell["\<\

                                 1
Power::infy: Infinite expression - encountered.
                                 0\
\>", "Print",
 CellLabel->"During evaluation of In[9]:=",
 CellID->105462399]
}, Open  ]],

Cell[TextData[{
 "Clean up by resetting ",
 Cell[BoxData[
  ButtonBox["$Messages",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Messages"]], "InlineFormula"],
 " to its default and closing the stream:"
}], "ExampleText",
 CellID->986990],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$Messages", " ", "=", " ", 
   RowBox[{"$Messages", "[", 
    RowBox[{"[", 
     RowBox[{"{", "1", "}"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Close", "[", "stream", "]"}], ";"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->48258864],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\rknapp\\\\Local \
Settings\\\\Temp\\\\000002a03924\"\>"], "Output",
 ImageSize->{459, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->469093941]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->128],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->24389]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16376],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->23711],

Cell[TextData[ButtonBox["Streams and Low\[Hyphen]Level Input and Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StreamsAndLowLevelInputAndOutput"]], "Tutorials",\

 CellID->13834]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Messages - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 13.0737540}", "context" -> "System`", 
    "keywords" -> {
     "list of files", "messages output", "message channel", "message streams",
       "warnings", "errors", "diagnostics", "message handling"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$Messages gives the list of files and pipes to which message output is \
sent. ", "synonyms" -> {}, "title" -> "$Messages", "type" -> "Symbol", "uri" -> 
    "ref/$Messages"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3397, 119, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->592925583]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10109, 372}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1377, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2000, 62, 47, 1, 70, "ObjectName",
 CellID->25855],
Cell[2050, 65, 453, 14, 70, "Usage",
 CellID->1158]
}, Open  ]],
Cell[CellGroupData[{
Cell[2540, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3018, 101, 342, 13, 70, "Notes",
 CellID->31098]
}, Closed]],
Cell[CellGroupData[{
Cell[3397, 119, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592925583],
Cell[CellGroupData[{
Cell[3782, 133, 148, 5, 70, "ExampleSection",
 CellID->728787626],
Cell[3933, 140, 94, 1, 70, "ExampleText",
 CellID->92397087],
Cell[CellGroupData[{
Cell[4052, 145, 78, 2, 28, "Input",
 CellID->224121111],
Cell[4133, 149, 254, 8, 36, "Output",
 CellID->446269]
}, Open  ]],
Cell[4402, 160, 124, 3, 70, "ExampleDelimiter",
 CellID->45154003],
Cell[4529, 165, 112, 3, 70, "ExampleText",
 CellID->725092029],
Cell[CellGroupData[{
Cell[4666, 172, 138, 4, 70, "Input",
 CellID->175108982],
Cell[4807, 178, 310, 8, 36, "Output",
 CellID->615178320]
}, Open  ]],
Cell[CellGroupData[{
Cell[5154, 191, 185, 5, 70, "Input",
 CellID->245917292],
Cell[5342, 198, 439, 13, 54, "Output",
 CellID->121789357]
}, Open  ]],
Cell[5796, 214, 61, 1, 70, "ExampleText",
 CellID->79136178],
Cell[CellGroupData[{
Cell[5882, 219, 92, 3, 70, "Input",
 CellID->304340353],
Cell[5977, 224, 179, 5, 70, "Message",
 CellID->5940890],
Cell[6159, 231, 173, 5, 36, "Output",
 CellID->366898132]
}, Open  ]],
Cell[6347, 239, 82, 1, 70, "ExampleText",
 CellID->77121135],
Cell[CellGroupData[{
Cell[6454, 244, 162, 5, 70, "Input",
 CellID->108291043],
Cell[6619, 251, 207, 7, 70, "Print",
 CellID->105462399]
}, Open  ]],
Cell[6841, 261, 242, 8, 70, "ExampleText",
 CellID->986990],
Cell[CellGroupData[{
Cell[7108, 273, 299, 9, 70, "Input",
 CellID->48258864],
Cell[7410, 284, 248, 6, 36, "Output",
 CellID->469093941]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7719, 297, 309, 9, 70, "SeeAlsoSection",
 CellID->128],
Cell[8031, 308, 204, 6, 70, "SeeAlso",
 CellID->24389]
}, Open  ]],
Cell[CellGroupData[{
Cell[8272, 319, 314, 9, 70, "TutorialsSection",
 CellID->16376],
Cell[8589, 330, 135, 3, 70, "Tutorials",
 CellID->23711],
Cell[8727, 335, 191, 4, 70, "Tutorials",
 CellID->13834]
}, Open  ]],
Cell[8933, 342, 27, 0, 70, "History"],
Cell[8963, 344, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

