(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24766,        927]
NotebookOptionsPosition[     18557,        710]
NotebookOutlinePosition[     19988,        749]
CellTagsIndexPosition[     19903,        744]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Machine\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MachinePrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Machine\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MinNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinNumber"], 
          "$MachineEpsilon" :> 
          Documentation`HelpLookup["paclet:ref/$MachineEpsilon"], 
          "$MachinePrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MachinePrecision"], 
          "$MaxMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MaxMachineNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MinNumber\"\>", 
       2->"\<\"$MachineEpsilon\"\>", 3->"\<\"$MachinePrecision\"\>", 
       4->"\<\"$MaxMachineNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Precision & Accuracy Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/PrecisionAndAccuracyControl"], 
          "Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Precision & Accuracy Control\"\>", 
       2->"\<\"Representation of Numbers\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MinMachineNumber", "ObjectName",
 CellID->11615],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MinMachineNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFormula"],
     "\[LineSeparator]is the smallest positive machine\[Hyphen]precision \
number that can be used on a particular computer system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", "0.", "]"}]], "InlineFormula"],
 " yields ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    RowBox[{"10", ",", "$MinMachineNumber"}], "]"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21966]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->233115756],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->692069821],

Cell["The smallest hardware floating point number:", "ExampleText",
 CellID->91806207],

Cell[CellGroupData[{

Cell[BoxData["$MinMachineNumber"], "Input",
 CellLabel->"In[1]:=",
 CellID->869441492],

Cell[BoxData["2.2250738585072014`*^-308"], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->63504223]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->233147892],

Cell[TextData[{
 "Numbers smaller than ",
 Cell[BoxData[
  ButtonBox["$MinMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFormula"],
 " are represented as arbitrary precision numbers:"
}], "ExampleText",
 CellID->414707577],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"$MinMachineNumber", "/", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222478936],

Cell[BoxData["1.11253692925360069154511635867`15.954589770191005*^-308"], \
"Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443061418]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"MachineNumberQ", "[", "x", "]"}], ",", 
   RowBox[{"Precision", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->230623131],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "15.954589770191005`"}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->223153106]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->458155344],

Cell["Find the minimum machine number algorithmatically:", "ExampleText",
 CellID->14421510],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "1."}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"MachineNumberQ", "[", "x", "]"}], ",", 
    RowBox[{
     RowBox[{"y", "=", "x"}], ";", 
     RowBox[{"x", "/=", "2"}]}]}], "]"}], ";"}], "\n", "y"}], "Input",
 CellLabel->"In[1]:=",
 CellID->113388238],

Cell[BoxData["2.2250738585072014`*^-308"], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206595195]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"y", "-", "$MinMachineNumber"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20370786],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245908957]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->751909032],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MinMachineNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinMachineNumber"]], "InlineFormula"],
 " has the smallest possible binary exponent and all but one bits set to 0:"
}], "ExampleText",
 CellID->333460643],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"$MinMachineNumber", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17570765],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWU1PwzAMzZqVjQn2cQIhDuMCHBA/A078iGpC2g4INPb/S5ImMJlUSdZC
nMyT2tSum/eavriN91Lt1q9v1W6zqpbP2+pjvVl9Lp/et8LFB4wVV4yxm0sm
jmtxpDbzuxbbj9lYF3LPv6PYrGd7fmT9hfY/BPYDsO9r85QK4Zx7totIcTB+
Ae6Ga/8j8N+pu5RXS2cJzo4i+ceEm9T4w7k0FbtSmFzHc20XuoXxjQrVDC33
8ybTsVK5I5Rnx8QqcVZ/wxnODltOLqxX2722Pn1n0Pm/eqeEhoYDzNNndZN/
od+uOQ6i4FXQvq1Jg7mhdecAMxVc9xyW7yj/5Y8WS3swr8E8SNrLHy2W9k5s
UaS9o0KLpb0uKw9TQZp5tr7xfce1xdtGTK7Zyr3zpjX+39VCM262em8/lutp
nAKbqsq4+3f1p749nF8gkzrNKnVo3NBrNNqqjKlUUwk3Dz6huOr961R3W3Ux
r/opscLCKkXOXVg1b1zXugvOXbxrAULDziEETX3fB78jaPTSRMPAgdRJaHg5
kDoJDS8HUieh4eUQrk6XGuWqydTrDqnCx/4XwDduokbDjE9oDZ8NvgDB+Gwm
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{538, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->170724902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318131616],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["$MaxMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxMachineNumber"], "\[Times]", 
   "$MinMachineNumber"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"4.", "\[Times]", 
   RowBox[{"(", 
    RowBox[{"1.", "-", 
     RowBox[{
      ButtonBox["$MachineEpsilon",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MachineEpsilon"], "/", "2"}]}], ")"}]}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->494050984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "=", 
  RowBox[{"$MaxMachineNumber", "\[Times]", "$MinMachineNumber"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10910368],

Cell[BoxData["3.9999999999999996`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156921906]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"p", "-", 
  RowBox[{"4.", 
   RowBox[{"(", 
    RowBox[{"1.", "-", 
     RowBox[{"$MachineEpsilon", "/", "2"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55652915],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->883860553]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->167744765],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Accuracy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Accuracy"], "[", "0.", "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  RowBox[{"-", 
   RowBox[{
    ButtonBox["Log",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Log"], "[", 
    RowBox[{"10", ",", "$MinMachineNumber"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->57857421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Accuracy", "[", "0.", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465669201],

Cell[BoxData["307.6526555685888`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142745463]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Log", "[", 
   RowBox[{"10", ",", "$MinMachineNumber"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->728093861],

Cell[BoxData["307.6526555685887`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->502036897]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->390309019],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " uses arbitrary precision to represent numbers that would be denormalized:"
}], "ExampleText",
 CellID->347335363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", 
  RowBox[{"$MinMachineNumber", "/", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->815374013],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->711190442]
}, Open  ]],

Cell[TextData[{
 "This conversion can be prevented in ",
 Cell[BoxData[
  ButtonBox["Compile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Compile"]], "InlineFormula"],
 " and some other functions with a system option:"
}], "ExampleText",
 CellID->480258605],

Cell[BoxData[
 RowBox[{
  RowBox[{"Developer`SetSystemOption", "[", 
   RowBox[{"\"\<CatchMachineUnderflow\>\"", "\[Rule]", "False"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->256442933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", " ", "=", " ", 
  RowBox[{"Compile", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"x", ",", "_Real"}], "}"}], "}"}], ",", 
    RowBox[{"x", "/", "2."}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->58301293],

Cell[BoxData[
 TagBox[
  RowBox[{"CompiledFunction", "[", 
   RowBox[{
    RowBox[{"{", "x", "}"}], ",", 
    RowBox[{"x", " ", "0.5`"}], ",", "\<\"-CompiledCode-\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->380026039]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"cf", "[", "$MinMachineNumber", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->144113251],

Cell[BoxData["1.1125369292536007`*^-308"], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->212693805]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->955914969],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->79462517]
}, Open  ]],

Cell["The smallest denormalized machine number:", "ExampleText",
 CellID->183915892],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"x", "\[NotEqual]", "0."}], ",", 
    RowBox[{
     RowBox[{"y", "=", "x"}], ";", 
     RowBox[{"x", "=", 
      RowBox[{"cf", "[", "x", "]"}]}]}]}], "]"}], ";", "y"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->91670247],

Cell[BoxData["5.`*^-324"], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->75334893]
}, Open  ]],

Cell["Restore the option to its default:", "ExampleText",
 CellID->179845440],

Cell[BoxData[
 RowBox[{
  RowBox[{"Developer`SetSystemOption", "[", 
   RowBox[{"\"\<CatchMachineUnderflow\>\"", "\[Rule]", "True"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->128292660]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2398],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineEpsilon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineEpsilon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachinePrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachinePrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22387]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30804],

Cell[TextData[ButtonBox["Machine\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MachinePrecisionNumbers"]], "Tutorials",
 CellID->15852]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->614980790],

Cell[TextData[ButtonBox["Precision & Accuracy Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecisionAndAccuracyControl"]], "MoreAbout",
 CellID->356373294],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->93220284],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->476168126]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MinMachineNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 13.3706366}", "context" -> "System`", 
    "keywords" -> {
     "smallest machine number", "smallest floating point number", 
      "floating point accuracy", "floating point resolution at zero"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$MinMachineNumber is the smallest positive machine-precision number that \
can be used on a particular computer system. ", 
    "synonyms" -> {"min machine number"}, "title" -> "$MinMachineNumber", 
    "type" -> "Symbol", "uri" -> "ref/$MinMachineNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4702, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->233115756]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19760, 737}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2540, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3163, 88, 55, 1, 70, "ObjectName",
 CellID->11615],
Cell[3221, 91, 511, 14, 70, "Usage",
 CellID->19728]
}, Open  ]],
Cell[CellGroupData[{
Cell[3769, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4247, 127, 418, 16, 70, "Notes",
 CellID->21966]
}, Closed]],
Cell[CellGroupData[{
Cell[4702, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->233115756],
Cell[CellGroupData[{
Cell[5087, 162, 148, 5, 70, "ExampleSection",
 CellID->692069821],
Cell[5238, 169, 86, 1, 70, "ExampleText",
 CellID->91806207],
Cell[CellGroupData[{
Cell[5349, 174, 86, 2, 28, "Input",
 CellID->869441492],
Cell[5438, 178, 181, 5, 36, "Output",
 CellID->63504223]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5668, 189, 220, 7, 70, "ExampleSection",
 CellID->233147892],
Cell[5891, 198, 269, 8, 70, "ExampleText",
 CellID->414707577],
Cell[CellGroupData[{
Cell[6185, 210, 131, 4, 70, "Input",
 CellID->222478936],
Cell[6319, 216, 216, 6, 36, "Output",
 CellID->443061418]
}, Open  ]],
Cell[CellGroupData[{
Cell[6572, 227, 194, 6, 70, "Input",
 CellID->230623131],
Cell[6769, 235, 226, 7, 36, "Output",
 CellID->223153106]
}, Open  ]],
Cell[7010, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->458155344],
Cell[7138, 250, 92, 1, 70, "ExampleText",
 CellID->14421510],
Cell[CellGroupData[{
Cell[7255, 255, 329, 11, 70, "Input",
 CellID->113388238],
Cell[7587, 268, 182, 5, 36, "Output",
 CellID->206595195]
}, Open  ]],
Cell[CellGroupData[{
Cell[7806, 278, 107, 3, 70, "Input",
 CellID->20370786],
Cell[7916, 283, 160, 5, 36, "Output",
 CellID->245908957]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8125, 294, 237, 7, 70, "ExampleSection",
 CellID->751909032],
Cell[8365, 303, 268, 7, 70, "ExampleText",
 CellID->333460643],
Cell[CellGroupData[{
Cell[8658, 314, 144, 4, 70, "Input",
 CellID->17570765],
Cell[8805, 320, 822, 18, 70, "Output",
 Evaluatable->False,
 CellID->170724902]
}, Open  ]],
Cell[9642, 341, 125, 3, 70, "ExampleDelimiter",
 CellID->318131616],
Cell[9770, 346, 513, 19, 70, "ExampleText",
 CellID->494050984],
Cell[CellGroupData[{
Cell[10308, 369, 153, 4, 70, "Input",
 CellID->10910368],
Cell[10464, 375, 176, 5, 36, "Output",
 CellID->156921906]
}, Open  ]],
Cell[CellGroupData[{
Cell[10677, 385, 200, 7, 70, "Input",
 CellID->55652915],
Cell[10880, 394, 160, 5, 36, "Output",
 CellID->883860553]
}, Open  ]],
Cell[11055, 402, 125, 3, 70, "ExampleDelimiter",
 CellID->167744765],
Cell[11183, 407, 422, 16, 70, "ExampleText",
 CellID->57857421],
Cell[CellGroupData[{
Cell[11630, 427, 105, 3, 70, "Input",
 CellID->465669201],
Cell[11738, 432, 175, 5, 36, "Output",
 CellID->142745463]
}, Open  ]],
Cell[CellGroupData[{
Cell[11950, 442, 158, 5, 70, "Input",
 CellID->728093861],
Cell[12111, 449, 175, 5, 36, "Output",
 CellID->502036897]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12335, 460, 230, 7, 70, "ExampleSection",
 CellID->390309019],
Cell[12568, 469, 181, 5, 70, "ExampleText",
 CellID->347335363],
Cell[CellGroupData[{
Cell[12774, 478, 149, 4, 70, "Input",
 CellID->815374013],
Cell[12926, 484, 162, 5, 36, "Output",
 CellID->711190442]
}, Open  ]],
Cell[13103, 492, 263, 8, 70, "ExampleText",
 CellID->480258605],
Cell[13369, 502, 204, 6, 70, "Input",
 CellID->256442933],
Cell[CellGroupData[{
Cell[13598, 512, 268, 9, 70, "Input",
 CellID->58301293],
Cell[13869, 523, 348, 12, 36, "Output",
 CellID->380026039]
}, Open  ]],
Cell[CellGroupData[{
Cell[14254, 540, 137, 4, 70, "Input",
 CellID->144113251],
Cell[14394, 546, 182, 5, 36, "Output",
 CellID->212693805]
}, Open  ]],
Cell[CellGroupData[{
Cell[14613, 556, 110, 3, 70, "Input",
 CellID->955914969],
Cell[14726, 561, 160, 5, 36, "Output",
 CellID->79462517]
}, Open  ]],
Cell[14901, 569, 84, 1, 70, "ExampleText",
 CellID->183915892],
Cell[CellGroupData[{
Cell[15010, 574, 293, 10, 70, "Input",
 CellID->91670247],
Cell[15306, 586, 165, 5, 36, "Output",
 CellID->75334893]
}, Open  ]],
Cell[15486, 594, 77, 1, 70, "ExampleText",
 CellID->179845440],
Cell[15566, 597, 203, 6, 70, "Input",
 CellID->128292660]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15818, 609, 310, 9, 70, "SeeAlsoSection",
 CellID->2398],
Cell[16131, 620, 995, 35, 70, "SeeAlso",
 CellID->22387]
}, Open  ]],
Cell[CellGroupData[{
Cell[17163, 660, 314, 9, 70, "TutorialsSection",
 CellID->30804],
Cell[17480, 671, 167, 3, 70, "Tutorials",
 CellID->15852]
}, Open  ]],
Cell[CellGroupData[{
Cell[17684, 679, 319, 9, 70, "MoreAboutSection",
 CellID->614980790],
Cell[18006, 690, 167, 3, 70, "MoreAbout",
 CellID->356373294],
Cell[18176, 695, 159, 3, 70, "MoreAbout",
 CellID->93220284],
Cell[18338, 700, 147, 3, 70, "MoreAbout",
 CellID->476168126]
}, Open  ]],
Cell[18500, 706, 27, 0, 70, "History"],
Cell[18530, 708, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

