(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16208,        583]
NotebookOptionsPosition[     12021,        441]
NotebookOutlinePosition[     13401,        480]
CellTagsIndexPosition[     13316,        475]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Machine\[Hyphen]Precision Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MachinePrecisionNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Machine\[Hyphen]Precision Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MinPrecision" :> 
          Documentation`HelpLookup["paclet:ref/$MinPrecision"], 
          "$MinMachineNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MinMachineNumber"], 
          "$MaxNumber" :> 
          Documentation`HelpLookup["paclet:ref/$MaxNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MinPrecision\"\>", 
       2->"\<\"$MinMachineNumber\"\>", 
       3->"\<\"$MaxNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representation of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/RepresentationOfNumbers"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Representation of Numbers\"\>", 
       2->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$MinNumber", "ObjectName",
 CellID->10319],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$MinNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$MinNumber"]], "InlineFormula"],
     "\[LineSeparator]gives the magnitude of the minimum positive arbitrary\
\[Hyphen]precision number that can be represented on a particular computer \
system. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24063]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical value for ",
 Cell[BoxData[
  ButtonBox["$MinNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinNumber"]], "InlineFormula"],
 " is around ",
 Cell[BoxData[
  SuperscriptBox["10", 
   RowBox[{"-", "646456888"}]]]],
 ". "
}], "Notes",
 CellID->376524139]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166514439],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->86393420],

Cell["\<\
The nonzero number of minimum magnitude representable on this computer \
system:\
\>", "ExampleText",
 CellID->181446241],

Cell[CellGroupData[{

Cell[BoxData["$MinNumber"], "Input",
 CellLabel->"In[1]:=",
 CellID->104748322],

Cell[BoxData["5.2077239409589238546156053328`15.954589770191005*^-646456888"],\
 "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55841729]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209058057],

Cell["Smaller numbers yield underflows:", "ExampleText",
 CellID->567312988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MinNumber", "/", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149997626],

Cell[BoxData[
 RowBox[{
  RowBox[{"General", "::", "\<\"unfl\"\>"}], ":", 
  " ", "\<\"Underflow occurred in computation. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/unfl\\\", ButtonNote -> \
\\\"General::unfl\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->319877531],

Cell[BoxData[
 RowBox[{"Underflow", "[", "]"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3388520]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22101227],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MinNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinNumber"]], "InlineFormula"],
 " has the smallest possible exponent and all but 1 significant bits set to \
0:"
}], "ExampleText",
 CellID->26848726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"$MinNumber", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137357546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0",
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
     ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"-", "2147483295"}]}], "}"}]], "Output",
 ImageSize->{578, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->920277393]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203141515],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MinNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinNumber"]], "InlineFormula"],
 "\[Times]",
 Cell[BoxData[
  ButtonBox["$MaxNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxNumber"]], "InlineFormula"],
 " is approximately 1:"
}], "ExampleText",
 CellID->27108687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$MinNumber", "*", "$MaxNumber"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184336668],

Cell[BoxData["0.99999999999999988897769753748`15.653559774527023"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239424482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->640622353],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$MinNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MinNumber"]], "InlineFormula"],
 " is not a machine number:"
}], "ExampleText",
 CellID->90692076],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "$MinNumber", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91555625],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19824129]
}, Open  ]],

Cell["\<\
It does have precision equivalent to that of machine numbers:\
\>", "ExampleText",
 CellID->32292427],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Precision", "[", "$MinNumber", "]"}], "\[Equal]", 
  "MachinePrecision"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->281017039],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252951652]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32305],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MinMachineNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MinMachineNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MaxNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MaxNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5556]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24261],

Cell[TextData[ButtonBox["Machine\[Hyphen]Precision Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MachinePrecisionNumbers"]], "Tutorials",
 CellID->20336]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->220336347],

Cell[TextData[ButtonBox["Representation of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RepresentationOfNumbers"]], "MoreAbout",
 CellID->8701817],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->140083880]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$MinNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 13.6987700}", "context" -> "System`", 
    "keywords" -> {
     "smallest representable number", "smallest positive number", 
      "smallest real number"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$MinNumber gives the magnitude of the minimum positive \
arbitrary-precision number that can be represented on a particular computer \
system. ", "synonyms" -> {"min number"}, "title" -> "$MinNumber", "type" -> 
    "Symbol", "uri" -> "ref/$MinNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4254, 139, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->166514439]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13173, 468}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2210, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2833, 82, 48, 1, 70, "ObjectName",
 CellID->10319],
Cell[2884, 85, 527, 15, 70, "Usage",
 CellID->24063]
}, Open  ]],
Cell[CellGroupData[{
Cell[3448, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3926, 122, 291, 12, 70, "Notes",
 CellID->376524139]
}, Closed]],
Cell[CellGroupData[{
Cell[4254, 139, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->166514439],
Cell[CellGroupData[{
Cell[4639, 153, 147, 5, 70, "ExampleSection",
 CellID->86393420],
Cell[4789, 160, 131, 4, 70, "ExampleText",
 CellID->181446241],
Cell[CellGroupData[{
Cell[4945, 168, 79, 2, 28, "Input",
 CellID->104748322],
Cell[5027, 172, 220, 6, 36, "Output",
 CellID->55841729]
}, Open  ]],
Cell[5262, 181, 125, 3, 70, "ExampleDelimiter",
 CellID->209058057],
Cell[5390, 186, 76, 1, 70, "ExampleText",
 CellID->567312988],
Cell[CellGroupData[{
Cell[5491, 191, 101, 3, 70, "Input",
 CellID->149997626],
Cell[5595, 196, 358, 7, 70, "Message",
 CellID->319877531],
Cell[5956, 205, 186, 6, 36, "Output",
 CellID->3388520]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6191, 217, 236, 7, 70, "ExampleSection",
 CellID->22101227],
Cell[6430, 226, 258, 8, 70, "ExampleText",
 CellID->26848726],
Cell[CellGroupData[{
Cell[6713, 238, 138, 4, 70, "Input",
 CellID->137357546],
Cell[6854, 244, 848, 18, 54, "Output",
 CellID->920277393]
}, Open  ]],
Cell[7717, 265, 125, 3, 70, "ExampleDelimiter",
 CellID->203141515],
Cell[7845, 270, 336, 12, 70, "ExampleText",
 CellID->27108687],
Cell[CellGroupData[{
Cell[8206, 286, 110, 3, 70, "Input",
 CellID->184336668],
Cell[8319, 291, 208, 5, 36, "Output",
 CellID->239424482]
}, Open  ]],
Cell[8542, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->640622353],
Cell[8670, 304, 205, 7, 70, "ExampleText",
 CellID->90692076],
Cell[CellGroupData[{
Cell[8900, 315, 118, 3, 70, "Input",
 CellID->91555625],
Cell[9021, 320, 161, 5, 36, "Output",
 CellID->19824129]
}, Open  ]],
Cell[9197, 328, 111, 3, 70, "ExampleText",
 CellID->32292427],
Cell[CellGroupData[{
Cell[9333, 335, 162, 5, 70, "Input",
 CellID->281017039],
Cell[9498, 342, 161, 5, 36, "Output",
 CellID->252951652]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9720, 354, 311, 9, 70, "SeeAlsoSection",
 CellID->32305],
Cell[10034, 365, 727, 26, 70, "SeeAlso",
 CellID->5556]
}, Open  ]],
Cell[CellGroupData[{
Cell[10798, 396, 314, 9, 70, "TutorialsSection",
 CellID->24261],
Cell[11115, 407, 167, 3, 70, "Tutorials",
 CellID->20336]
}, Open  ]],
Cell[CellGroupData[{
Cell[11319, 415, 319, 9, 70, "MoreAboutSection",
 CellID->220336347],
Cell[11641, 426, 158, 3, 70, "MoreAbout",
 CellID->8701817],
Cell[11802, 431, 147, 3, 70, "MoreAbout",
 CellID->140083880]
}, Open  ]],
Cell[11964, 437, 27, 0, 70, "History"],
Cell[11994, 439, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

