(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16141,        613]
NotebookOptionsPosition[     12033,        472]
NotebookOutlinePosition[     13328,        508]
CellTagsIndexPosition[     13243,        503]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"How Modules Work" :> 
          Documentation`HelpLookup["paclet:tutorial/HowModulesWork"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"How Modules Work\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$SessionID" :> 
          Documentation`HelpLookup["paclet:ref/$SessionID"], "Temporary" :> 
          Documentation`HelpLookup["paclet:ref/Temporary"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$SessionID\"\>", 
       2->"\<\"Temporary\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>", 
       2->"\<\"Namespace Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$ModuleNumber", "ObjectName",
 CellID->3045],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$ModuleNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
     "\[LineSeparator]gives the current serial number to be used for local \
variables that are created. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " is incremented every time ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 " is called. "
}], "Notes",
 CellID->25257],

Cell[TextData[{
 "Every ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session starts with ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " set to 1. "
}], "Notes",
 CellID->32473],

Cell[TextData[{
 "You can reset ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " to any positive integer, but if you do so, you run the risk of creating \
naming conflicts. "
}], "Notes",
 CellID->6766]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92263544],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->42128760],

Cell[TextData[{
 "Each use of ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " increments ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->100859915],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$ModuleNumber", ",", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", "x"}], "]"}], ",", "$ModuleNumber"}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->559802953],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23", ",", "x$23", ",", "24"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127354877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385649798],

Cell[TextData[{
 "You can reset ",
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->638773779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"$ModuleNumber", "=", "17"}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", "x"}], "]"}], ",", "$ModuleNumber"}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->532413827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x$17", ",", "18"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->174414969]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15768],

Cell[TextData[{
 "Use a unique module number in your ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session:"
}], "ExampleText",
 CellID->142030692],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$ModuleNumber", "=", " ", 
  RowBox[{"$SessionID", "*", 
   RowBox[{"2", "^", "20"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5654263],

Cell[BoxData["23247485134784511613075456"], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->720488651]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " will now increment starting from this number: "
}], "ExampleText",
 CellID->353345473],

Cell[CellGroupData[{

Cell[BoxData["$ModuleNumber"], "Input",
 CellLabel->"In[2]:=",
 CellID->177268963],

Cell[BoxData["23247485134784511613075457"], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->414187291]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10182],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$ModuleNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ModuleNumber"]], "InlineFormula"],
 " is also used by ",
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 " to create new symbols from given ones:"
}], "ExampleText",
 CellID->180099106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"$ModuleNumber", ",", 
   RowBox[{"Unique", "[", "x", "]"}], ",", "$ModuleNumber"}], "}"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->562883762],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"19", ",", "x$19", ",", "20"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->797213795]
}, Open  ]],

Cell[TextData[{
 "If given a string, it creates the first available symbol of the form ",
 StyleBox["x", "InlineCode"],
 StyleBox["nnn", "TI"],
 ":"
}], "ExampleText",
 CellID->8900864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "\"\<x\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->919245573],

Cell[BoxData["x1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185060212]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10395],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SessionID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SessionID"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Temporary",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Temporary"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11841]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28598],

Cell[TextData[ButtonBox["How Modules Work",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/HowModulesWork"]], "Tutorials",
 CellID->20091]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->598420318],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->234801946],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->113747469]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$ModuleNumber - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 19.4645426}", "context" -> "System`", 
    "keywords" -> {"module serial number", "module unique number"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$ModuleNumber gives the current serial number to be used for local \
variables that are created. ", "synonyms" -> {"module number"}, "title" -> 
    "$ModuleNumber", "type" -> "Symbol", "uri" -> "ref/$ModuleNumber"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4784, 163, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->92263544]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13101, 496}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2053, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2676, 78, 50, 1, 70, "ObjectName",
 CellID->3045],
Cell[2729, 81, 475, 14, 70, "Usage",
 CellID->9542]
}, Open  ]],
Cell[CellGroupData[{
Cell[3241, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3719, 117, 460, 17, 70, "Notes",
 CellID->25257],
Cell[4182, 136, 274, 11, 70, "Notes",
 CellID->32473],
Cell[4459, 149, 288, 9, 70, "Notes",
 CellID->6766]
}, Closed]],
Cell[CellGroupData[{
Cell[4784, 163, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->92263544],
Cell[CellGroupData[{
Cell[5168, 177, 147, 5, 70, "ExampleSection",
 CellID->42128760],
Cell[5318, 184, 337, 13, 70, "ExampleText",
 CellID->100859915],
Cell[CellGroupData[{
Cell[5680, 201, 237, 8, 28, "Input",
 CellID->559802953],
Cell[5920, 211, 218, 7, 36, "Output",
 CellID->127354877]
}, Open  ]],
Cell[6153, 221, 125, 3, 70, "ExampleDelimiter",
 CellID->385649798],
Cell[6281, 226, 207, 8, 70, "ExampleText",
 CellID->638773779],
Cell[CellGroupData[{
Cell[6513, 238, 279, 10, 70, "Input",
 CellID->532413827],
Cell[6795, 250, 207, 7, 36, "Output",
 CellID->174414969]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7051, 263, 223, 7, 70, "ExampleSection",
 CellID->15768],
Cell[7277, 272, 156, 6, 70, "ExampleText",
 CellID->142030692],
Cell[CellGroupData[{
Cell[7458, 282, 164, 5, 70, "Input",
 CellID->5654263],
Cell[7625, 289, 184, 5, 36, "Output",
 CellID->720488651]
}, Open  ]],
Cell[7824, 297, 234, 7, 70, "ExampleText",
 CellID->353345473],
Cell[CellGroupData[{
Cell[8083, 308, 82, 2, 70, "Input",
 CellID->177268963],
Cell[8168, 312, 184, 5, 36, "Output",
 CellID->414187291]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8401, 323, 233, 7, 70, "ExampleSection",
 CellID->10182],
Cell[8637, 332, 363, 12, 70, "ExampleText",
 CellID->180099106],
Cell[CellGroupData[{
Cell[9025, 348, 185, 6, 70, "Input",
 CellID->562883762],
Cell[9213, 356, 218, 7, 36, "Output",
 CellID->797213795]
}, Open  ]],
Cell[9446, 366, 185, 6, 70, "ExampleText",
 CellID->8900864],
Cell[CellGroupData[{
Cell[9656, 376, 110, 3, 70, "Input",
 CellID->919245573],
Cell[9769, 381, 159, 5, 36, "Output",
 CellID->185060212]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9989, 393, 311, 9, 70, "SeeAlsoSection",
 CellID->10395],
Cell[10303, 404, 457, 17, 70, "SeeAlso",
 CellID->11841]
}, Open  ]],
Cell[CellGroupData[{
Cell[10797, 426, 314, 9, 70, "TutorialsSection",
 CellID->28598],
Cell[11114, 437, 141, 3, 70, "Tutorials",
 CellID->20091]
}, Open  ]],
Cell[CellGroupData[{
Cell[11292, 445, 319, 9, 70, "MoreAboutSection",
 CellID->598420318],
Cell[11614, 456, 193, 4, 70, "MoreAbout",
 CellID->234801946],
Cell[11810, 462, 151, 3, 70, "MoreAbout",
 CellID->113747469]
}, Open  ]],
Cell[11976, 468, 27, 0, 70, "History"],
Cell[12006, 470, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

