(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13584,        489]
NotebookOptionsPosition[     10170,        375]
NotebookOutlinePosition[     11584,        414]
CellTagsIndexPosition[     11499,        409]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Intercepting the Creation of New Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/InterceptingTheCreationOfNewSymbols"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Intercepting the Creation of New Symbols\"\>"}, "\<\"tutorials\
\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DeclarePackage" :> 
          Documentation`HelpLookup["paclet:ref/DeclarePackage"], 
          "$NewMessage" :> 
          Documentation`HelpLookup["paclet:ref/$NewMessage"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DeclarePackage\"\>", 
       2->"\<\"$NewMessage\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Session Customization\"\>", 
       2->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$NewSymbol", "ObjectName",
 CellID->19775],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$NewSymbol",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
     "\[LineSeparator]is a global variable which, if set, is applied to the \
name and context of each new symbol that ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " creates. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5795]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The name and context of the symbol are given as strings. ", "Notes",
 CellID->7074],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " is applied before the symbol is actually created. If the action of ",
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " causes the symbol to be created, perhaps in a different context, then the \
symbol as created will be the one used. "
}], "Notes",
 CellID->25812],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " is applied even if a symbol has already been created with a ",
 Cell[BoxData[
  ButtonBox["Stub",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Stub"]], "InlineFormula"],
 " attribute by ",
 Cell[BoxData[
  ButtonBox["DeclarePackage",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeclarePackage"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19875],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " is not applied to symbols automatically created by scoping constructs such \
as ",
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7992]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->917008157],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->387000074],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " to a function that prints the name and context when a new symbol is \
created:"
}], "ExampleText",
 CellContext->"Global`",
 CellID->311300894],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$NewSymbol", "=", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{
    "\"\<Name: \>\"", ",", "#1", ",", "\"\< Context: \>\"", ",", "#2"}], 
    "]"}], "&"}]}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->68445678],

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", 
   RowBox[{"\<\"Name: \"\>", ",", "#1", ",", "\<\" Context: \"\>", ",", 
    "#2"}], "]"}], "&"}]], "Output",
 CellContext->"Global`",
 ImageSize->{238, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41896504]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["sn1"], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->697236679],

Cell[BoxData["sn1"], "Output",
 CellContext->"Global`",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7461372]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["context`sn2"], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->706798101],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Name: \"\>", "\[InvisibleSpace]", "\<\"sn2\"\>", 
   "\[InvisibleSpace]", "\<\" Context: \"\>", 
   "\[InvisibleSpace]", "\<\"context`\"\>"}],
  SequenceForm["Name: ", "sn2", " Context: ", "context`"],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[3]:=",
 CellID->45946343],

Cell[BoxData["context`sn2"], "Output",
 CellContext->"Global`",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->88753525]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$NewSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NewSymbol"]], "InlineFormula"],
 " to its default: "
}], "ExampleText",
 CellID->440664273],

Cell[BoxData[
 RowBox[{"$NewSymbol", "=."}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9444279]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9788],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeclarePackage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeclarePackage"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$NewMessage",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$NewMessage"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9253]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15073],

Cell[TextData[ButtonBox["Intercepting the Creation of New Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/InterceptingTheCreationOfNewSymbols"]], "Tutorials",
 CellID->22875]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2092915],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->56165132],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->50408695]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$NewSymbol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 19.9645554}", "context" -> "System`", 
    "keywords" -> {
     "symbol creation", "symbol notification", "new symbol call back", 
      "symbol table call back", "symbol hook", "symbol table hook"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$NewSymbol is a global variable which, if set, is applied to the name \
and context of each new symbol that Mathematica creates. ", 
    "synonyms" -> {"new symbol"}, "title" -> "$NewSymbol", "type" -> "Symbol",
     "uri" -> "ref/$NewSymbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5312, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->917008157]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11356, 402}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2072, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2695, 79, 48, 1, 70, "ObjectName",
 CellID->19775],
Cell[2746, 82, 559, 17, 70, "Usage",
 CellID->5795]
}, Open  ]],
Cell[CellGroupData[{
Cell[3342, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3820, 121, 89, 1, 70, "Notes",
 CellID->7074],
Cell[3912, 124, 484, 13, 70, "Notes",
 CellID->25812],
Cell[4399, 139, 500, 17, 70, "Notes",
 CellID->19875],
Cell[4902, 158, 373, 13, 70, "Notes",
 CellID->7992]
}, Closed]],
Cell[CellGroupData[{
Cell[5312, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->917008157],
Cell[CellGroupData[{
Cell[5697, 190, 148, 5, 70, "ExampleSection",
 CellID->387000074],
Cell[5848, 197, 294, 10, 70, "ExampleText",
 CellID->311300894],
Cell[CellGroupData[{
Cell[6167, 211, 263, 9, 28, "Input",
 CellID->68445678],
Cell[6433, 222, 313, 10, 36, "Output",
 CellID->41896504]
}, Open  ]],
Cell[CellGroupData[{
Cell[6783, 237, 97, 3, 28, "Input",
 CellID->697236679],
Cell[6883, 242, 183, 6, 36, "Output",
 CellID->7461372]
}, Open  ]],
Cell[CellGroupData[{
Cell[7103, 253, 105, 3, 70, "Input",
 CellID->706798101],
Cell[7211, 258, 343, 8, 70, "Print",
 CellID->45946343],
Cell[7557, 268, 192, 6, 36, "Output",
 CellID->88753525]
}, Open  ]],
Cell[7764, 277, 211, 8, 70, "ExampleText",
 CellID->440664273],
Cell[7978, 287, 95, 3, 70, "Input",
 CellID->9444279]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8122, 296, 310, 9, 70, "SeeAlsoSection",
 CellID->9788],
Cell[8435, 307, 468, 17, 70, "SeeAlso",
 CellID->9253]
}, Open  ]],
Cell[CellGroupData[{
Cell[8940, 329, 314, 9, 70, "TutorialsSection",
 CellID->15073],
Cell[9257, 340, 189, 4, 70, "Tutorials",
 CellID->22875]
}, Open  ]],
Cell[CellGroupData[{
Cell[9483, 349, 317, 9, 70, "MoreAboutSection",
 CellID->2092915],
Cell[9803, 360, 152, 3, 70, "MoreAbout",
 CellID->56165132],
Cell[9958, 365, 140, 3, 70, "MoreAbout",
 CellID->50408695]
}, Open  ]],
Cell[10113, 371, 27, 0, 70, "History"],
Cell[10143, 373, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

