(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9716,        330]
NotebookOptionsPosition[      7483,        259]
NotebookOutlinePosition[      8644,        290]
CellTagsIndexPosition[      8601,        287]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Precision" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalPrecision"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Precision\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"], "SetPrecision" :> 
          Documentation`HelpLookup["paclet:ref/SetPrecision"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberForm\"\>", 
       2->"\<\"SetPrecision\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"], 
          "Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Display of Numbers\"\>", 
       2->"\<\"Global Computation Settings & Parameters\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$NumberMarks", "ObjectName",
 CellID->23286],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$NumberMarks",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$NumberMarks"]], "InlineFormula"],
     "\[LineSeparator]gives the default value for the option ",
     Cell[BoxData[
      ButtonBox["NumberMarks",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberMarks"]], "InlineFormula"],
     ", which specifies whether ",
     Cell[BoxData["`"], "InlineFormula"],
     " marks should be included in the input form representations of \
approximate numbers. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5176]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting for ",
 Cell[BoxData[
  ButtonBox["$NumberMarks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$NumberMarks"]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23874],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$NumberMarks", "=", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " indicates that ",
 Cell[BoxData["`"], "InlineFormula"],
 " should by default be used in all approximate numbers, both \
machine\[Hyphen]precision and arbitrary\[Hyphen]precision ones. "
}], "Notes",
 CellID->9503],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$NumberMarks", "=", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " indicates that ",
 Cell[BoxData["`"], "InlineFormula"],
 " should by default be used in arbitrary\[Hyphen]precision but not machine\
\[Hyphen]precision numbers. "
}], "Notes",
 CellID->8264],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"$NumberMarks", "=", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " indicates that ",
 Cell[BoxData["`"], "InlineFormula"],
 " should by default never be used in outputting numbers. "
}], "Notes",
 CellID->17280]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28846],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10963]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13548],

Cell[TextData[ButtonBox["Numerical Precision",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalPrecision"]], "Tutorials",
 CellID->17377]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->17776781],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->36790798],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->383212033]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$NumberMarks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 35.5899554}", "context" -> "System`", 
    "keywords" -> {"approximate numbers"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$NumberMarks gives the default value for the option NumberMarks, which \
specifies whether ` marks should be included in the input form \
representations of approximate numbers. ", "synonyms" -> {"number marks"}, 
    "title" -> "$NumberMarks", "type" -> "Symbol", "uri" -> 
    "ref/$NumberMarks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2058, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2681, 78, 50, 1, 70, "ObjectName",
 CellID->23286],
Cell[2734, 81, 742, 21, 70, "Usage",
 CellID->5176]
}, Open  ]],
Cell[CellGroupData[{
Cell[3513, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3991, 124, 336, 13, 70, "Notes",
 CellID->23874],
Cell[4330, 139, 380, 11, 70, "Notes",
 CellID->9503],
Cell[4713, 152, 367, 11, 70, "Notes",
 CellID->8264],
Cell[5083, 165, 313, 10, 70, "Notes",
 CellID->17280]
}, Closed]],
Cell[CellGroupData[{
Cell[5433, 180, 311, 9, 70, "SeeAlsoSection",
 CellID->28846],
Cell[5747, 191, 463, 17, 70, "SeeAlso",
 CellID->10963]
}, Open  ]],
Cell[CellGroupData[{
Cell[6247, 213, 314, 9, 70, "TutorialsSection",
 CellID->13548],
Cell[6564, 224, 148, 3, 70, "Tutorials",
 CellID->17377]
}, Open  ]],
Cell[CellGroupData[{
Cell[6749, 232, 318, 9, 70, "MoreAboutSection",
 CellID->17776781],
Cell[7070, 243, 145, 3, 70, "MoreAbout",
 CellID->36790798],
Cell[7218, 248, 193, 4, 70, "MoreAbout",
 CellID->383212033]
}, Open  ]],
Cell[7426, 255, 27, 0, 70, "History"],
Cell[7456, 257, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

