(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11180,        392]
NotebookOptionsPosition[      8507,        304]
NotebookOutlinePosition[      9833,        341]
CellTagsIndexPosition[      9749,        336]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$MachineType" :> 
          Documentation`HelpLookup["paclet:ref/$MachineType"], "$System" :> 
          Documentation`HelpLookup["paclet:ref/$System"], "$SystemID" :> 
          Documentation`HelpLookup["paclet:ref/$SystemID"], "$ProcessorType" :> 
          Documentation`HelpLookup["paclet:ref/$ProcessorType"], 
          "SystemInformation" :> 
          Documentation`HelpLookup["paclet:ref/SystemInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$MachineType\"\>", 
       2->"\<\"$System\"\>", 3->"\<\"$SystemID\"\>", 
       4->"\<\"$ProcessorType\"\>", 
       5->"\<\"SystemInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$OperatingSystem", "ObjectName",
 CellID->16420],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$OperatingSystem",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$OperatingSystem"]], "InlineFormula"],
     "\[LineSeparator]is a string giving the type of operating system under \
which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is being run. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29083]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Typical values for ",
 Cell[BoxData[
  ButtonBox["$OperatingSystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OperatingSystem"]], "InlineFormula"],
 " are ",
 Cell[BoxData["\"\<Windows\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MacOSX\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Unix\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22781],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["$OperatingSystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OperatingSystem"]], "InlineFormula"],
 " to get an idea of what external commands will be available from within ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ". "
}], "Notes",
 CellID->1588],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$OperatingSystem",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OperatingSystem"]], "InlineFormula"],
 " typically has the same value for different versions or variants of a \
particular operating system. "
}], "Notes",
 CellID->4197]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81275620],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->42126936],

Cell[CellGroupData[{

Cell[BoxData["$OperatingSystem"], "Input",
 CellLabel->"In[1]:=",
 CellID->521929923],

Cell[BoxData["\<\"Windows\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199185849]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2891],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$System",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$System"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SystemID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SystemID"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ProcessorType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ProcessorType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4222]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18564],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->14214]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->30720251],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->13457055]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$OperatingSystem - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 35.8087110}", "context" -> "System`", 
    "keywords" -> {"command language", "external commands", "shell type"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$OperatingSystem is a string giving the type of operating system under \
which Mathematica is being run. ", "synonyms" -> {"operating system"}, 
    "title" -> "$OperatingSystem", "type" -> "Symbol", "uri" -> 
    "ref/$OperatingSystem"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5005, 165, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->81275620]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9607, 329}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2227, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2850, 81, 54, 1, 70, "ObjectName",
 CellID->16420],
Cell[2907, 84, 542, 17, 70, "Usage",
 CellID->29083]
}, Open  ]],
Cell[CellGroupData[{
Cell[3486, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3964, 123, 388, 14, 70, "Notes",
 CellID->22781],
Cell[4355, 139, 327, 11, 70, "Notes",
 CellID->1588],
Cell[4685, 152, 283, 8, 70, "Notes",
 CellID->4197]
}, Closed]],
Cell[CellGroupData[{
Cell[5005, 165, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81275620],
Cell[CellGroupData[{
Cell[5389, 179, 147, 5, 70, "ExampleSection",
 CellID->42126936],
Cell[CellGroupData[{
Cell[5561, 188, 85, 2, 28, "Input",
 CellID->521929923],
Cell[5649, 192, 172, 5, 36, "Output",
 CellID->199185849]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5882, 204, 310, 9, 70, "SeeAlsoSection",
 CellID->2891],
Cell[6195, 215, 1223, 44, 70, "SeeAlso",
 CellID->4222]
}, Open  ]],
Cell[CellGroupData[{
Cell[7455, 264, 314, 9, 70, "TutorialsSection",
 CellID->18564],
Cell[7772, 275, 159, 3, 70, "Tutorials",
 CellID->14214]
}, Open  ]],
Cell[CellGroupData[{
Cell[7968, 283, 318, 9, 70, "MoreAboutSection",
 CellID->30720251],
Cell[8289, 294, 146, 3, 70, "MoreAbout",
 CellID->13457055]
}, Open  ]],
Cell[8450, 300, 27, 0, 70, "History"],
Cell[8480, 302, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

