(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26962,        849]
NotebookOptionsPosition[     23118,        724]
NotebookOutlinePosition[     24600,        764]
CellTagsIndexPosition[     24515,        759]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Memory Management" :> 
          Documentation`HelpLookup["paclet:tutorial/MemoryManagement"], 
          "Short and Shallow Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ShortAndShallowOutput"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Memory Management\"\>", 
       2->"\<\"Short and Shallow Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Short" :> Documentation`HelpLookup["paclet:ref/Short"], 
          "Shallow" :> Documentation`HelpLookup["paclet:ref/Shallow"], 
          "$PrePrint" :> Documentation`HelpLookup["paclet:ref/$PrePrint"], 
          "$HistoryLength" :> 
          Documentation`HelpLookup["paclet:ref/$HistoryLength"], 
          "OutputSizeLimit" :> 
          Documentation`HelpLookup["paclet:ref/OutputSizeLimit"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Short\"\>", 2->"\<\"Shallow\"\>", 
       3->"\<\"$PrePrint\"\>", 4->"\<\"$HistoryLength\"\>", 
       5->"\<\"OutputSizeLimit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Options in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/EvaluationOptionsInNotebooks"], 
          "Managing Computations in Notebooks" :> 
          Documentation`HelpLookup[
           "paclet:guide/ManagingComputationsInNotebooks"], 
          "Mathematica Session History" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessionHistory"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Evaluation Options in Notebooks\"\>", 
       2->"\<\"Managing Computations in Notebooks\"\>", 
       3->"\<\"Mathematica Session History\"\>", 
       4->"\<\"Session Customization\"\>", 
       5->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$OutputSizeLimit", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$OutputSizeLimit",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$OutputSizeLimit"]], "InlineFormula"],
     " \[LineSeparator]specifies the maximum size in bytes of expressions \
that will automatically be output in their entirety in a ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18960]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For expressions larger than ",
 Cell[BoxData[
  ButtonBox["$OutputSizeLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OutputSizeLimit"]], "InlineFormula"],
 ", portions of the expression are displayed, together with controls to allow \
more to be displayed."
}], "Notes",
 CellID->637],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$OutputSizeLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OutputSizeLimit"]], "InlineFormula"],
 " is not affected by constructs such as ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " whose displayed form does not grow with the amount of data they contain."
}], "Notes",
 CellID->4185],

Cell[TextData[{
 "Larger portions of expressions elided as a result of ",
 Cell[BoxData[
  ButtonBox["$OutputSizeLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OutputSizeLimit"]], "InlineFormula"],
 " can only be displayed while the corresponding ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", 
   StyleBox["n", "TI"], "]"}]], "InlineFormula"],
 " is accessible in a single kernel session."
}], "Notes",
 CellID->77]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108551055],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->314628104],

Cell["This produces output that is somewhat lengthy:", "ExampleText",
 CellID->647125461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", 
     RowBox[{"3", "y"}]}], ")"}], "^", "27"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->452437229],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["x", "27"], "+", 
  RowBox[{"81", " ", 
   SuperscriptBox["x", "26"], " ", "y"}], "+", 
  RowBox[{"3159", " ", 
   SuperscriptBox["x", "25"], " ", 
   SuperscriptBox["y", "2"]}], "+", 
  RowBox[{"78975", " ", 
   SuperscriptBox["x", "24"], " ", 
   SuperscriptBox["y", "3"]}], "+", 
  RowBox[{"1421550", " ", 
   SuperscriptBox["x", "23"], " ", 
   SuperscriptBox["y", "4"]}], "+", 
  RowBox[{"19617390", " ", 
   SuperscriptBox["x", "22"], " ", 
   SuperscriptBox["y", "5"]}], "+", 
  RowBox[{"215791290", " ", 
   SuperscriptBox["x", "21"], " ", 
   SuperscriptBox["y", "6"]}], "+", 
  RowBox[{"1942121610", " ", 
   SuperscriptBox["x", "20"], " ", 
   SuperscriptBox["y", "7"]}], "+", 
  RowBox[{"14565912075", " ", 
   SuperscriptBox["x", "19"], " ", 
   SuperscriptBox["y", "8"]}], "+", 
  RowBox[{"92250776475", " ", 
   SuperscriptBox["x", "18"], " ", 
   SuperscriptBox["y", "9"]}], "+", 
  RowBox[{"498154192965", " ", 
   SuperscriptBox["x", "17"], " ", 
   SuperscriptBox["y", "10"]}], "+", 
  RowBox[{"2309623985565", " ", 
   SuperscriptBox["x", "16"], " ", 
   SuperscriptBox["y", "11"]}], "+", 
  RowBox[{"9238495942260", " ", 
   SuperscriptBox["x", "15"], " ", 
   SuperscriptBox["y", "12"]}], "+", 
  RowBox[{"31979409030900", " ", 
   SuperscriptBox["x", "14"], " ", 
   SuperscriptBox["y", "13"]}], "+", 
  RowBox[{"95938227092700", " ", 
   SuperscriptBox["x", "13"], " ", 
   SuperscriptBox["y", "14"]}], "+", 
  RowBox[{"249439390441020", " ", 
   SuperscriptBox["x", "12"], " ", 
   SuperscriptBox["y", "15"]}], "+", 
  RowBox[{"561238628492295", " ", 
   SuperscriptBox["x", "11"], " ", 
   SuperscriptBox["y", "16"]}], "+", 
  RowBox[{"1089463220014455", " ", 
   SuperscriptBox["x", "10"], " ", 
   SuperscriptBox["y", "17"]}], "+", 
  RowBox[{"1815772033357425", " ", 
   SuperscriptBox["x", "9"], " ", 
   SuperscriptBox["y", "18"]}], "+", 
  RowBox[{"2580307626350025", " ", 
   SuperscriptBox["x", "8"], " ", 
   SuperscriptBox["y", "19"]}], "+", 
  RowBox[{"3096369151620030", " ", 
   SuperscriptBox["x", "7"], " ", 
   SuperscriptBox["y", "20"]}], "+", 
  RowBox[{"3096369151620030", " ", 
   SuperscriptBox["x", "6"], " ", 
   SuperscriptBox["y", "21"]}], "+", 
  RowBox[{"2533392942234570", " ", 
   SuperscriptBox["x", "5"], " ", 
   SuperscriptBox["y", "22"]}], "+", 
  RowBox[{"1652212788413850", " ", 
   SuperscriptBox["x", "4"], " ", 
   SuperscriptBox["y", "23"]}], "+", 
  RowBox[{"826106394206925", " ", 
   SuperscriptBox["x", "3"], " ", 
   SuperscriptBox["y", "24"]}], "+", 
  RowBox[{"297398301914493", " ", 
   SuperscriptBox["x", "2"], " ", 
   SuperscriptBox["y", "25"]}], "+", 
  RowBox[{"68630377364883", " ", "x", " ", 
   SuperscriptBox["y", "26"]}], "+", 
  RowBox[{"7625597484987", " ", 
   SuperscriptBox["y", "27"]}]}]], "Output",
 ImageSize->{523, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->634412914]
}, Open  ]],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  ButtonBox["$OutputSizeLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OutputSizeLimit"]], "InlineFormula"],
 " to be rather small:"
}], "ExampleText",
 CellID->546020555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$OutputSizeLimit", "=", "4000"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95201795],

Cell[BoxData["4000"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321538243]
}, Open  ]],

Cell["Now the same output as before is shown in a shortened form:", \
"ExampleText",
 CellID->50949985],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", 
     RowBox[{"3", "y"}]}], ")"}], "^", "27"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12973506],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   PanelBox[
    TagBox[GridBox[{
       {
        StyleBox[
         StyleBox[
          DynamicBox[ToBoxes[
            FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
            StandardForm],
           ImageSizeCache->{319., {2., 10.}}],
          StripOnInput->False,
          DynamicUpdating->True], "Panel",
         StripOnInput->False,
         FontSize->1 + Inherited,
         Background->None]},
       {
        ItemBox[
         TagBox[
          RowBox[{
           SuperscriptBox["x", "27"], "+", 
           RowBox[{"81", " ", 
            SuperscriptBox["x", "26"], " ", "y"}], "+", 
           RowBox[{"3159", " ", 
            SuperscriptBox["x", "25"], " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"78975", " ", 
            SuperscriptBox["x", "24"], " ", 
            SuperscriptBox["y", "3"]}], "+", 
           RowBox[{"1421550", " ", 
            SuperscriptBox["x", "23"], " ", 
            SuperscriptBox["y", "4"]}], "+", 
           RowBox[{"19617390", " ", 
            SuperscriptBox["x", "22"], " ", 
            SuperscriptBox["y", "5"]}], "+", 
           RowBox[{"215791290", " ", 
            SuperscriptBox["x", "21"], " ", 
            SuperscriptBox["y", "6"]}], "+", 
           RowBox[{"1942121610", " ", 
            SuperscriptBox["x", "20"], " ", 
            SuperscriptBox["y", "7"]}], "+", 
           RowBox[{"\[LeftSkeleton]", "13", "\[RightSkeleton]"}], "+", 
           RowBox[{"3096369151620030", " ", 
            SuperscriptBox["x", "6"], " ", 
            SuperscriptBox["y", "21"]}], "+", 
           RowBox[{"2533392942234570", " ", 
            SuperscriptBox["x", "5"], " ", 
            SuperscriptBox["y", "22"]}], "+", 
           RowBox[{"1652212788413850", " ", 
            SuperscriptBox["x", "4"], " ", 
            SuperscriptBox["y", "23"]}], "+", 
           RowBox[{"826106394206925", " ", 
            SuperscriptBox["x", "3"], " ", 
            SuperscriptBox["y", "24"]}], "+", 
           RowBox[{"297398301914493", " ", 
            SuperscriptBox["x", "2"], " ", 
            SuperscriptBox["y", "25"]}], "+", 
           RowBox[{"68630377364883", " ", "x", " ", 
            SuperscriptBox["y", "26"]}], "+", 
           RowBox[{"7625597484987", " ", 
            SuperscriptBox["y", "27"]}]}],
          Short[#, 5]& ],
         Background->GrayLevel[1],
         BaseStyle->{Deployed -> False},
         Frame->True,
         FrameStyle->GrayLevel[0, 0.2],
         StripOnInput->False]},
       {
        RowBox[{
         ButtonBox[
          StyleBox[
           StyleBox[
            DynamicBox[ToBoxes[
              FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
              StandardForm],
             ImageSizeCache->{58., {1., 10.}}],
            StripOnInput->False,
            DynamicUpdating->True], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          
          ButtonFunction:>OutputSizeLimit`ButtonFunction[
           Identity, 15, 22181396556087408643, 5/2],
          Enabled->True,
          Evaluator->Automatic,
          Method->"Queued"], "\[ThinSpace]", 
         ButtonBox[
          StyleBox[
           StyleBox[
            DynamicBox[ToBoxes[
              FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
              StandardForm],
             ImageSizeCache->{62., {1., 10.}}],
            StripOnInput->False,
            DynamicUpdating->True], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          
          ButtonFunction:>OutputSizeLimit`ButtonFunction[
           Identity, 15, 22181396556087408643, 5 2],
          Enabled->True,
          Evaluator->Automatic,
          Method->"Queued"], "\[ThinSpace]", 
         ButtonBox[
          StyleBox[
           StyleBox[
            DynamicBox[ToBoxes[
              FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
              StandardForm],
             ImageSizeCache->{96., {2., 10.}}],
            StripOnInput->False,
            DynamicUpdating->True], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          
          ButtonFunction:>OutputSizeLimit`ButtonFunction[
           Identity, 15, 22181396556087408643, Infinity],
          Enabled->True,
          Evaluator->Automatic,
          Method->"Queued"], "\[ThinSpace]", 
         ButtonBox[
          StyleBox[
           StyleBox[
            DynamicBox[ToBoxes[
              FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
              StandardForm],
             ImageSizeCache->{85., {1., 9.}}],
            StripOnInput->False,
            DynamicUpdating->True], "Panel",
           StripOnInput->False,
           FontSize->1 + Inherited,
           Background->None],
          Appearance->Automatic,
          ButtonFrame->"DialogBox",
          ButtonFunction:>FrontEndExecute[{
             FrontEnd`SetOptions[
             FrontEnd`$FrontEnd, 
              FrontEnd`PreferencesSettings -> {"Page" -> "Evaluation"}], 
             FrontEnd`FrontEndToken["PreferencesDialog"]}],
          Evaluator->None,
          Method->"Preemptive"]}]}
      },
      ColumnsEqual->False,
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxDividers->{
       "Columns" -> {{False}}, "ColumnsIndexed" -> {}, "Rows" -> {{False}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{
       "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.5599999999999999]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[1.2]}, 
          Offset[0.2]}, "RowsIndexed" -> {}},
      RowsEqual->False],
     "Column"],
    DefaultBaseStyle->{},
    FrameMargins->5],
   Deployed->True,
   StripOnInput->False],
  Out[15]]], "Output",
 ImageSize->{586, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1024394249]
}, Open  ]],

Cell[TextData[{
 "This resets the ",
 Cell[BoxData[
  ButtonBox["$OutputSizeLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$OutputSizeLimit"]], "InlineFormula"],
 " option to its global setting:"
}], "ExampleText",
 CellID->868192494],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$OutputSizeLimit", "=", "Inherited"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->653057950],

Cell[BoxData["Inherited"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->617744944]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8698],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Short",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Short"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Shallow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Shallow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PrePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$HistoryLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$HistoryLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["OutputSizeLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OutputSizeLimit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20192]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26380],

Cell[TextData[ButtonBox["Memory Management",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MemoryManagement"]], "Tutorials",
 CellID->20907],

Cell[TextData[ButtonBox["Short and Shallow Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ShortAndShallowOutput"]], "Tutorials",
 CellID->152397031]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Evaluation Options in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationOptionsInNotebooks"]], "MoreAbout",
 CellID->678629372],

Cell[TextData[ButtonBox["Managing Computations in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ManagingComputationsInNotebooks"]], "MoreAbout",
 CellID->126829899],

Cell[TextData[ButtonBox["Mathematica Session History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionHistory"]], "MoreAbout",
 CellID->448946237],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->268878657],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->713831700]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$OutputSizeLimit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 43.4651570}", "context" -> "System`", 
    "keywords" -> {
     "output overflow", "formula overflow", "short output", "long output", 
      "large output", "suppressing large output", 
      "controlling output display"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$OutputSizeLimit specifies the maximum size in bytes of expressions that \
will automatically be output in their entirety in a Mathematica notebook. ", 
    "synonyms" -> {"output size limit"}, "title" -> "$OutputSizeLimit", 
    "type" -> "Symbol", "uri" -> "ref/$OutputSizeLimit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7819, 225, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->108551055]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24372, 752}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3109, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3732, 97, 1581, 37, 70, "ObjectNameGrid"],
Cell[5316, 136, 587, 17, 70, "Usage",
 CellID->18960]
}, Open  ]],
Cell[CellGroupData[{
Cell[5940, 158, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6418, 175, 313, 9, 70, "Notes",
 CellID->637],
Cell[6734, 186, 553, 17, 70, "Notes",
 CellID->4185],
Cell[7290, 205, 492, 15, 70, "Notes",
 CellID->77]
}, Closed]],
Cell[CellGroupData[{
Cell[7819, 225, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->108551055],
Cell[CellGroupData[{
Cell[8204, 239, 148, 5, 70, "ExampleSection",
 CellID->314628104],
Cell[8355, 246, 89, 1, 70, "ExampleText",
 CellID->647125461],
Cell[CellGroupData[{
Cell[8469, 251, 196, 7, 28, "Input",
 CellID->452437229],
Cell[8668, 260, 2963, 85, 156, "Output",
 CellID->634412914]
}, Open  ]],
Cell[11646, 348, 222, 8, 70, "ExampleText",
 CellID->546020555],
Cell[CellGroupData[{
Cell[11893, 360, 109, 3, 70, "Input",
 CellID->95201795],
Cell[12005, 365, 161, 5, 36, "Output",
 CellID->321538243]
}, Open  ]],
Cell[12181, 373, 103, 2, 70, "ExampleText",
 CellID->50949985],
Cell[CellGroupData[{
Cell[12309, 379, 195, 7, 70, "Input",
 CellID->12973506],
Cell[12507, 388, 6541, 180, 70, "Output",
 CellID->1024394249]
}, Open  ]],
Cell[19063, 571, 244, 8, 70, "ExampleText",
 CellID->868192494],
Cell[CellGroupData[{
Cell[19332, 583, 115, 3, 70, "Input",
 CellID->653057950],
Cell[19450, 588, 166, 5, 36, "Output",
 CellID->617744944]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19677, 600, 310, 9, 70, "SeeAlsoSection",
 CellID->8698],
Cell[19990, 611, 1206, 44, 70, "SeeAlso",
 CellID->20192]
}, Open  ]],
Cell[CellGroupData[{
Cell[21233, 660, 314, 9, 70, "TutorialsSection",
 CellID->26380],
Cell[21550, 671, 144, 3, 70, "Tutorials",
 CellID->20907],
Cell[21697, 676, 160, 3, 70, "Tutorials",
 CellID->152397031]
}, Open  ]],
Cell[CellGroupData[{
Cell[21894, 684, 299, 8, 70, "MoreAboutSection"],
Cell[22196, 694, 171, 3, 70, "MoreAbout",
 CellID->678629372],
Cell[22370, 699, 177, 3, 70, "MoreAbout",
 CellID->126829899],
Cell[22550, 704, 164, 3, 70, "MoreAbout",
 CellID->448946237],
Cell[22717, 709, 153, 3, 70, "MoreAbout",
 CellID->268878657],
Cell[22873, 714, 173, 3, 70, "MoreAbout",
 CellID->713831700]
}, Open  ]],
Cell[23061, 720, 27, 0, 70, "History"],
Cell[23091, 722, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

