(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20826,        637]
NotebookOptionsPosition[     17411,        527]
NotebookOutlinePosition[     18766,        565]
CellTagsIndexPosition[     18681,        560]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding and Manipulating Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingAndManipulatingFiles"], 
          "Naming and Finding Files" :> 
          Documentation`HelpLookup["paclet:tutorial/NamingAndFindingFiles"], 
          "Mathematica File Organization" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/MathematicaFileOrganization"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Finding and Manipulating Files\"\>",
        2->"\<\"Naming and Finding Files\"\>", 
       3->"\<\"Mathematica File Organization\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Path" :> Documentation`HelpLookup["paclet:ref/Path"], 
          "Directory" :> Documentation`HelpLookup["paclet:ref/Directory"], 
          "NotebookDirectory" :> 
          Documentation`HelpLookup["paclet:ref/NotebookDirectory"], 
          "SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "DirectoryName" :> 
          Documentation`HelpLookup["paclet:ref/DirectoryName"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Path\"\>", 2->"\<\"Directory\"\>", 
       3->"\<\"NotebookDirectory\"\>", 4->"\<\"SetDirectory\"\>", 
       5->"\<\"Get\"\>", 6->"\<\"DirectoryName\"\>", 
       7->"\<\"$Input\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"Mathematica Session Information\"\>", 
       3->"\<\"Mathematica Sessions\"\>", 
       4->"\<\"Mathematica System Setup\"\>", 
       5->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["$Path", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Path",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
     "\[LineSeparator]gives the default list of directories to search in \
attempting to find an external file. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28540]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The structure of directory and file names may differ from one computer system \
to another. \
\>", "Notes",
 CellID->18410],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " is used both for files in ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 " and for external programs in ",
 Cell[BoxData[
  ButtonBox["Install",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Install"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->26338],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " can be overridden in specific functions using the ",
 Cell[BoxData[
  ButtonBox["Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Path"]], "InlineFormula"],
 " option. "
}], "Notes",
 CellID->12453],

Cell[TextData[{
 "The directory names are specified by strings. The full file names tested \
are of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToFileName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToFileName"], "[", 
   RowBox[{
    StyleBox["directory", "TI"], ",", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16646],

Cell["\<\
On most computer systems, the following special characters can be used in \
directory names: \
\>", "Notes",
 CellID->25045],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], ".", Cell[
    "the current directory ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "..", Cell[
    "the directory one level up in the hierarchy ", "TableText"]},
   {Cell["      ", "TableRowIcon"], "~", Cell[
    "the user\[CloseCurlyQuote]s home directory ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->30913],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$Path",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Path"]], "InlineFormula"],
 " can contain nested sublists. "
}], "Notes",
 CellID->14945]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130850762],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->289501503],

Cell["\<\
Add a directory to look for files in after the system default:\
\>", "ExampleText",
 CellID->486758122],

Cell[BoxData[
 RowBox[{
  RowBox[{"AppendTo", "[", 
   RowBox[{"$Path", ",", " ", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"{", 
      RowBox[{"$HomeDirectory", ",", "\"\<MyPackages\>\""}], "}"}], "]"}]}], 
   "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138787243],

Cell["\<\
Add a directory to look for fiels in before any of the system defaults:\
\>", "ExampleText",
 CellID->474997182],

Cell[BoxData[
 RowBox[{
  RowBox[{"PrependTo", "[", 
   RowBox[{"$Path", ",", " ", 
    RowBox[{"ToFileName", "[", 
     RowBox[{"{", 
      RowBox[{
      "$HomeDirectory", ",", "\"\<MyPackages\>\"", ",", 
       "\"\<LookHereFirst\>\""}], "}"}], "]"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->197280846]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24121],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Path",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Path"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectoryName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19210],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "Tutorials",
 CellID->7781],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->17026],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"],
  FontSlant->"Italic"],
 ButtonBox[" File Organization",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaFileOrganization"]
}], "Tutorials",
 CellID->502212112]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->607666723],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->88277111],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->229696666],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->316468328],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->665521410],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->60419779]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Path - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 44.8245668}", "context" -> "System`", 
    "keywords" -> {
     "directories of files", "path for files", "search path", 
      "search path for files", "search path of directories"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "$Path gives the default list of directories to search in attempting to \
find an external file. ", "synonyms" -> {"PATH", "ENVIRONMENT"}, "title" -> 
    "$Path", "type" -> "Symbol", "uri" -> "ref/$Path"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11704, 315, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->130850762]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18537, 553}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3484, 76, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4107, 103, 4189, 83, 70, "ObjectNameGrid"],
Cell[8299, 188, 467, 14, 70, "Usage",
 CellID->28540]
}, Open  ]],
Cell[CellGroupData[{
Cell[8803, 207, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9281, 224, 133, 4, 70, "Notes",
 CellID->18410],
Cell[9417, 230, 456, 17, 70, "Notes",
 CellID->26338],
Cell[9876, 249, 358, 13, 70, "Notes",
 CellID->12453],
Cell[10237, 264, 377, 13, 70, "Notes",
 CellID->16646],
Cell[10617, 279, 134, 4, 70, "Notes",
 CellID->25045],
Cell[10754, 285, 719, 16, 70, "2ColumnTableMod",
 CellID->30913],
Cell[11476, 303, 191, 7, 70, "Notes",
 CellID->14945]
}, Closed]],
Cell[CellGroupData[{
Cell[11704, 315, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->130850762],
Cell[CellGroupData[{
Cell[12089, 329, 148, 5, 70, "ExampleSection",
 CellID->289501503],
Cell[12240, 336, 113, 3, 70, "ExampleText",
 CellID->486758122],
Cell[12356, 341, 281, 9, 70, "Input",
 CellID->138787243],
Cell[12640, 352, 122, 3, 70, "ExampleText",
 CellID->474997182],
Cell[12765, 357, 323, 10, 70, "Input",
 CellID->197280846]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13137, 373, 311, 9, 70, "SeeAlsoSection",
 CellID->24121],
Cell[13451, 384, 1691, 62, 70, "SeeAlso",
 CellID->8787]
}, Open  ]],
Cell[CellGroupData[{
Cell[15179, 451, 314, 9, 70, "TutorialsSection",
 CellID->19210],
Cell[15496, 462, 167, 3, 70, "Tutorials",
 CellID->7781],
Cell[15666, 467, 156, 3, 70, "Tutorials",
 CellID->17026],
Cell[15825, 472, 309, 9, 70, "Tutorials",
 CellID->502212112]
}, Open  ]],
Cell[CellGroupData[{
Cell[16171, 486, 319, 9, 70, "MoreAboutSection",
 CellID->607666723],
Cell[16493, 497, 178, 3, 70, "MoreAbout",
 CellID->88277111],
Cell[16674, 502, 172, 3, 70, "MoreAbout",
 CellID->229696666],
Cell[16849, 507, 151, 3, 70, "MoreAbout",
 CellID->316468328],
Cell[17003, 512, 158, 3, 70, "MoreAbout",
 CellID->665521410],
Cell[17164, 517, 152, 3, 70, "MoreAbout",
 CellID->60419779]
}, Open  ]],
Cell[17331, 523, 50, 0, 70, "History"],
Cell[17384, 525, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

