(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16263,        594]
NotebookOptionsPosition[     12472,        465]
NotebookOutlinePosition[     13735,        502]
CellTagsIndexPosition[     13650,        497]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"The Main Loop\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Pre" :> Documentation`HelpLookup["paclet:ref/$Pre"], 
          "$PrePrint" :> Documentation`HelpLookup["paclet:ref/$PrePrint"], 
          "CellEpilog" :> Documentation`HelpLookup["paclet:ref/CellEpilog"], 
          "CellEvaluationFunction" :> 
          Documentation`HelpLookup["paclet:ref/CellEvaluationFunction"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"$Pre\"\>", 
       2->"\<\"$PrePrint\"\>", 3->"\<\"CellEpilog\"\>", 
       4->"\<\"CellEvaluationFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Mathematica Sessions\"\>", 
       2->"\<\"Mathematica System Setup\"\>", 
       3->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$Post", "ObjectName",
 CellID->28597],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Post",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
     "\[LineSeparator]is a global variable whose value, if set, is applied to \
every output expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23442]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->804837590],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " is not defined, meaning output comes directly from evaluation:"
}], "ExampleText",
 CellID->289932834],

Cell[CellGroupData[{

Cell[BoxData["$Post"], "Input",
 CellLabel->"In[1]:=",
 CellID->614411681],

Cell[BoxData["$Post"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->673050443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->70712024],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 " so that all expressions are evaluated numerically after evaluation:"
}], "ExampleText",
 CellID->231964975],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Post", " ", "=", " ", "N"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->77917133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", "1", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->468707407],

Cell[BoxData["0.8414709848078965`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->560397535]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112375658],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", "1.167303978261419`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.18123244446987535`"}], "-", 
      RowBox[{"1.0839541013177107`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.18123244446987535`"}], "+", 
      RowBox[{"1.0839541013177107`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.7648844336005848`", "\[InvisibleSpace]", "-", 
      RowBox[{"0.35247154603172615`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"0.7648844336005848`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.35247154603172615`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{474, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10911048]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " to the default:"
}], "ExampleText",
 CellID->173285343],

Cell[BoxData[
 RowBox[{"$Post", "=."}]], "Input",
 CellLabel->"In[4]:=",
 CellID->250210368],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17679069],

Cell[TextData[{
 "Set ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " so that symbolic simplification is tried on each output:"
}], "ExampleText",
 CellID->674277898],

Cell[BoxData[
 RowBox[{
  RowBox[{"$Post", " ", "=", " ", "Simplify"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->265384719],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"x", "+", "1"}], ")"}], 
  RowBox[{"(", 
   RowBox[{"x", "-", "1"}], ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16252047],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->515712267]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "3"}], " ", "+", " ", "x"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->398234574],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{"17", "+", 
    RowBox[{"12", " ", "x"}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["x", "2"]}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "-", 
    RowBox[{"12", " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", "x"}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{245, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->400388907]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 " to the default:"
}], "ExampleText",
 CellID->169229035],

Cell[BoxData[
 RowBox[{"$Post", "=."}]], "Input",
 CellLabel->"In[4]:=",
 CellID->58409397]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27097],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Pre",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Pre"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PrePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEpilog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEpilog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEvaluationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEvaluationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12383]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30827],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->31232],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->236445173],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->722439082],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->268986720],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->515717149]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Post - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 51.4497364}", "context" -> "System`", 
    "keywords" -> {
     "epilog", "global switches", "postprocessing", "postprocessor"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$Post is a global variable whose value, if set, is applied to every \
output expression. ", "synonyms" -> {}, "title" -> "$Post", "type" -> 
    "Symbol", "uri" -> "ref/$Post"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3679, 106, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13515, 490}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2513, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3136, 84, 43, 1, 70, "ObjectName",
 CellID->28597],
Cell[3182, 87, 460, 14, 70, "Usage",
 CellID->23442]
}, Open  ]],
Cell[CellGroupData[{
Cell[3679, 106, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[4056, 120, 148, 5, 70, "ExampleSection",
 CellID->804837590],
Cell[4207, 127, 251, 8, 70, "ExampleText",
 CellID->289932834],
Cell[CellGroupData[{
Cell[4483, 139, 74, 2, 28, "Input",
 CellID->614411681],
Cell[4560, 143, 162, 5, 36, "Output",
 CellID->673050443]
}, Open  ]],
Cell[4737, 151, 124, 3, 70, "ExampleDelimiter",
 CellID->70712024],
Cell[4864, 156, 362, 13, 70, "ExampleText",
 CellID->231964975],
Cell[5229, 171, 123, 4, 70, "Input",
 CellID->77917133],
Cell[CellGroupData[{
Cell[5377, 179, 99, 3, 70, "Input",
 CellID->468707407],
Cell[5479, 184, 176, 5, 36, "Output",
 CellID->560397535]
}, Open  ]],
Cell[CellGroupData[{
Cell[5692, 194, 220, 8, 70, "Input",
 CellID->112375658],
Cell[5915, 204, 1047, 30, 54, "Output",
 CellID->10911048]
}, Open  ]],
Cell[6977, 237, 200, 8, 70, "ExampleText",
 CellID->173285343],
Cell[7180, 247, 92, 3, 70, "Input",
 CellID->250210368],
Cell[7275, 252, 124, 3, 70, "ExampleDelimiter",
 CellID->17679069],
Cell[7402, 257, 365, 13, 70, "ExampleText",
 CellID->674277898],
Cell[7770, 272, 131, 4, 70, "Input",
 CellID->265384719],
Cell[CellGroupData[{
Cell[7926, 280, 180, 7, 70, "Input",
 CellID->16252047],
Cell[8109, 289, 222, 8, 36, "Output",
 CellID->515712267]
}, Open  ]],
Cell[CellGroupData[{
Cell[8368, 302, 291, 10, 70, "Input",
 CellID->398234574],
Cell[8662, 314, 496, 17, 51, "Output",
 CellID->400388907]
}, Open  ]],
Cell[9173, 334, 200, 8, 70, "ExampleText",
 CellID->169229035],
Cell[9376, 344, 91, 3, 70, "Input",
 CellID->58409397]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9516, 353, 311, 9, 70, "SeeAlsoSection",
 CellID->27097],
Cell[9830, 364, 967, 35, 70, "SeeAlso",
 CellID->12383]
}, Open  ]],
Cell[CellGroupData[{
Cell[10834, 404, 314, 9, 70, "TutorialsSection",
 CellID->30827],
Cell[11151, 415, 135, 3, 70, "Tutorials",
 CellID->31232],
Cell[11289, 420, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[11610, 434, 319, 9, 70, "MoreAboutSection",
 CellID->236445173],
Cell[11932, 445, 151, 3, 70, "MoreAbout",
 CellID->722439082],
Cell[12086, 450, 158, 3, 70, "MoreAbout",
 CellID->268986720],
Cell[12247, 455, 153, 3, 70, "MoreAbout",
 CellID->515717149]
}, Open  ]],
Cell[12415, 461, 27, 0, 70, "History"],
Cell[12445, 463, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

