(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16587,        610]
NotebookOptionsPosition[     13023,        489]
NotebookOutlinePosition[     14269,        525]
CellTagsIndexPosition[     14184,        520]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Main Loop" :> 
          Documentation`HelpLookup["paclet:tutorial/TheMainLoop"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:tutorial/MathematicaSessions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"The Main Loop\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$PreRead" :> Documentation`HelpLookup["paclet:ref/$PreRead"], 
          "$PrePrint" :> Documentation`HelpLookup["paclet:ref/$PrePrint"], 
          "$Post" :> Documentation`HelpLookup["paclet:ref/$Post"], 
          "CellEvaluationFunction" :> 
          Documentation`HelpLookup["paclet:ref/CellEvaluationFunction"], 
          "CellProlog" :> 
          Documentation`HelpLookup["paclet:ref/CellProlog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$PreRead\"\>", 
       2->"\<\"$PrePrint\"\>", 3->"\<\"$Post\"\>", 
       4->"\<\"CellEvaluationFunction\"\>", 
       5->"\<\"CellProlog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Session Customization" :> 
          Documentation`HelpLookup["paclet:guide/SessionCustomization"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Session Customization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$Pre", "ObjectName",
 CellID->24194],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$Pre",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
     "\[LineSeparator]is a global variable whose value, if set, is applied to \
every input expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6492]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Unless ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " is assigned to be a function which holds its arguments unevaluated, input \
expressions will be evaluated before ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " is applied, so the effect of ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " will be the same as ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3308],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " is applied to expressions, while ",
 Cell[BoxData[
  ButtonBox["$PreRead",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PreRead"]], "InlineFormula"],
 " is applied to strings which have not yet been parsed into expressions. "
}], "Notes",
 CellID->19859]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269462274],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->570186697],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " is not defined, meaning the input is evaluated directly:"
}], "ExampleText",
 CellID->289932834],

Cell[CellGroupData[{

Cell[BoxData["$Pre"], "Input",
 CellLabel->"In[1]:=",
 CellID->614411681],

Cell[BoxData["$Pre"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77316970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->894922765],

Cell["Save input expressions in held form:", "ExampleText",
 CellID->60490623],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"saveinputs", ",", " ", "HoldAll"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"inputs", " ", "=", 
   RowBox[{"{", "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"saveinputs", "[", "new_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"inputs", "=", 
      RowBox[{"{", 
       RowBox[{"inputs", ",", 
        RowBox[{"HoldForm", "[", "new", "]"}]}], "}"}]}], ";", "new"}], 
    ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Pre", "=", "saveinputs"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->26618688],

Cell["Evaluation works as expected:", "ExampleText",
 CellID->106774180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "Pi", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->669245331],

Cell[BoxData["3.141592653589793`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->405000206]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "5"}], "-", "x", "+", "1"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3524577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "2"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "3"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "4"}], "]"}]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"1", "-", "#1", "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "5"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{561, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->329163359]
}, Open  ]],

Cell[TextData[{
 "Restore ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " to its default:"
}], "ExampleText",
 CellID->174671228],

Cell[BoxData[
 RowBox[{"$Pre", "=."}]], "Input",
 CellLabel->"In[4]:=",
 CellID->492272088],

Cell[TextData[{
 "The variable ",
 Cell[BoxData[
  StyleBox["inputs", "TI"]], "InlineFormula"],
 " holds the inputs in unevaluated form:"
}], "ExampleText",
 CellID->386119776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Flatten", "[", "inputs", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->744531548],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"N", "[", "\[Pi]", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "5"], "-", "x", "+", "1"}], "\[Equal]", "0"}], 
      ",", "x"}], "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{"$Pre", "=."}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{258, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->402115600]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8370],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PreRead",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PreRead"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PrePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PrePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Post",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Post"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellEvaluationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellEvaluationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CellProlog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CellProlog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25229],

Cell[TextData[ButtonBox["The Main Loop",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheMainLoop"]], "Tutorials",
 CellID->25599],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/MathematicaSessions"]
}], "Tutorials",
 CellID->522604605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->215569588],

Cell[TextData[ButtonBox["Session Customization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SessionCustomization"]], "MoreAbout",
 CellID->47787027]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$Pre - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 31, 51.7309936}", "context" -> "System`", 
    "keywords" -> {"preprocessing", "preprocessor", "pre evaluator"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$Pre is a global variable whose value, if set, is applied to every input \
expression. ", "synonyms" -> {}, "title" -> "$Pre", "type" -> "Symbol", "uri" -> 
    "ref/$Pre"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5077, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->269462274]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14041, 513}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2322, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2945, 82, 42, 1, 70, "ObjectName",
 CellID->24194],
Cell[2990, 85, 456, 14, 70, "Usage",
 CellID->6492]
}, Open  ]],
Cell[CellGroupData[{
Cell[3483, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3961, 121, 687, 24, 70, "Notes",
 CellID->3308],
Cell[4651, 147, 389, 12, 70, "Notes",
 CellID->19859]
}, Closed]],
Cell[CellGroupData[{
Cell[5077, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->269462274],
Cell[CellGroupData[{
Cell[5462, 178, 148, 5, 70, "ExampleSection",
 CellID->570186697],
Cell[5613, 185, 243, 8, 70, "ExampleText",
 CellID->289932834],
Cell[CellGroupData[{
Cell[5881, 197, 73, 2, 28, "Input",
 CellID->614411681],
Cell[5957, 201, 160, 5, 36, "Output",
 CellID->77316970]
}, Open  ]],
Cell[6132, 209, 125, 3, 70, "ExampleDelimiter",
 CellID->894922765],
Cell[6260, 214, 78, 1, 70, "ExampleText",
 CellID->60490623],
Cell[6341, 217, 652, 21, 70, "Input",
 CellID->26618688],
Cell[6996, 240, 72, 1, 70, "ExampleText",
 CellID->106774180],
Cell[CellGroupData[{
Cell[7093, 245, 98, 3, 70, "Input",
 CellID->669245331],
Cell[7194, 250, 175, 5, 36, "Output",
 CellID->405000206]
}, Open  ]],
Cell[CellGroupData[{
Cell[7406, 260, 218, 8, 70, "Input",
 CellID->3524577],
Cell[7627, 270, 1308, 47, 58, "Output",
 CellID->329163359]
}, Open  ]],
Cell[8950, 320, 198, 8, 70, "ExampleText",
 CellID->174671228],
Cell[9151, 330, 91, 3, 70, "Input",
 CellID->492272088],
Cell[9245, 335, 176, 6, 70, "ExampleText",
 CellID->386119776],
Cell[CellGroupData[{
Cell[9446, 345, 108, 3, 70, "Input",
 CellID->744531548],
Cell[9557, 350, 519, 21, 39, "Output",
 CellID->402115600]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10137, 378, 310, 9, 70, "SeeAlsoSection",
 CellID->8370],
Cell[10450, 389, 1214, 44, 70, "SeeAlso",
 CellID->31426]
}, Open  ]],
Cell[CellGroupData[{
Cell[11701, 438, 314, 9, 70, "TutorialsSection",
 CellID->25229],
Cell[12018, 449, 135, 3, 70, "Tutorials",
 CellID->25599],
Cell[12156, 454, 284, 9, 70, "Tutorials",
 CellID->522604605]
}, Open  ]],
Cell[CellGroupData[{
Cell[12477, 468, 319, 9, 70, "MoreAboutSection",
 CellID->215569588],
Cell[12799, 479, 152, 3, 70, "MoreAbout",
 CellID->47787027]
}, Open  ]],
Cell[12966, 485, 27, 0, 70, "History"],
Cell[12996, 487, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

