(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11999,        416]
NotebookOptionsPosition[      9304,        326]
NotebookOutlinePosition[     10593,        363]
CellTagsIndexPosition[     10508,        358]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$SystemID" :> Documentation`HelpLookup["paclet:ref/$SystemID"],
           "$Version" :> Documentation`HelpLookup["paclet:ref/$Version"], 
          "$MachineType" :> 
          Documentation`HelpLookup["paclet:ref/$MachineType"], 
          "$ProcessorType" :> 
          Documentation`HelpLookup["paclet:ref/$ProcessorType"], 
          "$OperatingSystem" :> 
          Documentation`HelpLookup["paclet:ref/$OperatingSystem"], 
          "$MachineName" :> 
          Documentation`HelpLookup["paclet:ref/$MachineName"], 
          "SystemInformation" :> 
          Documentation`HelpLookup["paclet:ref/SystemInformation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$SystemID\"\>", 
       2->"\<\"$Version\"\>", 3->"\<\"$MachineType\"\>", 
       4->"\<\"$ProcessorType\"\>", 5->"\<\"$OperatingSystem\"\>", 
       6->"\<\"$MachineName\"\>", 
       7->"\<\"SystemInformation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica System Setup\"\>", 
       2->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$System", "ObjectName",
 CellID->8140],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$System",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$System"]], "InlineFormula"],
     "\[LineSeparator]is a string describing the type of computer system on \
which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is being run. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21516]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$System",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$System"]], "InlineFormula"],
 " typically consists of words separated by spaces. "
}], "Notes",
 CellID->11151],

Cell[TextData[{
 "Typical values are ",
 Cell[BoxData["\"\<Microsoft Windows\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Mac OS X\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<Linux\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9841],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 " provides a more succinct version of the same information. "
}], "Notes",
 CellID->22266]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->356424499],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->578422],

Cell[CellGroupData[{

Cell[BoxData["$System"], "Input",
 CellLabel->"In[1]:=",
 CellID->1458152],

Cell[BoxData["\<\"Microsoft Windows (32-bit)\"\>"], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70300909]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20009],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SystemID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SystemID"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Version",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Version"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ProcessorType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ProcessorType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$OperatingSystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$OperatingSystem"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23681]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->12670],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->11908]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->83247967],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->143162336],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->325713516]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$System - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 8.1376636}", "context" -> "System`", 
    "keywords" -> {
     "machine type", "platform", "system type", "type of computer system"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$System is a string describing the type of computer system on which \
Mathematica is being run. ", "synonyms" -> {}, "title" -> "$System", "type" -> 
    "Symbol", "uri" -> "ref/$System"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5115, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->356424499]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10365, 351}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2665, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3288, 90, 44, 1, 70, "ObjectName",
 CellID->8140],
Cell[3335, 93, 524, 17, 70, "Usage",
 CellID->21516]
}, Open  ]],
Cell[CellGroupData[{
Cell[3896, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4374, 132, 215, 7, 70, "Notes",
 CellID->11151],
Cell[4592, 141, 255, 9, 70, "Notes",
 CellID->9841],
Cell[4850, 152, 228, 7, 70, "Notes",
 CellID->22266]
}, Closed]],
Cell[CellGroupData[{
Cell[5115, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->356424499],
Cell[CellGroupData[{
Cell[5500, 178, 145, 5, 70, "ExampleSection",
 CellID->578422],
Cell[CellGroupData[{
Cell[5670, 187, 74, 2, 28, "Input",
 CellID->1458152],
Cell[5747, 191, 191, 5, 36, "Output",
 CellID->70300909]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5999, 203, 311, 9, 70, "SeeAlsoSection",
 CellID->20009],
Cell[6313, 214, 1740, 62, 70, "SeeAlso",
 CellID->23681]
}, Open  ]],
Cell[CellGroupData[{
Cell[8090, 281, 314, 9, 70, "TutorialsSection",
 CellID->12670],
Cell[8407, 292, 159, 3, 70, "Tutorials",
 CellID->11908]
}, Open  ]],
Cell[CellGroupData[{
Cell[8603, 300, 318, 9, 70, "MoreAboutSection",
 CellID->83247967],
Cell[8924, 311, 158, 3, 70, "MoreAbout",
 CellID->143162336],
Cell[9085, 316, 147, 3, 70, "MoreAbout",
 CellID->325713516]
}, Open  ]],
Cell[9247, 322, 27, 0, 70, "History"],
Cell[9277, 324, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

