(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13867,        474]
NotebookOptionsPosition[     10778,        373]
NotebookOutlinePosition[     12159,        411]
CellTagsIndexPosition[     12074,        406]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"], 
          "Portability of MathLink Programs" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PortabilityOfMathLinkPrograms"], 
          "Global System Information" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GlobalSystemInformation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Reading and Writing Mathematica Files\"\>", 
       2->"\<\"Portability of MathLink Programs\"\>", 
       3->"\<\"Global System Information\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$System" :> Documentation`HelpLookup["paclet:ref/$System"], 
          "$Version" :> Documentation`HelpLookup["paclet:ref/$Version"], 
          "$MachineType" :> 
          Documentation`HelpLookup["paclet:ref/$MachineType"], 
          "$OperatingSystem" :> 
          Documentation`HelpLookup["paclet:ref/$OperatingSystem"], 
          "$MachineID" :> 
          Documentation`HelpLookup["paclet:ref/$MachineID"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$System\"\>", 2->"\<\"$Version\"\>",
        3->"\<\"$MachineType\"\>", 4->"\<\"$OperatingSystem\"\>", 
       5->"\<\"$MachineID\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Package Bulletproofing" :> 
          Documentation`HelpLookup["paclet:guide/PackageBulletproofing"], 
          "Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Package Bulletproofing\"\>", 
       2->"\<\"Package Development\"\>", 
       3->"\<\"System Information\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$SystemID", "ObjectName",
 CellID->8456],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["$SystemID",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
     "\[LineSeparator]is a short string that identifies the type of computer \
system on which ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " is being run. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17245]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Computer systems with the same ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 " should be binary compatible, so that the same external programs and ",
 Cell[BoxData[
  RowBox[{".", "mx"}]], "InlineFormula"],
 " files can be used. "
}], "Notes",
 CellID->32015],

Cell["\<\
Sometimes binary compatibility may only be complete when the same version of \
the operating system is used. \
\>", "Notes",
 CellID->27157],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 " is used in naming directories generated by ",
 Cell[BoxData[
  ButtonBox["DumpSave",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DumpSave"]], "InlineFormula"],
 " and ",
 Cell[BoxData["mcc"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8224],

Cell[TextData[{
 "Values for ",
 Cell[BoxData[
  ButtonBox["$SystemID",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SystemID"]], "InlineFormula"],
 " contain only alphanumeric characters and dashes. "
}], "Notes",
 CellID->25691],

Cell[TextData[{
 "Typical values are ",
 Cell[BoxData["\"\<Windows\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Darwin\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Linux\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<UltraSPARC\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->2949]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->427995296],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->627321799],

Cell[CellGroupData[{

Cell[BoxData["$SystemID"], "Input",
 CellLabel->"In[1]:=",
 CellID->29074972],

Cell[BoxData["\<\"Windows\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534125422]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20875],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$System",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$System"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Version",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Version"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineType",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineType"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$OperatingSystem",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$OperatingSystem"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$MachineID",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$MachineID"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23058]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1450],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->14771],

Cell[TextData[{
 ButtonBox["Portability of ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
 StyleBox[ButtonBox["MathLink",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"],
  FontSlant->"Italic"],
 ButtonBox[" Programs",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/PortabilityOfMathLinkPrograms"]
}], "Tutorials",
 CellID->85486369],

Cell[TextData[ButtonBox["Global System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GlobalSystemInformation"]], "Tutorials",
 CellID->28732]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->427741356],

Cell[TextData[ButtonBox["Package Bulletproofing",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageBulletproofing"]], "MoreAbout",
 CellID->21465568],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->210984643],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->286207314]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$SystemID - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 32, 7.9032826}", "context" -> "System`", 
    "keywords" -> {
     "compatibility", "system number", "system type", "system platform", 
      "computer platform", "computer type", "code-compatible"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "$SystemID is a short string that identifies the type of computer system \
on which Mathematica is being run. ", "synonyms" -> {"system ID"}, "title" -> 
    "$SystemID", "type" -> "Symbol", "uri" -> "ref/$SystemID"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6132, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->427995296]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11931, 399}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2923, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3546, 93, 46, 1, 70, "ObjectName",
 CellID->8456],
Cell[3595, 96, 539, 17, 70, "Usage",
 CellID->17245]
}, Open  ]],
Cell[CellGroupData[{
Cell[4171, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4649, 135, 356, 11, 70, "Notes",
 CellID->32015],
Cell[5008, 148, 150, 4, 70, "Notes",
 CellID->27157],
Cell[5161, 154, 388, 14, 70, "Notes",
 CellID->8224],
Cell[5552, 170, 235, 8, 70, "Notes",
 CellID->25691],
Cell[5790, 180, 305, 11, 70, "Notes",
 CellID->2949]
}, Closed]],
Cell[CellGroupData[{
Cell[6132, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->427995296],
Cell[CellGroupData[{
Cell[6517, 210, 148, 5, 70, "ExampleSection",
 CellID->627321799],
Cell[CellGroupData[{
Cell[6690, 219, 77, 2, 28, "Input",
 CellID->29074972],
Cell[6770, 223, 172, 5, 36, "Output",
 CellID->534125422]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7003, 235, 311, 9, 70, "SeeAlsoSection",
 CellID->20875],
Cell[7317, 246, 1212, 44, 70, "SeeAlso",
 CellID->23058]
}, Open  ]],
Cell[CellGroupData[{
Cell[8566, 295, 313, 9, 70, "TutorialsSection",
 CellID->1450],
Cell[8882, 306, 429, 12, 70, "Tutorials",
 CellID->14771],
Cell[9314, 320, 415, 12, 70, "Tutorials",
 CellID->85486369],
Cell[9732, 334, 159, 3, 70, "Tutorials",
 CellID->28732]
}, Open  ]],
Cell[CellGroupData[{
Cell[9928, 342, 319, 9, 70, "MoreAboutSection",
 CellID->427741356],
Cell[10250, 353, 154, 3, 70, "MoreAbout",
 CellID->21465568],
Cell[10407, 358, 149, 3, 70, "MoreAbout",
 CellID->210984643],
Cell[10559, 363, 147, 3, 70, "MoreAbout",
 CellID->286207314]
}, Open  ]],
Cell[10721, 369, 27, 0, 70, "History"],
Cell[10751, 371, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

