(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     18598,        675]
NotebookOptionsPosition[     14574,        536]
NotebookOutlinePosition[     15838,        574]
CellTagsIndexPosition[     15753,        569]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupts and Aborts" :> 
          Documentation`HelpLookup["paclet:tutorial/InterruptsAndAborts"], 
          "Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/Evaluation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interrupts and Aborts\"\>", 
       2->"\<\"Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interrupt" :> Documentation`HelpLookup["paclet:ref/Interrupt"],
           "Throw" :> Documentation`HelpLookup["paclet:ref/Throw"], 
          "TimeConstrained" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstrained"], 
          "MemoryConstrained" :> 
          Documentation`HelpLookup["paclet:ref/MemoryConstrained"], "Return" :> 
          Documentation`HelpLookup["paclet:ref/Return"], "$Aborted" :> 
          Documentation`HelpLookup["paclet:ref/$Aborted"], "AbortProtect" :> 
          Documentation`HelpLookup["paclet:ref/AbortProtect"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interrupt\"\>", 2->"\<\"Throw\"\>", 
       3->"\<\"TimeConstrained\"\>", 4->"\<\"MemoryConstrained\"\>", 
       5->"\<\"Return\"\>", 6->"\<\"$Aborted\"\>", 
       7->"\<\"AbortProtect\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Flow Control" :> 
          Documentation`HelpLookup["paclet:guide/FlowControl"], 
          "Looping Constructs" :> 
          Documentation`HelpLookup["paclet:guide/LoopingConstructs"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Flow Control\"\>", 
       2->"\<\"Looping Constructs\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abort", "ObjectName",
 CellID->15006],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Abort",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Abort"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an interrupt to abort a computation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31101]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can call ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 " anywhere within a computation. It has the same effect as an interactive \
interrupt in which you select the abort option. "
}], "Notes",
 CellID->24393],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 " as an \"emergency stop\" in a computation. "
}], "Notes",
 CellID->3548],

Cell[TextData[{
 "Once ",
 Cell[BoxData[
  ButtonBox["Abort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abort"]], "InlineFormula"],
 " has been called, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " functions currently being evaluated return as quickly as possible. "
}], "Notes",
 CellID->19629],

Cell[TextData[{
 "In an interactive session, the final result from an aborted computation is \
",
 Cell[BoxData[
  ButtonBox["$Aborted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Aborted"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12623],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["CheckAbort",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckAbort"]], "InlineFormula"],
 " to \"catch\" returns from an abort. "
}], "Notes",
 CellID->24084]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120121366],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->111549608],

Cell["Abort execution of a sequence of commands:", "ExampleText",
 CellID->53335987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Print", "[", "a", "]"}], ";", 
  RowBox[{"Abort", "[", "]"}], ";", 
  RowBox[{"Print", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11607562],

Cell[BoxData["a"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->330919063],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16223608]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165939902],

Cell["\<\
A function for doing fixed-point iteration that aborts if the value gets \
above a certain limit:\
\>", "ExampleText",
 CellID->2998790],

Cell[BoxData[
 RowBox[{
  RowBox[{"fpit", "[", 
   RowBox[{"f_", ",", "start_", ",", " ", "limit_"}], "]"}], ":=", 
  RowBox[{"FixedPoint", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", "x", "]"}], ">", "limit"}], ",", " ", 
        RowBox[{"Abort", "[", "]"}], ",", 
        RowBox[{"f", "[", "x", "]"}]}], "]"}]}], "]"}], ",", "start", ",", 
    RowBox[{"10", "^", "6"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256543948],

Cell["An unstable iteration:", "ExampleText",
 CellID->400829707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fpit", "[", 
  RowBox[{"Exp", ",", "1.", ",", "100"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73513454],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->368830045]
}, Open  ]],

Cell[TextData[{
 "A stable iteration to approximate ",
 Cell[BoxData[
  ButtonBox["GoldenRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GoldenRatio"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->699287497],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fpit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"1", "/", "#"}]}], "&"}], ",", "1.", ",", "100"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->474333564],

Cell[BoxData["1.618033988749895`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->292083721]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->692877331],

Cell["\<\
Abort the numerical solution of a differential equation if the solution would \
become complex:\
\>", "ExampleText",
 CellID->535549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ">", "1"}], ",", 
        RowBox[{"Abort", "[", "]"}], ",", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "-", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"x", "[", "t", "]"}]}], "]"}]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", ".6"}]}], "}"}], ",", "x", 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131043056],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"x", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"0.`", ",", "1.`"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], 
      "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{309, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->334761179]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NDSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ">", "1"}], ",", 
        RowBox[{"Abort", "[", "]"}], ",", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], "-", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", " ", "-", " ", 
           RowBox[{"x", "[", "t", "]"}]}], "]"}]}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", ".7"}]}], "}"}], ",", "x", 
   ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146483640],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10375737]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7376],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interrupt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interrupt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Throw",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Throw"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MemoryConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MemoryConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Aborted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Aborted"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbortProtect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbortProtect"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13931]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19954],

Cell[TextData[ButtonBox["Interrupts and Aborts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/InterruptsAndAborts"]], "Tutorials",
 CellID->18756],

Cell[TextData[ButtonBox["Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Evaluation"]], "Tutorials",
 CellID->959752411]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->241313883],

Cell[TextData[ButtonBox["Flow Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FlowControl"]], "MoreAbout",
 CellID->265992107],

Cell[TextData[ButtonBox["Looping Constructs",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LoopingConstructs"]], "MoreAbout",
 CellID->3618548]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abort - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 15.3443668}", "context" -> "System`", 
    "keywords" -> {
     "stopping calculations", "terminating computations", 
      "aborting a computation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Abort[] generates an interrupt to abort a computation. ", 
    "synonyms" -> {}, "title" -> "Abort", "type" -> "Symbol", "uri" -> 
    "ref/Abort"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5635, 184, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->120121366]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15610, 562}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2638, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3261, 87, 43, 1, 70, "ObjectName",
 CellID->15006],
Cell[3307, 90, 454, 14, 70, "Usage",
 CellID->31101]
}, Open  ]],
Cell[CellGroupData[{
Cell[3798, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4276, 126, 302, 9, 70, "Notes",
 CellID->24393],
Cell[4581, 137, 221, 8, 70, "Notes",
 CellID->3548],
Cell[4805, 147, 311, 11, 70, "Notes",
 CellID->19629],
Cell[5119, 160, 251, 9, 70, "Notes",
 CellID->12623],
Cell[5373, 171, 225, 8, 70, "Notes",
 CellID->24084]
}, Closed]],
Cell[CellGroupData[{
Cell[5635, 184, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->120121366],
Cell[CellGroupData[{
Cell[6020, 198, 148, 5, 70, "ExampleSection",
 CellID->111549608],
Cell[6171, 205, 84, 1, 70, "ExampleText",
 CellID->53335987],
Cell[CellGroupData[{
Cell[6280, 210, 192, 6, 70, "Input",
 CellID->11607562],
Cell[6475, 218, 91, 2, 23, "Print",
 CellID->330919063],
Cell[6569, 222, 164, 5, 36, "Output",
 CellID->16223608]
}, Open  ]],
Cell[6748, 230, 125, 3, 70, "ExampleDelimiter",
 CellID->165939902],
Cell[6876, 235, 146, 4, 70, "ExampleText",
 CellID->2998790],
Cell[7025, 241, 578, 17, 70, "Input",
 CellID->256543948],
Cell[7606, 260, 65, 1, 70, "ExampleText",
 CellID->400829707],
Cell[CellGroupData[{
Cell[7696, 265, 137, 4, 70, "Input",
 CellID->73513454],
Cell[7836, 271, 165, 5, 36, "Output",
 CellID->368830045]
}, Open  ]],
Cell[8016, 279, 223, 8, 70, "ExampleText",
 CellID->699287497],
Cell[CellGroupData[{
Cell[8264, 291, 209, 8, 70, "Input",
 CellID->474333564],
Cell[8476, 301, 175, 5, 36, "Output",
 CellID->292083721]
}, Open  ]],
Cell[8666, 309, 125, 3, 70, "ExampleDelimiter",
 CellID->692877331],
Cell[8794, 314, 143, 4, 70, "ExampleText",
 CellID->535549],
Cell[CellGroupData[{
Cell[8962, 322, 750, 24, 70, "Input",
 CellID->131043056],
Cell[9715, 348, 466, 17, 36, "Output",
 CellID->334761179]
}, Open  ]],
Cell[CellGroupData[{
Cell[10218, 370, 750, 24, 70, "Input",
 CellID->146483640],
Cell[10971, 396, 164, 5, 36, "Output",
 CellID->10375737]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11196, 408, 310, 9, 70, "SeeAlsoSection",
 CellID->7376],
Cell[11509, 419, 1708, 62, 70, "SeeAlso",
 CellID->13931]
}, Open  ]],
Cell[CellGroupData[{
Cell[13254, 486, 314, 9, 70, "TutorialsSection",
 CellID->19954],
Cell[13571, 497, 151, 3, 70, "Tutorials",
 CellID->18756],
Cell[13725, 502, 135, 3, 70, "Tutorials",
 CellID->959752411]
}, Open  ]],
Cell[CellGroupData[{
Cell[13897, 510, 319, 9, 70, "MoreAboutSection",
 CellID->241313883],
Cell[14219, 521, 135, 3, 70, "MoreAbout",
 CellID->265992107],
Cell[14357, 526, 145, 3, 70, "MoreAbout",
 CellID->3618548]
}, Open  ]],
Cell[14517, 532, 27, 0, 70, "History"],
Cell[14547, 534, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

