(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    123720,       3350]
NotebookOptionsPosition[    111388,       2939]
NotebookOutlinePosition[    112661,       2976]
CellTagsIndexPosition[    112574,       2971]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], "Complex Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/ComplexNumbers"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/NumericalFunctions"], 
          "Piecewise Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/PiecewiseFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Some Mathematical Functions\"\>", 2->"\<\"Complex Numbers\"\>",
        3->"\<\"Numerical Functions\"\>", 
       4->"\<\"Piecewise Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Re" :> Documentation`HelpLookup["paclet:ref/Re"], "Im" :> 
          Documentation`HelpLookup["paclet:ref/Im"], "Arg" :> 
          Documentation`HelpLookup["paclet:ref/Arg"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "ComplexExpand" :> 
          Documentation`HelpLookup["paclet:ref/ComplexExpand"], "Norm" :> 
          Documentation`HelpLookup["paclet:ref/Norm"], "Sign" :> 
          Documentation`HelpLookup["paclet:ref/Sign"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Re\"\>", 2->"\<\"Im\"\>", 
       3->"\<\"Arg\"\>", 4->"\<\"Mod\"\>", 5->"\<\"ComplexExpand\"\>", 
       6->"\<\"Norm\"\>", 7->"\<\"Sign\"\>", 
       8->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Complex Numbers" :> 
          Documentation`HelpLookup["paclet:guide/ComplexNumbers"], 
          "Functions of Complex Variables" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsOfComplexVariables"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Numerical Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumericalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Complex Numbers\"\>", 
       2->"\<\"Functions of Complex Variables\"\>", 
       3->"\<\"Mathematical Functions\"\>", 
       4->"\<\"Numerical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Abs", "ObjectName",
 CellID->19589],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Abs",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Abs"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the absolute value of the real or complex number \
",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20798]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For complex numbers ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " gives the modulus ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[LeftBracketingBar]", "z", "\[RightBracketingBar]"}], 
   TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->27157],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is left unevaluated if ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " is not a numeric quantity. "
}], "Notes",
 CellID->20472],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->344926268],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->541540507],

Cell["Real numbers:", "ExampleText",
 CellID->15327091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"-", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52071251]
}, Open  ]],

Cell["Complex numbers:", "ExampleText",
 CellID->40481842],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"1.4", "+", 
   RowBox[{"2.3", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["2.692582403567252`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->605764243]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "2"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1", ",", "0", ",", "1", ",", "2"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99692378]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->697957349],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53952246],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtxX1M1HUcB/DjOPhpoeihstwUzwkkKop/mA/J55tO2XQg4skhihx6KPJw
F6HWIAbVJmAjfACLNXGBECiIemMWc3y+PkYK5ePwoUBUupgi3CFyB8ZV2/uP
1166HZaYZLVKpYr6z/+fM7QOu92KxOJg7oSjM8YUicWOqpjQFW8ViYW2/w/T
fqcisdh7wH775YAisVjaNL3+YbcisWBthtF6RZFYtLdP/nVXgSKxuGW5eqFW
o0gsfP6u+7H0oLfEIrl2bmWP1ltiUVOqbZ582EtiEWAIvWvz95JY5K+xji8v
1UgsxnLurGv000gsmgrnFFu+95RYbLrU9fKd9zwlFiG32iOjT6glFjODY38e
CVZLLFx1EavyazwkFhM809saF3hILMYVurKaT6kkFrrNuqCQEJXE4vnA8PkC
k5sx6Uvy9JnGMca05FG680zGP4zpr8/nd1TuesuYbjfOumk0jTKmBSXZlz7J
GmFMcddrHMvNLsb0um5pkCHbyZhuznCbV349zJgye791PCx4w5gKk459dqNs
iDFlhO1ellnymjEVH073fVo8yJgCKjpsNccdjClPPXVUV25nTNF+P02yVw8w
puaUgE+nWPoZU2Z81irrnj7G9G71Ee3IgReM6aMTsXENOb2MKd7RUznuqI0x
9SZ3+jutPYxpalGOWl//jDHN8XpuN/zSzZgqkp42HMrqYkxPXL+1lac9Zky2
1TFDjtoOxvR+38zxgWV3GVPCIU1kVPHvjGl1qyWsalorY1qW+/jBplFmTB5h
i/f90HmWMTWlfXe6UZ/ImDr9ugYTOrYzJu+LgR/6xG9nTLE+1raUxATG9Ka+
vU+XupUxLXmlXlSaZ2BM5u5HKXb9BsbUEpbiioyPYkwTvxwqOpUYyZjOzJ50
emfqesbUv3NN3/28CMb0pC3x2d7NxJjyM7I1ocaVjGnWxLJAW+oKxpS04cbu
LfkfMKZrVXse5MQuZEzePRXTX6XNY0xrg+5tM34RzJi+2Zh7uSgugDH53rOt
NX/lz5h0DSePVW/zZUwRpsHwP03uFhzuXG8+Hm35uAWH/wskVHOe
     "]], LineBox[CompressedData["
1:eJxNxWlIk3EcAOB5zMnA0pijPMJyezMtFDLSIA8Exyqnlm7OmThtyy2bY0Rq
msl0JvRu5YaQDLURpiJdSkpJygSPsFahJJJHWhablvPIY7qt+uDv/X94eA7l
Fl4QuZJIJM4//988J2tIKZTH7F59+UjIB4wTu/v739+laiwbtnYm4AWYDFbS
VwOysHJ4ZOjs/EVMAxc+vPE2GWuEjTjek4Q9hckeCopZ2gezbwtVL7lDcHeJ
aKr5kwmeyLwarigahX1YarExbhz2HhN1nBJ8gYODCtpUuTNw1NS1kXjtLGy0
VZwf03+D8/uGh3uV83B9Xoufb85P+HjG7LpDZIanV5NNcewFeGXmQAQ9/Rd8
v/3mFR5vCcb2eiYV661wl7yiXdO0DI8xdZRU7QrMqBwNuVS/CkenzEQ26dfg
KbkqRo3/gTui+V4DteswnTs00aragGPnSLX91zfhenq+F1a8BSsbJXdOSm1w
g+nBoEa+Dd+S6ayBih14QRiyn59rh+/aLe7TYgf8epG1tCfTCX9mRs2dZpDi
ds8/mheuayY2cgWl8Qdd4BMZljaagbigMnH8jL8rXCP2tLnoiN8ECp0Wmhv8
ylHtFqohNnUmWNQ+7vBAkHgQ1xJXdacbZqlkOOvwZLZATbzdFe4fRvGAy9zM
7+rKiemMaCGTRIGLZNw1agnxMk6V+u4QB1TF05jIrNLi3kjkBsmPfWnI7MT+
Hi2ywVni5W0nTlWYn1MdxGWSIIEfcksOjxyKbOcM8NnIbWEG1xpkl/mMNLKT
+NjkPQcNmTc62MpAfmKMtCcg8xu9HyuRq+pYKVrkZ3i5zYBMLl3kGJEjFMFb
H5EFksxHX5Grc2qTrMgveMMbTuS/4xQ7Yg==
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{-3, 3}, {0., 2.99999993877551}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2373552]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " works with symbolic representations of numbers:"
}], "ExampleText",
 CellID->350406651],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"E", "-", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541573647],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ExponentialE]"}], "+", "\[Pi]"}]], "Output",
 ImageSize->{40, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->736138050]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"E", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 SqrtBox[
  RowBox[{"1", "+", 
   SuperscriptBox["\[ExponentialE]", "2"]}]]], "Output",
 ImageSize->{55, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99464079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["\<\
Express absolute values of algebraic numbers as explicit algebraic numbers:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"5", " ", 
      RowBox[{"#", "^", "6"}]}], "+", 
     RowBox[{"3", 
      RowBox[{"#", "^", "2"}]}], "-", "5"}], "&"}], ",", "4"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "5"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"5", " ", 
      SuperscriptBox["#1", "6"]}]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{174, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59290695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "5"}], "+", 
      RowBox[{"3", " ", 
       SuperscriptBox["#1", "2"]}], "+", 
      RowBox[{"5", " ", 
       SuperscriptBox["#1", "6"]}]}], "&"}], ",", "4"}], "]"}], 
  "]"}]], "Output",
 ImageSize->{209, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21419951]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"N", "[", "%", "]"}], ",", " ", 
   RowBox[{"Abs", "[", 
    RowBox[{"N", "[", "%%", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.0563280189810964`", ",", "1.0563280189810964`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->106525532]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Abs", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 FormBox[
  RowBox[{"\[LeftBracketingBar]", "x", "\[RightBracketingBar]"}], 
  TraditionalForm]], "Output",
 ImageSize->{15, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->72490472]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", " ", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", "2"}], "}"}], "]"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125655227]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Infinite arguments give symbolic results:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"{", 
   RowBox[{"Infinity", ",", 
    RowBox[{"-", "Infinity"}], ",", "ComplexInfinity"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", "\[Infinity]", ",", "\[Infinity]"}], 
  "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187617528]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " threads element-wise over sparse arrays: "
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "1"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
      RowBox[{"I", " ", "Pi"}]}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", "2"}], ",", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"4", ",", "2"}], "}"}], "\[Rule]", "u"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70247046]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "0", "\[Pi]"},
     {"0", "0", "0"},
     {"0", "0", "2"},
     {"0", 
      RowBox[{"Abs", "[", "u", "]"}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{97, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->221817944]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", 
     RowBox[{"I", " ", "y"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->135963843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Color plots according to ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"Abs", "[", "#2", "]"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364650397]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"ColorFunction", "->", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{"Sin", "[", 
         RowBox[{"#1", "+", 
          RowBox[{"I", " ", "#2"}]}], "]"}], "]"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->829263214]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Abs", "[", "x", "]"}]}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"2", "x"}], "+", "2"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", " ", 
    RowBox[{"Abs", "[", "x", "]"}]}], ",", 
   RowBox[{"Abs", "[", 
    RowBox[{"2", "+", 
     RowBox[{"2", " ", "x"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139146207]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", " ", 
   RowBox[{"x", " ", ">", " ", "3"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["x", "2"], ",", 
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{93, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294663538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " is idempotent:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{"Abs", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Abs", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149489075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " as a target function in ",
 Cell[BoxData[
  ButtonBox["ComplexExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"ArcSin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"TargetFunctions", "->", 
    RowBox[{"{", "Abs", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "\[ImaginaryI]"}], " ", 
   RowBox[{"Log", "[", 
    RowBox[{
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "+", 
          RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}]], "+", 
     RowBox[{"\[ImaginaryI]", " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", 
        RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}]}], "]"}]}], "+", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Log", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "+", 
           RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}], "2"]}]], "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{"x", "+", 
         RowBox[{"\[ImaginaryI]", " ", "y"}]}], ")"}]}]}], "]"}], 
    "]"}]}]}]], "Output",
 ImageSize->{494, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->496681837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->290276463],

Cell[TextData[{
 "Solve an equation involving ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->63009025],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Abs", "[", 
      RowBox[{"x", "+", "3"}], "]"}], "+", 
     RowBox[{"Abs", "[", 
      RowBox[{"x", "-", "2"}], "]"}]}], "\[Equal]", "17"}], ",", "x", ",", 
   "Reals"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->182863228],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", "9"}]}], "||", 
  RowBox[{"x", "\[Equal]", "8"}]}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40207145]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Prove an inequality containing",
 " ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"z1", "+", "z2", "+", "z3"}], "]"}], "\[LessEqual]", 
    RowBox[{
     RowBox[{"Abs", "[", "z1", "]"}], "+", 
     RowBox[{"Abs", "[", "z2", "]"}], "+", 
     RowBox[{"Abs", "[", "z3", "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z1", ",", "z2", ",", "z3"}], "}"}], ",", "Reals"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->611033226]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Definite integration:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"4", "+", 
    SuperscriptBox["\[Pi]", "2"]}], ")"}]}]], "Output",
 ImageSize->{66, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1047429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 RowBox[{"\[Pi]", "-", 
  RowBox[{"2", " ", 
   RowBox[{"Cos", "[", "2", "]"}]}], "+", 
  RowBox[{"Sin", "[", "2", "]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274140379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447512168],

Cell["\<\
Integrate along a line in the complex plane, symbolically and numerically:\
\>", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "I"}], ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox["5"]}], "+", 
    RowBox[{"\[Pi]", " ", 
     SqrtBox[
      RowBox[{"1", "+", 
       SuperscriptBox["\[Pi]", "2"]}]]}], "+", 
    RowBox[{"ArcSinh", "[", "2", "]"}], "+", 
    RowBox[{"ArcSinh", "[", "\[Pi]", "]"}]}], ")"}]}]], "Output",
 ImageSize->{308, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83466908]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["9.067805049048488`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40254590]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "+", "I"}], ",", 
     RowBox[{"Pi", "+", "I"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:="],

Cell[BoxData[
 RowBox[{"9.06780504904716`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->232242652]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Interpret as the indefinite integral for real arguments:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Output",
 ImageSize->{77, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360367941]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[Element]", "Reals"}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Abs", "[", "x", "]"}], ",", "x"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylVktuwjAQHfJpoC39QasKNqz6o62qfqQukVq1YtFDRKgSLKpGlAW7HIEl
R2DJEXoEjsExXH8miWs7IRBLie3x85s344zhwx/1P7/80aDnt96HftAf9H5a
b99DarJLANClz9Mp0DGhI/50CaH9IX3bbDGeAZsS3tBqs7czHo9/eVsulzsK
7jHB2WEYonU3F0rmgljJZlwva1gvMHJmd7G3AAcgmkWHDvY6w6WiyV4xtyIm
yeYYmT0+p7lGHR7X1el0cP04j2c3nmNA+XznisrI7a6VKZYNJ12n2bqS2UJm
DA7ESpR5C483Onedr8wTk/ABNDSLmse6kamC/pq0Z+d3kol6Tlfjyr4j1w9G
fFVRZkbtKaj7AijZI6Tqyscl6lRkdzqdzmYzNnyVrAlWtgZBMJlMEmuRW+GI
iK/jNnVVjsOMqimomwIo2SOk6srHZY74jPyvD5eISvZIVp2cE7UqthUNGbWt
sW2R5A7OuveqqDGqGm8NHxfSnogj71492vIGCvY1lpqS+0qBHB4gx9UGe9ok
66x13XdGXB1ZrlNX5djMKPWXrZ2gnPl8HvK2WCxUNoFrSFaIlTSNWPH/B0p/
17z+YA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{73, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->659908541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["Integral transforms:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{"FourierTransform", "[", 
   RowBox[{
    RowBox[{"Abs", "[", "y", "]"}], ",", "y", ",", "x"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SqrtBox[
    FractionBox["2", "\[Pi]"]], 
   SuperscriptBox["x", "2"]]}]], "Output",
 ImageSize->{46, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->838648657]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"LaplaceTransform", "[", 
   RowBox[{
    RowBox[{"Abs", "[", "y", "]"}], ",", "y", ",", "x"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData[
 FractionBox["1", 
  SuperscriptBox["x", "2"]]], "Output",
 ImageSize->{21, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->54377401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " from ",
 Cell[BoxData[
  ButtonBox["Limit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Limit"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Assuming", "[", 
  RowBox[{
   RowBox[{"x", "\[Element]", "Reals"}], ",", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{"1", " "}], "\[Pi]"], 
     RowBox[{"Limit", "[", 
      RowBox[{
       RowBox[{"ArcTan", "[", 
        FractionBox["x", "\[CurlyEpsilon]"], "]"}], ",", 
       RowBox[{"\[CurlyEpsilon]", "\[Rule]", 
        RowBox[{"+", "0"}]}]}], "]"}]}], "+", 
    FractionBox["1", "2"]}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], "+", 
  FractionBox[
   RowBox[{"Abs", "[", "x", "]"}], 
   RowBox[{"2", " ", "x"}]]}]], "Output",
 ImageSize->{74, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->468981055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Convert into ",
 Cell[BoxData[
  ButtonBox["Piecewise",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Piecewise"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", "x", "]"}], 
    RowBox[{"Abs", "[", 
     RowBox[{"1", "-", "x"}], "]"}]}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVttOwkAQXWiXUgTUB22JiRIvIcT/8PJgop/QEBN4MBrkD9QHvnqdbnfq
5nRCgWBCk+72nJkdzs7OTnjKFtPXt2wxm2TD+3n2MZ1NPod373OigoZSaknv
Waro29CXfZfG0HyUj0GO7aMuAb9Yr0NgrwE/W6+AxpxsgzWmQROMgA9paBJs
ujmssZ+4+IGLFzjefqjiyX1DmpNSkR8RlR0ARoXayvjDqmBWeiTggRoQ8w59
brCW+qbLA+ZNO77l8tMCO/PpOkp1iV2St9Nal+n/06r3rhrKWpdzW2G3U983
m92uU7AzXyy0D6zg+56K+mLAHcCYmfNK7rDSxuLvYNy2kSvmgoaI4K0Y5cuy
vLOfEvk+3ytYOR6yx4CvAD+Kq7BH3wB+EFdhz87ztIsu3DPFqbdcPA12v/to
PsVadV3Au7h7PSPdJqzLsLIOKwp7krwj3i/mj3uQpHedLt0XdxE5K1d77M31
WjfN/nYauTI6bmbN2Kn2rUJYZ1Tx97Mt7yAn65Rv2pm7okrUEMAqtMtVjF0f
zwa7dCJqGYmxcS3XKHbmgcvbyM+HKv6fqsYviiCQQA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{137, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52064765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell["De\[Hyphen]nest:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PiecewiseExpand", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"x", "+", 
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{"1", "-", "x"}], "]"}], "^", "3"}]}], "]"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVttOAjEQLeyFqxfuIDHBJ5UX9Sf0ydsnbIgJPBgN8ivqAx9bu90plNNZ
WBZJdmfPdDo9M51OeYwW07f3aDGbRKOHefQ5nU2+Rvcfc6XyCkKIpXou+kJ9
S/Wln6WUStrvlnoHaqgUIy+20T9RVq8YekoWlSySPCV9APo6zPdhvGX5Cyy/
+kMkv9jWJ5kMxOgYPCPTCmDt0F/jhLMIVhpaMHDsjsCTa9Hh1tqCTQYwM8Kx
DCkvPsMhILahlfcS6TF6k/c6jYeEu1mYOznKxv1kxw4FrG/DDHNqIsB9PzyS
YKO29okglFgJbm00iZ9rm6+uiqYa+F3htTsja1hY0Ap4TjcqGMZj6dHuoN70
B24+lY5IRuwZnlx3hv35D9hcYDfqA646O4CV3mbZmKjbJM+sbNh2WKM19SqZ
2nW8vgLuAb5kZ71AJrqArzOthUyv2FnfWmt27HeFbJufLVre3yFa0y+P5bpv
2lXFnWDu3moBHgA2/desx5+yMmBdDxluHJzHd8qUfrGhGTqaKpMBPJm7I7Hv
H+yQee6hc5IVS+7PCrtMmOItjVUP2JhoarnYNJhVtu+zWc+9K7LsbPmg3DWZ
Wf95A3QAI8t8dcifqHzdf5zKwLcqtUFxDmW2Hj+W1p0tnmEUe/qNtnqytFwP
v2N94cq32ir5Py8Kf3CkCno=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{155, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109759551]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20328],

Cell[TextData[{
 "Norms of general vectors contain ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->170225646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163496479],

Cell[BoxData[
 SqrtBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "y", "]"}], "2"], "+", 
   SuperscriptBox[
    RowBox[{"Abs", "[", "z", "]"}], "2"]}]]], "Output",
 ImageSize->{191, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->186189078]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17055592],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " can stay unevaluated for some complicated numeric arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\\(\\(-1\\)\\) - \\(\\(2\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \\((1 + \[ExponentialE])\\)\\^2\
\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->383275085],

Cell[BoxData[
 RowBox[{"Abs", "[", 
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"2", " ", "\[ExponentialE]"}], "-", 
   SuperscriptBox["\[ExponentialE]", "2"], "+", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "\[ExponentialE]"}], ")"}], "2"]}], "]"}]], "Output",
 ImageSize->{168, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167597253]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->463563726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "No series can be formed from ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " for complex arguments:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 RowBox[{"Abs", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218146153]
}, Open  ]],

Cell["For real arguments, a series can be found:", "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Abs", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"Element", "[", 
     RowBox[{"x", ",", "Reals"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFVktPwzAMztpmHY8NwRAaj0PHBbYDjwODO68TP6KakFYQKhr7/yFJky51
3DarKq1S69jx44sTO/2IV4vPn3iVzOPofRn/LpL5X/SWLrnI7xBCUv6OR4SP
GR/JN2WM02v+9Ti7p+hTLiW+0JKPnDX5mdTSNp6iIdCi/CNYQUmQy4FVAKzO
lZXPKVVU6MkByR5hGyiaTQR2HD7oAd8yFjWREASBZ/mhQOMC8H4Nr9drYbE0
QyOXVGOrRaxz1G2C0/K+GdKdRjluHzEtnAfTRsbY2rnIzzieZ1xqrYGyYtUM
yhE7V5qWj0rkauNJNmN6Euh0jdpYT52yCXsKnD+ysg3P5TEa/Yytu47Z2eBe
Dfkn5OwJ6uUR8Leo1oPBizXeo1ozwN+hWomU6gx/55yp81Uhxf1B6RRkBccy
rdmrG9Rqn1XfB13W5D44BPPCmirv5WewX4yB1LxE0ULN2+d0F2hUVD/aq8xb
T98DbmjLuuqQrXt1vjOOiAYM7/PtICrcIo6Itrm3vQYZhHVxUI5u497dB3pu
tzGOc+yUtbq+HdVEFEsUkVx69CUza/wVzF5J6bMhFZEmkr4AXflHS7J/XtL5
B8Hus+Q=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{111, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83356890]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection"],

Cell[TextData[{
 "Form nested functions involving ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 ":"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"SeedRandom", "[", "3", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NestList", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"r", ":=", 
         RowBox[{"RandomChoice", "[", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "2"}], "/", "3"}], ",", 
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}], ",", 
            RowBox[{
             RowBox[{"-", "1"}], "/", "3"}], ",", "0", ",", 
            RowBox[{"1", "/", "3"}], ",", 
            RowBox[{"1", "/", "2"}], ",", 
            RowBox[{"2", "/", "3"}]}], "}"}], "]"}]}], "}"}], ",", 
       RowBox[{"(", 
        RowBox[{"#", "/.", " ", 
         RowBox[{
          RowBox[{"Abs", "[", "x_", "]"}], ":>", 
          RowBox[{"Sum", "[", 
           RowBox[{
            RowBox[{"r", " ", 
             RowBox[{"Abs", "[", 
              RowBox[{"r", "+", 
               RowBox[{"r", " ", "x"}], " ", "+", 
               RowBox[{"r", " ", 
                RowBox[{"Abs", "[", 
                 RowBox[{"r", "+", 
                  RowBox[{"r", " ", "x"}]}], "]"}]}]}], "]"}]}], ",", 
            RowBox[{"{", "2", "}"}]}], "]"}]}]}], ")"}]}], "]"}], "&"}], ",", 
    
    RowBox[{"Abs", "[", "x", "]"}], ",", "3"}], "]"}], " ", "//", " ", 
  "TraditionalForm"}]}], "Input",
 CellLabel->"In[1]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{557, 307},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->125815893]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "%", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:="],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2144250]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter"],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Abs",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Abs"]], "InlineFormula"],
 " at Gaussian integers:"
}], "ExampleText"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"Round", "[", 
       RowBox[{"Abs", "[", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", "2"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "36"}], ",", "36"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "36"}], ",", "36"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:="],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy9ll1SwzAQg3e5CcfhlSNwAe7/BkNrr6SVE5thoCnkV3wrqWlePz7fP14i
4u35jsxa5vv7Vz4Owk/M/XBqLTEWlMohEvUztpNl4PImNbUIKSLwIMsE6kSb
bkEEb1SyUsYkYxFf+NArUDJJiMiiaTaMRrmhSY4o8VRQQp1mkiPy0a+lLohM
g0DHVaATtegRRdukrZxECBSklNmQegWKyEQPozUkbxJb1IAquNofQJRiETYI
K92QtAJKRJmRx0lIrQJKtCoirCTqmNjAIlAqkODNqqnGNi1KmxascHpoeLuB
cAHRI7FKKoC3NMh9AQS7QaoTERAkb8RqAaSnVAdSSRpy/A9AKosQqOayYljM
FItcWkFbvDKlmEjqY1eQDZEmkQJFpL6cWEIF4NPRrQ1WF7lKj4iiiTijzcwx
TRrRrzxxg5IJAwmAFtc0ZbUqyqK1SGR3RndMosXxSyBezcy2b38ymu5urjuh
Qto77/Z1SXIitPX6P6L8A4/GGb9PTYFOe2SRtpt9O9fmZ+1C5OzTv1QeSuf3
o7YXgDbvkN6cw3v2ypzjb5HFylQ6+l5TWQTa/qZtbKVkiPCwFetpzej3n0Zc
WhX99vNRMwdlTp7YZNwkmZNnSJPWSMcQzTR7eryJDTp8zmZzUOYhsv3kL+aQ
TAhRiFSzCtMaZmZYIjgu6WlaGr0QSQUEyRSxhQax9WL+/HV9NqFRbKbjDQii
z0ZUR6SYQaNp9NGICElasJLR0Dg2K9WKmLdEKVJtNI5+RQRm62jr6B1Ry40r
zdEPDSESk1gHZTD6MERwMHmc7DLURUtEuVExbfQCZE2Ca78AbxoMsA==
   "], {{0, 0}, {73, 73}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->528581517]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29657],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexExpand"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Norm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Norm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sign",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sign"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7958]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23622],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->18538],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ComplexNumbers"]], "Tutorials",
 CellID->12292],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NumericalFunctions"]], "Tutorials",
 CellID->6038],

Cell[TextData[ButtonBox["Piecewise Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PiecewiseFunctions"]], "Tutorials",
 CellID->869807265]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->24179],

Cell[TextData[{
 ButtonBox["Demonstrations with Abs",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Abs"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/AbsoluteValue.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ComplexComponents/Abs/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->259944588],

Cell[TextData[ButtonBox["Complex Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComplexNumbers"]], "MoreAbout",
 CellID->477877982],

Cell[TextData[ButtonBox["Functions of Complex Variables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsOfComplexVariables"]], "MoreAbout",
 CellID->572471874],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->330572821],

Cell[TextData[ButtonBox["Numerical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalFunctions"]], "MoreAbout",
 CellID->664015437]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Abs - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 16.1568876}", "context" -> "System`", 
    "keywords" -> {
     "absolute value", "complex number", "magnitude of complex number"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Abs[z] gives the absolute value of the real or complex number z. ", 
    "synonyms" -> {"magnitude", "modulus"}, "title" -> "Abs", "type" -> 
    "Symbol", "uri" -> "ref/Abs"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6167, 194, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->344926268]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 112431, 2964}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3287, 71, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3910, 98, 41, 1, 70, "ObjectName",
 CellID->19589],
Cell[3954, 101, 565, 19, 70, "Usage",
 CellID->20798]
}, Open  ]],
Cell[CellGroupData[{
Cell[4556, 125, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5034, 142, 120, 4, 70, "Notes",
 CellID->20640],
Cell[5157, 148, 454, 18, 70, "Notes",
 CellID->27157],
Cell[5614, 168, 322, 12, 70, "Notes",
 CellID->20472],
Cell[5939, 182, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6167, 194, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->344926268],
Cell[CellGroupData[{
Cell[6552, 208, 148, 5, 70, "ExampleSection",
 CellID->541540507],
Cell[6703, 215, 55, 1, 70, "ExampleText",
 CellID->15327091],
Cell[CellGroupData[{
Cell[6783, 220, 97, 3, 28, "Input"],
Cell[6883, 225, 157, 5, 36, "Output",
 CellID->52071251]
}, Open  ]],
Cell[7055, 233, 58, 1, 70, "ExampleText",
 CellID->40481842],
Cell[CellGroupData[{
Cell[7138, 238, 125, 4, 28, "Input"],
Cell[7266, 244, 175, 5, 36, "Output",
 CellID->605764243]
}, Open  ]],
Cell[7456, 252, 105, 2, 70, "ExampleDelimiter"],
Cell[7564, 256, 180, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[7769, 266, 198, 7, 70, "Input"],
Cell[7970, 275, 232, 7, 36, "Output",
 CellID->99692378]
}, Open  ]],
Cell[8217, 285, 125, 3, 70, "ExampleDelimiter",
 CellID->697957349],
Cell[CellGroupData[{
Cell[8367, 292, 256, 9, 70, "Input",
 CellID->53952246],
Cell[8626, 303, 2492, 50, 148, "Output",
 CellID->2373552]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11167, 359, 200, 6, 70, "ExampleSection"],
Cell[11370, 367, 215, 7, 70, "ExampleText",
 CellID->350406651],
Cell[CellGroupData[{
Cell[11610, 378, 123, 4, 70, "Input",
 CellID->541573647],
Cell[11736, 384, 216, 7, 36, "Output",
 CellID->736138050]
}, Open  ]],
Cell[CellGroupData[{
Cell[11989, 396, 102, 3, 70, "Input"],
Cell[12094, 401, 230, 8, 45, "Output",
 CellID->99464079]
}, Open  ]],
Cell[12339, 412, 105, 2, 70, "ExampleDelimiter"],
Cell[12447, 416, 106, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[12578, 422, 261, 10, 70, "Input"],
Cell[12842, 434, 396, 14, 39, "Output",
 CellID->59290695]
}, Open  ]],
Cell[CellGroupData[{
Cell[13275, 453, 79, 2, 70, "Input"],
Cell[13357, 457, 437, 16, 39, "Output",
 CellID->21419951]
}, Open  ]],
Cell[CellGroupData[{
Cell[13831, 478, 191, 6, 70, "Input"],
Cell[14025, 486, 243, 8, 36, "Output",
 CellID->106525532]
}, Open  ]],
Cell[14283, 497, 105, 2, 70, "ExampleDelimiter"],
Cell[14391, 501, 183, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[14599, 511, 117, 3, 70, "Input"],
Cell[14719, 516, 267, 8, 50, "Output",
 CellID->72490472]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15035, 530, 223, 6, 70, "ExampleSection"],
Cell[15261, 538, 192, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[15478, 548, 189, 6, 70, "Input"],
Cell[15670, 556, 240, 8, 36, "Output",
 CellID->125655227]
}, Open  ]],
Cell[15925, 567, 105, 2, 70, "ExampleDelimiter"],
Cell[16033, 571, 64, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16122, 575, 187, 6, 70, "Input"],
Cell[16312, 583, 246, 8, 36, "Output",
 CellID->187617528]
}, Open  ]],
Cell[16573, 594, 105, 2, 70, "ExampleDelimiter"],
Cell[16681, 598, 189, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[16895, 608, 565, 19, 70, "Input"],
Cell[17463, 629, 478, 17, 36, "Output",
 CellID->70247046]
}, Open  ]],
Cell[CellGroupData[{
Cell[17978, 651, 115, 3, 70, "Input"],
Cell[18096, 656, 817, 25, 92, "Output",
 CellID->221817944]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18962, 687, 207, 6, 70, "ExampleSection"],
Cell[19172, 695, 181, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[19378, 706, 357, 12, 70, "Input"],
Cell[19738, 720, 21637, 359, 70, "Output",
 Evaluatable->False,
 CellID->135963843]
}, Open  ]],
Cell[41390, 1082, 105, 2, 70, "ExampleDelimiter"],
Cell[41498, 1086, 178, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[41701, 1097, 381, 13, 70, "Input"],
Cell[42085, 1112, 2392, 43, 70, "Output",
 Evaluatable->False,
 CellID->364650397]
}, Open  ]],
Cell[CellGroupData[{
Cell[44514, 1160, 699, 24, 70, "Input"],
Cell[45216, 1186, 18480, 307, 70, "Output",
 Evaluatable->False,
 CellID->829263214]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[63745, 1499, 217, 6, 70, "ExampleSection"],
Cell[63965, 1507, 185, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[64175, 1518, 228, 8, 70, "Input"],
Cell[64406, 1528, 342, 12, 36, "Output",
 CellID->139146207]
}, Open  ]],
Cell[CellGroupData[{
Cell[64785, 1545, 146, 4, 70, "Input"],
Cell[64934, 1551, 303, 11, 39, "Output",
 CellID->294663538]
}, Open  ]],
Cell[65252, 1565, 105, 2, 70, "ExampleDelimiter"],
Cell[65360, 1569, 162, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[65547, 1579, 109, 3, 70, "Input"],
Cell[65659, 1584, 187, 6, 36, "Output",
 CellID->149489075]
}, Open  ]],
Cell[65861, 1593, 105, 2, 70, "ExampleDelimiter"],
Cell[65969, 1597, 316, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[66310, 1613, 296, 9, 70, "Input"],
Cell[66609, 1624, 1044, 35, 48, "Output",
 CellID->496681837]
}, Open  ]],
Cell[67668, 1662, 125, 3, 70, "ExampleDelimiter",
 CellID->290276463],
Cell[67796, 1667, 200, 8, 70, "ExampleText",
 CellID->63009025],
Cell[CellGroupData[{
Cell[68021, 1679, 320, 11, 70, "Input",
 CellID->182863228],
Cell[68344, 1692, 259, 9, 36, "Output",
 CellID->40207145]
}, Open  ]],
Cell[68618, 1704, 105, 2, 70, "ExampleDelimiter"],
Cell[68726, 1708, 189, 8, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[68940, 1720, 427, 13, 70, "Input"],
Cell[69370, 1735, 161, 5, 36, "Output",
 CellID->611033226]
}, Open  ]],
Cell[69546, 1743, 105, 2, 70, "ExampleDelimiter"],
Cell[69654, 1747, 44, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[69723, 1751, 220, 7, 70, "Input"],
Cell[69946, 1760, 276, 10, 51, "Output",
 CellID->1047429]
}, Open  ]],
Cell[CellGroupData[{
Cell[70259, 1775, 278, 9, 70, "Input"],
Cell[70540, 1786, 279, 9, 36, "Output",
 CellID->274140379]
}, Open  ]],
Cell[70834, 1798, 125, 3, 70, "ExampleDelimiter",
 CellID->447512168],
Cell[70962, 1803, 105, 2, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[71092, 1809, 273, 9, 70, "Input"],
Cell[71368, 1820, 488, 17, 52, "Output",
 CellID->83466908]
}, Open  ]],
Cell[CellGroupData[{
Cell[71893, 1842, 77, 2, 70, "Input"],
Cell[71973, 1846, 174, 5, 36, "Output",
 CellID->40254590]
}, Open  ]],
Cell[CellGroupData[{
Cell[72184, 1856, 274, 9, 70, "Input"],
Cell[72461, 1867, 254, 7, 36, "Output",
 CellID->232242652]
}, Open  ]],
Cell[72730, 1877, 105, 2, 70, "ExampleDelimiter"],
Cell[72838, 1881, 79, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[72942, 1885, 139, 4, 70, "Input"],
Cell[73084, 1891, 268, 9, 50, "Output",
 CellID->360367941]
}, Open  ]],
Cell[CellGroupData[{
Cell[73389, 1905, 239, 7, 70, "Input"],
Cell[73631, 1914, 829, 18, 70, "Output",
 Evaluatable->False,
 CellID->659908541]
}, Open  ]],
Cell[74475, 1935, 105, 2, 70, "ExampleDelimiter"],
Cell[74583, 1939, 43, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[74651, 1943, 184, 6, 70, "Input"],
Cell[74838, 1951, 261, 10, 77, "Output",
 CellID->838648657]
}, Open  ]],
Cell[CellGroupData[{
Cell[75136, 1966, 179, 6, 70, "Input"],
Cell[75318, 1974, 201, 7, 52, "Output",
 CellID->54377401]
}, Open  ]],
Cell[75534, 1984, 105, 2, 70, "ExampleDelimiter"],
Cell[75642, 1988, 284, 12, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[75951, 2004, 474, 15, 70, "Input"],
Cell[76428, 2021, 277, 10, 52, "Output",
 CellID->468981055]
}, Open  ]],
Cell[76720, 2034, 105, 2, 70, "ExampleDelimiter"],
Cell[76828, 2038, 178, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[77031, 2049, 260, 8, 70, "Input"],
Cell[77294, 2059, 804, 17, 70, "Output",
 Evaluatable->False,
 CellID->52064765]
}, Open  ]],
Cell[78113, 2079, 105, 2, 70, "ExampleDelimiter"],
Cell[78221, 2083, 39, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[78285, 2087, 295, 9, 70, "Input"],
Cell[78583, 2098, 907, 19, 70, "Output",
 Evaluatable->False,
 CellID->109759551]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[79539, 2123, 226, 7, 70, "ExampleSection",
 CellID->20328],
Cell[79768, 2132, 206, 8, 70, "ExampleText",
 CellID->170225646],
Cell[CellGroupData[{
Cell[79999, 2144, 157, 5, 70, "Input",
 CellID->163496479],
Cell[80159, 2151, 374, 13, 45, "Output",
 CellID->186189078]
}, Open  ]],
Cell[80548, 2167, 124, 3, 70, "ExampleDelimiter",
 CellID->17055592],
Cell[80675, 2172, 208, 6, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[80908, 2182, 308, 9, 70, "Input"],
Cell[81219, 2193, 523, 9, 70, "Message",
 CellID->383275085],
Cell[81745, 2204, 417, 13, 39, "Output",
 CellID->167597253]
}, Open  ]],
Cell[CellGroupData[{
Cell[82199, 2222, 84, 2, 70, "Input"],
Cell[82286, 2226, 158, 5, 36, "Output",
 CellID->463563726]
}, Open  ]],
Cell[82459, 2234, 105, 2, 70, "ExampleDelimiter"],
Cell[82567, 2238, 204, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[82796, 2249, 195, 6, 70, "Input"],
Cell[82994, 2257, 187, 6, 36, "Output",
 CellID->218146153]
}, Open  ]],
Cell[83196, 2266, 65, 0, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[83286, 2270, 316, 9, 70, "Input"],
Cell[83605, 2281, 829, 18, 70, "Output",
 Evaluatable->False,
 CellID->83356890]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84483, 2305, 208, 6, 70, "ExampleSection"],
Cell[84694, 2313, 185, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[84904, 2324, 1451, 41, 70, "Input"],
Cell[86358, 2367, 12625, 211, 70, "Output",
 Evaluatable->False,
 CellID->125815893]
}, Open  ]],
Cell[CellGroupData[{
Cell[99020, 2583, 219, 7, 70, "Input"],
Cell[99242, 2592, 4696, 81, 70, "Output",
 Evaluatable->False,
 CellID->2144250]
}, Open  ]],
Cell[103953, 2676, 105, 2, 70, "ExampleDelimiter"],
Cell[104061, 2680, 179, 7, 70, "ExampleText"],
Cell[CellGroupData[{
Cell[104265, 2691, 509, 16, 70, "Input"],
Cell[104777, 2709, 1255, 27, 246, "Output",
 CellID->528581517]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[106093, 2743, 311, 9, 70, "SeeAlsoSection",
 CellID->29657],
Cell[106407, 2754, 1872, 71, 70, "SeeAlso",
 CellID->7958]
}, Open  ]],
Cell[CellGroupData[{
Cell[108316, 2830, 314, 9, 70, "TutorialsSection",
 CellID->23622],
Cell[108633, 2841, 163, 3, 70, "Tutorials",
 CellID->18538],
Cell[108799, 2846, 140, 3, 70, "Tutorials",
 CellID->12292],
Cell[108942, 2851, 147, 3, 70, "Tutorials",
 CellID->6038],
Cell[109092, 2856, 152, 3, 70, "Tutorials",
 CellID->869807265]
}, Open  ]],
Cell[CellGroupData[{
Cell[109281, 2864, 321, 9, 70, "RelatedLinksSection",
 CellID->24179],
Cell[109605, 2875, 346, 11, 70, "RelatedLinks"],
Cell[109954, 2888, 184, 4, 70, "RelatedLinks"],
Cell[110141, 2894, 193, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[110371, 2903, 319, 9, 70, "MoreAboutSection",
 CellID->259944588],
Cell[110693, 2914, 141, 3, 70, "MoreAbout",
 CellID->477877982],
Cell[110837, 2919, 169, 3, 70, "MoreAbout",
 CellID->572471874],
Cell[111009, 2924, 155, 3, 70, "MoreAbout",
 CellID->330572821],
Cell[111167, 2929, 149, 3, 70, "MoreAbout",
 CellID->664015437]
}, Open  ]],
Cell[111331, 2935, 27, 0, 70, "History"],
Cell[111361, 2937, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

