(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15174,        520]
NotebookOptionsPosition[     12019,        422]
NotebookOutlinePosition[     13637,        463]
CellTagsIndexPosition[     13552,        458]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Options" :> 
          Documentation`HelpLookup["paclet:tutorial/ManipulatingOptions"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheStructureOfGraphics"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Manipulating Options\"\>", 
       2->"\<\"The Structure of Graphics\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "FullGraphics" :> 
          Documentation`HelpLookup["paclet:ref/FullGraphics"], "SetOptions" :> 
          Documentation`HelpLookup["paclet:ref/SetOptions"], 
          "AbsoluteCurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteCurrentValue"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Options\"\>", 
       2->"\<\"FullGraphics\"\>", 3->"\<\"SetOptions\"\>", 
       4->"\<\"AbsoluteCurrentValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options Management" :> 
          Documentation`HelpLookup["paclet:guide/OptionsManagement"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options Management\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AbsoluteOptions", "ObjectName",
 CellID->18896],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the absolute settings of options specified in an \
expression such as a graphics object. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the absolute setting for the option ",
     Cell[BoxData[
      StyleBox["name", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["name", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["name", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the absolute settings for the options ",
     
     Cell[BoxData[
      SubscriptBox[
       StyleBox["name", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AbsoluteOptions",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
       StyleBox["object", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the absolute settings for options associated with \
an external object such as a ",
     Cell[BoxData[
      ButtonBox["NotebookObject",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->4667]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFormula"],
 " gives the actual settings for options used internally by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " when the setting given is ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["All",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/All"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7285],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFormula"],
 " returns lists of rules, just like ",
 Cell[BoxData[
  ButtonBox["Options",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Options"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12550],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["AbsoluteOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFormula"],
 " on graphics options such as ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->140],

Cell[TextData[{
 "If you ask for ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AbsoluteOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteOptions"], "[", 
   RowBox[{
    RowBox[{
     ButtonBox["NotebookObject",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/NotebookObject"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], ",", 
    StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
 " the kernel will send a request to the front end to find the result. "
}], "Notes",
 CellID->13694]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34181477],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->23610817],

Cell[TextData[{
 "Tell explicit values of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->918018652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteOptions", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "Automatic"}]}], "]"}], ",", 
   "PlotRange"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->413850212],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"PlotRange", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.`", ",", "6.283185178951315`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.9999998592131705`"}], ",", "0.9999998782112116`"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{272, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->575292463]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21694],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullGraphics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullGraphics"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetOptions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetOptions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteCurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteCurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22658]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->2695],

Cell[TextData[ButtonBox["Manipulating Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingOptions"]], "Tutorials",
 CellID->21624],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->28019]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->377952602],

Cell[TextData[ButtonBox["Options Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OptionsManagement"]], "MoreAbout",
 CellID->252032798]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AbsoluteOptions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 22.3289206}", "context" -> "System`", 
    "keywords" -> {"automatic options"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AbsoluteOptions[expr] gives the absolute settings of options specified \
in an expression such as a graphics object. AbsoluteOptions[expr, name] gives \
the absolute setting for the option name. AbsoluteOptions[expr, {name_1, \
name_2, ...}] gives a list of the absolute settings for the options name_i. \
AbsoluteOptions[object] gives the absolute settings for options associated \
with an external object such as a NotebookObject. ", 
    "synonyms" -> {"absolute options"}, "title" -> "AbsoluteOptions", "type" -> 
    "Symbol", "uri" -> "ref/AbsoluteOptions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7704, 253, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->34181477]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13410, 451}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2264, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2887, 81, 53, 1, 70, "ObjectName",
 CellID->18896],
Cell[2943, 84, 2306, 70, 70, "Usage",
 CellID->4667]
}, Open  ]],
Cell[CellGroupData[{
Cell[5286, 159, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5764, 176, 565, 20, 70, "Notes",
 CellID->7285],
Cell[6332, 198, 340, 12, 70, "Notes",
 CellID->12550],
Cell[6675, 212, 476, 18, 70, "Notes",
 CellID->140],
Cell[7154, 232, 513, 16, 70, "Notes",
 CellID->13694]
}, Closed]],
Cell[CellGroupData[{
Cell[7704, 253, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->34181477],
Cell[CellGroupData[{
Cell[8088, 267, 147, 5, 70, "ExampleSection",
 CellID->23610817],
Cell[8238, 274, 322, 12, 70, "ExampleText",
 CellID->918018652],
Cell[CellGroupData[{
Cell[8585, 290, 381, 12, 28, "Input",
 CellID->413850212],
Cell[8969, 304, 458, 15, 36, "Output",
 CellID->575292463]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9488, 326, 311, 9, 70, "SeeAlsoSection",
 CellID->21694],
Cell[9802, 337, 975, 35, 70, "SeeAlso",
 CellID->22658]
}, Open  ]],
Cell[CellGroupData[{
Cell[10814, 377, 313, 9, 70, "TutorialsSection",
 CellID->2695],
Cell[11130, 388, 150, 3, 70, "Tutorials",
 CellID->21624],
Cell[11283, 393, 158, 3, 70, "Tutorials",
 CellID->28019]
}, Open  ]],
Cell[CellGroupData[{
Cell[11478, 401, 319, 9, 70, "MoreAboutSection",
 CellID->377952602],
Cell[11800, 412, 147, 3, 70, "MoreAbout",
 CellID->252032798]
}, Open  ]],
Cell[11962, 418, 27, 0, 70, "History"],
Cell[11992, 420, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

