(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14818,        494]
NotebookOptionsPosition[     11794,        397]
NotebookOutlinePosition[     13282,        437]
CellTagsIndexPosition[     13197,        432]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PaddedForm" :> 
          Documentation`HelpLookup["paclet:ref/PaddedForm"], "NumberForm" :> 
          Documentation`HelpLookup["paclet:ref/NumberForm"], "Column" :> 
          Documentation`HelpLookup["paclet:ref/Column"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"PaddedForm\"\>", 2->"\<\"NumberForm\"\>", 
       3->"\<\"Column\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Display of Numbers" :> 
          Documentation`HelpLookup["paclet:guide/DisplayOfNumbers"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Display of Numbers\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AccountingForm", "ObjectName",
 CellID->23847],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AccountingForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AccountingForm"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with all numbers in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " given in standard accounting notation. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AccountingForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AccountingForm"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with numbers given to ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Hyphen]digit precision. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->32604]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 " never uses scientific notation. "
}], "Notes",
 CellID->503],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 " uses parentheses to indicate negative numbers. "
}], "Notes",
 CellID->21221],

Cell["The following options can be given: ", "Notes",
 CellID->22663],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DigitBlock",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DigitBlock"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "number of digits between breaks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function to apply to exponents ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExponentStep",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ExponentStep"], "1", Cell[
    "steps by which exponents can increase", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberFormat"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "function used to assemble mantissa, base, and exponent ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberMultiplier",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberMultiplier"], "\"\<\>\"", Cell[
    "string to use to indicate multiplication ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPadding"], 
    RowBox[{"{", 
     RowBox[{"\"\<\>\"", ",", "\"\<\>\""}], "}"}], Cell[
    "strings to use for left and right padding ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberPoint",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberPoint"], "\"\<.\>\"", Cell[
    "decimal point string ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSeparator",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSeparator"], 
    RowBox[{"{", 
     RowBox[{"\"\<,\>\"", ",", "\"\< \>\""}], "}"}], Cell[
    "string to insert at breaks between blocks ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["NumberSigns",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/NumberSigns"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<(\>\"", ",", "\"\<)\>\""}], "}"}], ",", "\"\<\>\""}], 
     "}"}], Cell[
    "strings to use for signs of negative and positive numbers ", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SignPadding",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/SignPadding"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "whether to insert padding after the sign ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True}}}},
 CellID->5706],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AccountingForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AccountingForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects printing, but not evaluation. "
}], "Notes",
 CellID->2363]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->228622930],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->362787925],

Cell["\<\
In accounting form negative numbers and scientific notation are not used:\
\>", "ExampleText",
 CellID->3699554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AccountingForm", "[", 
  RowBox[{"{", 
   RowBox[{"5.6", ",", 
    RowBox[{"-", "6.7"}], ",", 
    RowBox[{"10.", "^", "7"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63309749],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    InterpretationBox["\<\"5.6\"\>",
     5.6,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"(6.7)\"\>",
     -6.7,
     AutoDelete->True], ",", 
    InterpretationBox["\<\"10000000.\"\>",
     1.*^7,
     AutoDelete->True]}], "}"}],
  AccountingForm]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//AccountingForm=",
 CellID->78945198]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12164],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaddedForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaddedForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Column",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Column"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25542]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9010],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->22171]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->303577120],

Cell[TextData[ButtonBox["Display of Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DisplayOfNumbers"]], "MoreAbout",
 CellID->351591476]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AccountingForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 25.1102418}", "context" -> "System`", 
    "keywords" -> {
     "accounting number format", "number formatting", "numeric formatting", 
      "number output", "financial number formatting", 
      "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AccountingForm[expr] prints with all numbers in expr given in standard \
accounting notation. AccountingForm[expr, n] prints with numbers given to \
n-digit precision. ", "synonyms" -> {"accounting form"}, "title" -> 
    "AccountingForm", "type" -> "Symbol", "uri" -> "ref/AccountingForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8255, 253, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->228622930]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13054, 425}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1955, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2578, 76, 52, 1, 70, "ObjectName",
 CellID->23847],
Cell[2633, 79, 1057, 32, 70, "Usage",
 CellID->32604]
}, Open  ]],
Cell[CellGroupData[{
Cell[3727, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4205, 133, 210, 7, 70, "Notes",
 CellID->503],
Cell[4418, 142, 227, 7, 70, "Notes",
 CellID->21221],
Cell[4648, 151, 69, 1, 70, "Notes",
 CellID->22663],
Cell[4720, 154, 3249, 85, 70, "3ColumnTableMod",
 CellID->5706],
Cell[7972, 241, 246, 7, 70, "Notes",
 CellID->2363]
}, Closed]],
Cell[CellGroupData[{
Cell[8255, 253, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->228622930],
Cell[CellGroupData[{
Cell[8640, 267, 148, 5, 70, "ExampleSection",
 CellID->362787925],
Cell[8791, 274, 122, 3, 70, "ExampleText",
 CellID->3699554],
Cell[CellGroupData[{
Cell[8938, 281, 217, 7, 28, "Input",
 CellID->63309749],
Cell[9158, 290, 471, 18, 50, "Output",
 CellID->78945198]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9690, 315, 311, 9, 70, "SeeAlsoSection",
 CellID->12164],
Cell[10004, 326, 700, 26, 70, "SeeAlso",
 CellID->25542]
}, Open  ]],
Cell[CellGroupData[{
Cell[10741, 357, 313, 9, 70, "TutorialsSection",
 CellID->9010],
Cell[11057, 368, 160, 3, 70, "Tutorials",
 CellID->22171]
}, Open  ]],
Cell[CellGroupData[{
Cell[11254, 376, 319, 9, 70, "MoreAboutSection",
 CellID->303577120],
Cell[11576, 387, 146, 3, 70, "MoreAbout",
 CellID->351591476]
}, Open  ]],
Cell[11737, 393, 27, 0, 70, "History"],
Cell[11767, 395, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

