(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20327,        734]
NotebookOptionsPosition[     15994,        591]
NotebookOutlinePosition[     17493,        632]
CellTagsIndexPosition[     17408,        627]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BaselinePosition" :> 
          Documentation`HelpLookup["paclet:ref/BaselinePosition"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "ScriptBaselineShifts" :> 
          Documentation`HelpLookup["paclet:ref/ScriptBaselineShifts"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"BaselinePosition\"\>", 
       2->"\<\"Style\"\>", 3->"\<\"Grid\"\>", 
       4->"\<\"ScriptBaselineShifts\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AdjustmentBox", "ObjectName",
 CellID->7783],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AdjustmentBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AdjustmentBox"], "[", 
       RowBox[{
        StyleBox["box", "TI"], ",", 
        StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct which displays with the \
placement of ",
     Cell[BoxData[
      StyleBox["box", "TI"]], "InlineFormula"],
     " adjusted using the options given. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16828]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "In the notebook front end, ",
 Cell[BoxData[
  ButtonBox["AdjustmentBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AdjustmentBox"]], "InlineFormula"],
 " objects can typically be inserted and modified using ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["LeftArrow", "KeyEvent"],
 ", ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["RightArrow", "KeyEvent"],
 ", ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["UpArrow", "KeyEvent"],
 " and ",
 StyleBox["Alt", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["DownArrow", "KeyEvent"],
 " (",
 StyleBox["Ctrl", "KeyEvent"],
 " on Macintosh). These keys move your current selection by one pixel at the \
current screen magnification. "
}], "Notes",
 CellID->7727],

Cell["The following options can be given: ", "Notes",
 CellID->29426],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxMargins",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxMargins"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        StyleBox["left", "TI"], ",", 
        StyleBox["right", "TI"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["bottom", "TI"], ",", 
        StyleBox["top", "TI"]}], "}"}]}], "}"}], Cell[
    "margins to leave around the contents of the box ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BoxBaselineShift",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BoxBaselineShift"], 
    StyleBox["up", "TI"], Cell["\<\
how much the baseline should be shifted relative to those of neighboring \
boxes \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->15871],

Cell["\<\
Horizontal motion specifications are in ems; vertical ones in \
x\[Hyphen]heights. \
\>", "Notes",
 CellID->10697],

Cell["\<\
Motion specifications can be either positive or negative numbers. \
\>", "Notes",
 CellID->17612],

Cell[TextData[{
 "Positive margin specifications increase the spacing around ",
 Cell[BoxData[
  StyleBox["box", "TI"]], "InlineFormula"],
 "; negative ones decrease it. "
}], "Notes",
 CellID->18703],

Cell[TextData[{
 "Moving the baseline affects for example vertical alignment in a ",
 Cell[BoxData[
  ButtonBox["RowBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RowBox"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11027],

Cell[TextData[{
 "Top and bottom margins affect for example placement in a ",
 Cell[BoxData[
  ButtonBox["FractionBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FractionBox"]], "InlineFormula"],
 " or an ",
 Cell[BoxData[
  ButtonBox["OverscriptBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OverscriptBox"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11408],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " input, ",
 Cell[BoxData[
  ButtonBox["AdjustmentBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AdjustmentBox"]], "InlineFormula"],
 " is by default ignored, so that ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AdjustmentBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AdjustmentBox"], "[", 
   RowBox[{
    StyleBox["box", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 " is interpreted just as ",
 Cell[BoxData[
  StyleBox["box", "TI"]], "InlineFormula"],
 " would be. "
}], "Notes",
 CellID->5545],

Cell[TextData[{
 "Inserting an explicit spacing character such as ",
 Cell[TextData[ButtonBox["\\[ThinSpace]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/ThinSpace"]], "InlineCharacterName"],
 " can have the same effect for display as ",
 Cell[BoxData[
  ButtonBox["AdjustmentBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AdjustmentBox"]], "InlineFormula"],
 ", but the spacing character by default affects interpretation. "
}], "Notes",
 CellID->9508],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AdjustmentBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AdjustmentBox"], "[", 
   RowBox[{
    StyleBox["box", "TI"], ",", 
    StyleBox["opts", "TI"]}], "]"}]], "InlineFormula"],
 " uses the options given only to adjust the position of ",
 Cell[BoxData[
  StyleBox["box", "TI"]], "InlineFormula"],
 " itself. Unlike ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 ", it does not propagate the options to subboxes. "
}], "Notes",
 CellID->7185]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118611200],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->221548724],

Cell["Display letters with different amounts of baseline shift:", \
"ExampleText",
 CellID->110280404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"AdjustmentBox", "[", 
      RowBox[{"\"\<x\>\"", ",", 
       RowBox[{"BoxBaselineShift", "\[Rule]", "b"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", 
       RowBox[{"-", ".2"}], ",", ".2", ",", ".2"}], "}"}]}], "]"}], "]"}], "//",
   "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177567825],

Cell[BoxData[
 TagBox[
  RowBox[{
   AdjustmentBox["x",
    BoxBaselineShift->-0.2], 
   AdjustmentBox["x",
    BoxBaselineShift->0.], 
   AdjustmentBox["x",
    BoxBaselineShift->0.2]}],
  DisplayForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->144112123]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292428007],

Cell["Display letters with different amounts of margin:", "ExampleText",
 CellID->491420814],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"AdjustmentBox", "[", 
      RowBox[{"\"\<x\>\"", ",", 
       RowBox[{"BoxMargins", "\[Rule]", "b"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"b", ",", "0", ",", ".2", ",", ".1"}], "}"}]}], "]"}], "]"}], "//",
   "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->600758993],

Cell[BoxData[
 TagBox[
  RowBox[{
   AdjustmentBox["x",
    BoxMargins->0.], 
   AdjustmentBox["x",
    BoxMargins->0.1], 
   AdjustmentBox["x",
    BoxMargins->0.2]}],
  DisplayForm]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->403839710]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->608952542],

Cell["Display a letter with different margins on different sides:", \
"ExampleText",
 CellID->537558262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<yyy\>\"", ",", 
     RowBox[{"AdjustmentBox", "[", 
      RowBox[{"\"\<x\>\"", ",", 
       RowBox[{"BoxMargins", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.1", ",", "0.3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0.4", ",", "0.2"}], "}"}]}], "}"}]}]}], "]"}], ",", 
     "\"\<yyy\>\""}], "}"}], "]"}], "//", "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242774823],

Cell[BoxData[
 TagBox[
  RowBox[{"yyy", 
   AdjustmentBox["x",
    BoxMargins->{{0.1, 0.3}, {0.4, 0.2}}], "yyy"}],
  DisplayForm]], "Output",
 ImageSize->{69, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->114285970]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22183444],

Cell[TextData[{
 "Adjustments are typically ignored when an ",
 Cell[BoxData[
  ButtonBox["AdjustmentBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AdjustmentBox"]], "InlineFormula"],
 " form is interpreted as input:"
}], "ExampleText",
 CellID->449017820],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"AdjustmentBox", "[", 
    RowBox[{"\"\<x\>\"", ",", 
     RowBox[{"BoxBaselineShift", "\[Rule]", "0.3"}], ",", 
     RowBox[{"BoxMargins", "\[Rule]", "0.2"}]}], "]"}], ",", "StandardForm"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27669645],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100288828]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25362379],

Cell[BoxData[
 TagBox[
  StyleBox["x",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->113676042]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22501],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ScriptBaselineShifts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ScriptBaselineShifts"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8850]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with AdjustmentBox",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=AdjustmentBox"],
     None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->50036956]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AdjustmentBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 32.1885480}", "context" -> "System`", 
    "keywords" -> {
     "adjust character position", "barred characters", 
      "double-struck characters", "overprinting", "overstrike", 
      "slashed characters", "nudging", "character box", "typeset box", 
      "kerning"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "AdjustmentBox[box, opts] is a low-level box construct which displays \
with the placement of box adjusted using the options given. ", 
    "synonyms" -> {"adjustment box"}, "title" -> "AdjustmentBox", "type" -> 
    "Symbol", "uri" -> "ref/AdjustmentBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8488, 290, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118611200]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17265, 620}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1532, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2155, 63, 50, 1, 70, "ObjectName",
 CellID->7783],
Cell[2208, 66, 690, 21, 70, "Usage",
 CellID->16828]
}, Open  ]],
Cell[CellGroupData[{
Cell[2935, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3413, 109, 847, 27, 70, "Notes",
 CellID->7727],
Cell[4263, 138, 69, 1, 70, "Notes",
 CellID->29426],
Cell[4335, 141, 1166, 33, 70, "3ColumnTableMod",
 CellID->15871],
Cell[5504, 176, 124, 4, 70, "Notes",
 CellID->10697],
Cell[5631, 182, 107, 3, 70, "Notes",
 CellID->17612],
Cell[5741, 187, 200, 6, 70, "Notes",
 CellID->18703],
Cell[5944, 195, 234, 8, 70, "Notes",
 CellID->11027],
Cell[6181, 205, 378, 13, 70, "Notes",
 CellID->11408],
Cell[6562, 220, 822, 30, 70, "Notes",
 CellID->5545],
Cell[7387, 252, 475, 12, 70, "Notes",
 CellID->9508],
Cell[7865, 266, 586, 19, 70, "Notes",
 CellID->7185]
}, Closed]],
Cell[CellGroupData[{
Cell[8488, 290, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118611200],
Cell[CellGroupData[{
Cell[8873, 304, 148, 5, 70, "ExampleSection",
 CellID->221548724],
Cell[9024, 311, 102, 2, 70, "ExampleText",
 CellID->110280404],
Cell[CellGroupData[{
Cell[9151, 317, 423, 13, 47, "Input",
 CellID->177567825],
Cell[9577, 332, 357, 14, 50, "Output",
 CellID->144112123]
}, Open  ]],
Cell[9949, 349, 125, 3, 70, "ExampleDelimiter",
 CellID->292428007],
Cell[10077, 354, 92, 1, 70, "ExampleText",
 CellID->491420814],
Cell[CellGroupData[{
Cell[10194, 359, 393, 12, 70, "Input",
 CellID->600758993],
Cell[10590, 373, 338, 14, 50, "Output",
 CellID->403839710]
}, Open  ]],
Cell[10943, 390, 125, 3, 70, "ExampleDelimiter",
 CellID->608952542],
Cell[11071, 395, 104, 2, 70, "ExampleText",
 CellID->537558262],
Cell[CellGroupData[{
Cell[11200, 401, 535, 16, 70, "Input",
 CellID->242774823],
Cell[11738, 419, 284, 10, 52, "Output",
 CellID->114285970]
}, Open  ]],
Cell[12037, 432, 124, 3, 70, "ExampleDelimiter",
 CellID->22183444],
Cell[12164, 437, 264, 8, 70, "ExampleText",
 CellID->449017820],
Cell[CellGroupData[{
Cell[12453, 449, 320, 9, 70, "Input",
 CellID->27669645],
Cell[12776, 460, 158, 5, 36, "Output",
 CellID->100288828]
}, Open  ]],
Cell[CellGroupData[{
Cell[12971, 470, 99, 3, 70, "Input",
 CellID->25362379],
Cell[13073, 475, 289, 11, 50, "Output",
 CellID->113676042]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13423, 493, 311, 9, 70, "SeeAlsoSection",
 CellID->22501],
Cell[13737, 504, 966, 35, 70, "SeeAlso",
 CellID->8850]
}, Open  ]],
Cell[CellGroupData[{
Cell[14740, 544, 305, 8, 70, "RelatedLinksSection"],
Cell[15048, 554, 371, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15456, 571, 299, 8, 70, "MoreAboutSection"],
Cell[15758, 581, 164, 3, 70, "MoreAbout",
 CellID->50036956]
}, Open  ]],
Cell[15937, 587, 27, 0, 70, "History"],
Cell[15967, 589, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

