(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     51919,       1640]
NotebookOptionsPosition[     44472,       1385]
NotebookOutlinePosition[     45981,       1426]
CellTagsIndexPosition[     45895,       1421]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"GeometricTransformation" :> 
          Documentation`HelpLookup["paclet:ref/GeometricTransformation"], 
          "LinearFractionalTransform" :> 
          Documentation`HelpLookup["paclet:ref/LinearFractionalTransform"], 
          "TransformationFunction" :> 
          Documentation`HelpLookup["paclet:ref/TransformationFunction"], 
          "RotationTransform" :> 
          Documentation`HelpLookup["paclet:ref/RotationTransform"], "Dot" :> 
          Documentation`HelpLookup["paclet:ref/Dot"], "ViewMatrix" :> 
          Documentation`HelpLookup["paclet:ref/ViewMatrix"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"GeometricTransformation\"\>", 
       2->"\<\"LinearFractionalTransform\"\>", 
       3->"\<\"TransformationFunction\"\>", 4->"\<\"RotationTransform\"\>", 
       5->"\<\"Dot\"\>", 6->"\<\"ViewMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Geometric Transforms" :> 
          Documentation`HelpLookup["paclet:guide/GeometricTransforms"], 
          "Graphics Transformations" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsTransformations"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Geometric Transforms\"\>", 
       3->"\<\"Graphics Transformations\"\>", 
       4->"\<\"Symbolic Graphics Language\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AffineTransform", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AffineTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AffineTransform"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a ",
     Cell[BoxData[
      ButtonBox["TransformationFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
     " that represents an affine transform that maps ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], ".", 
       StyleBox["r", "TI"]}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AffineTransform",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AffineTransform"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["m", "TI"], ",", 
         StyleBox["v", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an affine transform that maps ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{
       RowBox[{
        StyleBox["m", "TI"], ".", 
        StyleBox["r", "TI"]}], "+", 
       StyleBox["v", "TI"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AffineTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AffineTransform"]], "InlineFormula"],
 " gives a ",
 Cell[BoxData[
  ButtonBox["TransformationFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
 " which can be applied to vectors."
}], "Notes",
 CellID->108862120],

Cell[TextData[{
 "For ordinary affine transforms in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " dimensions, ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is an ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "\[Times]",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " matrix."
}], "Notes",
 CellID->60721000],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AffineTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AffineTransform"]], "InlineFormula"],
 " in general supports ",
 Cell[BoxData[
  FormBox["s", TraditionalForm]], "InlineMath"],
 "\[Times]",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " matrices for transformations in ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " dimensions."
}], "Notes",
 CellID->518398028]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412435521],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->184203171],

Cell["A general affine transformation: ", "ExampleText",
 CellID->262588348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"AffineTransform", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["a", 
          RowBox[{"1", ",", "1"}]], ",", 
         SubscriptBox["a", 
          RowBox[{"1", ",", "2"}]]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox["a", 
          RowBox[{"2", ",", "1"}]], ",", 
         SubscriptBox["a", 
          RowBox[{"2", ",", "2"}]]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["b", "1"], ",", 
       SubscriptBox["b", "2"]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->562065775],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      SubscriptBox["a", 
       RowBox[{"1", ",", "1"}]], 
      SubscriptBox["a", 
       RowBox[{"1", ",", "2"}]], 
      SubscriptBox["b", "1"]},
     {
      SubscriptBox["a", 
       RowBox[{"2", ",", "1"}]], 
      SubscriptBox["a", 
       RowBox[{"2", ",", "2"}]], 
      SubscriptBox["b", "2"]},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{268, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->656400027]
}, Open  ]],

Cell["Transform points: ", "ExampleText",
 CellID->67686513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7611636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["b", "1"], "+", 
    RowBox[{"x", " ", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "1"}]]}], "+", 
    RowBox[{"y", " ", 
     SubscriptBox["a", 
      RowBox[{"1", ",", "2"}]]}]}], ",", 
   RowBox[{
    SubscriptBox["b", "2"], "+", 
    RowBox[{"x", " ", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "1"}]]}], "+", 
    RowBox[{"y", " ", 
     SubscriptBox["a", 
      RowBox[{"2", ",", "2"}]]}]}]}], "}"}]], "Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156500428]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318566111],

Cell["A pure rotation: ", "ExampleText",
 CellID->304140537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tr", "=", 
  RowBox[{"AffineTransform", "[", 
   RowBox[{"RotationMatrix", "[", "\[Theta]", "]"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17437165],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{"Cos", "[", "\[Theta]", "]"}], 
      RowBox[{"-", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "0"},
     {
      RowBox[{"Sin", "[", "\[Theta]", "]"}], 
      RowBox[{"Cos", "[", "\[Theta]", "]"}], "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{308, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183565354]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tr", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->477868098],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "-", 
    RowBox[{"y", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"y", " ", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "+", 
    RowBox[{"x", " ", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413201795]
}, Open  ]],

Cell["A pure translation: ", "ExampleText",
 CellID->336263831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tt", "=", 
  RowBox[{"AffineTransform", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"IdentityMatrix", "[", "2", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["b", "1"], ",", 
       SubscriptBox["b", "2"]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->47691607],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", 
      SubscriptBox["b", "1"]},
     {"0", "1", 
      SubscriptBox["b", "2"]},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{236, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->223084912]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tt", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->368882807],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", 
    SubscriptBox["b", "1"]}], ",", 
   RowBox[{"y", "+", 
    SubscriptBox["b", "2"]}]}], "}"}]], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->22008038]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->53795577],

Cell["Affine transform in four dimensions:", "ExampleText",
 CellID->5908750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "=", 
  RowBox[{"AffineTransform", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"DiagonalMatrix", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1", ",", "2"}], "}"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "y0", ",", "z0", ",", "w0"}], "}"}]}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->239856774],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", "0", "0", "x0"},
     {"0", "1", "0", "0", "y0"},
     {"0", "0", "1", "0", "z0"},
     {"0", "0", "0", "2", "w0"},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{267, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->250487215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t", "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->135471106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "+", "x0"}], ",", 
   RowBox[{"y", "+", "y0"}], ",", 
   RowBox[{"z", "+", "z0"}], ",", 
   RowBox[{
    RowBox[{"2", " ", "w"}], "+", "w0"}]}], "}"}]], "Output",
 ImageSize->{197, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->494861721]
}, Open  ]],

Cell["The inverse transform:", "ExampleText",
 CellID->656649796],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFunction", "[", "t", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->404415642],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", "0", "0", 
      RowBox[{"-", "x0"}]},
     {"0", "1", "0", "0", 
      RowBox[{"-", "y0"}]},
     {"0", "0", "1", "0", 
      RowBox[{"-", "z0"}]},
     {"0", "0", "0", 
      FractionBox["1", "2"], 
      RowBox[{"-", 
       FractionBox["w0", "2"]}]},
     {"0", "0", "0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{279, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->69229159]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", "t", "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->69092502],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"x", "-", "x0"}], ",", 
   RowBox[{"y", "-", "y0"}], ",", 
   RowBox[{"z", "-", "z0"}], ",", 
   RowBox[{
    FractionBox["w", "2"], "-", 
    FractionBox["w0", "2"]}]}], "}"}]], "Output",
 ImageSize->{195, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->112367272]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131638136],

Cell["Transformation applied to a 2D shape:", "ExampleText",
 CellID->479507293],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Rectangle", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->419323043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
    ",", 
    RowBox[{"GeometricTransformation", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}], 
      ",", 
      RowBox[{"AffineTransform", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{".8", ",", ".5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".8"}], "}"}]}], "}"}], "]"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->150504143],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], RectangleBox[{0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
     {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, GeometricTransformationBox[
    {RGBColor[1, 0, 0], Opacity[0.85], RectangleBox[{0, 0}], 
     {AbsolutePointSize[10], Opacity[1], 
      {RGBColor[1, 0, 1], PointBox[{0, 0}]}, 
      {RGBColor[0, 1, 0], PointBox[{1, 1}]}}}, {{{0.8, 0.5}, {0, 0.8}}, {0, 
     0}}]}]], "Output",
 ImageSize->{184, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3749890]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->56656449],

Cell["Transformation applied to a 3D shape:", "ExampleText",
 CellID->137131831],

Cell[BoxData[
 RowBox[{
  RowBox[{"gr", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cuboid", "[", "]"}], ",", 
     RowBox[{"AbsolutePointSize", "[", "10", "]"}], ",", 
     RowBox[{"Opacity", "[", "1", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"Magenta", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Point", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367829949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", ".35", "]"}], ",", "Blue", ",", "gr"}], "}"}], 
     ",", 
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Opacity", "[", ".85", "]"}], ",", "Red", ",", "gr"}], "}"}],
        ",", 
       RowBox[{"AffineTransform", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{".8", ",", ".5", ",", ".5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".8", ",", ".5"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "0", ",", ".8"}], "}"}]}], "}"}], "]"}]}], 
      "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->167437831],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[0, 0, 1], Opacity[0.35], CuboidBox[{0, 0, 0}], 
    {AbsolutePointSize[10], Opacity[1], 
     {RGBColor[1, 0, 1], Point3DBox[{0, 0, 0}]}, 
     {RGBColor[0, 1, 0], Point3DBox[{1, 1, 1}]}}}, 
   InterpretationBox[
    {RGBColor[1., 0., 0.], Opacity[0.85], 
     GraphicsComplex3DBox[{{0., 0., 0.}, {0.5, 0.5, 0.8}, {0.5, 0.8, 0.}, {1.,
       1.3, 0.8}, {0.8, 0., 0.}, {1.3, 0.5, 0.8}, {1.3, 0.8, 0.}, {1.8, 1.3, 
      0.8}}, Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8,
        7}, {1, 2, 4, 3}, {5, 7, 8, 6}}],
      VertexColors->Automatic,
      VertexNormals->Automatic], 
     {AbsolutePointSize[10.], Opacity[1.], 
      {RGBColor[1., 0., 1.], Point3DBox[{0., 0., 0.}]}, 
      {RGBColor[0., 1., 0.], Point3DBox[{1.8, 1.3, 0.8}]}}},
    GeometricTransformation[{
      Opacity[0.85], 
      RGBColor[1, 0, 0], {
       Cuboid[{0, 0, 0}], 
       AbsolutePointSize[10], 
       Opacity[1], {
        RGBColor[1, 0, 1], 
        Point[{0, 0, 0}]}, {
        RGBColor[0, 1, 0], 
        Point[{1, 1, 1}]}}}, {{{0.8, 0.5, 0.5}, {0, 0.8, 0.5}, {0, 0, 0.8}}, {
      0, 0, 0}}]]},
  Boxed->False]], "Output",
 ImageSize->{184, 156},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88332644,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->117606223],

Cell["Transforming graphics primitives:", "ExampleText",
 CellID->304565429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"GeometricTransformation", "[", 
   RowBox[{
    RowBox[{"Style", "[", 
     RowBox[{
      RowBox[{"Text", "[", "\"\<Mathematica\>\"", "]"}], ",", "24"}], "]"}], 
    ",", 
    RowBox[{"AffineTransform", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20217230],

Cell[BoxData[
 GraphicsBox[GeometricTransformationBox[
   StyleBox[InsetBox["\<\"Mathematica\"\>", {0, 0}],
    StripOnInput->False,
    FontSize->24], {{{1, -1}, {1, 1}}, {0, 0}}]]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53388101]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25816771],

Cell["\<\
Many other geometric transformations are a special case of affine transform:\
\>", "ExampleText",
 CellID->56333249],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{
    RowBox[{"TranslationTransform", "[", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "y0"}], "}"}], "]"}], ",", 
    RowBox[{"RotationTransform", "[", "a", "]"}]}], "]"}], "\[Equal]", 
  RowBox[{"AffineTransform", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", "a", "]"}], ",", 
         RowBox[{"-", 
          RowBox[{"Sin", "[", "a", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Sin", "[", "a", "]"}], ",", 
         RowBox[{"Cos", "[", "a", "]"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "y0"}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368495022],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12974829]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168903201],

Cell["\<\
In turn, an affine transformation is a special case of a linear-fractional \
transformation:\
\>", "ExampleText",
 CellID->570860373],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m", ",", "v"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114474269],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AffineTransform", "[", 
   RowBox[{"{", 
    RowBox[{"m", ",", "v"}], "}"}], "]"}], "\[Equal]", 
  RowBox[{"LinearFractionalTransform", "[", 
   RowBox[{"{", 
    RowBox[{"m", ",", "v", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "1"}], "}"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->84362392],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->127426155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->181114794],

Cell["The composition of affine transforms is an affine transform:", \
"DesignDiscussion",
 CellID->624776954],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m1", ",", "v1"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"a1", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], ",", 
       RowBox[{"y", "[", "1", "]"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108354421],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"m2", ",", "v2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"a2", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], ",", 
       RowBox[{"y", "[", "2", "]"}]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38156088],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{
    RowBox[{"AffineTransform", "[", 
     RowBox[{"{", 
      RowBox[{"m1", ",", "v1"}], "}"}], "]"}], ",", 
    RowBox[{"AffineTransform", "[", 
     RowBox[{"{", 
      RowBox[{"m2", ",", "v2"}], "}"}], "]"}]}], "]"}], "\[Equal]", 
  RowBox[{"AffineTransform", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m1", ".", "m2"}], ",", 
     RowBox[{
      RowBox[{"m1", ".", "v2"}], "+", "v1"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->323882477],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->45312436]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->44580134],

Cell["Nested transformations of a circle:", "ExampleText",
 CellID->2227832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"GeometricTransformation", "[", 
      RowBox[{"#", ",", 
       RowBox[{"AffineTransform", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{".184", ",", 
            RowBox[{"-", ".6"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"1.16", ",", ".6"}], "}"}]}], "}"}], "]"}]}], "]"}], "&"}],
     ",", 
    RowBox[{"Circle", "[", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], "]"}], ",", "25"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136469131],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{162, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161886461]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26489],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["GeometricTransformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeometricTransformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LinearFractionalTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearFractionalTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TransformationFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TransformationFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RotationTransform",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RotationTransform"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ViewMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ViewMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->159]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->444806433],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->33894454],

Cell[TextData[ButtonBox["Geometric Transforms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GeometricTransforms"]], "MoreAbout",
 CellID->454330920],

Cell[TextData[ButtonBox["Graphics Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsTransformations"]], "MoreAbout",
 CellID->383134286],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->62268364],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->804118584],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->208264096]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AffineTransform - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 38.4074572}", "context" -> "System`", 
    "keywords" -> {
     "affine transformation", "geometric transformation", 
      "homogenous coordinates", "linear-fractional transformation", 
      "linear transformation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AffineTransform[m] gives a TransformationFunction that represents an \
affine transform that maps r to m.r. AffineTransform[{m, v}] gives an affine \
transform that maps r to m.r + v.", "synonyms" -> {"affine transform"}, 
    "title" -> "AffineTransform", "type" -> "Symbol", "uri" -> 
    "ref/AffineTransform"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8318, 248, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->412435521]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 45752, 1414}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2780, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3403, 85, 1580, 37, 70, "ObjectNameGrid"],
Cell[4986, 124, 1546, 50, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6569, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7047, 196, 379, 12, 70, "Notes",
 CellID->108862120],
Cell[7429, 210, 383, 15, 70, "Notes",
 CellID->60721000],
Cell[7815, 227, 466, 16, 70, "Notes",
 CellID->518398028]
}, Closed]],
Cell[CellGroupData[{
Cell[8318, 248, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->412435521],
Cell[CellGroupData[{
Cell[8703, 262, 148, 5, 70, "ExampleSection",
 CellID->184203171],
Cell[8854, 269, 76, 1, 70, "ExampleText",
 CellID->262588348],
Cell[CellGroupData[{
Cell[8955, 274, 697, 24, 28, "Input",
 CellID->562065775],
Cell[9655, 300, 673, 24, 66, "Output",
 CellID->656400027]
}, Open  ]],
Cell[10343, 327, 60, 1, 70, "ExampleText",
 CellID->67686513],
Cell[CellGroupData[{
Cell[10428, 332, 142, 5, 28, "Input",
 CellID->7611636],
Cell[10573, 339, 628, 23, 36, "Output",
 CellID->156500428]
}, Open  ]],
Cell[11216, 365, 125, 3, 70, "ExampleDelimiter",
 CellID->318566111],
Cell[11344, 370, 60, 1, 70, "ExampleText",
 CellID->304140537],
Cell[CellGroupData[{
Cell[11429, 375, 183, 5, 70, "Input",
 CellID->17437165],
Cell[11615, 382, 592, 19, 64, "Output",
 CellID->183565354]
}, Open  ]],
Cell[CellGroupData[{
Cell[12244, 406, 145, 5, 70, "Input",
 CellID->477868098],
Cell[12392, 413, 512, 17, 36, "Output",
 CellID->413201795]
}, Open  ]],
Cell[12919, 433, 63, 1, 70, "ExampleText",
 CellID->336263831],
Cell[CellGroupData[{
Cell[13007, 438, 334, 11, 70, "Input",
 CellID->47691607],
Cell[13344, 451, 457, 16, 64, "Output",
 CellID->223084912]
}, Open  ]],
Cell[CellGroupData[{
Cell[13838, 472, 145, 5, 70, "Input",
 CellID->368882807],
Cell[13986, 479, 298, 11, 36, "Output",
 CellID->22008038]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14333, 496, 219, 7, 70, "ExampleSection",
 CellID->53795577],
Cell[14555, 505, 77, 1, 70, "ExampleText",
 CellID->5908750],
Cell[CellGroupData[{
Cell[14657, 510, 383, 12, 70, "Input",
 CellID->239856774],
Cell[15043, 524, 503, 16, 94, "Output",
 CellID->250487215]
}, Open  ]],
Cell[CellGroupData[{
Cell[15583, 545, 164, 5, 70, "Input",
 CellID->135471106],
Cell[15750, 552, 349, 12, 36, "Output",
 CellID->494861721]
}, Open  ]],
Cell[16114, 567, 65, 1, 70, "ExampleText",
 CellID->656649796],
Cell[CellGroupData[{
Cell[16204, 572, 111, 3, 70, "Input",
 CellID->404415642],
Cell[16318, 577, 641, 22, 104, "Output",
 CellID->69229159]
}, Open  ]],
Cell[CellGroupData[{
Cell[16996, 604, 205, 6, 70, "Input",
 CellID->69092502],
Cell[17204, 612, 370, 13, 51, "Output",
 CellID->112367272]
}, Open  ]],
Cell[17589, 628, 125, 3, 70, "ExampleDelimiter",
 CellID->131638136],
Cell[17717, 633, 80, 1, 70, "ExampleText",
 CellID->479507293],
Cell[17800, 636, 620, 20, 70, "Input",
 CellID->419323043],
Cell[CellGroupData[{
Cell[18445, 660, 687, 23, 70, "Input",
 CellID->150504143],
Cell[19135, 685, 630, 15, 162, "Output",
 CellID->3749890]
}, Open  ]],
Cell[19780, 703, 124, 3, 70, "ExampleDelimiter",
 CellID->56656449],
Cell[19907, 708, 80, 1, 70, "ExampleText",
 CellID->137131831],
Cell[19990, 711, 637, 20, 70, "Input",
 CellID->367829949],
Cell[CellGroupData[{
Cell[20652, 735, 879, 27, 70, "Input",
 CellID->167437831],
Cell[21534, 764, 5117, 97, 177, 1174, 28, "CachedBoxData", "BoxData", \
"Output",
 CellID->88332644]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26700, 867, 227, 7, 70, "ExampleSection",
 CellID->117606223],
Cell[26930, 876, 76, 1, 70, "ExampleText",
 CellID->304565429],
Cell[CellGroupData[{
Cell[27031, 881, 535, 18, 70, "Input",
 CellID->20217230],
Cell[27569, 901, 324, 9, 201, "Output",
 CellID->53388101]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27942, 916, 236, 7, 70, "ExampleSection",
 CellID->25816771],
Cell[28181, 925, 126, 3, 70, "ExampleText",
 CellID->56333249],
Cell[CellGroupData[{
Cell[28332, 932, 798, 25, 70, "Input",
 CellID->368495022],
Cell[29133, 959, 160, 5, 36, "Output",
 CellID->12974829]
}, Open  ]],
Cell[29308, 967, 125, 3, 70, "ExampleDelimiter",
 CellID->168903201],
Cell[29436, 972, 143, 4, 70, "ExampleText",
 CellID->570860373],
Cell[29582, 978, 390, 14, 70, "Input",
 CellID->114474269],
Cell[CellGroupData[{
Cell[29997, 996, 377, 12, 70, "Input",
 CellID->84362392],
Cell[30377, 1010, 161, 5, 36, "Output",
 CellID->127426155]
}, Open  ]],
Cell[30553, 1018, 125, 3, 70, "ExampleDelimiter",
 CellID->181114794],
Cell[30681, 1023, 110, 2, 70, "DesignDiscussion",
 CellID->624776954],
Cell[30794, 1027, 449, 16, 70, "Input",
 CellID->108354421],
Cell[31246, 1045, 448, 16, 70, "Input",
 CellID->38156088],
Cell[CellGroupData[{
Cell[31719, 1065, 534, 17, 70, "Input",
 CellID->323882477],
Cell[32256, 1084, 160, 5, 36, "Output",
 CellID->45312436]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[32465, 1095, 227, 7, 70, "ExampleSection",
 CellID->44580134],
Cell[32695, 1104, 76, 1, 70, "ExampleText",
 CellID->2227832],
Cell[CellGroupData[{
Cell[32796, 1109, 638, 21, 70, "Input",
 CellID->136469131],
Cell[33437, 1132, 7679, 130, 70, "Output",
 Evaluatable->False,
 CellID->161886461]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41177, 1269, 311, 9, 70, "SeeAlsoSection",
 CellID->26489],
Cell[41491, 1280, 1533, 53, 70, "SeeAlso",
 CellID->159]
}, Open  ]],
Cell[CellGroupData[{
Cell[43061, 1338, 319, 9, 70, "MoreAboutSection",
 CellID->444806433],
Cell[43383, 1349, 154, 3, 70, "MoreAbout",
 CellID->33894454],
Cell[43540, 1354, 151, 3, 70, "MoreAbout",
 CellID->454330920],
Cell[43694, 1359, 159, 3, 70, "MoreAbout",
 CellID->383134286],
Cell[43856, 1364, 161, 3, 70, "MoreAbout",
 CellID->62268364],
Cell[44020, 1369, 179, 3, 70, "MoreAbout",
 CellID->804118584],
Cell[44202, 1374, 198, 4, 70, "MoreAbout",
 CellID->208264096]
}, Open  ]],
Cell[44415, 1381, 27, 0, 70, "History"],
Cell[44445, 1383, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

