(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    255760,       5640]
NotebookOptionsPosition[    243342,       5211]
NotebookOutlinePosition[    244827,       5252]
CellTagsIndexPosition[    244689,       5246]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AiryAi" :> Documentation`HelpLookup["paclet:ref/AiryAi"], 
          "AiryBi" :> Documentation`HelpLookup["paclet:ref/AiryBi"], 
          "AiryBiPrime" :> 
          Documentation`HelpLookup["paclet:ref/AiryBiPrime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AiryAi\"\>", 2->"\<\"AiryBi\"\>", 
       3->"\<\"AiryBiPrime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["AiryAiPrime", "ObjectName",
 CellID->23186],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AiryAiPrime",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AiryAiPrime"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the derivative of the Airy function ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], TraditionalForm]], 
      "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14507]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->265854530],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->525072205],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->580576952],

Cell["Evaluate numerically:", "ExampleText",
 CellID->152726107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", "0.5", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27285712],

Cell[BoxData[
 RowBox[{"-", "0.22491053266468392`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221708835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->272077164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5587629],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->578066408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->467198663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->104402871],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{"1", "/", "3"}]], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["1", "3"], "]"}]}]]}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", " ", 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}]], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], 
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"1", "/", "3"}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["1", "3"], "]"}]}], ")"}]}]], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], 
    RowBox[{"30", " ", 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-3^Rational[-1, 3]/Gamma[
     Rational[1, 3]], 0, Rational[1, 2] 3^Rational[-2, 3]/Gamma[
     Rational[2, 3]], Rational[-1, 3] 3^Rational[-1, 3]/Gamma[
     Rational[1, 3]], 0, Rational[1, 30] 3^Rational[-2, 3]/Gamma[
     Rational[2, 3]]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{502, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110050886]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17604],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->177179144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68147727],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.0018792086096351543`"}], "+", 
  RowBox[{"0.03102762428412435`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13631000]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->103032914],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->441374880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", 
    RowBox[{"5", "/", "2"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->521453795],

Cell[BoxData[
 RowBox[{"-", 
  "0.0262508810359032303648954962972325094463178381357707164354993259688`49.\
999999999999986"}]], "Output",
 ImageSize->{383, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->742482060]
}, Open  ]],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->362205240],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", "2.50000000000000000000000", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->758297733],

Cell[BoxData[
 RowBox[{"-", 
  "0.02625088103590323036489549629723250944`24.329737698114773"}]], "Output",
 ImageSize->{201, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->722087964]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->971875072],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->129651381],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8513118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.1327853785572263`"}], ",", 
   RowBox[{"-", "0.09738201284230133`"}], ",", 
   RowBox[{"-", "0.06852478011861093`"}]}], "}"}]], "Output",
 ImageSize->{239, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92237967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136399151],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->464487210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304690627],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{
    SuperscriptBox["3", 
     RowBox[{"1", "/", "3"}]], " ", 
    RowBox[{"Gamma", "[", 
     FractionBox["1", "3"], "]"}]}]]}]], "Output",
 ImageSize->{101, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->398927421]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->567607451],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->87281018],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58376630],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", 
      SuperscriptBox["x", 
       RowBox[{"3", "/", "2"}]]}], "3"]}]], " ", 
  RowBox[{"(", 
   InterpretationBox[
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SqrtBox["\[Pi]"], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"1", "/", "4"}]]}]]}], "-", 
     FractionBox[
      RowBox[{"7", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"5", "/", "4"}]]}], 
      RowBox[{"96", " ", 
       SqrtBox["\[Pi]"]}]], "+", 
     FractionBox[
      RowBox[{"455", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], 
        RowBox[{"11", "/", "4"}]]}], 
      RowBox[{"9216", " ", 
       SqrtBox["\[Pi]"]}]], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", 
        FractionBox["1", "x"], "]"}], 
       RowBox[{"13", "/", "4"}]],
      SeriesData[$CellContext`x, 
       DirectedInfinity[1], {}, -1, 13, 4],
      Editable->False]}],
    SeriesData[$CellContext`x, 
     DirectedInfinity[1], {
     Rational[-1, 2] Pi^Rational[-1, 2], 0, 0, 0, 0, 0, Rational[-7, 96] 
      Pi^Rational[-1, 2], 0, 0, 0, 0, 0, Rational[455, 9216] 
      Pi^Rational[-1, 2]}, -1, 13, 4],
    Editable->False], ")"}]}]], "Output",
 ImageSize->{371, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19639742]
}, Open  ]],

Cell["The behavior at negative infinity is quite different:", "ExampleText",
 CellID->22276],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Infinity"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25759],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"-", "x"}]], " ", "x"}], "3"]}], "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox[
       RowBox[{"7", " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"3", "/", "4"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["1", "x"], ")"}], 
         RowBox[{"5", "/", "4"}]]}], 
       RowBox[{"48", " ", 
        SqrtBox["\[Pi]"]}]], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"3", "/", "2"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[-1], {}, 5, 6, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[-1], {
      Rational[7, 48] (-1)^Rational[3, 4] Pi^Rational[-1, 2]}, 5, 6, 4],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "4"}]], 
        RowBox[{
         SqrtBox["\[Pi]"], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["1", "x"], ")"}], 
          RowBox[{"1", "/", "4"}]]}]]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], 
        RowBox[{"5", "/", "4"}]],
       SeriesData[$CellContext`x, 
        DirectedInfinity[-1], {}, -1, 5, 4],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[-1], {-(-1)^Rational[1, 4] Pi^Rational[-1, 2]}, -1, 5, 
      4],
     Editable->False], ")"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{
     FractionBox["\[Pi]", "4"], "+", 
     FractionBox[
      RowBox[{"2", " ", 
       SqrtBox[
        RowBox[{"-", "x"}]], " ", "x"}], "3"]}], "]"}]}]}]], "Output",
 ImageSize->{583, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->93153712]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->686962333],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->89086006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AiryAiPrime", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->422133542],

Cell[BoxData[
 FormBox[
  RowBox[{
   SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], 
  TraditionalForm]], "Output",
 ImageSize->{33, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->448270952]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->208272636],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->284910746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", "x"}], "]"}], "+", 
   RowBox[{
    RowBox[{"O", "[", "x", "]"}], "^", "4"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227782221],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["3", 
       RowBox[{"1", "/", "3"}]], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["1", "3"], "]"}]}]]}], "+", 
   FractionBox[
    SuperscriptBox["x", "2"], 
    RowBox[{"2", " ", 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]], " ", 
     RowBox[{"Gamma", "[", 
      FractionBox["2", "3"], "]"}]}]], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"3", " ", 
         SuperscriptBox["3", 
          RowBox[{"1", "/", "3"}]], " ", 
         RowBox[{"Gamma", "[", 
          FractionBox["1", "3"], "]"}]}]]}], "-", 
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"2", "/", "3"}]], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}]}]]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"1", "/", "3"}]], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["1", "3"], "]"}]}]], "+", 
      FractionBox["11", 
       RowBox[{"24", " ", 
        SuperscriptBox["3", 
         RowBox[{"2", "/", "3"}]], " ", 
        RowBox[{"Gamma", "[", 
         FractionBox["2", "3"], "]"}]}]]}], ")"}], " ", 
    SuperscriptBox["x", "4"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "5"],
    SeriesData[$CellContext`x, 0, {}, 0, 5, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-3^Rational[-1, 3]/Gamma[
     Rational[1, 3]], 0, Rational[1, 2] 3^Rational[-2, 3]/Gamma[
     Rational[2, 3]], Rational[-1, 3] 3^Rational[-1, 3]/Gamma[
      Rational[1, 3]] + Rational[-1, 2] 3^Rational[-2, 3]/Gamma[
      Rational[2, 3]], Rational[1, 2] 3^Rational[-1, 3]/Gamma[
      Rational[1, 3]] + Rational[11, 24] 3^Rational[-2, 3]/Gamma[
      Rational[2, 3]]}, 0, 5, 1],
  Editable->False]], "Output",
 ImageSize->{482, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->402238362]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7768],

Cell[TextData[{
 "A plot of the absolute value of ",
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " over the complex plane:"
}], "ExampleText",
 CellID->289597052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{"AiryAiPrime", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "8"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->40481414],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147598443]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11388736],

Cell[TextData[{
 "Solve differential equations in terms of ",
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->43417108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "9"}], " ", 
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{"w", "[", "z", "]"}]}], "+", 
     RowBox[{"9", " ", 
      RowBox[{"z", "^", "5"}], " ", 
      RowBox[{"w", "[", "z", "]"}]}], "-", 
     RowBox[{"15", " ", 
      RowBox[{
       RowBox[{"w", "'"}], "[", "z", "]"}]}], "+", 
     RowBox[{"20", " ", 
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{
       RowBox[{"w", "'"}], "[", "z", "]"}]}], "+", 
     RowBox[{"15", " ", "z", " ", 
      RowBox[{
       RowBox[{"w", "''"}], "[", "z", "]"}]}], "-", 
     RowBox[{"10", " ", 
      RowBox[{"z", "^", "4"}], " ", 
      RowBox[{
       RowBox[{"w", "''"}], "[", "z", "]"}]}], "-", 
     RowBox[{"6", " ", 
      RowBox[{"z", "^", "2"}], " ", 
      RowBox[{
       RowBox[{"w", "'''"}], "[", "z", "]"}]}], "+", 
     RowBox[{
      RowBox[{"z", "^", "3"}], " ", 
      RowBox[{
       RowBox[{"w", "''''"}], "[", "z", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270396206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"AiryAiPrime", "[", "z", "]"}], "3"], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"AiryAiPrime", "[", "z", "]"}], "2"], " ", 
      RowBox[{"AiryBiPrime", "[", "z", "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{
      RowBox[{"AiryAiPrime", "[", "z", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"AiryBiPrime", "[", "z", "]"}], "2"], " ", 
      RowBox[{"C", "[", "3", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"AiryBiPrime", "[", "z", "]"}], "3"], " ", 
      RowBox[{"C", "[", "4", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{455, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->466978291]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30709181],

Cell["\<\
Solution of the time\[Hyphen]independent Schr\[ODoubleDot]dinger equation in \
a linear cone potential:\
\>", "ExampleText",
 CellID->138136831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{
         RowBox[{"\[Psi]", "''"}], "[", "z", "]"}]}], "+", 
       RowBox[{
        RowBox[{"Piecewise", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"z", ",", 
             RowBox[{"z", ">", "0"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "z"}], ",", 
             RowBox[{"z", "<", "0"}]}], "}"}]}], "}"}], "]"}], " ", 
        RowBox[{"\[Psi]", "[", "z", "]"}]}]}], "==", 
      RowBox[{"\[CurlyEpsilon]", " ", 
       RowBox[{"\[Psi]", "[", "z", "]"}]}]}], ",", " ", "\[IndentingNewLine]",
      
     RowBox[{
      RowBox[{"\[Psi]", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"\[Psi]", "'"}], "[", "0", "]"}], "==", "0"}]}], "}"}], ",", 
   RowBox[{"\[Psi]", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207762545],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{576, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->60236740]
}, Open  ]],

Cell[TextData[{
 "The normalizable states are determined through the zeros of ",
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 ":  "
}], "ExampleText",
 CellID->27343431],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "n_", "]"}], ":=", 
  RowBox[{"x", "/.", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"AiryAiPrime", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", 
           RowBox[{"Pi", "/", "8"}], 
           RowBox[{"(", 
            RowBox[{"Max", "[", 
             RowBox[{"0", ",", 
              RowBox[{
               RowBox[{"4", "n"}], "-", "1"}]}], "]"}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "/", "3"}], ")"}]}]}], ",", 
       RowBox[{"-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", 
           RowBox[{"Pi", "/", "8"}], 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", "n"}], "+", "3"}], ")"}]}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{"2", "/", "3"}], ")"}]}]}]}], "}"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->185972111],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"n_", ",", "x_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"-", 
       RowBox[{"b", "[", "n", "]"}]}], "]"}]}], "/", " ", 
    RowBox[{"AiryAi", "[", 
     RowBox[{"b", "[", "n", "]"}], "]"}]}], 
   RowBox[{"AiryAi", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"x", "^", "2"}], "]"}], "+", 
     RowBox[{"b", "[", "n", "]"}]}], "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->230468774],

Cell["Plot the normalizable states:", "ExampleText",
 CellID->173137172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Prepend", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          RowBox[{"b", "[", "n", "]"}]}], "+", 
         RowBox[{"\[Psi]", "[", 
          RowBox[{"n", ",", " ", "x"}], "]"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"n", ",", " ", "0", ",", " ", "12"}], "}"}]}], "]"}], ",", 
      RowBox[{"Abs", "[", "x", "]"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", 
     RowBox[{"-", "16"}], ",", "16"}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->650529424],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->297497972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->633813267],

Cell["\<\
An integral kernel related to the Gaussian Unitary Ensembles:\
\>", "ExampleText",
 CellID->180352770],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"AiryAi", "[", "x", "]"}], " ", 
       RowBox[{"AiryAiPrime", "[", "y", "]"}]}], "-", 
      RowBox[{
       RowBox[{"AiryAiPrime", "[", "x", "]"}], " ", 
       RowBox[{"AiryAi", "[", "y", "]"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5.5"}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->339338037],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJxsXXV8FFcXnWzWXRKKEzwFikux7uKuxTV4cXdbtLgXKBqguDsUmUtxD1Ag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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mXtsl+UVx9/aC797aX9vN1GRCWIGaoKZtplCGYvCvESRUgGBQUFARGHo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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmlsVFUUx29LO9MpM/P65r0qpWBtC0SK3xBUliIuGCABoUJQQNoClrUN
1BQX4gIGt0CCBISugKwlbtFEI1VbJUGrjVHBD+BCIZIYQYGCCVCKv5O/H07m
nnf2c8/53ymsrJlZne6ca4EyoJKkc7tD5yZnOlfez7lS+C/gZ8K/CD8k17mD
fGvOdq4J+s5zrhW+hfNadGbFnVvCtxTnLdCEhHNXAvmKEOgBfO3g22cx59qg
Gynn8vG5FftpWc7dx/kkPlalOfcH344hvwZ/B7LhUBa+otAczo9B9+KrB36l
+cKmKMe5YqiL2H3wAfFSUB6xO9Hfg6+lgc7ZyA/A18D/BJ8Dfzdnz3eujHzX
8S0N/iY5jKE5j8B3wn8NHUV3AjHPUXsx/ps570XnNLWf8VR7BP4m5z5oGP66
M2Q7G/2umHzcyXkNNZST31p0Kqi/PFe5ze7v3Pfk5wLFbsL+MOcL2CynNyX4
mMH5few/xH4sfBm5jianOnz1Qk8hm0E9v5LPPNNBfww0D7cfoT+Tc1moXvLj
PiXecXyUwG8j3g/4+hEaje3t0C5ky+C78F2A/OeUYloss5mEk0ZiduC7HRrP
XVRSz3xqOUUOU5DvQl6Prx7sTyK/FYpRz6KIc1X06knrl1MNl9BfT7wa5NVQ
AlnSU29Np4d8vwl0F/+gPyBUzpbrmzHN4hx0FmZpJrutFk930QxVkstgbN5C
dwd0nloa0MnL0A5cjWsGbfam8u0Uut2hZtV60Il9BfwJbFeQzz5sTyfl+7lM
zUYrPk5kaUZsdvviuiub4UHIy/FxP/keov76hHbEduNz6DbrJ/qX8L0dfiy9
WpCr2fglU7sxBf56tnbkeex/S+ru9qPfi/1W+GeQPw1dgd8Iv5rzKmgotmVx
3b3t9AvUehxmBuffo+wj5wlmwzx+gr9BzNI92HQiryCH+fTyCFRrvcLHO/ha
lCtZITabsR1JzZP66Y5v8VWD5b43orvtwH5Vpu74ZXTXQwvoR0W6sMUwx7DG
MKYN2UViHLD9wD4LWUtSs2g1GpbYztiuGKYYlhSEulvDlMX0pyjUrk3CfxX+
dsWV+1H6ty6pmbNZsxh16I8INauW0070W6AGzo2Qj/4N5M+iPxGfG5C9Eih3
2+kL2F+n5tfJNUS+hNrnwp+BX478LLEfCnXXm4l3DP5bT1jq+NaQ0E7ZLl3h
07sJYaRho83MLGQf8O3jdGHKOPjxoXbb7iyPXObicxS2rxFzFPHziH+Qczcx
RsLn+roLw4j91JMeaHYN8/I5D4SW0ptl0G5iTQ31FlgP9pHrSmyqsvVGVFu8
hHbPMHUquU7O1W7bjD7uKweLbT0w3z3oX44pRn9fGG7Y3YB8FrJivk3MEAZl
cS5hRrdEhfl1to8JYeHfMe36New3RP7f+UA6JquEb4RvCnR3hkFvoL8mLqy3
N8Owahz2T/QXZnnUFwSytR4WEOtf/NVSy1lyXMv5Bjn9maYaDEsqEtpVwxTb
paHkuymqnaqx9wF5HrEGZOru2og/Iqo7fM/XjNhs2LfA0x1Y74/Qg7eR7/Y1
CwVR7dZdgXplO/ZwqJmyWTIMHkbsISnNpuVgb8dFaEW23pB2Txhq2Gk7aNhQ
7Sk3w4hNSWGGYYXVPI3zdGhwVG/IHpsdX7nUETOf8/SEsKw1olgvJbWrFtNm
5S++Lc7WzNjd1geadbvjw+SyCf4y9ZamqVcpT7Vbz7YlhWmGZbZzRch76der
Ee2YnQsTmnX7NjwlTDMss5m5jvxqju7OZuRLfH/lCdsP8207tqWhsM4wdyHn
ylAyw/jznM+Fys1qWMi87I/rv4PNTMzXfxL7L2JvyMZAmGxYbDXtRN7iq1fW
w1rkqwNhkb0R7fjuCIVF9p+lGNu+HGGHzdghbFt9veX25g/09cba22o7bdg8
2FfvDaPtv0xpQv+97D/Ng/h+1NNbZf/B/gPbrlkQ
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.37091261028077777`, 0.1921500761560536, 0.6383428607478178], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFm3m0VMW1xvv27Xt77r49QERwAI3ARWKCqJdBRY0CivrEKEnIAJg4EATN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxu8U5r2Zef3eQZABBSwzFE0EsaGgkaX0IoiKRkoENVQbFlzS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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4672304907913043, 0.3596208582752561, 0.7737292936692528], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeUldW1x7+5M3Pnzsytcy+CCCr6DCSgRMUGYsGAiDTzjIJ52JKHBVQU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHeUVdUVxu+UV2Z85b73LoqgAhqjoYgiGIGYRBAEpChRigYFK9IJDEWJ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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5635483713018309, 0.5270916403944587, 0.909115726590688], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXu01lMax3+d23vOe97r7/ceRWaSSkU3RlgzpZuJwdQJI8UoLTEiQ1Kh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHmQ1NURx397zc7uzsxvZ36zLoIKyKlyGlEr4XRR1MgRDxBiAVKsFoeE
Qw6TsBJKFEisAAERJMqRCqAcIsdCJRweKIhgUoEgVgRSXBIFdiNyKubzzXf/
6JrXv+7X3a9fvz6m8ZBfPDwqNwiCpjlBkM9vujQIMsD2giC4Oy8I3koFwd4w
CPqCV8CwOhMEa4DOsSD4ORtHsB4J7CkMgqXwR6yzwCb4G4EfSQbB1+kgKAfP
Ax+RCIIk8reAD0VfKbKrgKaSD/41/M+BNwRPwz8X/K5sECxE9zT07caehdC7
Q+8B/UlkDwHi2DNSdOQfheevrHtypims38WelvCfhr8K/C/g+fCfAs8ivxB5
v4P/EPyDoS+AXgR9B/RHoiB4FOjK+jz05di+AtiQbx0F8M9j/0boHYDfo781
9APoW8R5emFbb+AKeH34P5KvgJvjQXAB/i3or4b+AbT3gXrI6wR9Mf58EPo0
8A/AB2DPf+UP1q8CNYW27150P46+q8hvj32z0N8T+mror6N/PLInAPXZPxX5
5cjrBn1Znfz67F0gndjzETK2wvsu0An6bvgvcvZ1+L9NcRCMLQqC6egbjo4J
8LeF/ziyjmV817rTQGcHBqJvAPx5yJ7O/h9YV0JeC29FGfdc7Bg6ga6noR+F
Xou+ach/AXgU3sn4+Cz+KQf/kHVz5DcHnxJ6rW8TQseQYkcxcwv2vli3fzw2
lsM/VDzQtsO/Al23gC+G3gwbfon+jthzqNg+Gs+6O3tKsOVgCb5O2UfyTUfk
nYB2jj1D8U8DvlWjrxd7rrG/D/unKB7xTw70XGAf5+0B/QL0IdD/Cf9oeL5h
/RBnroF+DuiP/+5B/mXWlzJ+Sw+An9PZSy27N/wbsGc9sI277oONr3OelvDM
4TzXo+M88jtiYz60Psj4FF3d0X8W2iMx+64Z9J11/qxG9gOh7/o+6NvTjgHh
HbH/KvKq0XE7+0fJRvBuwCxsmw3cybpD5Le4B5k9kRVH/hrWF4G7oU3CH5MD
+7AvtrTB/kr4ry+x7nFJ5xLpnAn/DKAG2bVANbwvQL+CrLHAvdCqEn5bf4C+
B9opeJZCK0L+FWy9CjyLvd/go5mK1YR9sSZuWSc53xOFlrkKeVsU0+yth3+P
wVsLvRJ6Fnw9sgbCU4ptbZF5FtokvtVAK0bmRtaDoKeht4d+mfUGvrVjPQ6e
Wdj2K+TfjPx26L+BdS73O0HvC/1dIvtEvljLtxbYtwueiQWmvwl9NXfUhbsp
R97L2Pca8rPIn40PyqGfhX8J/E8h/1bWx9G5hL0HgDPIy4a+b+XYfsh6rNT5
SDmjt/I78u4vts/7Q6tOOJeI5zK0S1m/Xfn0HuS1gecgtKXYlIs/WiXt63b4
I5ez5JU5ll9mz4mU70h3I5s2KNbZ8yNoITyjod0W2tYDynFp+1i+1R3sgzYW
GcPYX6UaErkmqRY9zP592LIXeBP9b0Dvj+0rlN+hLdKbh7at1LleNegU9Apk
fsX+n6CvA7beAWS4v1fi1vUk9FSBdW6Gf1vab2Eee9aUOmYUK13ZvxreTSnH
5gD4x3CeAfB8z/pz6BXgbcE/A18W89tpC3+TYr+hp7F1PP49g7yP0dEK3m7s
WRJzDVkP/dmUfZWKO1ftSri2KWcpNlal7AvFyHPYOi/pWrkfGAQ+MO3aeBz6
uJR9Kl8q5hULugP5Xve9H/xb5A+KOYdrvQsbGsf9LYasO/Ue0d8bn+bB34wz
jYOexAej4G8YOheoh1jI2ZqjswxbI6AW3seAq+wfwZnfgzaVPU0C5//hyLvE
t7X5rsHboM1Tjiw0rrexM+XaoDciWX0jv23JrIU+KOF6oJjfyvpinTz1CJU6
H/iq/LoeIO0aJN3KCb9GV73Ib0kyvoT/OvDKuGNWteN+8Plx1xDl3orIuVA5
eBXnXZ11bgpzvfd0qWNTMv7G+lOgf8w1/Qjr9+C5C18MA/8ze/dhXyLXMXJN
tROYzN5O+Ht+6JqkWtRNMQZezP4B4Pmc6X3Wh5G5Nccyd2fcc6jX0B12jpxD
lDtmgn/P+t/wj0D3cKAH9PsivwWd8XHk9wtda/RmxuCrmdz/+ZhrWCNs6Yz8
JYXuKSrU2/CtX55juCt4l4xzgXgUC82R9/d8x0QLnUU5H13Xgc/PuMaqtqrH
6cD6GWJ+Rolj7o+qdynXunpAUdI1R7VGd9ws5ZhTrClH6u4VQ4od0Ycjfxjw
4xz3rDPhnZF1b6cepQraM/B/Ae0w0BG8QcqxLpufgjcRupdQz/ID+r+ApwP2
31HgXKycr1yvnFyLb6Oke8sqbDic8ZvRW9Ee9UKn0Tc3xz1Rnu4KGQ3yXCOU
O3plXBuUQz7OWKd0qYd8CHwgMh4scU5Wr3EReety3HMot2yEpzTuHCNfNtGd
5NmnE6GPCev8DT2WdE5TLtMbac1ZMmnnLvWUuqtOkWNHd/YJsvZm3NuoBy7S
3cgfdfPDylLHuGJbPe4KZK1MO9ZUYy5g60Hog2O2+SCyP4vcG+mNyBcFyJtY
aJ9MBJ8UejZQzp+e8Eyg/kM9xo3svSly71WPb99BP51y762eKdR7Rt7UQvfr
3yKrEHxSnfwbwW8CEvnuIdVLvgSU1OFXWX8XuvcVj3qDS5F7Y/UIPZLumdQr
qaaoN7gSuRdQj/BTbOmTdm3YWei7U8+uXl13WAa9VcZvW2caDb4u49rzOXgs
dEwplo4gbw70f2XcK8jGQdAHh84FqAz2omtf2r2fZpwzyufs/xn4UvzRWr19
1rWhjXrujH0k3+gNjIO/JnKu1gyk2voE3/LirrFB6J5JvZJmoi8znjE0W2im
eC30TCNcOeEatlxI+m40k+Vn3NOrl9cdxzLugXQe3cmrqsUp5z7F7En5A33n
C9zztQJfhv0NifXGQBn7g5TjT3e8XL1Yyr1+U+A21um0e5dG4O1T5hGtebFl
iUc0yVygu066nmnm1Nv/KlHXK/OtMuGcoVyhGqjaPwV/nYy7B9AssSjr3KaZ
ohG0hpFjTWeuwZbTofsdzRSaJTZFrt2aKZpiy5+yPptmhDdYL84696nH19s9
pPxW5Df8IXt3Ru5NlNNvV2wmPGurhvwm8syotycbt4FvjTxbqkdV7VmZtS9U
g27gbMUpv2X5QLb+J3RvJZvl6/rwvFhon89V7KUcP8I/4Xx70p49FXM70p7J
5DvNmG+z963Iva1yoHrn2Qn32uqh3wF/GxiZ5xl0P/v/kXbsK2c0RFeDuvlM
M3MR65aRZz/9B/EO8sek/HbU0+0Afz7l/wL0n8L4lHss9VbKkQ0y/g9E59WZ
bo3c46q31cy7CVvmJNzrayb6/2yV8FvSjHUMeZvVI7F3seIjdI+j/kIz6CZo
m5Oe9RXDz6c9M2tW1sx4Bvxo0v+VqMauDJ0zlCv0H4xq128jz0aqYa9k/J+A
/gtQj7QU2pJS44oJ+W5t1r2IfKhev0/KvaZ6ftmqnli9sGxuEXoG1uyrGW15
xjOoZk+9ec0Smsk1O6q/iuDNlnlWVQ/3P+vQYaE=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6344364468639039, 0.6410250236241083, 0.9111085590331172], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQVcUVxi+zvWXefe/d+2ZAMRBRATcIiBqNBJVVENBSwQXRCNFEiATE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHu0zWUax3/n7LPPhf3bl9/eB6NI5RDF6rg0UxoRDiHTMuVOg6mZphiX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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7052523762154471, 0.7548065173501095, 0.9127229441062888], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXeQ1dUVx39v971921777VtjEikiauI4YERAWcsYUYpilMFAECxgiTN2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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmGl0VdUVx2+SlzyGd9979+aFSgsIwUrrcklQMUhqXSrzpE1RWUy1DFqL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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7746986124034293, 0.8510222271836242, 0.9086247204574449], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQVNUVxt9Mz3RPM9Pd7/XMRKFwN6kYFJcowa1AiAYlgqyKoEFAUUEG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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3mw1WUZx9+7nnvw/M75/c45N5QxFqmmQkHNAAVDrmkYoSyBK8QWi2mX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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8382961233138292, 0.8722303024565538, 0.8801330925613903], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmX2UlVUVxt+583Vn5r537jv3Xj/QFuJalKQuB20llAKDmpbZElDzgy/5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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmw1WMYx9/O7dzqdn7nnN85v5NthmkmLRIlSxkqpcGU0aJNErnpphV1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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.901893634224229, 0.8934383777294832, 0.8516414646653357], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl1+MXVUVxs/cuXfuzL333HvP3HPbB60MmZm2mlCkoiVEaY3UB7VB2kG0
2GlCR6n4h6QpTB0DqY0ottWO0qCNkmj/TGfsRKrxwcALUWpECm0ogg8tLdIB
6VCr4IMjYPx+/dYkPpzsffZZe+2111rft9a58va71n6tkCTJ9o4k6dQ4W06S
1/Xker+9miQLakmyTfNd+ni+mCTLJZzq/QqNfZJfW7TMgNa+rfn1BX+7tpEk
7VaSnNXamjRJbtB7v9Y3SefCmnXv0belRZ/1kPS/T/NBzf9d9b6lkh8rJcmn
9SzW+72SebfWXtG5b0jmTT0v6z3XOKenFfvY/9+C9Q38n865WN/YKzub0iO9
Z/T9X1q/qPUsdDb1vFD0GejnnTlnv1XwPbj7VNV7Bws+mzOwGX8sDJ/c12nb
sflqrZ2TzA+09mK3529rfZG+v0fP/R1eeylkHpOuJ7X2fsmc7fY6+zZr7ZlY
/5L8eqeeVsl7z4bOd7T3SNj2LZ37obbPuE1r6/Ucl55JvT8aZ3CXAclNavyF
nv6a9+KHCwXf/bIvi86H71Q8H4gYLoo4TsbeWdlwOkuSk4r9UNm6+0P/o7rb
dNU24n9GzuL7QJyL7cj0dtieIzG/SbruLzkuyPONs4gfd2hIpi/sYB19U+EH
xsmQ+YZyc0zPuW7fbyLiy3Oo6njhr5tKjst19SS5p+13ZA9XjYMVHZZnfkBx
uLvlfL1Zz7Ka4/gI99a3xR2+w5KCY/eEzh7X3jUF5xe+5vwLXUmyU/Mtmh+U
nw9UnFfkdtrpebnqveByl9Y/WrDeq3ROrWVd5AI2kIPYOBF2ko/YCJ74fnXY
Sf4wZ9+UZIZLzo2jmm8qOeeI/QnJjmrcrLWTMd8RceJ+5D44J/+/LFvu1PO0
7voJYe6L8uFI1d9HQgZ96ELPTMncMBp6FgRXcP6viraBEWwwv0V6X9e3DVo7
ULCtrOP/seANzr4tcp7cZ75IsnOK6X/q3jP/jbjj71NV4wzfrQ95sE6+DgZm
dgQG9xcsfzHx+FzMiR1z9HGPtYEd/Ar20LGx4rvjg5nwQY+e412Wxz/DRc/h
MXC2IbD2V+HrdMO5//2iORR+/rn8fW1mnMHZO2MdXt8Te6cDh8QL+1rBXb/V
2org+K9Iz1f1nJRvHtQ4qvhN6/vnhOnFmbn+NY3nG+ZVeJ818DWmcXfRfgAr
6EUnXN0OHoaP85iTv+huSebHOmsw8548eJ316fn3DvuAuHOXfZ3mbvyWBX8z
h8uz4HByvRkY/4ti/kLdvgBnKwvmCvRujpgeiPzifYPu+wHZsyriTLxZH+q2
HfADtsyGPeOdri3YcEHjDzt9xmr574jy4FLJdvWGbXMlz7kHmC4HJ9yqcwcy
x2Nvp2NMHNE9E/qXy/dZy3lJrM+XHG/yBT3kDFgDQzPBSWCDvF5dsS1gP8uT
5Eqd9esu8wjxwB/k8KGK40guH4w5voB3kJ2oeJ384R5zwc/7qDuZ5aj/p+qu
nf/QeKluDIDjqcDCOvnnjrb3D+vuH8zCjsAQ9lBvhgML1B9wA6bWlc1b3At/
Uw+p1XASOJ0N+0+Frn/q/DfqPns0cgh/EsOJuMsD8uuIbPpZp/Oakdx+p2wb
2QNHk0PoB0/4BUy9Ld1v1c1VJ7pdJ+gZ4GHm8ExNd031PFBxjOmfwNDC3NgD
dysrjvve6I+QxQf7pXt13bWXnKGWUAty7f1RzbrWhq/wz/OSHc+MSfqIc9FL
sP+bFfPKUMnn9Hc4z+AT/Iy+JZl1XoraRs68K3eMie/vyvb5fK4zUoe36h43
No2Jhu7a1LNb590oe7Zqvl3zD0v3DZk5b0Q6n0ldk98bNmEPXACPsP43yfym
5jjwfVXFdnMmMe8L+3fGXf4u+YO95qT5PhL/wwf3Rtz/KJkn9Xws/M34UHD/
fSEPT2+quOZx/ua2bXhN+y7k/rYkcAOHUG8PBees6zZfwBXU2GVRZ+nrwCH+
PCYdf8h9n1fJgbrPujnqGHYcif5sMPLu8S77e6V8PFUz39DTXVV2bj6utevb
fgcj6KCWzTTco9NTLCv7O/uukb7esvkP/iCH1gRH0XuB66r0VdruAVs9ku/x
vbgjc/xMj0YPgjx5DAb6o25yDpik9+L+l/ui4GowNRk2IfeK/DCTu06yZ0tw
9dLM+ASTL4Uf8SHji6HzcPQ85MyZhrkSnlyRuZ5RT2a19mrqvgrb10WMrog6
BmaHo8/dFv9EjHDG9yrOP/IUnx2NHmRX1NvB4H+wQW5u1T1Op+536SX3N9xP
koPjkYdwOxwMV4NVag18S99KXjeCo2bjH+1i2fM0cNcXXHc8OKfe4ZhiF7rg
PmpXK+KwJWLRl7kGcPZh+eZSbn80W7Ybm6n561NzIZyxPXgDbH296bi/LNnz
eobBeMWcBY42xD8CvqWe4GfuBYcjC4/D/UNN5xq2p+H/N+P/C7zOxX8WNWFv
+BmM05vR39MLgbNbojbP/w+ghzPHwp/l6J2JETxUCi667KOo72BvX/S3x7pd
X9mzI/p4ME4fTeyIIVx/XZdrGnvhBvYT41ZghDgRP+rLU/LTn3L76QmNv8/N
9xPC7Kdyx+6z8ndb8/Ee97GM4Je+4DOp6wb4PpoZw7/U3tGW+0bq7YLcuGMv
OYFO/gUfrvv/BvxcjFynhhyLOgJeT4Y8sf1uat8tkb4vtCw7Hf9l5EbeMpa4
Hz6Yitr+Edl1R2oOoZ5vTF3TyVn8gPxdmevT7qhZ1AHk4aszPf6fJR+wHx7e
1nLNQK4dPSRYvkZryzNzYrXlWgL2/yy7PlkzJ62IPpXcoi59vO74Paz58zVj
ZVX8SxFjOBo7sIH/BvyI/x9Uzm+sG3/0hp9PvY+e8bH4v8NPI+Er7D8R/iQe
zMnJZ1P38cSgV3HJ2uYVcvZyLUOPvo9k/i+clPxPm87TM6n7b/rnoeB3bNvT
dA9NzSSPDtV8LjlejDz/SdP/CfQsxGdxbp//D3mgTQw=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVlsVWUQxz9ue3q73HPuufeeow8GI5HVBAKGCJIINVIXCEGhrsHW2GJY
VBKiQfFFE3dR6voiRFIWSzSm5cn4RFBcUJYQERLbYKAFLGDVN0SMvz//h0m+
OTPzn/lm5vufCY+vW/Z0IYTwDFKPdMYhzKmE8HldCLdjeLaGDelBvzcK4QHs
WRbCqzjPwX5nQkw1hDORfR7BPpX4bZznYa8ndg8+7Y0hLEf+4bwC6cK/H4xb
yyF8UgphGH0YfQP+zyE/NYQwcVwIq3Li0hAuYb9SDKEX3+/Jf0dzCO/g/wv6
u+SrYptFzLfY9iEfkL8VnwPgby+79o3IcXL3IlOJ3YxsJNfzyElq+w3ZCd5a
9IOcE/KvIXYmcpm71CKfl3DHGwv+djO551PfAs57yf915hpV2wLyHyPXrIpt
b/Itx76I+PH49zSFsIXYralr7+VbzH2bkIn4vk78D/h/h3xU5ztfzYWMRs55
ANvd5LgJ/4XY+6j9U6QKdg25jO0U9cwFfwCfe9DbiB8jvg3//sQz0mx2or9B
beuod5N6A/4GfJdRT97inRjAfxr6Dnx3IVvQXwb/evzHI2PoA8TPYB596K2p
Y+R7npxnwX+ffbmIPQZvkH4OSfC9SL5ruM+1yJFG97ib+KOxbdop5VbNqlU1
JOhV5G3O08B4DOzVZc9qHzm24jsXWRq5xknU9mDs3f1SO566RtV2ARkh91r8
V3HuBHN3yZjCUs81u0Ew2oueYW/ZPVevlaOD2BOJd+sCPt0V74BmP8oMPgTv
NDk6wJ7Et3ZsfybuVQfx9bl7ql6+iM8U4h+O/Zb05uZR6w1829PgN/cE/l+U
/Fa6mVFz7hzCfo34MXL9kXmW2okG7AsTY7+EVKg9Ra4UPIMS5xZkFP04elRz
j9Sb+xv9lvVNZ73pW6ilIzZXvIV/P/p6/NejT+f+s9Efxd6K/hX9/ozadtCz
+yLvYB/nF2p+e5PHedeG8P+v4J0bpvZTyOE692w+eLchSwrmiMXgTS+71lfA
y8HKat6tk3yrgHeX+CfyjuhtteTujd7YKNhntW/4d/GtLXGP1BtxxN+JZ6TZ
7K537eIUcYnuoF3fW/JdtfPand8zY2mHJmBfTD9GIs9MdzmTebd0p20lc6C4
bz89WEPtD8XmBnHQIc6bU++qZiKsldTX1WLMdvSfiV9aNEcO4v9x6l5rpk9S
z7nM3Kk7igv+SnwXcYKwFqXeHWGKO7/JzF3iUHHjVc5oNkc+hb6rZG7UGxU3
/ZiZe8RR4qJSbu4SJ4mbLyXmenF0D3pfbK4Tx0wmdopyNnqmae43rbe8CYwj
+P5KzPKi39wK9Osy75p2SrPdn5nrNeNhejFS9uy1Q/rX/JuY+/TPea/qN6q3
eb7o3h0re3fUw+6aZ6JZqCbt8sqK3652ujMxhmLFYartMDUNNbnG/wF80v3i

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1738, 591, 298}, {2443, 919, 16}, {920, 919, 286}, {3231,
          3897, 248}, {3123, 3122, 3050}, {4413, 4414, 1741}, {2443, 2444, 
         563}, {1739, 1522, 588}, {5159, 5158, 2464}, {4042, 4004, 286}, {
         3657, 4985, 920}, {1518, 919, 563}, {4987, 4008, 1365}, {591, 3051, 
         298}, {3123, 3051, 588}, {4985, 4986, 920}, {2466, 2269, 591}, {1738,
          1741, 591}, {1518, 2267, 286}, {1739, 3052, 591}, {4980, 4981, 
         2267}, {3051, 3052, 588}, {3051, 3050, 298}, {2464, 1738, 1737}, {
         4703, 3654, 1985}, {4984, 4983, 2269}, {4003, 4042, 286}, {1741, 
         2466, 591}, {3052, 3051, 591}, {4171, 4385, 1522}, {5477, 4171, 
         1522}, {2444, 2445, 563}, {919, 1067, 16}, {2443, 3122, 588}, {3122, 
         3123, 588}, {3232, 4964, 248}, {3897, 3232, 248}, {1522, 2444, 
         588}, {1985, 1518, 563}, {3051, 3123, 3050}, {3050, 3122, 16}, {919, 
         2443, 563}, {1365, 1067, 919}, {919, 1518, 286}, {2445, 2444, 
         1522}, {1737, 1738, 298}, {2269, 1739, 591}, {3122, 2443, 16}, {4165,
          3657, 920}, {3246, 5478, 1739}, {4004, 3243, 286}, {920, 1365, 
         919}, {2444, 2443, 588}, {3052, 1739, 588}, {4384, 4154, 563}, {4170,
          5477, 1522}, {1365, 1523, 1067}},
         VertexColors->None], 
        PolygonBox[{{4385, 5137, 2445, 1522}, {4983, 3246, 1739, 2269}, {4965,
          5159, 2464, 1737}, {4986, 4987, 1365, 920}, {5137, 4384, 563, 
         2445}, {4164, 4980, 2267, 1518}, {3654, 4164, 1518, 1985}, {5478, 
         4170, 1522, 1739}, {4981, 4003, 286, 2267}, {4414, 4412, 2466, 
         1741}, {4964, 4965, 1737, 248}, {4412, 4984, 2269, 2466}, {3431, 
         4413, 1741, 1738}, {4008, 3247, 1523, 1365}, {3243, 4165, 920, 
         286}, {5158, 3431, 1738, 2464}, {4154, 4703, 1985, 563}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3231, 3897, 3232, 4964, 4965, 5159, 5158, 3431, 4413, 4414, 
         4412, 4984, 4983, 3246, 5478, 4170, 5477, 4171, 4385, 5137, 4384, 
         4154, 4703, 3654, 4164, 4980, 4981, 4003, 4042, 4004, 3243, 4165, 
         3657, 4985, 4986, 4987, 4008, 3247}],
        "0.7`"],
       Annotation[#, 0.7, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3535, 4571, 3536, 4572, 3402, 5141, 3416, 4970, 4971, 3237, 
         5196, 3238, 4973, 4972, 5143, 5142, 3795, 3902, 3405, 3888, 3946, 
         3945, 4704, 3241, 4159, 4158, 4402, 4401, 3797, 4452, 4453, 4210, 
         4528, 5434, 3264, 4529, 3823, 3824, 3668, 3826, 3825, 3298, 3835, 
         3836, 3676, 3834, 3833, 4497, 3286, 4253, 4252, 3496, 4496, 3798, 
         4463, 3465, 4217, 4772, 5358, 5359, 5031, 5032, 4002, 5494, 3640, 
         3741, 5430, 3204, 3740, 5380, 5381, 5492, 3652, 5382, 3653, 3746, 
         3799, 3800, 3678, 4754, 3679, 4755, 3559, 4075, 4884, 4885, 3892, 
         4069, 4068, 4585, 3549, 5458, 4215, 5011, 4407, 3423, 4405, 3422, 
         4406, 3225, 5147, 3420, 4403, 3421, 4404, 5025, 4251, 3548, 5236, 
         4880, 4881, 3890, 4061, 4060, 4578, 3538, 4196, 5000, 4392, 3418, 
         4390, 3417, 4391, 3223, 5140, 3414, 4388, 3415, 4389, 5016, 4239, 
         3534, 5220, 4875, 4876, 3885, 3147, 4053, 4052, 4180, 5479, 4179, 
         5480, 3252, 5352, 3692, 5351, 5354, 5353, 3691, 5349, 5350, 5346, 
         5348, 5347, 3221, 5386, 5387, 5385, 5389, 5388, 3656, 5322, 5323, 
         5319, 5321, 5320, 3234, 5315, 5316, 5314, 5318, 5317, 3655, 5393, 
         5394, 5390, 5392, 5391}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{4160, 3761, 5417, 3760, 4868, 3762, 4869, 4161, 4160}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3248, 4988, 3432, 5160, 3411, 4153, 4152, 4151, 3410, 4383, 
         3644, 4416, 3436, 4174, 4176, 4177, 3437, 4424, 4423, 4173, 3435, 
         4415, 3434, 4487, 3485, 4232, 4234, 4235, 3487, 4490, 4489, 4238, 
         3486, 4488, 3792, 4435, 3450, 4190, 4192, 4193, 3452, 4438, 4437, 
         4189, 3449, 4434, 3439, 4492, 3493, 4244, 4246, 4247, 3495, 4495, 
         4494, 4250, 3494, 4493, 4698, 4697, 4456, 4457, 4213, 4214, 3268, 
         4462, 3267, 5435, 4461, 4212, 4455, 4454, 3461, 4498, 4499, 4254, 
         4255, 3287, 4503, 3288, 5439, 4502, 4256, 4501, 4500, 4699, 3649, 
         4466, 3469, 4219, 4220, 4221, 3472, 5169, 3473, 3468, 5487, 3467, 
         3921, 3500, 5455, 3501, 3290, 4007, 3650, 5463, 3651, 3904, 3903, 
         3227, 5153, 3427, 5152, 3428, 5401, 5402, 5399, 3749, 5400, 4020, 
         3970, 4163, 4162, 3689, 5442, 3293, 4024, 3292, 5441, 3688, 3777, 
         3174, 3509, 5457, 3510, 3344, 5083, 3343, 5483, 4531, 5488, 3508, 
         5014, 3277, 5482, 4530, 4382, 3409, 5136, 3408, 5134, 5135, 5028, 
         5334, 5029, 5030, 4021, 4022, 3683, 5335, 3682, 5491, 5012, 5013, 
         4727, 3670, 4726, 4729, 4728, 3669, 4859, 4860, 4858, 5398, 5397, 
         3893, 4746, 4747, 4745, 4749, 4748, 3558, 4719, 4720, 4718, 5010, 
         5009, 3263, 4722, 4723, 4721, 4725, 4724, 3556, 4017, 4018, 3727, 
         4016, 4015, 3891, 4394, 4395, 4393, 4397, 4396, 3297, 4399, 4400, 
         4398, 5146, 5145, 3224, 3900, 3901, 3648, 4695, 3647, 4696, 3905, 
         3285, 4409, 4410, 4408, 5157, 5156}],
        "0.5`"],
       Annotation[#, 0.5, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1FtMz3EYx/GvlXEhOnChOcW9xCgzblhjmM1cKackNlYNbUjMqdgQOeSw
uSiZSyuHscKYORQqZUr1z2bltDE5XXr9Lt59vs/zfJ7n+f6//Sstr2hl4bAQ
QqofV0aFsDElhDmJIdThKmJyNbQWK9CLHtxNCqFBrYx/pXgZFsktxPvRIZQn
h1CBY/LH0c6bOyaETvVqPW/pCflu2oWlCSH00RjWybeJe52z9WwU5yEXpfKr
5HvtOGp+Dj0nfwEXIx//gnF6ol28MdqPDyjkrdVTg1fu0IZWvMbd6DPoq3fe
Zn6F3q20nKaPDeGR+1fqW2PGSXoap9Cn/oXvKwbsGMQnFPFdU69Du5md6MAb
PLJruV0Nzjv1VZqxg56kM+x6YtdlfflmXKKbaImZO1Gq/pnvD/8X+pd+5O8z
K1ncQ5Oit6PP6BG7DuMQqsVZ+vfpOSj+Ef1++frx3fmn+UNYG31ObDY3wz1z
nePVE+kY/IvelfZjhPxIbOE9rreYppuXIjdZfRKGRW+mlkCn0pn6z7rHOVQh
Vf4MPRZ9R+ybqydNf7x7xiFTnIVmvhd4bkaGGbPl5mA87wCdpbfEjEHnIjo9
egP+p2jXU0En8kzCBFwXt/K12d2OVnTgDVZHd+WZhslIwxRkmtOl3o136MF7
FPD30Rh6sVncEv19uH8zna93r/N+dz3v7g/V8+Vzovem29UfyG3AHbnRPMPp
rugd6ChxA21Sv48q8S/zfmMIe+zcje0838y76bM/1tvkLRoR03OPltJ6+Zu4
hWL+RuyVb6NltIne0H9bvZm24CUGxXH2DtB6WkyLsA0HxOvdo0P/PFogzpZf
jCXR/xJxt1oX/gOUKa/7
         "]],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV00lsjVEUwPHb0ho60GppFxJD1bCQ0i5Ed6JaLSJVU6lQK1NFuhDE0NYU
NNixFxJTgpTSuWqMGEpijCgWNXWjCV0Yft/i//7nnnPuufd773vjK7eWVsWE
ENJ8vEkKoXBkCG+5NyWERVzB+3iT/BZUYcGIEE6MCuE4tlnXqq/XtyQ5hMtq
pfyUL3F2eghTMBk7rW+mhtCIa/btsL4hrrN/sf4Ovm9OJ69Jcza69DU456F8
l/x2vs0P+G5iCLH2tZoxiPvlaziBY/gwf7c/iX/wG3Neo0/8HB3iYfpGqx/h
dB7KZ9xrp5nLeRev4Cfu8hjJ1oe4zPMsxVHxMQzVk6E2hMfwSi7jfF7KrXpa
sEw8FvXiBLVccR5yMBMzMN4dgtkx+GL9DV+RqX8eF2IuJloXcKLvIglZnqnI
usK+Y76b+eJiJKvle7ZJ6iXWp5x9GrM9fz526M1y5uzovojTn6e/Ty2XN5s3
QX6E807oi+Vx0T2RZmZO9B6YUa+2gRPkhuOjeg8GzEjhVMTLZ+ufjDr9A/iN
XzhpbibnOC+D/7nHr+i3tG+P++5GEO8zowZ3xAft6RbfFf9U70eb2e3otv+e
/c+id4XXqpWb+8eev+iVq7Yezv+i3zyaqbfNuiOaGe1Hu3WLdTNuodW6S343
/7RvcPT/MCeO+62ro3fL99Cpp1luI7fwbb7iXo3q5e6yCqvRLN+k3sRF5lzw
LBfxXvxZ7hNeqFfKrcc67DVnD647p1BfA79zdom4GFX6P9jXg7fWSXpL9UwX
L+TX/CpC/SUe6d9v7gHURP9J1OKq3qnuOA1z9M1DAXrlz3uOC9F/yZyzcvHO
KJY/J54l9x8h4Jnp
         "]],
        "0.3`"],
       Annotation[#, 0.3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV0ltoz3EYx/EvQ6lttjFbzrLNYTZR5sZhjuWYlGNropC0YVLO+yuHUrIY
ht0hxpxuNpI5nwnldOFUtjnPXKBcbF6/i/c+z/d5Ps/zfX7f/fsuXjmruE0I
IdOfufEhDO0UQk6XEHJRkBzCQhSiNCGERXQxlieFcIX3b2IIdXR/SggHUI4K
HEQD/0/eZnwx8yvm855UK6A9OodwQvxT/o55t1ErNyM1hBq6Xt9+M9bRcjrC
Pnf1XdNT6t6rNEav09/qLXx/aLN5PfX3QizaV0+GuFQc3PECz/Fb/p7e+7iL
h3iAVjPe0neI48vUu4R3i3MRzXbeLO6k1pWmItijG+2OZPkUFPP2tkse/3Ck
y6XyDeaJpwfVKqI++UP0s3waHUv70NE0H2NQydvWu8Shybk5ejdk8B3zLoPp
UZpNk33nON+Qa+40nkI9ZXaZLs5RT1Efrz5EfUY0325zeHLVjpuR79zffWvl
JvBVyvVXGyk/CqOx27wj8pnyh2kWzdKTiZHROzh3cE9e9BuIvp8WmddPLUmt
gi+RtuhtxVCeYSgxd4/aCppgv3jU6/mIf2Z0pl3QUX4A/0Ds4N+Jfea1l99L
3/D0iN4s+h/ij7g9bYcsc2LRrjSV/sJC921SSzcvDU1yZeZspJPsvYHWyV/B
M3dsV7vF/1T8BN/wSu01XmKVb1+NXe74QT/Qazzv6XfnIvOuOtfhMraYd9m8
JdHvMno7vjM8NeJabHNu1PcJDVjmzZYinueb3Wv1TRav4ZtPS6J+886iWu0c
He87vvCeF5+24ymcUas2P058mj7WO4U+MrtKPFU8M/oW8xbwxvi2YqLaPOe5
mI1V6tlyg1Cv5xVtoA/lP9GYOxvpBffXmHdRfiy9RGtplZlV0fvghvgm3olf
mvMfbY6i/g==
         "]],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3151, 4874, 4058, 3722, 3936, 3935, 3152, 3850, 3153}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[CompressedData["
1:eJwV1EdsiGEYwPHXHrFbRYwaB6sUIXHgoC11sYrioEoILUGNqpEexKg6iJmU
mAcjqdUWdTBjtKGtpGLciAOCRsXoIPH7Dv/+n+d5n/d53+/72g5ati5tbYsQ
wkg/2ncOYUbXEDpwQ5cQsruFUNQjhEzxWfG5mBDedgohR8+W2BDyUNc9hB+o
xwdrwdpFvRdwHqVmvbO/0tp2PRU8qWcI28T51nN5Mw7re8bP8VS9At/0vpDX
cYo9NeJK9Wquwh5xO+fF2ruPY7hera24Ulyr5yVeqb3Gb3NqPM8fTjWvWvxG
vYqfY6/4qL1t3PcYt+YjvB99rHeQ99TTkfvJE51RZO14dJ5agbmbMESexxO9
r776461N1t+bT1gbxEnywZzMU8xJ0DcKB+zbgTP68nmqGSm47F0XY5rexfKr
4msowXX8UWtABkrlB+0t40Z5E5bghvyQ+k2+hWa1VPMyuVw+3juZgGlRHdMx
PPqe1sa46wUey5e4ms9zIk/Rl4RkDNN/Sn2Y+kk+g9NYaG0BJjnvJ+e6RyHS
xfNRj+/YqDaP5yINo6Nva38hCtDK3IPOaIieLXru6DnQhFF6473DBG7pu4+w
P9u8Av1/0YwmHDFjAPfHLuzGE7XHqBAPtb+t79IOv+Tx5gxEnLgX6qzH8jfO
527IxRf5Vv7KedHfCH46vyr6ncVX+WeOM+sTL3LHMmdscm4pb+YbkT3LSp4t
rxLP4hzfZZ99hdiPLOvZWIU1WI05+hq4MfodR6w9MUh07nzsdJeHelaIl0fP
4p733eEB7uAe7qJc33X710e9nMMlXKt/qX0b5NW8kW9zsftc8TyP+DGe4L38
nznv+JKZF3FLvkiejlnymRgn/mzOX2sZZpWKy5DlrAXyhUhBMj7qKY/+z1j/
D6mUstY=
         "]],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3201, 3220, 3745, 3744, 4850, 4851, 4849, 4938, 4937, 3200, 
         5467, 5466, 5465, 4145, 5495, 4144, 4372, 4371, 3199, 3219, 4962, 
         4961, 5117, 5116, 3197, 4956, 4955, 4954, 3397, 5110, 3194, 4136, 
         4135, 4134, 3389, 5271, 3613, 5270, 3612, 4359, 3384, 5106, 3383, 
         5486, 4647, 3602, 5262, 3986, 3987, 3603, 4648, 5264, 5263}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3327, 3821, 3514, 5209, 3306, 5038, 5037, 5208, 5207, 4538, 
         4323, 3329, 4322, 3328, 3525, 5445, 3312, 3758, 5048, 5049, 5050, 
         4037, 4038, 3721, 5418, 3150, 4717, 3156, 5420, 5421, 5419, 4339, 
         4338, 4341, 4340, 4879, 4878, 4343, 3352, 4342, 3353, 4344, 3158, 
         5090, 3354, 5089, 3355, 5225, 5226, 5224, 3542, 5091, 3356, 4939, 
         5227, 5228, 3543, 5092, 3357, 4940, 5229, 5230, 3544, 5093, 3358, 
         4941, 5231, 5232, 5234, 5233, 5094, 5095, 4942, 5235, 3203, 3545}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3511, 3926, 3906, 3148, 3765, 3533, 3818, 3816, 3222, 4426, 
         4427, 4425, 4429, 4428, 3296, 3819, 4688, 4689, 4687, 3637, 3899, 
         3898, 3884, 4010, 4011, 3723, 4039, 3662, 4012, 5221, 4710, 3661, 
         4708, 3660, 4853, 4854, 4852, 3747, 4491, 3488, 4241, 4242, 4243, 
         3851, 3283, 5017, 4240, 4376, 5132, 3404, 4375, 4148, 4439, 4440, 
         4198, 4524, 5433, 3257, 5004, 4525, 4526, 4324, 5063, 3330, 4325, 
         5039, 4027, 3704, 4047, 3703, 4026, 3948, 4273, 4272, 4271, 3702, 
         4790, 4199, 3830, 3335, 4031, 3768, 4330, 3769, 3716, 4803, 3162, 
         5422, 4802, 4077, 4601, 4600, 3360, 3967, 3779, 3780, 3965, 3964, 
         3857, 4604, 3569, 4084, 3570, 3867, 3866, 3168, 4897, 4351, 3368, 
         4125, 3369, 4352, 4899, 4898, 5248, 5247, 3370, 4126, 4616, 4617, 
         3579, 4353, 3371, 4128, 4618, 4619, 3580, 5249, 5096, 5097, 4943, 
         5250, 3205, 5251, 5098, 5099, 4944, 5252, 3206, 5253, 5100, 5101, 
         4945, 5254, 3207, 3581}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3636, 5130, 3401, 5128, 3400, 5129, 5307, 5306, 5126, 5127, 
         5123, 5125, 5124, 5305, 5121, 5122, 5118, 5120, 5119, 5294, 4001, 
         5291, 3634, 5290, 3635, 3999, 3998, 3195, 3214, 4139, 4138, 3392, 
         4368, 4921, 3789, 3788, 3997, 3386, 4654, 4655, 4653, 3606, 3872, 
         3376, 4651, 3604, 4118, 4816, 4817, 4819, 4818, 4909, 4908, 4112, 
         3735, 4837, 3590, 4826, 4827, 4823, 4825, 4824, 3281, 5192, 5193, 
         4484, 4486, 4485, 3320, 4313, 4314, 4110, 4777, 5426, 3180, 4778, 
         3171, 4098, 4097, 4621, 4620, 3582, 4767, 4768, 4764, 4766, 4765, 
         3278, 5185, 5186, 4481, 4483, 4482, 3311, 4298, 4299, 4093, 4532, 
         5423, 3169, 4533, 3165, 3772, 3642, 5308, 3641, 3922, 3274, 5173, 
         5174, 5170, 5172, 5171, 3226, 4507, 4508, 4506, 3499, 4509, 5027, 
         4505, 3498, 4504, 3497, 5197, 3918, 3919, 3771, 3770}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{3244, 4982, 3245, 5476, 4380, 5432, 4381, 4379, 3407, 5148, 
         3424, 4976, 4977, 3502, 5440, 3291, 5151, 3426, 5149, 3425, 5150, 
         3228, 3480, 5182, 5184, 5183, 3301, 5180, 5181, 5177, 5179, 5178, 
         3923, 5198, 5199, 4510, 4512, 4511, 3294, 4516, 4517, 4513, 4515, 
         4514, 3229, 3483, 5190, 3484, 5191, 3302, 5189, 3482, 5187, 3481, 
         5188, 3924, 3530, 5217, 5219, 5218, 3323, 4034, 4035, 3759, 5448, 
         3321, 4820, 3322, 5450, 5451, 5449, 4315, 4119, 5265, 4915, 4916, 
         4362, 4363, 4130, 4131, 3211, 3191, 4919, 4367, 3390, 4137, 5431, 
         4953, 3391, 5109, 3625, 5281, 3626, 5282, 3614, 4845, 3739, 4844, 
         3738, 4361, 3385, 5107, 4360, 4650, 4649, 4735, 5333, 4645, 4646, 
         4644, 3601, 5373, 3734, 5372, 3733, 5384, 3743, 5383, 3742, 4769, 
         3690, 5344, 5345, 4862, 4861, 5403, 3279, 4864, 4865, 4863, 3751, 
         4866, 3750, 3810, 3809, 3894, 4095, 4094}],
        RowBox[{"-", "0.1`"}]],
       Annotation[#, -0.1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3720, 4036, 3933, 3233, 4967, 4966, 5313, 5312, 3791, 5138, 
         5139, 4968, 4969, 3236, 5200, 3235, 5472, 5473, 5471, 4155, 4374, 
         5131, 4373, 4147, 4433, 3444, 4187, 4522, 4523, 3503, 5456, 3504, 
         5201, 3326, 4871, 4872, 4873, 5203, 5202, 3155, 5413, 3753, 5412, 
         3754, 4044, 4043, 3284, 5018, 4387, 3413, 4386, 3412, 3794, 3793, 
         5144, 3419, 4974, 4975, 3240, 5204, 3239, 5475, 4156, 5474, 4157, 
         4378, 5133, 4377, 4149, 4442, 4443, 4200, 4527, 5481, 3260, 3505, 
         5205, 5206, 5064, 5066, 5065, 3315, 4032, 4033, 3715, 5362, 3714, 
         3314, 4030, 3313, 5052, 4300, 5464, 3713, 5361, 5360, 5051, 5459, 
         3553, 5238, 4882, 4883, 3855, 3163, 4889, 4349, 3361, 4348, 3362, 
         4603, 3568, 4602, 3567, 4350, 3363, 4124, 4605, 5244, 3571, 4890, 
         4891, 3859, 3364, 3858, 3555, 3951, 3554, 3950, 3725, 5365, 3726, 
         5366, 3359, 4345, 4347, 4346, 3160, 3944, 3157, 4067, 4066, 3724, 
         3854, 3853, 3942, 3943, 3639, 4690, 3638, 4691, 4822, 4821, 3258, 
         3806, 3454, 5005, 5006, 3259, 5215, 3822, 5356, 5357, 5355, 3693, 
         4006, 4005, 5311, 3646, 5195, 3490, 5022, 5023, 5024, 3491, 5021, 
         5020, 5019, 3489, 5194, 3445, 5163, 3446, 4994, 4995, 4996, 3448, 
         4999, 4998, 4997, 3447, 5164, 3645, 5154, 3429, 4978, 4979, 3242, 
         5155, 3820}],
        RowBox[{"-", "0.1`"}]],
       Annotation[#, -0.1, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-5, 2}, {-5.5, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62724027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->719058440],

Cell[TextData[{
 "A convolution integral solving the modified linearized ",
 ButtonBox["Korteweg-deVries equation",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Korteweg-deVriesEquation.html"], 
    None}],
 " for any function ",
 Cell[BoxData[
  FormBox["f", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->978557986],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", " ", "t_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"3", " ", "t"}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "2"}], "/", "3"}], ")"}]}], " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AiryAiPrime", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", " ", "-", " ", "y"}], ")"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"3", " ", "t"}], ")"}], "^", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "/", "3"}], ")"}]}]}], "]"}], " ", 
      RowBox[{"f", "[", "y", "]"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"y", ",", " ", 
       RowBox[{"-", "Infinity"}], ",", " ", "Infinity"}], "}"}]}], 
    "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721167105],

Cell["Verify solution:", "ExampleText",
 CellID->258679987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", "t", ",", "x"}], "]"}], 
   " ", "+", " ", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", " ", "t"}], "]"}], ",", " ", "x", ",", " ", "x", ",", 
     " ", "x", ",", "x"}], "]"}]}], " ", "//.", " ", "\n", "    ", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Alpha]_.", " ", 
     RowBox[{"Integrate", "[", 
      RowBox[{"a_", ",", " ", "i_"}], "]"}]}], " ", "+", "  ", 
    RowBox[{"\[Beta]_.", " ", 
     RowBox[{"Integrate", "[", 
      RowBox[{"b_", ",", " ", "i_"}], "]"}]}]}], " ", ":>", " ", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[Alpha]", " ", "a"}], " ", "+", " ", 
      RowBox[{"\[Beta]", " ", "b"}]}], ",", " ", "i"}], "]"}], 
   " "}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166919569],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->552108965]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29022],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify Airy functions, here in the ",
 ButtonBox["Wronskian",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/Wronskian.html"], None}],
 " of the Airy equation:"
}], "ExampleText",
 CellID->294964549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"Outer", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"#1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"AiryAi", "[", "x", "]"}], ",", 
      RowBox[{"AiryBi", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38793564],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    RowBox[{"AiryAiPrime", "[", "x", "]"}]}], " ", 
   RowBox[{"AiryBi", "[", "x", "]"}]}], "+", 
  RowBox[{
   RowBox[{"AiryAi", "[", "x", "]"}], " ", 
   RowBox[{"AiryBiPrime", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{353, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17241519]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->565761617],

Cell[BoxData[
 FractionBox["1", "\[Pi]"]], "Output",
 ImageSize->{17, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85081476]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->261831751],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " tries to simplify the argument of ",
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 ":  "
}], "ExampleText",
 CellID->371150634],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", " ", "[", 
   RowBox[{"AiryAiPrime", "[", 
    RowBox[{"z", " ", 
     RowBox[{"Exp", "[", 
      RowBox[{"2", "Pi", " ", 
       RowBox[{"I", "/", "3"}]}], "]"}]}], "]"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30650379],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     SqrtBox["3"]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"AiryAiPrime", "[", "z", "]"}], "-", 
    RowBox[{"\[ImaginaryI]", " ", 
     RowBox[{"AiryBiPrime", "[", "z", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{324, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355999249]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107297369],

Cell[TextData[{
 "Airy functions are generated as solutions by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->204315082],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{
       RowBox[{"w", "''"}], "[", "z", "]"}]}], "-", 
     RowBox[{
      RowBox[{"w", "'"}], "[", "z", "]"}], "-", 
     RowBox[{
      RowBox[{"z", "^", "2"}], 
      RowBox[{"w", "[", "z", "]"}]}]}], "\[Equal]", "0"}], ",", " ", 
   RowBox[{"w", "[", "z", "]"}], ",", " ", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62810057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      RowBox[{"AiryAiPrime", "[", "z", "]"}], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      RowBox[{"AiryBiPrime", "[", "z", "]"}], " ", 
      RowBox[{"C", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5529942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->80901575],

Cell["Integrals:", "ExampleText",
 CellID->548286067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", "^", "a"}], " ", 
    RowBox[{
     RowBox[{"AiryAiPrime", "[", "z", "]"}], "^", "2"}]}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383984272],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["2", 
    RowBox[{
     RowBox[{"-", "3"}], "-", 
     FractionBox[
      RowBox[{"2", " ", "a"}], "3"]}]], " ", 
   SuperscriptBox["3", 
    RowBox[{
     RowBox[{"2", " ", "a"}], "/", "3"}]], " ", 
   RowBox[{"MeijerG", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", "1", "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "6"], " ", 
         RowBox[{"(", 
          RowBox[{"9", "+", 
           RowBox[{"2", " ", "a"}]}], ")"}]}], "}"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         FractionBox[
          RowBox[{"1", "+", "a"}], "3"], ",", 
         FractionBox[
          RowBox[{"3", "+", "a"}], "3"], ",", 
         FractionBox[
          RowBox[{"5", "+", "a"}], "3"]}], "}"}], ",", 
       RowBox[{"{", "0", "}"}]}], "}"}], ",", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox["2", "3"], ")"}], 
       RowBox[{"2", "/", "3"}]], " ", "z"}], ",", 
     FractionBox["1", "3"]}], "]"}]}], 
  SuperscriptBox["\[Pi]", 
   RowBox[{"3", "/", "2"}]]]], "Output",
 ImageSize->{502, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125666325]
}, Open  ]],

Cell["Integral transforms:", "ExampleText",
 CellID->66848246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->225358637],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", "s", " ", 
    RowBox[{"Cos", "[", 
     FractionBox[
      SuperscriptBox["s", "3"], "3"], "]"}]}], "-", 
   RowBox[{"s", " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      SuperscriptBox["s", "3"], "3"], "]"}]}]}], 
  SqrtBox[
   RowBox[{"2", " ", "\[Pi]"}]]]], "Output",
 ImageSize->{159, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295092717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57398179],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " from sums:  "
}], "ExampleText",
 CellID->448379374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"1", " "}], 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"1", "/", "3"}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["1", "3"], "]"}]}]]}], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]"], 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"Pochhammer", "[", 
         RowBox[{
          FractionBox["1", "3"], ",", "k"}], "]"}], " ", 
        RowBox[{"k", "!"}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         SuperscriptBox["z", "3"], "9"], ")"}], "k"]}]}]}], "+", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["z", "2"], " "}], 
     RowBox[{"2", " ", 
      SuperscriptBox["3", 
       RowBox[{"2", "/", "3"}]], " ", 
      RowBox[{"Gamma", "[", 
       FractionBox["2", "3"], "]"}]}]], 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{"k", "=", "0"}], "\[Infinity]"], 
     RowBox[{
      FractionBox["1", 
       RowBox[{
        RowBox[{"Pochhammer", "[", 
         RowBox[{
          FractionBox["5", "3"], ",", "k"}], "]"}], " ", 
        RowBox[{"k", "!"}]}]], 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         SuperscriptBox["z", "3"], "9"], ")"}], "k"]}]}]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128199239],

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", "z", "]"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->376607052]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->503966618],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 " appears in special cases of several mathematical functions:  "
}], "ExampleText",
 CellID->20877310],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", " ", 
   RowBox[{
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["z", "2"], " ", 
       RowBox[{"Hypergeometric0F1", "[", 
        RowBox[{
         FractionBox["5", "3"], ",", 
         FractionBox[
          SuperscriptBox["z", "3"], "9"]}], "]"}]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["2", "3"], "]"}]}]], "-", 
     FractionBox[
      RowBox[{" ", 
       RowBox[{"Hypergeometric0F1", "[", 
        RowBox[{
         FractionBox["1", "3"], ",", 
         FractionBox[
          SuperscriptBox["z", "3"], "9"]}], "]"}]}], 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{"1", "/", "3"}]], " ", 
       RowBox[{"Gamma", "[", 
        FractionBox["1", "3"], "]"}]}]]}], ",", " ", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", 
          FractionBox["2", "3"]}], "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{
       SuperscriptBox["3", 
        RowBox[{
         RowBox[{"-", "2"}], "/", "3"}]], " ", "z"}], ",", 
      FractionBox["1", "3"]}], "]"}]}], "}"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44736887],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", "z", "]"}], ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "\[Pi]", " ", 
      RowBox[{"AiryAiPrime", "[", "z", "]"}]}], 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "6"}]]]}]}], "}"}]], "Output",
 ImageSize->{258, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86851103]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19413],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->545532713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", 
  RowBox[{"-", 
   RowBox[{"10.", "^", "12"}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102757707],

Cell[BoxData["98.34524553686343`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262545724]
}, Open  ]],

Cell["Use arbitrary-precision evaluation instead:", "ExampleText",
 CellID->29307178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", 
    RowBox[{"-", 
     RowBox[{"10", "^", "12"}]}], " ", "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103603250],

Cell[BoxData["366.1713874892549368842`10.000000000000004"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->146893057]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121309298],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->118482006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryAiPrime", "[", 
    RowBox[{"-", 
     RowBox[{"10", "^", "100"}]}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233639817],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(AiryAiPrime[\\(\\(-\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000\\)\\)]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->196224081],

Cell[BoxData["0``-24.751425063652935"], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->381967620]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"AiryAiPrime", "[", 
      RowBox[{"-", 
       RowBox[{"10", "^", "100"}]}], "]"}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->321969127],

Cell[BoxData[
 RowBox[{"-", "5.02523994420989554510719590561913`20.*^24"}]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->832181815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83875056],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->1002663206],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryAiPrime", "[", 
  RowBox[{"10.", "^", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444432402],

Cell[BoxData[
 RowBox[{"-", 
  "2.9431339179160031543288660244090248`15.954589770191005*^-9156"}]], \
"Output",
 ImageSize->{182, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166650484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->687146190],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->166023038]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->542],

Cell[TextData[{
 "Nested integrals of the square of ",
 Cell[BoxData[
  ButtonBox["AiryAiPrime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryAiPrime"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->192543262],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NestList", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Integrate", "[", 
       RowBox[{"#", ",", "z"}], "]"}], "&"}], ",", 
     RowBox[{
      RowBox[{"AiryAiPrime", "[", "z", "]"}], "^", "2"}], ",", "4"}], "]"}], "//",
    "Simplify"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360923885],

Cell[BoxData[
 FormBox[
  RowBox[{"{", 
   RowBox[{
    SuperscriptBox[
     RowBox[{
      SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], "2"], ",", 
    RowBox[{
     FractionBox["1", "3"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox["z", "2"]}], " ", 
        SuperscriptBox[
         RowBox[{"Ai", "(", "z", ")"}], "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{
         SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], " ", 
        RowBox[{"Ai", "(", "z", ")"}]}], "+", 
       RowBox[{"z", " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
      ")"}]}], ",", 
    RowBox[{
     FractionBox["1", "30"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"9", "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["z", "3"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Ai", "(", "z", ")"}], "2"]}], "+", 
       RowBox[{"2", " ", "z", " ", 
        RowBox[{
         SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], " ", 
        RowBox[{"Ai", "(", "z", ")"}]}], "+", 
       RowBox[{"4", " ", 
        SuperscriptBox["z", "2"], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
      ")"}]}], ",", 
    RowBox[{
     FractionBox["1", "210"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"4", " ", 
        RowBox[{"Ai", "(", "z", ")"}], " ", 
        RowBox[{
         SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], " ", 
        SuperscriptBox["z", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"63", " ", "z"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"Ai", "(", "z", ")"}], "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["z", "3"]}], "-", "15"}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{
          SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
      ")"}]}], ",", 
    FractionBox[
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"371", " ", 
          SuperscriptBox["z", "2"]}], "-", 
         RowBox[{"16", " ", 
          SuperscriptBox["z", "5"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"Ai", "(", "z", ")"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"8", " ", 
          SuperscriptBox["z", "3"]}], "-", "175"}], ")"}], " ", 
       RowBox[{
        SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], " ", 
       RowBox[{"Ai", "(", "z", ")"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SuperscriptBox["z", "3"]}], "-", "365"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{
         SuperscriptBox["Ai", "\[Prime]"], "(", "z", ")"}], "2"]}]}], 
     "1890"]}], "}"}], TraditionalForm]], "Output",
 ImageSize->{520, 113},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->65109570]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30271],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryAi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryBi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryBiPrime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBiPrime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10268]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17827],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->28074]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->26431],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/AiryFunctions.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/BesselAiryStruveFunctions/AiryAiPrime/"],
    None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->225167486],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->337088532],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->272711297],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->511907184]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AiryAiPrime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 45.3763856}", "context" -> "System`", 
    "keywords" -> {"Airy Ai prime", "Airy derivative", "Airy functions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AiryAiPrime[z] gives the derivative of the Airy function Ai^\\[Prime] \
(z). ", "synonyms" -> {"airy ai prime"}, "title" -> "AiryAiPrime", "type" -> 
    "Symbol", "uri" -> "ref/AiryAiPrime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4963, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->525072205]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[236157, 4955, 268, 9, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->192543262]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 244390, 5235},
 {"XRef-2005-4-26-23-37-1.8558342", 244547, 5239}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2271, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2894, 81, 49, 1, 70, "ObjectName",
 CellID->23186],
Cell[2946, 84, 651, 21, 70, "Usage",
 CellID->14507]
}, Open  ]],
Cell[CellGroupData[{
Cell[3634, 110, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4112, 127, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4235, 133, 254, 8, 70, "Notes",
 CellID->265854530],
Cell[4492, 143, 224, 7, 70, "Notes",
 CellID->31226],
Cell[4719, 152, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[4963, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->525072205],
Cell[CellGroupData[{
Cell[5348, 178, 148, 5, 70, "ExampleSection",
 CellID->580576952],
Cell[5499, 185, 64, 1, 70, "ExampleText",
 CellID->152726107],
Cell[CellGroupData[{
Cell[5588, 190, 108, 3, 28, "Input",
 CellID->27285712],
Cell[5699, 195, 194, 6, 36, "Output",
 CellID->221708835]
}, Open  ]],
Cell[5908, 204, 125, 3, 70, "ExampleDelimiter",
 CellID->272077164],
Cell[CellGroupData[{
Cell[6058, 211, 242, 8, 28, "Input",
 CellID->5587629],
Cell[6303, 221, 3828, 67, 138, "Output",
 Evaluatable->False,
 CellID->578066408]
}, Open  ]],
Cell[10146, 291, 125, 3, 70, "ExampleDelimiter",
 CellID->467198663],
Cell[CellGroupData[{
Cell[10296, 298, 223, 7, 70, "Input",
 CellID->104402871],
Cell[10522, 307, 1516, 48, 63, "Output",
 CellID->110050886]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12087, 361, 216, 7, 70, "ExampleSection",
 CellID->17604],
Cell[12306, 370, 74, 1, 70, "ExampleText",
 CellID->177179144],
Cell[CellGroupData[{
Cell[12405, 375, 131, 4, 70, "Input",
 CellID->68147727],
Cell[12539, 381, 273, 8, 36, "Output",
 CellID->13631000]
}, Open  ]],
Cell[12827, 392, 125, 3, 70, "ExampleDelimiter",
 CellID->103032914],
Cell[12955, 397, 70, 1, 70, "ExampleText",
 CellID->441374880],
Cell[CellGroupData[{
Cell[13050, 402, 185, 6, 70, "Input",
 CellID->521453795],
Cell[13238, 410, 268, 8, 36, "Output",
 CellID->742482060]
}, Open  ]],
Cell[13521, 421, 113, 3, 70, "ExampleText",
 CellID->362205240],
Cell[CellGroupData[{
Cell[13659, 428, 131, 3, 70, "Input",
 CellID->758297733],
Cell[13793, 433, 237, 7, 36, "Output",
 CellID->722087964]
}, Open  ]],
Cell[14045, 443, 125, 3, 70, "ExampleDelimiter",
 CellID->971875072],
Cell[14173, 448, 216, 7, 70, "ExampleText",
 CellID->129651381],
Cell[CellGroupData[{
Cell[14414, 459, 168, 5, 70, "Input",
 CellID->8513118],
Cell[14585, 466, 326, 10, 36, "Output",
 CellID->92237967]
}, Open  ]],
Cell[14926, 479, 125, 3, 70, "ExampleDelimiter",
 CellID->136399151],
Cell[15054, 484, 91, 1, 70, "ExampleText",
 CellID->464487210],
Cell[CellGroupData[{
Cell[15170, 489, 107, 3, 70, "Input",
 CellID->304690627],
Cell[15280, 494, 331, 12, 60, "Output",
 CellID->398927421]
}, Open  ]],
Cell[15626, 509, 125, 3, 70, "ExampleDelimiter",
 CellID->567607451],
Cell[15754, 514, 77, 1, 70, "ExampleText",
 CellID->87281018],
Cell[CellGroupData[{
Cell[15856, 519, 229, 7, 70, "Input",
 CellID->58376630],
Cell[16088, 528, 1592, 53, 71, "Output",
 CellID->19639742]
}, Open  ]],
Cell[17695, 584, 92, 1, 70, "ExampleText",
 CellID->22276],
Cell[CellGroupData[{
Cell[17812, 589, 247, 8, 70, "Input",
 CellID->25759],
Cell[18062, 599, 2235, 76, 71, "Output",
 CellID->93153712]
}, Open  ]],
Cell[20312, 678, 125, 3, 70, "ExampleDelimiter",
 CellID->686962333],
Cell[20440, 683, 202, 7, 70, "ExampleText",
 CellID->89086006],
Cell[CellGroupData[{
Cell[20667, 694, 147, 5, 70, "Input",
 CellID->422133542],
Cell[20817, 701, 267, 9, 50, "Output",
 CellID->448270952]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21133, 716, 243, 7, 70, "ExampleSection",
 CellID->208272636],
Cell[21379, 725, 215, 7, 70, "ExampleText",
 CellID->284910746],
Cell[CellGroupData[{
Cell[21619, 736, 240, 8, 70, "Input",
 CellID->227782221],
Cell[21862, 746, 2187, 67, 110, "Output",
 CellID->402238362]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24098, 819, 222, 7, 70, "ExampleSection",
 CellID->7768],
Cell[24323, 828, 244, 8, 70, "ExampleText",
 CellID->289597052],
Cell[CellGroupData[{
Cell[24592, 840, 418, 14, 70, "Input",
 CellID->40481414],
Cell[25013, 856, 20452, 339, 70, "Output",
 Evaluatable->False,
 CellID->147598443]
}, Open  ]],
Cell[45480, 1198, 124, 3, 70, "ExampleDelimiter",
 CellID->11388736],
Cell[45607, 1203, 229, 8, 70, "ExampleText",
 CellID->43417108],
Cell[CellGroupData[{
Cell[45861, 1215, 1131, 36, 70, "Input",
 CellID->270396206],
Cell[46995, 1253, 929, 28, 58, "Output",
 CellID->466978291]
}, Open  ]],
Cell[47939, 1284, 124, 3, 70, "ExampleDelimiter",
 CellID->30709181],
Cell[48066, 1289, 154, 4, 70, "ExampleText",
 CellID->138136831],
Cell[CellGroupData[{
Cell[48245, 1297, 1031, 32, 70, "Input",
 CellID->207762545],
Cell[49279, 1331, 2821, 50, 70, "Output",
 Evaluatable->False,
 CellID->60236740]
}, Open  ]],
Cell[52115, 1384, 250, 8, 70, "ExampleText",
 CellID->27343431],
Cell[52368, 1394, 991, 32, 70, "Input",
 CellID->185972111],
Cell[53362, 1428, 530, 18, 70, "Input",
 CellID->230468774],
Cell[53895, 1448, 72, 1, 70, "ExampleText",
 CellID->173137172],
Cell[CellGroupData[{
Cell[53992, 1453, 751, 22, 70, "Input",
 CellID->650529424],
Cell[54746, 1477, 11746, 197, 70, "Output",
 Evaluatable->False,
 CellID->297497972]
}, Open  ]],
Cell[66507, 1677, 125, 3, 70, "ExampleDelimiter",
 CellID->633813267],
Cell[66635, 1682, 112, 3, 70, "ExampleText",
 CellID->180352770],
Cell[CellGroupData[{
Cell[66772, 1689, 649, 21, 70, "Input",
 CellID->339338037],
Cell[67424, 1712, 150286, 2512, 70, "Output",
 CellID->62724027]
}, Open  ]],
Cell[217725, 4227, 125, 3, 70, "ExampleDelimiter",
 CellID->719058440],
Cell[217853, 4232, 372, 12, 70, "ExampleText",
 CellID->978557986],
Cell[218228, 4246, 890, 30, 70, "Input",
 CellID->721167105],
Cell[219121, 4278, 59, 1, 70, "ExampleText",
 CellID->258679987],
Cell[CellGroupData[{
Cell[219205, 4283, 916, 28, 70, "Input",
 CellID->166919569],
Cell[220124, 4313, 158, 5, 36, "Output",
 CellID->552108965]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[220331, 4324, 233, 7, 70, "ExampleSection",
 CellID->29022],
Cell[220567, 4333, 392, 13, 70, "ExampleText",
 CellID->294964549],
Cell[CellGroupData[{
Cell[220984, 4350, 477, 16, 70, "Input",
 CellID->38793564],
Cell[221464, 4368, 392, 13, 36, "Output",
 CellID->17241519]
}, Open  ]],
Cell[CellGroupData[{
Cell[221893, 4386, 108, 3, 70, "Input",
 CellID->565761617],
Cell[222004, 4391, 181, 6, 51, "Output",
 CellID->85081476]
}, Open  ]],
Cell[222200, 4400, 125, 3, 70, "ExampleDelimiter",
 CellID->261831751],
Cell[222328, 4405, 357, 12, 70, "ExampleText",
 CellID->371150634],
Cell[CellGroupData[{
Cell[222710, 4421, 306, 10, 70, "Input",
 CellID->30650379],
Cell[223019, 4433, 476, 16, 51, "Output",
 CellID->355999249]
}, Open  ]],
Cell[223510, 4452, 125, 3, 70, "ExampleDelimiter",
 CellID->107297369],
Cell[223638, 4457, 224, 8, 70, "ExampleText",
 CellID->204315082],
Cell[CellGroupData[{
Cell[223887, 4469, 454, 15, 70, "Input",
 CellID->62810057],
Cell[224344, 4486, 487, 16, 36, "Output",
 CellID->5529942]
}, Open  ]],
Cell[224846, 4505, 124, 3, 70, "ExampleDelimiter",
 CellID->80901575],
Cell[224973, 4510, 53, 1, 70, "ExampleText",
 CellID->548286067],
Cell[CellGroupData[{
Cell[225051, 4515, 246, 9, 70, "Input",
 CellID->383984272],
Cell[225300, 4526, 1287, 45, 66, "Output",
 CellID->125666325]
}, Open  ]],
Cell[226602, 4574, 62, 1, 70, "ExampleText",
 CellID->66848246],
Cell[CellGroupData[{
Cell[226689, 4579, 187, 6, 70, "Input",
 CellID->225358637],
Cell[226879, 4587, 500, 18, 66, "Output",
 CellID->295092717]
}, Open  ]],
Cell[227394, 4608, 124, 3, 70, "ExampleDelimiter",
 CellID->57398179],
Cell[227521, 4613, 208, 8, 70, "ExampleText",
 CellID->448379374],
Cell[CellGroupData[{
Cell[227754, 4625, 1433, 51, 70, "Input",
 CellID->128199239],
Cell[229190, 4678, 196, 6, 36, "Output",
 CellID->376607052]
}, Open  ]],
Cell[229401, 4687, 125, 3, 70, "ExampleDelimiter",
 CellID->503966618],
Cell[229529, 4692, 244, 7, 70, "ExampleText",
 CellID->20877310],
Cell[CellGroupData[{
Cell[229798, 4703, 1441, 49, 70, "Input",
 CellID->44736887],
Cell[231242, 4754, 420, 14, 52, "Output",
 CellID->86851103]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[231711, 4774, 226, 7, 70, "ExampleSection",
 CellID->19413],
Cell[231940, 4783, 116, 3, 70, "ExampleText",
 CellID->545532713],
Cell[CellGroupData[{
Cell[232081, 4790, 157, 5, 70, "Input",
 CellID->102757707],
Cell[232241, 4797, 175, 5, 36, "Output",
 CellID->262545724]
}, Open  ]],
Cell[232431, 4805, 85, 1, 70, "ExampleText",
 CellID->29307178],
Cell[CellGroupData[{
Cell[232541, 4810, 213, 7, 70, "Input",
 CellID->103603250],
Cell[232757, 4819, 199, 5, 36, "Output",
 CellID->146893057]
}, Open  ]],
Cell[232971, 4827, 125, 3, 70, "ExampleDelimiter",
 CellID->121309298],
Cell[233099, 4832, 246, 8, 70, "ExampleText",
 CellID->118482006],
Cell[CellGroupData[{
Cell[233370, 4844, 209, 7, 70, "Input",
 CellID->233639817],
Cell[233582, 4853, 548, 11, 70, "Message",
 CellID->196224081],
Cell[234133, 4866, 179, 5, 36, "Output",
 CellID->381967620]
}, Open  ]],
Cell[CellGroupData[{
Cell[234349, 4876, 344, 12, 70, "Input",
 CellID->321969127],
Cell[234696, 4890, 217, 6, 36, "Output",
 CellID->832181815]
}, Open  ]],
Cell[234928, 4899, 124, 3, 70, "ExampleDelimiter",
 CellID->83875056],
Cell[235055, 4904, 114, 3, 70, "ExampleText",
 CellID->1002663206],
Cell[CellGroupData[{
Cell[235194, 4911, 132, 4, 70, "Input",
 CellID->444432402],
Cell[235329, 4917, 242, 8, 36, "Output",
 CellID->166650484]
}, Open  ]],
Cell[CellGroupData[{
Cell[235608, 4930, 110, 3, 70, "Input",
 CellID->687146190],
Cell[235721, 4935, 162, 5, 36, "Output",
 CellID->166023038]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[235932, 4946, 222, 7, 70, "ExampleSection",
 CellID->542],
Cell[236157, 4955, 268, 9, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->192543262],
Cell[CellGroupData[{
Cell[236450, 4968, 370, 12, 70, "Input",
 CellID->360923885],
Cell[236823, 4982, 3277, 104, 148, "Output",
 CellID->65109570]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[240161, 5093, 311, 9, 70, "SeeAlsoSection",
 CellID->30271],
Cell[240475, 5104, 694, 26, 70, "SeeAlso",
 CellID->10268]
}, Open  ]],
Cell[CellGroupData[{
Cell[241206, 5135, 314, 9, 70, "TutorialsSection",
 CellID->17827],
Cell[241523, 5146, 144, 3, 70, "Tutorials",
 CellID->28074]
}, Open  ]],
Cell[CellGroupData[{
Cell[241704, 5154, 321, 9, 70, "RelatedLinksSection",
 CellID->26431],
Cell[242028, 5165, 184, 4, 70, "RelatedLinks"],
Cell[242215, 5171, 209, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[242461, 5180, 319, 9, 70, "MoreAboutSection",
 CellID->225167486],
Cell[242783, 5191, 158, 3, 70, "MoreAbout",
 CellID->337088532],
Cell[242944, 5196, 178, 3, 70, "MoreAbout",
 CellID->272711297],
Cell[243125, 5201, 145, 3, 70, "MoreAbout",
 CellID->511907184]
}, Open  ]],
Cell[243285, 5207, 27, 0, 70, "History"],
Cell[243315, 5209, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

