(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28572,        930]
NotebookOptionsPosition[     23730,        767]
NotebookOutlinePosition[     25060,        804]
CellTagsIndexPosition[     24975,        799]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AiryBi" :> Documentation`HelpLookup["paclet:ref/AiryBi"], 
          "AiryAiZero" :> Documentation`HelpLookup["paclet:ref/AiryAiZero"], 
          "BesselJZero" :> Documentation`HelpLookup["paclet:ref/BesselJZero"],
           "FindRoot" :> Documentation`HelpLookup["paclet:ref/FindRoot"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"AiryBi\"\>", 
       2->"\<\"AiryAiZero\"\>", 3->"\<\"BesselJZero\"\>", 
       4->"\<\"FindRoot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Bessel-Related Functions" :> 
          Documentation`HelpLookup["paclet:guide/BesselRelatedFunctions"], 
          "Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"], 
          "Inverse Functions" :> 
          Documentation`HelpLookup["paclet:guide/InverseFunctions"], 
          "New in 6.0: Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicalFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Bessel-Related Functions\"\>", 
       2->"\<\"Functions Used in Quantum Mechanics\"\>", 
       3->"\<\"Inverse Functions\"\>", 
       4->"\<\"New in 6.0: Mathematical Functions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AiryBiZero", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AiryBiZero",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AiryBiZero"], "[", 
       StyleBox["k", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero of the Airy function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Bi", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AiryBiZero",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AiryBiZero"], "[", 
       RowBox[{
        StyleBox["k", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["0", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " zero less than ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{"AiryBiZero", "[", 
    StyleBox["k", "TI"], "]"}], "]"}]], "InlineFormula"],
 " gives a numerical approximation so long as the specified zero exists."
}], "Notes",
 CellID->43381924],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["AiryBiZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBiZero"], "[", 
   StyleBox["k", "TI"], "]"}]], "InlineFormula"],
 " represents the ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " zero less than 0."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiZero"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiZero"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->743432258],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->248925918],

Cell["Evaluate numerically:", "ExampleText",
 CellID->24457934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"AiryBiZero", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->846423094],

Cell[BoxData[
 RowBox[{"-", "1.173713222709128`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11575927]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->107280062],

Cell["Evaluate symbolically:", "ExampleText",
 CellID->94628078],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AiryBi", "[", 
  RowBox[{"AiryBiZero", "[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16966966],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21451089]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->4879934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"AiryBiZero", "[", "10", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210060541],

Cell[BoxData[
 RowBox[{"-", 
  "12.3864171385827387455619015028632809482597983846856097159318936467364`50.\
"}]], "Output",
 ImageSize->{369, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->566848843]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81909017],

Cell[TextData[{
 "Find the first zero of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"Bi", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " less than -1000:"
}], "ExampleText",
 CellID->25126027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"AiryBiZero", "[", 
   RowBox[{"1", ",", 
    RowBox[{"-", "1000"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->726288814],

Cell[BoxData[
 RowBox[{"-", "1000.0683872565394`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->52023348]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->219294962],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AiryBiZero",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AiryBiZero"]], "InlineFormula"],
 " ",
 "threads element-wise over lists:"
}], "ExampleText",
 CellID->65490277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AiryBiZero", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}], "//", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298902341],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.173713222709128`"}], ",", 
   RowBox[{"-", "3.271093302836353`"}], ",", 
   RowBox[{"-", "4.830737841662016`"}]}], "}"}]], "Output",
 ImageSize->{211, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->288658966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465855712],

Cell[TextData[{
 "Asymptotic behavior of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AiryBiZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBiZero"], "[", 
   StyleBox["k", "TI"], "]"}]], "InlineFormula"],
 " for large ",
 Cell[BoxData[
  StyleBox["k", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14555186],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"AiryBiZero", "[", "k", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "\[Infinity]", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->125185909],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"77125", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["1", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["3", "4"]}], "+", "k"}]], ")"}], 
      RowBox[{"16", "/", "3"}]]}], 
    RowBox[{"314928", " ", 
     SuperscriptBox["2", 
      RowBox[{"2", "/", "3"}]], " ", 
     SuperscriptBox["3", 
      RowBox[{"1", "/", "3"}]], " ", 
     SuperscriptBox["\[Pi]", 
      RowBox[{"16", "/", "3"}]]}]]}], "+", 
  FractionBox[
   RowBox[{"10", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["2", "3"], ")"}], 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "+", "k"}]], ")"}], 
     RowBox[{"10", "/", "3"}]]}], 
   RowBox[{"243", " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"10", "/", "3"}]]}]], "-", 
  FractionBox[
   RowBox[{"5", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["3", "4"]}], "+", "k"}]], ")"}], 
     RowBox[{"4", "/", "3"}]]}], 
   RowBox[{"36", " ", 
    SuperscriptBox["2", 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["3", 
     RowBox[{"1", "/", "3"}]], " ", 
    SuperscriptBox["\[Pi]", 
     RowBox[{"4", "/", "3"}]]}]], "-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"3", " ", "\[Pi]"}], "2"], ")"}], 
    RowBox[{"2", "/", "3"}]], 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["3", "4"]}], "+", "k"}]], ")"}], 
    RowBox[{"2", "/", "3"}]]]}]], "Output",
 ImageSize->{465, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->359946491]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Display zeros on the plot:", "ExampleText",
 CellID->32898500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"AiryBi", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "20"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Prolog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "0.03", "]"}], ",", 
      RowBox[{"Point", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"AiryBiZero", "[", "k", "]"}], ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", "19"}], "}"}]}], "]"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184083053],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 109},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169458091]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryBi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryBi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AiryAiZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AiryAiZero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BesselJZero",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BesselJZero"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindRoot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindRoot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->23022]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Bessel-Related Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BesselRelatedFunctions"]], "MoreAbout",
 CellID->162613776],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->224163126],

Cell[TextData[ButtonBox["Inverse Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InverseFunctions"]], "MoreAbout",
 CellID->197034788],

Cell[TextData[ButtonBox["New in 6.0: Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicalFunctions"]], "MoreAbout",
 CellID->313390294]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AiryBiZero - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 53.5328444}", "context" -> "System`", 
    "keywords" -> {"Airy Bi zero", "zero of airy function"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "AiryBiZero[k] represents the k\\[Null]^th zero of the Airy function \
Bi(x). AiryBiZero[k, x_0] represents the k\\[Null]^th zero less than x_0.", 
    "synonyms" -> {"airy bi zero"}, "title" -> "AiryBiZero", "type" -> 
    "Symbol", "uri" -> "ref/AiryBiZero"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8094, 253, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->743432258]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24832, 792}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2588, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3211, 87, 1575, 37, 70, "ObjectNameGrid"],
Cell[4789, 126, 1473, 49, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6299, 180, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6777, 197, 120, 4, 70, "Notes",
 CellID->20640],
Cell[6900, 203, 316, 10, 70, "Notes",
 CellID->43381924],
Cell[7219, 215, 405, 15, 70, "Notes",
 CellID->1067943069],
Cell[7627, 232, 222, 7, 70, "Notes",
 CellID->31226],
Cell[7852, 241, 205, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[8094, 253, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->743432258],
Cell[CellGroupData[{
Cell[8479, 267, 148, 5, 70, "ExampleSection",
 CellID->248925918],
Cell[8630, 274, 63, 1, 70, "ExampleText",
 CellID->24457934],
Cell[CellGroupData[{
Cell[8718, 279, 134, 4, 28, "Input",
 CellID->846423094],
Cell[8855, 285, 191, 6, 36, "Output",
 CellID->11575927]
}, Open  ]],
Cell[9061, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->107280062],
Cell[9189, 299, 64, 1, 70, "ExampleText",
 CellID->94628078],
Cell[CellGroupData[{
Cell[9278, 304, 138, 4, 70, "Input",
 CellID->16966966],
Cell[9419, 310, 157, 5, 36, "Output",
 CellID->21451089]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9625, 321, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9849, 330, 68, 1, 70, "ExampleText",
 CellID->4879934],
Cell[CellGroupData[{
Cell[9942, 335, 160, 5, 70, "Input",
 CellID->210060541],
Cell[10105, 342, 254, 8, 36, "Output",
 CellID->566848843]
}, Open  ]],
Cell[10374, 353, 124, 3, 70, "ExampleDelimiter",
 CellID->81909017],
Cell[10501, 358, 196, 7, 70, "ExampleText",
 CellID->25126027],
Cell[CellGroupData[{
Cell[10722, 369, 181, 6, 70, "Input",
 CellID->726288814],
Cell[10906, 377, 192, 6, 36, "Output",
 CellID->52023348]
}, Open  ]],
Cell[11113, 386, 125, 3, 70, "ExampleDelimiter",
 CellID->219294962],
Cell[11241, 391, 218, 8, 70, "ExampleText",
 CellID->65490277],
Cell[CellGroupData[{
Cell[11484, 403, 189, 6, 70, "Input",
 CellID->298902341],
Cell[11676, 411, 322, 10, 36, "Output",
 CellID->288658966]
}, Open  ]],
Cell[12013, 424, 125, 3, 70, "ExampleDelimiter",
 CellID->465855712],
Cell[12141, 429, 333, 13, 70, "ExampleText",
 CellID->14555186],
Cell[CellGroupData[{
Cell[12499, 446, 232, 7, 70, "Input",
 CellID->125185909],
Cell[12734, 455, 1864, 68, 102, "Output",
 CellID->359946491]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14647, 529, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[14877, 538, 68, 1, 70, "ExampleText",
 CellID->32898500],
Cell[CellGroupData[{
Cell[14970, 543, 651, 21, 70, "Input",
 CellID->184083053],
Cell[15624, 566, 5198, 89, 70, "Output",
 Evaluatable->False,
 CellID->169458091]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20883, 662, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[21202, 673, 951, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[22190, 713, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[22511, 724, 144, 3, 70, "Tutorials",
 CellID->23022]
}, Open  ]],
Cell[CellGroupData[{
Cell[22692, 732, 299, 8, 70, "MoreAboutSection"],
Cell[22994, 742, 158, 3, 70, "MoreAbout",
 CellID->162613776],
Cell[23155, 747, 178, 3, 70, "MoreAbout",
 CellID->224163126],
Cell[23336, 752, 145, 3, 70, "MoreAbout",
 CellID->197034788],
Cell[23484, 757, 174, 3, 70, "MoreAbout",
 CellID->313390294]
}, Open  ]],
Cell[23673, 763, 27, 0, 70, "History"],
Cell[23703, 765, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

