(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26743,        982]
NotebookOptionsPosition[     21309,        794]
NotebookOutlinePosition[     22681,        832]
CellTagsIndexPosition[     22596,        827]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AlgebraicNumber" :> 
          Documentation`HelpLookup["paclet:ref/AlgebraicNumber"], 
          "ToNumberField" :> 
          Documentation`HelpLookup["paclet:ref/ToNumberField"], 
          "MinimalPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/MinimalPolynomial"], 
          "NumberFieldIntegralBasis" :> 
          Documentation`HelpLookup["paclet:ref/NumberFieldIntegralBasis"], 
          "FromDigits" :> 
          Documentation`HelpLookup["paclet:ref/FromDigits"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AlgebraicNumber\"\>", 
       2->"\<\"ToNumberField\"\>", 3->"\<\"MinimalPolynomial\"\>", 
       4->"\<\"NumberFieldIntegralBasis\"\>", 
       5->"\<\"FromDigits\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["AlgebraicNumberPolynomial", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["AlgebraicNumberPolynomial",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/AlgebraicNumberPolynomial"], "[", 
       RowBox[{
        StyleBox["a", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the polynomial in ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " corresponding to the ",
     Cell[BoxData[
      ButtonBox["AlgebraicNumber",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
     " object ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For an algebraic number ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " of the form ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"], "[", 
   RowBox[{
    StyleBox["\[Theta]", "TR"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["0", "TR"]], ",", 
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["AlgebraicNumberPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumberPolynomial"], "[", 
   RowBox[{
    StyleBox["a", "TI"], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " is the polynomial ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["c", 
    StyleBox["0", "TR"]], "+", 
   RowBox[{
    SubscriptBox["c", 
     StyleBox["1", "TR"]], "x"}], "+", 
   RowBox[{
    SubscriptBox["c", 
     StyleBox["2", "TR"]], 
    SuperscriptBox["x", 
     StyleBox["2", "TR"]]}], "+", 
   StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
 ", from which ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " can be obtained by replacing ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  StyleBox["\[Theta]", "TR"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->279574279],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->97250917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "+", 
    RowBox[{"Sqrt", "[", "3", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575369133],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"10", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{369, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180191971]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberPolynomial", "[", 
  RowBox[{"%", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->918473467],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->243616049]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Integers and rational numbers:", "ExampleText",
 CellID->288458106],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberPolynomial", "[", 
  RowBox[{"2", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1244796263],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20149973]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberPolynomial", "[", 
  RowBox[{
   RowBox[{"1", "/", "2"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1374897400],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->935404562]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1975234186],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->1958748776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberPolynomial", "[", 
  RowBox[{
   RowBox[{"AlgebraicNumber", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1913853369],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", "x"}]}]], "Output",
 ImageSize->{41, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->571438695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1017184307],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumberPolynomial",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumberPolynomial"]], "InlineFormula"],
 " threads automatically over lists:"
}], "ExampleText",
 CellID->1846817629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberPolynomial", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", " ", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}]}], "]"}]}], "}"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1882740512],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", 
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}]}]}], "}"}]], "Output",
 ImageSize->{73, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->396521081]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Addition of algebraic numbers using polynomials:", "ExampleText",
 CellID->385262479],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "\[Lambda]"}], "}"}], " ", "=", " ", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "+", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}], ",", 
     RowBox[{"AlgebraicNumber", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"Sqrt", "[", "2", "]"}], "+", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "2"}], ",", "1", ",", "1"}], "}"}]}], "]"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1985526862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{"\[Theta]", "+", "\[Lambda]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2061647618],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "129575"}], "+", 
     RowBox[{"107800", " ", "#1"}], "-", 
     RowBox[{"22114", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"88", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{354, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106831605]
}, Open  ]],

Cell["An equivalent way of performing the same operation:", "ExampleText",
 CellID->1168082322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AlgebraicNumberPolynomial", "[", 
   RowBox[{"\[Theta]", ",", "x"}], "]"}], "+", 
  RowBox[{"AlgebraicNumberPolynomial", "[", 
   RowBox[{"\[Lambda]", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->973033334],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"5", " ", 
   SuperscriptBox["x", "3"]}]}]], "Output",
 ImageSize->{82, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3524755]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{"%", "/.", " ", 
   RowBox[{"x", "\[Rule]", " ", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", 
     RowBox[{"Sqrt", "[", "3", "]"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1803423490],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "129575"}], "+", 
     RowBox[{"107800", " ", "#1"}], "-", 
     RowBox[{"22114", " ", 
      SuperscriptBox["#1", "2"]}], "-", 
     RowBox[{"88", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}]], "Output",
 ImageSize->{354, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->52970113]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " by definition is a polynomial function of an algebraic number:"
}], "ExampleText",
 CellID->1171271520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", "=", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", "+", 
      RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120010625],

Cell[BoxData[
 RowBox[{"AlgebraicNumber", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"1", "-", 
       RowBox[{"4", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       SuperscriptBox["#1", "4"]}], "&"}], ",", "4"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}]}], "]"}]], "Output",
 ImageSize->{362, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683624355]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"b", " ", "=", " ", 
  RowBox[{
   RowBox[{"AlgebraicNumberPolynomial", "[", 
    RowBox[{"a", ",", "x"}], "]"}], " ", "/.", " ", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"2", "+", 
      RowBox[{"Sqrt", "[", "3", "]"}]}], "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17945372],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   SqrtBox[
    RowBox[{"2", "+", 
     SqrtBox["3"]}]]}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SqrtBox["3"]}], ")"}]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"2", "+", 
      SqrtBox["3"]}], ")"}], 
    RowBox[{"3", "/", "2"}]]}]}]], "Output",
 ImageSize->{272, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->257420602]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RootReduce", "[", 
  RowBox[{"b", "\[Equal]", "a"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1706789109],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->129546338]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "The input must be an ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " object or a rational number:"
}], "ExampleText",
 CellID->1770014210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AlgebraicNumberPolynomial", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "2", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1685349226],

Cell[BoxData[
 RowBox[{
  RowBox[{"AlgebraicNumberPolynomial", "::", "\<\"naobj\"\>"}], ":", 
  " ", "\<\"\\!\\(\\@2\\) is not a valid AlgebraicNumber object. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/naobj\\\", \
ButtonNote -> \\\"AlgebraicNumberPolynomial::naobj\\\"]\\)\"\>"}]], "Message",\
 "MSG",
 CellID->683348674],

Cell[BoxData[
 RowBox[{"AlgebraicNumberPolynomial", "[", 
  RowBox[{
   SqrtBox["2"], ",", "x"}], "]"}]], "Output",
 ImageSize->{236, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->234165156]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlgebraicNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlgebraicNumber"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MinimalPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MinimalPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberFieldIntegralBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberFieldIntegralBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromDigits",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromDigits"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->52389866],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->352340412]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"AlgebraicNumberPolynomial - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 56.2360386}", "context" -> "System`", 
    "keywords" -> {"algebraic number", "polynomial", "primitive element"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "AlgebraicNumberPolynomial[a, x] gives the polynomial in x corresponding \
to the AlgebraicNumber object a.", 
    "synonyms" -> {"algebraic number polynomial"}, "title" -> 
    "AlgebraicNumberPolynomial", "type" -> "Symbol", "uri" -> 
    "ref/AlgebraicNumberPolynomial"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6869, 217, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->279574279]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22453, 820}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1733, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2356, 68, 1590, 37, 70, "ObjectNameGrid"],
Cell[3949, 107, 896, 28, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4882, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5360, 157, 1472, 55, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[6869, 217, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->279574279],
Cell[CellGroupData[{
Cell[7254, 231, 147, 5, 70, "ExampleSection",
 CellID->97250917],
Cell[CellGroupData[{
Cell[7426, 240, 293, 9, 28, "Input",
 CellID->575369133],
Cell[7722, 251, 545, 18, 39, "Output",
 CellID->180191971]
}, Open  ]],
Cell[CellGroupData[{
Cell[8304, 274, 144, 4, 28, "Input",
 CellID->918473467],
Cell[8451, 280, 368, 13, 36, "Output",
 CellID->243616049]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8868, 299, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[9092, 308, 73, 1, 70, "ExampleText",
 CellID->288458106],
Cell[CellGroupData[{
Cell[9190, 313, 145, 4, 70, "Input",
 CellID->1244796263],
Cell[9338, 319, 157, 5, 36, "Output",
 CellID->20149973]
}, Open  ]],
Cell[CellGroupData[{
Cell[9532, 329, 169, 5, 70, "Input",
 CellID->1374897400],
Cell[9704, 336, 178, 6, 51, "Output",
 CellID->935404562]
}, Open  ]],
Cell[9897, 345, 126, 3, 70, "ExampleDelimiter",
 CellID->1975234186],
Cell[10026, 350, 201, 7, 70, "ExampleText",
 CellID->1958748776],
Cell[CellGroupData[{
Cell[10252, 361, 300, 9, 70, "Input",
 CellID->1913853369],
Cell[10555, 372, 203, 7, 36, "Output",
 CellID->571438695]
}, Open  ]],
Cell[10773, 382, 126, 3, 70, "ExampleDelimiter",
 CellID->1017184307],
Cell[10902, 387, 246, 7, 70, "ExampleText",
 CellID->1846817629],
Cell[CellGroupData[{
Cell[11173, 398, 367, 12, 70, "Input",
 CellID->1882740512],
Cell[11543, 412, 252, 9, 36, "Output",
 CellID->396521081]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11844, 427, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[12074, 436, 91, 1, 70, "ExampleText",
 CellID->385262479],
Cell[12168, 439, 764, 24, 70, "Input",
 CellID->1985526862],
Cell[CellGroupData[{
Cell[12957, 467, 145, 4, 70, "Input",
 CellID->2061647618],
Cell[13105, 473, 487, 16, 39, "Output",
 CellID->106831605]
}, Open  ]],
Cell[13607, 492, 95, 1, 70, "ExampleText",
 CellID->1168082322],
Cell[CellGroupData[{
Cell[13727, 497, 259, 7, 70, "Input",
 CellID->973033334],
Cell[13989, 506, 284, 10, 36, "Output",
 CellID->3524755]
}, Open  ]],
Cell[CellGroupData[{
Cell[14310, 521, 264, 8, 70, "Input",
 CellID->1803423490],
Cell[14577, 531, 486, 16, 39, "Output",
 CellID->52970113]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15112, 553, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[15353, 562, 255, 7, 70, "ExampleText",
 CellID->1171271520],
Cell[CellGroupData[{
Cell[15633, 573, 323, 10, 70, "Input",
 CellID->120010625],
Cell[15959, 585, 496, 16, 39, "Output",
 CellID->683624355]
}, Open  ]],
Cell[CellGroupData[{
Cell[16492, 606, 337, 10, 70, "Input",
 CellID->17945372],
Cell[16832, 618, 504, 20, 49, "Output",
 CellID->257420602]
}, Open  ]],
Cell[CellGroupData[{
Cell[17373, 643, 137, 4, 70, "Input",
 CellID->1706789109],
Cell[17513, 649, 161, 5, 36, "Output",
 CellID->129546338]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17723, 660, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[17957, 669, 247, 8, 70, "ExampleText",
 CellID->1770014210],
Cell[CellGroupData[{
Cell[18229, 681, 177, 5, 70, "Input",
 CellID->1685349226],
Cell[18409, 688, 417, 8, 70, "Message",
 CellID->683348674],
Cell[18829, 698, 246, 8, 43, "Output",
 CellID->234165156]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19136, 713, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[19455, 724, 1268, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[20760, 773, 318, 9, 70, "MoreAboutSection",
 CellID->52389866],
Cell[21081, 784, 156, 3, 70, "MoreAbout",
 CellID->352340412]
}, Open  ]],
Cell[21252, 790, 27, 0, 70, "History"],
Cell[21282, 792, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

