(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29137,       1098]
NotebookOptionsPosition[     22582,        871]
NotebookOutlinePosition[     23931,        909]
CellTagsIndexPosition[     23846,        904]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Using Assumptions" :> 
          Documentation`HelpLookup["paclet:tutorial/UsingAssumptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Using Assumptions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Element" :> Documentation`HelpLookup["paclet:ref/Element"], 
          "Simplify" :> Documentation`HelpLookup["paclet:ref/Simplify"], 
          "Integers" :> Documentation`HelpLookup["paclet:ref/Integers"], 
          "Root" :> Documentation`HelpLookup["paclet:ref/Root"], "Extension" :> 
          Documentation`HelpLookup["paclet:ref/Extension"], "Reals" :> 
          Documentation`HelpLookup["paclet:ref/Reals"], "Rationals" :> 
          Documentation`HelpLookup["paclet:ref/Rationals"], "Complexes" :> 
          Documentation`HelpLookup["paclet:ref/Complexes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Element\"\>", 2->"\<\"Simplify\"\>",
        3->"\<\"Integers\"\>", 4->"\<\"Root\"\>", 5->"\<\"Extension\"\>", 
       6->"\<\"Reals\"\>", 7->"\<\"Rationals\"\>", 
       8->"\<\"Complexes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Assumptions and Domains" :> 
          Documentation`HelpLookup["paclet:guide/AssumptionsAndDomains"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Assumptions and Domains\"\>", 3->"\<\"Number Recognition\"\>", 
       4->"\<\"Number Theory\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Algebraics", "ObjectName",
 CellID->32425],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Algebraics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
     "\[LineSeparator]represents the domain of algebraic numbers, as in ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], 
       StyleBox["\[Element]", "TR"], "Algebraics"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26867]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Algebraic numbers are defined to be numbers that solve polynomial equations \
with rational coefficients. \
\>", "Notes",
 CellID->13189],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], 
   StyleBox["\[Element]", "TR"], "Algebraics"}]], "InlineFormula"],
 " evaluates immediately only for quantities ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " that are explicitly constructed from rational numbers, radicals and ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects, or are known to be transcendental. "
}], "Notes",
 CellID->10542],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], 
    StyleBox["\[Element]", "TR"], "Algebraics"}], "]"}]], "InlineFormula"],
 " can be used to try to determine whether an expression corresponds to an \
algebraic number. "
}], "Notes",
 CellID->13063],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 " is output in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " as ",
 Cell[BoxData[
  FormBox["\[DoubleStruckCapitalA]", TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->21547]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337063541],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->607438096],

Cell["An algebraic number:", "ExampleText",
 CellID->1861421917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"6", "+", 
      RowBox[{"I", " ", 
       RowBox[{"Sqrt", "[", "5", "]"}]}]}], ")"}], "^", 
    RowBox[{"(", 
     RowBox[{"1", "/", "3"}], ")"}]}], ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->376389523],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254415025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205006662],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " is not an algebraic number:"
}], "ExampleText",
 CellID->1169690380],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{"Pi", ",", " ", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->920912022],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105044194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19797180],

Cell["\<\
The square root of an algebraic number is an algebraic number:\
\>", "ExampleText",
 CellID->118080933],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", "x", "]"}], ",", "Algebraics"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Algebraics"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107600702],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->318929521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->335285338],

Cell["Find algebraic solutions of an equation:", "ExampleText",
 CellID->595802410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "E"}], ")"}]}], "\[Equal]", "0"}], ",", 
   "x", ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67769349],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SqrtBox["2"]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SqrtBox["2"]}]}]], "Output",
 ImageSize->{128, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->247773291]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->232204150],

Cell["Test domain membership of a numeric expression:  ", "ExampleText",
 CellID->186508013],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "^", 
    RowBox[{"Sqrt", "[", "2", "]"}]}], ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->150279975],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2117075]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "Pi", "]"}], ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->183880553],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->384725775]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->766994403],

Cell["Make domain membership assumptions:", "ExampleText",
 CellID->24636061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Sqrt", "[", "x", "]"}], "^", "2"}], "+", 
      RowBox[{"y", "^", 
       RowBox[{"(", 
        RowBox[{"2", "/", "3"}], ")"}]}]}], ",", "Algebraics"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{
     RowBox[{"x", "|", "y"}], ",", "Algebraics"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144317606],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238183167]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37527979],

Cell[TextData[{
 "Specify the default domain for ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->207424431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "3"}], "-", "7"}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", 
       RowBox[{"Pi", "^", "2"}]}], ")"}]}], "\[Equal]", "0"}], ",", "x", ",", 
   "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->816452736],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"-", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "7"}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   SuperscriptBox["7", 
    RowBox[{"1", "/", "3"}]]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], 
     RowBox[{"2", "/", "3"}]], " ", 
    SuperscriptBox["7", 
     RowBox[{"1", "/", "3"}]]}]}]}]], "Output",
 ImageSize->{260, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->113636346]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"1", "/", "2"}], "<=", 
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<=", "1"}], " ", "&&", " ", 
      RowBox[{"y", "==", 
       RowBox[{"x", "^", "2"}]}]}]}], "]"}], ",", "Algebraics"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103904224],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->498968068]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7406872],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " of formatting:"
}], "ExampleText",
 CellID->2113989541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Algebraics", "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1852759619],

Cell[BoxData[
 FormBox[
  TagBox["\[DoubleStruckCapitalA]",
   Function[{}, Algebraics]], TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->393160515]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->429479862],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 " contains ",
 Cell[BoxData[
  ButtonBox["Rationals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationals"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Integers",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integers"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Primes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Primes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->706275928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Refine", "[", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "Algebraics"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"x", ",", "#"}], "]"}]}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Rationals", ",", "Integers", ",", "Primes"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->289987794],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14311539]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36287242],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 " is contained in ",
 Cell[BoxData[
  ButtonBox["Complexes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complexes"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->356793860],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Complexes"}], "]"}], ",", 
   RowBox[{"Element", "[", 
    RowBox[{"x", ",", "Algebraics"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->134385914],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->66589800]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139033113],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Algebraics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Algebraics"]], "InlineFormula"],
 " neither contains nor is contained in ",
 Cell[BoxData[
  ButtonBox["Reals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reals"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139072146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Element", "[", 
      RowBox[{"#", ",", "Reals"}], "]"}], ",", 
     RowBox[{"Element", "[", 
      RowBox[{"#", ",", "Algebraics"}], "]"}]}], "}"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{"Pi", ",", "I"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->662754147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "True"}], "}"}]}], "}"}]], "Output",
 ImageSize->{206, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->187264744]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29962],

Cell["Some numbers are not yet known to be algebraic or not: ", "ExampleText",
 CellID->141542687],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"EulerGamma", " ", "\[Element]", " ", "Algebraics"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643543180],

Cell[BoxData[
 RowBox[{"EulerGamma", "\[Element]", "Algebraics"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3935328]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17226],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Element",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Element"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Simplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Simplify"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integers",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integers"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rationals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rationals"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Complexes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Complexes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31203]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30502],

Cell[TextData[ButtonBox["Using Assumptions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/UsingAssumptions"]], "Tutorials",
 CellID->29617]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->211002851],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->6486189],

Cell[TextData[ButtonBox["Assumptions and Domains",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AssumptionsAndDomains"]], "MoreAbout",
 CellID->123054902],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->106557198],

Cell[TextData[ButtonBox["Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheory"]], "MoreAbout",
 CellID->772399473]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Algebraics - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 23, 57.2829404}", "context" -> "System`", 
    "keywords" -> {
     "algebraic numbers", "algebraic solutions", "algebraic variables", 
      "domain of algebraic numbers", "type specification"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Algebraics represents the domain of algebraic numbers, as in x \
\\[Element] Algebraics. ", "synonyms" -> {}, "title" -> "Algebraics", "type" -> 
    "Symbol", "uri" -> "ref/Algebraics"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6075, 188, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->337063541]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 23703, 897}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2810, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3433, 88, 48, 1, 70, "ObjectName",
 CellID->32425],
Cell[3484, 91, 583, 18, 70, "Usage",
 CellID->26867]
}, Open  ]],
Cell[CellGroupData[{
Cell[4104, 114, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4582, 131, 147, 4, 70, "Notes",
 CellID->13189],
Cell[4732, 137, 502, 15, 70, "Notes",
 CellID->10542],
Cell[5237, 154, 378, 12, 70, "Notes",
 CellID->13063],
Cell[5618, 168, 420, 15, 70, "Notes",
 CellID->21547]
}, Closed]],
Cell[CellGroupData[{
Cell[6075, 188, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337063541],
Cell[CellGroupData[{
Cell[6460, 202, 148, 5, 70, "ExampleSection",
 CellID->607438096],
Cell[6611, 209, 64, 1, 70, "ExampleText",
 CellID->1861421917],
Cell[CellGroupData[{
Cell[6700, 214, 324, 11, 28, "Input",
 CellID->376389523],
Cell[7027, 227, 161, 5, 36, "Output",
 CellID->254415025]
}, Open  ]],
Cell[7203, 235, 125, 3, 70, "ExampleDelimiter",
 CellID->205006662],
Cell[7331, 240, 148, 5, 70, "ExampleText",
 CellID->1169690380],
Cell[CellGroupData[{
Cell[7504, 249, 141, 4, 70, "Input",
 CellID->920912022],
Cell[7648, 255, 162, 5, 36, "Output",
 CellID->105044194]
}, Open  ]],
Cell[7825, 263, 124, 3, 70, "ExampleDelimiter",
 CellID->19797180],
Cell[7952, 268, 113, 3, 70, "ExampleText",
 CellID->118080933],
Cell[CellGroupData[{
Cell[8090, 275, 299, 9, 70, "Input",
 CellID->107600702],
Cell[8392, 286, 161, 5, 36, "Output",
 CellID->318929521]
}, Open  ]],
Cell[8568, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->335285338],
Cell[8696, 299, 83, 1, 70, "ExampleText",
 CellID->595802410],
Cell[CellGroupData[{
Cell[8804, 304, 360, 13, 70, "Input",
 CellID->67769349],
Cell[9167, 319, 288, 11, 38, "Output",
 CellID->247773291]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9504, 336, 220, 7, 70, "ExampleSection",
 CellID->232204150],
Cell[9727, 345, 92, 1, 70, "ExampleText",
 CellID->186508013],
Cell[CellGroupData[{
Cell[9844, 350, 225, 7, 70, "Input",
 CellID->150279975],
Cell[10072, 359, 160, 5, 36, "Output",
 CellID->2117075]
}, Open  ]],
Cell[CellGroupData[{
Cell[10269, 369, 167, 5, 70, "Input",
 CellID->183880553],
Cell[10439, 376, 162, 5, 36, "Output",
 CellID->384725775]
}, Open  ]],
Cell[10616, 384, 125, 3, 70, "ExampleDelimiter",
 CellID->766994403],
Cell[10744, 389, 77, 1, 70, "ExampleText",
 CellID->24636061],
Cell[CellGroupData[{
Cell[10846, 394, 462, 15, 70, "Input",
 CellID->144317606],
Cell[11311, 411, 161, 5, 36, "Output",
 CellID->238183167]
}, Open  ]],
Cell[11487, 419, 124, 3, 70, "ExampleDelimiter",
 CellID->37527979],
Cell[11614, 424, 337, 13, 70, "ExampleText",
 CellID->207424431],
Cell[CellGroupData[{
Cell[11976, 441, 390, 14, 70, "Input",
 CellID->816452736],
Cell[12369, 457, 628, 23, 36, "Output",
 CellID->113636346]
}, Open  ]],
Cell[CellGroupData[{
Cell[13034, 485, 496, 17, 70, "Input",
 CellID->103904224],
Cell[13533, 504, 161, 5, 36, "Output",
 CellID->498968068]
}, Open  ]],
Cell[13709, 512, 123, 3, 70, "ExampleDelimiter",
 CellID->7406872],
Cell[13835, 517, 207, 7, 70, "ExampleText",
 CellID->2113989541],
Cell[CellGroupData[{
Cell[14067, 528, 117, 3, 70, "Input",
 CellID->1852759619],
Cell[14187, 533, 265, 8, 50, "Output",
 CellID->393160515]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14501, 547, 237, 7, 70, "ExampleSection",
 CellID->429479862],
Cell[14741, 556, 569, 22, 70, "ExampleText",
 CellID->706275928],
Cell[CellGroupData[{
Cell[15335, 582, 384, 12, 70, "Input",
 CellID->289987794],
Cell[15722, 596, 222, 7, 36, "Output",
 CellID->14311539]
}, Open  ]],
Cell[15959, 606, 124, 3, 70, "ExampleDelimiter",
 CellID->36287242],
Cell[16086, 611, 325, 12, 70, "ExampleText",
 CellID->356793860],
Cell[CellGroupData[{
Cell[16436, 627, 262, 8, 70, "Input",
 CellID->134385914],
Cell[16701, 637, 160, 5, 36, "Output",
 CellID->66589800]
}, Open  ]],
Cell[16876, 645, 125, 3, 70, "ExampleDelimiter",
 CellID->139033113],
Cell[17004, 650, 338, 12, 70, "ExampleText",
 CellID->139072146],
Cell[CellGroupData[{
Cell[17367, 666, 349, 12, 70, "Input",
 CellID->662754147],
Cell[17719, 680, 316, 11, 36, "Output",
 CellID->187264744]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18084, 697, 226, 7, 70, "ExampleSection",
 CellID->29962],
Cell[18313, 706, 98, 1, 70, "ExampleText",
 CellID->141542687],
Cell[CellGroupData[{
Cell[18436, 711, 130, 3, 70, "Input",
 CellID->1643543180],
Cell[18569, 716, 206, 6, 36, "Output",
 CellID->3935328]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18836, 729, 311, 9, 70, "SeeAlsoSection",
 CellID->17226],
Cell[19150, 740, 1911, 71, 70, "SeeAlso",
 CellID->31203]
}, Open  ]],
Cell[CellGroupData[{
Cell[21098, 816, 314, 9, 70, "TutorialsSection",
 CellID->30502],
Cell[21415, 827, 144, 3, 70, "Tutorials",
 CellID->29617]
}, Open  ]],
Cell[CellGroupData[{
Cell[21596, 835, 319, 9, 70, "MoreAboutSection",
 CellID->211002851],
Cell[21918, 846, 143, 3, 70, "MoreAbout",
 CellID->6486189],
Cell[22064, 851, 156, 3, 70, "MoreAbout",
 CellID->123054902],
Cell[22223, 856, 147, 3, 70, "MoreAbout",
 CellID->106557198],
Cell[22373, 861, 137, 3, 70, "MoreAbout",
 CellID->772399473]
}, Open  ]],
Cell[22525, 867, 27, 0, 70, "History"],
Cell[22555, 869, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

