(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33562,       1161]
NotebookOptionsPosition[     28064,        975]
NotebookOutlinePosition[     29381,       1012]
CellTagsIndexPosition[     29295,       1007]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Cells" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForCells"], 
          "Redrawing and Combining Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RedrawingAndCombiningPlots"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Grids, Rows, and Columns in Mathematica" :> 
          Documentation`HelpLookup["paclet:tutorial/GridsRowsAndColumns"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Options for Cells\"\>", 
       2->"\<\"Redrawing and Combining Plots\"\>", 
       3->"\<\"Tables and Matrices\"\>", 
       4->"\<\"Grids, Rows, and Columns in Mathematica\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TextAlignment" :> 
          Documentation`HelpLookup["paclet:ref/TextAlignment"], 
          "AlignmentPoint" :> 
          Documentation`HelpLookup["paclet:ref/AlignmentPoint"], 
          "BaselinePosition" :> 
          Documentation`HelpLookup["paclet:ref/BaselinePosition"], "Item" :> 
          Documentation`HelpLookup["paclet:ref/Item"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"], "ControlPlacement" :> 
          Documentation`HelpLookup["paclet:ref/ControlPlacement"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"TextAlignment\"\>", 
       2->"\<\"AlignmentPoint\"\>", 3->"\<\"BaselinePosition\"\>", 
       4->"\<\"Item\"\>", 5->"\<\"Inset\"\>", 
       6->"\<\"ControlPlacement\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combining Graphics" :> 
          Documentation`HelpLookup["paclet:guide/CombiningGraphics"], 
          "Grids & Tables" :> 
          Documentation`HelpLookup["paclet:guide/GridsAndTables"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Combining Graphics\"\>", 
       2->"\<\"Grids & Tables\"\>", 3->"\<\"Layout & Tables\"\>", 
       4->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       5->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Alignment", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Alignment",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
     " \[LineSeparator]is an option which specifies how the contents of a \
displayed object should be aligned within the available area in the object."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3917]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be given:", "Notes",
 CellID->31717],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], 
    RowBox[{
    Cell["default alignment based on environment", "TableText"], " "}]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Left",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Left"], Cell["left aligned", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Right",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Right"], Cell["right aligned", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Top",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Top"], Cell["top aligned", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Bottom",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Bottom"], Cell["bottom aligned", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Baseline",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Baseline"], Cell[
    "baseline aligned", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Center",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Center"], Cell["centered", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["h", "TI"], ",", 
      StyleBox["v", "TI"]}], "}"}], Cell[
    "separate horizontal and vertical alignments", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["x", "TI"], Cell[TextData[{
     "aligned at position ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " from -1 (left) to +1 (right)"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], Cell[TextData[{
     "aligned at horizontal and vertical positions ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " from -1 to +1"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"c\", \"TI\"]\)\>\"", 
    RowBox[{
    Cell["aligned on the specified character in a grid", "TableText"], " "}]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->1892],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Alignment", "->", 
   ButtonBox["Center",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Center"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"Alignment", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Center",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Center"], ",", 
     ButtonBox["Center",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Center"]}], "}"}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13698],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{"Alignment", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " values run from -1 at the bottom to +1 at the top."
}], "Notes",
 CellID->11267],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Alignment", "->", 
   StyleBox["spec", "TI"]}]], "InlineFormula"],
 " indicates that the ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 " element of an object should align with the ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 " element of whatever object contains it. "
}], "Notes",
 CellID->11749],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"Alignment", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", the alignment for the contents of an object will be based on the \
alignment specified for whatever object contains it. "
}], "Notes",
 CellID->65],

Cell[TextData[{
 "For objects such as ",
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Column",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Column"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Row",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Row"]], "InlineFormula"],
 ", the setting for ",
 Cell[BoxData[
  ButtonBox["Alignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Alignment"]], "InlineFormula"],
 " can be a list that specifies alignments for individual columns, rows or \
elements. "
}], "Notes",
 CellID->15292]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26199861],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->190458782],

Cell["Align elements around the center of the grid:", "ExampleText",
 CellID->78137354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "20"}]}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "30"}]}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}], ",", 
       RowBox[{"Graphics", "[", 
        RowBox[{
         RowBox[{"Rectangle", "[", "]"}], ",", 
         RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Right", ",", "Left"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Bottom", ",", "Top"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42645857],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAw5AJxvAQDkP0fyALj
3P//gTSUZAADZpA4GDDogwgkvjmQYKSrKiYgoQ/kso2qHnKqmYGEGlR2VNeo
rlFdo7pGdY3qGtU1FHUNfFsQoWowtFTFgYQQllAkTTUozGWAXMlRXaO6RnUN
CV3YekGjqger6oGvpyCjKwyMAHcbAD0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{109, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1784855]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->468602814],

Cell[TextData[{
 "Different predefined alignment options for ",
 Cell[BoxData[
  ButtonBox["Button",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Button"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->569627317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<y\>\"", ",", 
       RowBox[{"ImageSize", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "50"}], "}"}]}], ",", 
       RowBox[{"Alignment", "\[Rule]", "a"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->618910655],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   ButtonBox["\<\"y\"\>",
    Alignment->Top,
    Appearance->Automatic,
    ButtonData->"paclet:ref/y",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    ImageSize->{Automatic, 50},
    Method->"Preemptive"], "xxx", 
   ButtonBox["\<\"y\"\>",
    Alignment->Center,
    Appearance->Automatic,
    ButtonData->"paclet:ref/y",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    ImageSize->{Automatic, 50},
    Method->"Preemptive"], "xxx", 
   ButtonBox["\<\"y\"\>",
    Alignment->Bottom,
    Appearance->Automatic,
    ButtonData->"paclet:ref/y",
    ButtonFrame->"DialogBox",
    ButtonFunction:>{},
    Evaluator->None,
    ImageSize->{Automatic, 50},
    Method->"Preemptive"]}],
  Row[{
    Button["y", ImageSize -> {Automatic, 50}, Alignment -> Top], 
    Button["y", ImageSize -> {Automatic, 50}, Alignment -> Center], 
    Button["y", ImageSize -> {Automatic, 50}, Alignment -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{106, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584138253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->163689999],

Cell["Align expressions within panel:", "ExampleText",
 CellID->11517942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Panel", "[", 
     RowBox[{
      RowBox[{"x", "+", "y", "+", "z"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"100", ",", "50"}], "}"}]}], ",", 
      RowBox[{"Alignment", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"w", ",", "h"}], "}"}]}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"h", ",", 
      RowBox[{"{", 
       RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", 
      RowBox[{"{", 
       RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], "]"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92528656],

Cell[BoxData[
 TagBox[GridBox[{
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Left, Top},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Center, Top},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Right, Top},
      ImageSize->{100, 50}]},
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Left, Center},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Center, Center},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Right, Center},
      ImageSize->{100, 50}]},
    {
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Left, Bottom},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Center, Bottom},
      ImageSize->{100, 50}], 
     PanelBox[
      RowBox[{"x", "+", "y", "+", "z"}],
      Alignment->{Right, Bottom},
      ImageSize->{100, 50}]}
   }],
  "Grid"]], "Output",
 ImageSize->{320, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38632786]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18630],

Cell["Align the contents of a grid to the left:", "ExampleText",
 CellID->771853027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "bbbb"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ccc", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "Left"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1732596909],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "bbbb"},
    {"ccc", "d"}
   },
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}}],
  "Grid"]], "Output",
 ImageSize->{72, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88446449]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1415328442],

Cell["Align numbers on the decimal point:", "ExampleText",
 CellID->1896250522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.234", ",", "12.34"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"123.4", ",", "1234."}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1234", ",", "1.234"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", "\"\<.\>\""}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1625201774],

Cell[BoxData[
 TagBox[GridBox[{
    {"1.234`", "12.34`"},
    {"123.4`", "1234.`"},
    {"1234", "1.234`"}
   },
   GridBoxAlignment->{"Columns" -> {{"."}}, "Rows" -> {{"."}}}],
  "Grid"]], "Output",
 ImageSize->{124, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->460784619]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->507118242],

Cell["Align an element within a grid:", "ExampleText",
 CellID->1921181998],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Item", "[", 
       RowBox[{"a", ",", 
        RowBox[{"Alignment", "\[Rule]", "Left"}]}], "]"}], ",", "bbbb"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"ccc", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1889207741],

Cell[BoxData[
 TagBox[GridBox[{
    {
     ItemBox["a",
      Alignment->Left,
      StripOnInput->False], "bbbb"},
    {"ccc", "d"},
    {"e", "f"}
   }],
  "Grid"]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->581060451]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19172],

Cell["Align the columns of a grid separately:", "ExampleText",
 CellID->1380306720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<first\>\"", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<second\>\"", ",", "100"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"Right", ",", "Left"}], "}"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1643344302],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"first\"\>", "1"},
    {"\<\"second\"\>", "100"}
   },
   GridBoxAlignment->{"Columns" -> {Right, Left}}],
  "Grid"]], "Output",
 ImageSize->{75, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1274857048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->628453180],

Cell["Align a set of elements within a grid:", "ExampleText",
 CellID->1582854460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "bbbb"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ccc", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"Alignment", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Center", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "Left"}], ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", "2"}], "}"}], "\[Rule]", "Right"}]}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7490184],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "bbbb"},
    {"ccc", "d"},
    {"e", "f"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Center}}, "Rows" -> {{Automatic}}, 
     "ItemsIndexed" -> {{1, 1} -> {Left, Inherited}, {2, 2} -> {
        Right, Inherited}}}],
  "Grid"]], "Output",
 ImageSize->{61, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->534163193]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2003],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextAlignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextAlignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AlignmentPoint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AlignmentPoint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["BaselinePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BaselinePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Item",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Item"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControlPlacement",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlPlacement"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29130]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10389],

Cell[TextData[ButtonBox["Options for Cells",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForCells"]], "Tutorials",
 CellID->992],

Cell[TextData[ButtonBox["Redrawing and Combining Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RedrawingAndCombiningPlots"]], "Tutorials",
 CellID->25408],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->811360059],

Cell[TextData[{
 ButtonBox["Grids, Rows, and Columns in ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/GridsRowsAndColumns"],
  FontSlant->"Italic"]
}], "Tutorials",
 CellID->542584750]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->798974949],

Cell[TextData[ButtonBox["Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CombiningGraphics"]], "MoreAbout",
 CellID->731127786],

Cell[TextData[ButtonBox["Grids & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GridsAndTables"]], "MoreAbout",
 CellID->114446916],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->266871097],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->1301440],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->26732568]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Alignment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 24, 2.5018240}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Alignment is an option which specifies how the contents of a displayed \
object should be aligned within the available area in the object.", 
    "synonyms" -> {"align", "rowalign", "columnalign", "groupalign"}, "title" -> 
    "Alignment", "type" -> "Symbol", "uri" -> "ref/Alignment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11687, 349, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->26199861]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29152, 1000}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3546, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4169, 105, 1574, 37, 70, "ObjectNameGrid"],
Cell[5746, 144, 513, 14, 70, "Usage",
 CellID->3917]
}, Open  ]],
Cell[CellGroupData[{
Cell[6296, 163, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6774, 180, 69, 1, 70, "Notes",
 CellID->31717],
Cell[6846, 183, 2578, 73, 70, "2ColumnTableMod",
 CellID->1892],
Cell[9427, 258, 514, 19, 70, "Notes",
 CellID->13698],
Cell[9944, 279, 334, 13, 70, "Notes",
 CellID->11267],
Cell[10281, 294, 376, 12, 70, "Notes",
 CellID->11749],
Cell[10660, 308, 333, 10, 70, "Notes",
 CellID->65],
Cell[10996, 320, 654, 24, 70, "Notes",
 CellID->15292]
}, Closed]],
Cell[CellGroupData[{
Cell[11687, 349, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->26199861],
Cell[CellGroupData[{
Cell[12071, 363, 148, 5, 70, "ExampleSection",
 CellID->190458782],
Cell[12222, 370, 87, 1, 70, "ExampleText",
 CellID->78137354],
Cell[CellGroupData[{
Cell[12334, 375, 1148, 35, 65, "Input",
 CellID->42645857],
Cell[13485, 412, 425, 11, 116, "Output",
 Evaluatable->False,
 CellID->1784855]
}, Open  ]],
Cell[13925, 426, 125, 3, 70, "ExampleDelimiter",
 CellID->468602814],
Cell[14053, 431, 222, 8, 70, "ExampleText",
 CellID->569627317],
Cell[CellGroupData[{
Cell[14300, 443, 560, 17, 70, "Input",
 CellID->618910655],
Cell[14863, 462, 1152, 39, 70, "Output",
 CellID->584138253]
}, Open  ]],
Cell[16030, 504, 125, 3, 70, "ExampleDelimiter",
 CellID->163689999],
Cell[16158, 509, 73, 1, 70, "ExampleText",
 CellID->11517942],
Cell[CellGroupData[{
Cell[16256, 514, 730, 23, 70, "Input",
 CellID->92528656],
Cell[16989, 539, 1279, 47, 70, "Output",
 CellID->38632786]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18317, 592, 216, 7, 70, "ExampleSection",
 CellID->18630],
Cell[18536, 601, 84, 1, 70, "ExampleText",
 CellID->771853027],
Cell[CellGroupData[{
Cell[18645, 606, 371, 12, 70, "Input",
 CellID->1732596909],
Cell[19019, 620, 333, 12, 56, "Output",
 CellID->88446449]
}, Open  ]],
Cell[19367, 635, 126, 3, 70, "ExampleDelimiter",
 CellID->1415328442],
Cell[19496, 640, 79, 1, 70, "ExampleText",
 CellID->1896250522],
Cell[CellGroupData[{
Cell[19600, 645, 411, 13, 70, "Input",
 CellID->1625201774],
Cell[20014, 660, 330, 12, 64, "Output",
 CellID->460784619]
}, Open  ]],
Cell[20359, 675, 125, 3, 70, "ExampleDelimiter",
 CellID->507118242],
Cell[20487, 680, 75, 1, 70, "ExampleText",
 CellID->1921181998],
Cell[CellGroupData[{
Cell[20587, 685, 431, 15, 70, "Input",
 CellID->1889207741],
Cell[21021, 702, 307, 14, 64, "Output",
 CellID->581060451]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21377, 722, 239, 7, 70, "ExampleSection",
 CellID->19172],
Cell[21619, 731, 83, 1, 70, "ExampleText",
 CellID->1380306720],
Cell[CellGroupData[{
Cell[21727, 736, 429, 14, 70, "Input",
 CellID->1643344302],
Cell[22159, 752, 300, 11, 48, "Output",
 CellID->1274857048]
}, Open  ]],
Cell[22474, 766, 125, 3, 70, "ExampleDelimiter",
 CellID->628453180],
Cell[22602, 771, 82, 1, 70, "ExampleText",
 CellID->1582854460],
Cell[CellGroupData[{
Cell[22709, 776, 716, 24, 70, "Input",
 CellID->7490184],
Cell[23428, 802, 414, 15, 64, "Output",
 CellID->534163193]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23903, 824, 310, 9, 70, "SeeAlsoSection",
 CellID->2003],
Cell[24216, 835, 1471, 53, 70, "SeeAlso",
 CellID->29130]
}, Open  ]],
Cell[CellGroupData[{
Cell[25724, 893, 314, 9, 70, "TutorialsSection",
 CellID->10389],
Cell[26041, 904, 141, 3, 70, "Tutorials",
 CellID->992],
Cell[26185, 909, 166, 3, 70, "Tutorials",
 CellID->25408],
Cell[26354, 914, 151, 3, 70, "Tutorials",
 CellID->811360059],
Cell[26508, 919, 303, 9, 70, "Tutorials",
 CellID->542584750]
}, Open  ]],
Cell[CellGroupData[{
Cell[26848, 933, 319, 9, 70, "MoreAboutSection",
 CellID->798974949],
Cell[27170, 944, 147, 3, 70, "MoreAbout",
 CellID->731127786],
Cell[27320, 949, 140, 3, 70, "MoreAbout",
 CellID->114446916],
Cell[27463, 954, 142, 3, 70, "MoreAbout",
 CellID->266871097],
Cell[27608, 959, 202, 4, 70, "MoreAbout",
 CellID->1301440],
Cell[27813, 965, 179, 3, 70, "MoreAbout",
 CellID->26732568]
}, Open  ]],
Cell[28007, 971, 27, 0, 70, "History"],
Cell[28037, 973, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

